/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.metaqtl3.graphics;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.imageio.ImageIO;
import umcg.genetica.math.stats.Regression;

public class QQPlot {
    private static final int FILE_TYPE_PNG = 1;
    private static final int FILE_TYPE_PDF = 2;
    private int outputPlotsFileType = 2;

    public void draw(String fileName, double fdrCutOff, int nrPermutationsFDR, int maxNrMostSignificantEQTLs, double[][] permutedPValues, double[] pValues, boolean[] pValueSignificant, int nrSignificantEQTLs) {
        int margin;
        System.setProperty("java.awt.headless", "true");
        int width = 600;
        int height = 600;
        int x0 = margin = 50;
        int x1 = width - margin;
        int innerWidth = x1 - x0;
        int y0 = margin + 40;
        int y1 = height - margin - 12 - 10;
        int innerHeight = y1 - y0;
        File fileQQPlot = null;
        fileQQPlot = this.outputPlotsFileType == 1 ? new File(fileName) : new File(fileName);
        Graphics2D g2d = null;
        BufferedImage bi = null;
        Document document = null;
        PdfContentByte cb = null;
        PdfWriter writer = null;
        if (this.outputPlotsFileType == 1) {
            bi = new BufferedImage(width, height, 1);
            g2d = bi.createGraphics();
        } else {
            Rectangle rectangle = new Rectangle((float)width, (float)height);
            document = new Document(rectangle);
            try {
                writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(fileQQPlot));
                document.open();
                cb = writer.getDirectContent();
                cb.saveState();
                g2d = cb.createGraphics((float)width, (float)height);
            }
            catch (Exception e) {
                System.out.println("Cannot write to PDF file!:\t" + fileQQPlot.getAbsolutePath());
                System.exit(-1);
            }
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(new Color(255, 255, 255));
        g2d.fillRect(0, 0, width, height);
        double capLog = 16.0;
        g2d.setFont(new Font("Arial", 0, 11));
        int l = 0;
        while ((double)l <= capLog) {
            double log10 = l;
            int posX = x0 + (int)Math.round((double)innerWidth * (log10 / capLog));
            int posY = y1 - (int)Math.round((double)innerHeight * (log10 / capLog));
            g2d.setColor(new Color(220, 220, 220));
            g2d.drawLine(x0, posY, x1, posY);
            g2d.drawLine(posX, y0, posX, y1);
            g2d.setColor(new Color(0, 0, 0));
            g2d.drawLine(x0 - 3, posY, x0, posY);
            g2d.drawLine(posX, y1, posX, y1 + 3);
            g2d.setColor(new Color(0, 0, 0));
            String logPValueString = new DecimalFormat("##;-##", new DecimalFormatSymbols(Locale.US)).format(log10);
            g2d.drawString(logPValueString, posX - 1 - this.getWidth(logPValueString, g2d.getFont()) / 2, y1 + 13);
            g2d.drawString(logPValueString, x0 - 7 - this.getWidth(logPValueString, g2d.getFont()), posY + 4);
            ++l;
        }
        g2d.setColor(new Color(200, 200, 200));
        g2d.drawLine(x0, y1, x1, y0);
        g2d.setColor(new Color(0, 0, 0));
        g2d.drawLine(x0, y1, x0, y0);
        g2d.drawLine(x0, y1, x1, y1);
        double[] distLog10Observed = new double[maxNrMostSignificantEQTLs];
        double[] distLog10Null = new double[maxNrMostSignificantEQTLs];
        for (int p = 0; p < maxNrMostSignificantEQTLs; ++p) {
            double log10Observed;
            distLog10Observed[p] = log10Observed = -Math.log10(pValues[p]);
            if (log10Observed > capLog) {
                log10Observed = capLog;
            }
            double log10Null = 0.0;
            for (int permutationRound = 0; permutationRound < nrPermutationsFDR; ++permutationRound) {
                log10Null += permutedPValues[permutationRound][p];
            }
            distLog10Null[p] = log10Null = -Math.log10(log10Null / (double)nrPermutationsFDR);
            if (log10Null > capLog) {
                log10Null = capLog;
            }
            if (pValueSignificant[p]) {
                g2d.setColor(new Color(255, 0, 0));
            } else {
                g2d.setColor(new Color(0, 0, 0));
            }
            int posX = x0 + (int)Math.round((double)innerWidth * (log10Null / capLog));
            int posY = y1 - (int)Math.round((double)innerHeight * (log10Observed / capLog));
            g2d.fillOval(posX - 1, posY - 1, 3, 3);
        }
        double[] rc = Regression.getLinearRegressionCoefficients(distLog10Null, distLog10Observed);
        g2d.setColor(new Color(0, 0, 0));
        String slopeString = "Lambda inflation: " + new DecimalFormat("##.##;-##.##", new DecimalFormatSymbols(Locale.US)).format(rc[0]);
        g2d.drawString(slopeString, x0, y0 - 15);
        String fdrString = new DecimalFormat("##.##;-##.##", new DecimalFormatSymbols(Locale.US)).format(fdrCutOff);
        String nrEQTLsString = "Number of significant eQTLs (FDR " + fdrString + "):\t" + nrSignificantEQTLs;
        g2d.drawString(nrEQTLsString, x0, y0 - 30);
        if (this.outputPlotsFileType == 1) {
            try {
                ImageIO.write((RenderedImage)bi, "png", fileQQPlot);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                System.out.println(e.getStackTrace());
            }
        } else {
            g2d.dispose();
            cb.restoreState();
            document.close();
            writer.close();
        }
    }

    private int getWidth(String text, Font font) {
        Graphics2D g2d = new BufferedImage(1, 1, 2).createGraphics();
        TextLayout tL = new TextLayout(text, font, g2d.getFontRenderContext());
        return (int)tL.getBounds().getWidth();
    }
}

