/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.metaqtl3.graphics;

import cern.colt.matrix.tint.IntMatrix2D;
import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import eqtlmappingpipeline.metaqtl3.containers.Result;
import eqtlmappingpipeline.metaqtl3.containers.Settings;
import eqtlmappingpipeline.metaqtl3.containers.WorkPackage;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Locale;
import javax.imageio.ImageIO;
import umcg.genetica.graphics.ViolinBoxPlot;
import umcg.genetica.io.trityper.SNP;
import umcg.genetica.io.trityper.TriTyperExpressionData;
import umcg.genetica.io.trityper.TriTyperGeneticalGenomicsDataset;
import umcg.genetica.io.trityper.util.BaseAnnot;
import umcg.genetica.math.stats.Descriptives;
import umcg.genetica.math.stats.Regression;
import umcg.genetica.util.Primitives;
import umcg.genetica.util.RankArray;

public class EQTLPlotter {
    private static final int FILE_TYPE_PNG = 1;
    private static final int FILE_TYPE_PDF = 2;
    private int outputPlotsFileType = 2;
    private static final DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);
    private static final DecimalFormat df1 = new DecimalFormat("###.#;-###.#", dfs);
    private static final DecimalFormat df2 = new DecimalFormat("###.######;-###.######", dfs);
    private static final DecimalFormat df3 = new DecimalFormat("##.00;-##.00", dfs);
    private static final DecimalFormat df5 = new DecimalFormat("0.##E0", dfs);
    private static final DecimalFormat df6 = new DecimalFormat("##.###;-##.###", dfs);
    private final TriTyperGeneticalGenomicsDataset[] m_gg;
    private final String m_outputDir;
    private final String[] m_probeList;
    private final IntMatrix2D m_probeTranslation;
    private final boolean m_cisOnly;
    private final boolean m_parametricAnalysis;
    private final RankArray m_rda;
    private static final Color red = new Color(255, 0, 0);
    private static final Color black = new Color(0, 0, 0);
    private static final Color darkgray = new Color(100, 100, 100);
    private static final Color white = new Color(255, 255, 255);
    private static final Color grey = new Color(125, 125, 125);
    private static final Color blue = new Color(0, 0, 255);
    private static final Color lightgray = new Color(200, 200, 200);
    private static final Color medgray = new Color(150, 150, 150);
    private final boolean m_giveTiesSameRank;

    public EQTLPlotter(TriTyperGeneticalGenomicsDataset[] gg, Settings settings, String[] probeList, IntMatrix2D probeTranslation) {
        this.m_gg = gg;
        this.m_outputDir = settings.plotOutputDirectory;
        this.m_probeList = probeList;
        this.m_cisOnly = settings.cisAnalysis && !settings.transAnalysis;
        this.m_probeTranslation = probeTranslation;
        this.m_parametricAnalysis = settings.performParametricAnalysis;
        this.m_rda = new RankArray();
        this.m_giveTiesSameRank = settings.equalRankForTies;
    }

    public void draw(WorkPackage wp, int pid) {
        double logPValue;
        String logPValueString;
        int margin;
        System.setProperty("java.awt.headless", "true");
        boolean jitter = true;
        int width = 40 + this.m_gg.length * 200;
        if (width < 440) {
            width = 440;
        }
        int height = 340;
        int x0 = margin = 30;
        int x1 = width - margin;
        int innerWidth = x1 - x0;
        int y0 = margin + 40;
        int y1 = height - margin - 12 - 10;
        int innerHeight = y1 - y0;
        double metaPvalue = wp.results.pvalues[pid];
        SNP[] snps = wp.getSnps();
        String snpName = "";
        byte snpChr = 0;
        int snpChrpos = 0;
        int[] probes = wp.getProbes();
        int probeId = pid;
        if (probes != null && probes.length == wp.results.pvalues.length) {
            probeId = probes[pid];
        }
        String probeName = this.m_probeList[probeId];
        for (SNP snp : snps) {
            if (snp == null) continue;
            snpName = snp.getName();
            snpChr = snp.getChr();
            snpChrpos = snp.getChrPos();
            break;
        }
        String probeAnnot = "";
        for (int d = 0; d < snps.length; ++d) {
            if (this.m_probeTranslation.get(d, probeId) == -9) continue;
            Integer realProbeId = this.m_probeTranslation.get(d, probeId);
            TriTyperExpressionData expressionData = this.m_gg[d].getExpressionData();
            probeAnnot = expressionData.getAnnotation()[realProbeId] + ", Chr: " + expressionData.getChr()[realProbeId] + " (" + expressionData.getChrStart()[realProbeId] + " - " + expressionData.getChrStop()[realProbeId] + ")";
            break;
        }
        if ((logPValueString = df3.format(logPValue = -Math.log10(metaPvalue))).startsWith(".")) {
            logPValueString = "0" + logPValueString;
        }
        String fileName = this.m_outputDir + "" + logPValueString + "-" + snpName.replace("/", "_") + "-" + probeName.replace("/", "_").replace(";", "_") + ".pdf";
        File file = new File(fileName);
        Graphics2D g2d = null;
        BufferedImage bi = null;
        Document document = null;
        PdfContentByte cb = null;
        PdfWriter writer = null;
        if (this.outputPlotsFileType == 1) {
            bi = new BufferedImage(width, height, 1);
            g2d = bi.createGraphics();
        } else {
            Rectangle rectangle = new Rectangle((float)width, (float)height);
            document = new Document(rectangle);
            try {
                writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file));
                document.open();
                cb = writer.getDirectContent();
                cb.saveState();
                g2d = cb.createGraphics((float)width, (float)height);
            }
            catch (Exception e) {
                System.out.println("Cannot write to PDF file!:\t" + file.getAbsolutePath());
                System.exit(-1);
            }
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(white);
        g2d.fillRect(0, 0, width, height);
        g2d.setColor(black);
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2d.setFont(new Font("Arial", 1, 9));
        g2d.drawString("SNP", margin, 15);
        g2d.drawString("Probe", margin, 25);
        g2d.drawString("P-Value", margin, 35);
        g2d.setFont(new Font("Arial", 0, 9));
        g2d.drawString(snpName + " - Chr: " + snpChr + " (" + snpChrpos + ")", margin + 40, 15);
        g2d.drawString(probeName + " - " + probeAnnot, margin + 40, 25);
        String pValueOverallString = df5.format(metaPvalue);
        if (metaPvalue > 0.001) {
            pValueOverallString = df6.format(metaPvalue);
        }
        g2d.drawString(pValueOverallString, margin + 40, 35);
        int numDatasets = this.m_gg.length;
        Boolean[] flipalleles = wp.getFlipSNPAlleles();
        Result results = wp.results;
        for (int d = 0; d < numDatasets; ++d) {
            g2d.setColor(black);
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
            g2d.setFont(new Font("Arial", 1, 10));
            g2d.drawString(this.m_gg[d].getSettings().name, margin + d * 200, 53);
            TriTyperGeneticalGenomicsDataset currentDataset = this.m_gg[d];
            SNP currentSNP = snps[d];
            Integer probe = (Integer)currentDataset.getExpressionData().getProbeToId().get((Object)probeName);
            if (currentSNP != null && probe != null) {
                double[] bbArr;
                double[] abArr;
                int ind;
                int s;
                int itr = 0;
                int[] nrSamplesPerX = new int[3];
                int nrSamplesWithData = results.numSamples[d];
                double[] x = new double[nrSamplesWithData];
                int[] xBinary = new int[nrSamplesWithData];
                Boolean[] indIsFemale = new Boolean[x.length];
                Boolean[] isFemale = currentDataset.getGenotypeData().getIsFemale();
                int numSamples = currentDataset.getTotalGGSamples();
                int[] indWGA = currentDataset.getExpressionToGenotypeIdArray();
                byte[] genotypes = currentSNP.getGenotypes();
                double[] rawData = currentDataset.getExpressionData().getMatrix()[probe];
                double[] y = new double[nrSamplesWithData];
                ArrayList<Double> valsAA = new ArrayList<Double>();
                ArrayList<Double> valsAB = new ArrayList<Double>();
                ArrayList<Double> valsBB = new ArrayList<Double>();
                int minYAA = Integer.MAX_VALUE;
                int maxYAA = -2147483647;
                int minYAB = Integer.MAX_VALUE;
                int maxYAB = -2147483647;
                int minYBB = Integer.MAX_VALUE;
                int maxYBB = -2147483647;
                for (s = 0; s < numSamples; ++s) {
                    double valX;
                    ind = indWGA[s];
                    if (ind == -1 || (valX = (double)genotypes[ind]) == -1.0) continue;
                    if (flipalleles[d].booleanValue()) {
                        int n = (int)(2.0 - valX);
                        nrSamplesPerX[n] = nrSamplesPerX[n] + 1;
                    } else {
                        int n = (int)valX;
                        nrSamplesPerX[n] = nrSamplesPerX[n] + 1;
                    }
                    xBinary[itr] = (int)valX;
                    if (wp.getFlipSNPAlleles()[d].booleanValue()) {
                        xBinary[itr] = 2 - (int)valX;
                    }
                    if (currentSNP.hasDosageInformation()) {
                        valX = currentSNP.getDosageValues()[ind];
                    }
                    if (flipalleles[d].booleanValue()) {
                        valX = 2.0 - valX;
                    }
                    x[itr] = valX;
                    indIsFemale[itr] = isFemale[ind];
                    ++itr;
                }
                if (nrSamplesWithData == numSamples) {
                    y = rawData;
                } else {
                    itr = 0;
                    for (s = 0; s < numSamples; ++s) {
                        byte valX;
                        ind = indWGA[s];
                        if (ind == -1 || (valX = currentSNP.getGenotypes()[ind]) == -1) continue;
                        y[itr] = rawData[s];
                        ++itr;
                    }
                }
                g2d.setColor(black);
                double minExpression = Double.MAX_VALUE;
                double maxExpression = Double.MIN_VALUE;
                for (int i = 0; i < y.length; ++i) {
                    if (y[i] < minExpression) {
                        minExpression = y[i];
                    }
                    if (!(y[i] > maxExpression)) continue;
                    maxExpression = y[i];
                }
                double[] correlationValues = Regression.getLinearRegressionCoefficients(x, y);
                g2d.setComposite(AlphaComposite.getInstance(3, 0.25f));
                g2d.setStroke(new BasicStroke(2.0f));
                int pixelY1 = y1 - (int)((correlationValues[1] - minExpression) / (maxExpression - minExpression) * (double)innerHeight);
                int pixelY2 = y1 - (int)((2.0 * correlationValues[0] + correlationValues[1] - minExpression) / (maxExpression - minExpression) * (double)innerHeight);
                int pixelXGroup0 = x0 + d * 200 + 0;
                int pixelXGroup2 = x0 + d * 200 + 100;
                g2d.drawLine(pixelXGroup0 + 6, pixelY1, pixelXGroup2 + 6, pixelY2);
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.setComposite(AlphaComposite.getInstance(3, 0.5f));
                boolean[][][] positionToPlot = new boolean[3][41][innerHeight + 5];
                g2d.setFont(new Font("Arial", 0, 6));
                for (int i = 0; i < x.length; ++i) {
                    int pixelX = x0 + d * 200 + (int)(x[i] * 50.0);
                    if (jitter) {
                        pixelX = x0 + d * 200 + (int)((double)xBinary[i] * 50.0);
                    }
                    int posY = (int)((y[i] - minExpression) / (maxExpression - minExpression) * (double)innerHeight);
                    int pixelY = y1 - posY;
                    switch (xBinary[i]) {
                        case 0: {
                            valsAA.add(y[i]);
                            if (pixelY > maxYAA) {
                                maxYAA = pixelY;
                            }
                            if (pixelY >= minYAA) break;
                            minYAA = pixelY;
                            break;
                        }
                        case 1: {
                            valsAB.add(y[i]);
                            if (pixelY > maxYAB) {
                                maxYAB = pixelY;
                            }
                            if (pixelY >= minYAB) break;
                            minYAB = pixelY;
                            break;
                        }
                        case 2: {
                            valsBB.add(y[i]);
                            if (pixelY > maxYBB) {
                                maxYBB = pixelY;
                            }
                            if (pixelY >= minYBB) break;
                            minYBB = pixelY;
                        }
                    }
                    if (!currentSNP.hasDosageInformation() || jitter) {
                        int offsetToPlot = 40;
                        for (int offset = 0; offset < 41; ++offset) {
                            int q;
                            boolean allClear = true;
                            for (q = 0; q < 4; ++q) {
                                if (!positionToPlot[xBinary[i]][offset][posY + q]) continue;
                                allClear = false;
                                break;
                            }
                            if (!allClear) continue;
                            for (q = 0; q < 4; ++q) {
                                positionToPlot[xBinary[i]][offset][posY + q] = true;
                            }
                            offsetToPlot = offset;
                            break;
                        }
                        double diffOffset = 0.0;
                        if (offsetToPlot > 0) {
                            double sign = offsetToPlot % 2;
                            if (sign == 0.0) {
                                sign = -1.0;
                            }
                            diffOffset = 1.0 * sign * (double)(offsetToPlot - (offsetToPlot + 1) % 2 + 1);
                        }
                        pixelX = (int)((double)pixelX + diffOffset);
                    }
                    if (indIsFemale[i] == null) {
                        g2d.setColor(grey);
                    } else if (indIsFemale[i].booleanValue()) {
                        g2d.setColor(red);
                    } else {
                        g2d.setColor(blue);
                    }
                    g2d.fillOval(pixelX + 6, pixelY, 2, 2);
                }
                double correlation = results.correlations[d][pid];
                g2d.setColor(black);
                g2d.setFont(new Font("Arial", 0, 10));
                g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
                String correlationString = df6.format(correlation);
                String r2String = df6.format(correlation * correlation);
                String allele0 = "";
                String allele1 = "";
                byte[] loadedSNPAlleles = currentSNP.getAlleles();
                allele0 = BaseAnnot.toString(loadedSNPAlleles[0]);
                allele1 = BaseAnnot.toString(loadedSNPAlleles[1]);
                if (wp.getFlipSNPAlleles()[d].booleanValue()) {
                    String alleleTemp = allele0;
                    allele0 = allele1;
                    allele1 = alleleTemp;
                }
                ViolinBoxPlot boxplotter = new ViolinBoxPlot();
                AlphaComposite alphaComposite100 = AlphaComposite.getInstance(2, 1.0f);
                g2d.setComposite(alphaComposite100);
                g2d.setColor(new Color(0, 0, 0));
                double[] aaArr = this.toArray(valsAA);
                if (aaArr.length > 0) {
                    boxplotter.drawBoxPlot(g2d, margin + d * 200 + 0 - 5, minYAA, 25, maxYAA - minYAA, aaArr, Primitives.min(aaArr), Primitives.max(aaArr), false);
                }
                if ((abArr = this.toArray(valsAB)).length > 0) {
                    boxplotter.drawBoxPlot(g2d, margin + d * 200 + 50 - 5, minYAB, 25, maxYAB - minYAB, abArr, Primitives.min(abArr), Primitives.max(abArr), false);
                }
                if ((bbArr = this.toArray(valsBB)).length > 0) {
                    boxplotter.drawBoxPlot(g2d, margin + d * 200 + 100 - 5, minYBB, 25, maxYBB - minYBB, bbArr, Primitives.min(bbArr), Primitives.max(bbArr), false);
                }
                g2d.setColor(black);
                g2d.drawString(allele0 + allele0, margin + d * 200 + 0, height - 15 - 10);
                g2d.drawString(allele0 + allele1, margin + d * 200 + 50, height - 15 - 10);
                g2d.drawString(allele1 + allele1, margin + d * 200 + 100, height - 15 - 10);
                g2d.setColor(black);
                g2d.drawString("(" + nrSamplesPerX[0] + ")", margin + d * 200 + 0 + 17, height - 15 - 10);
                g2d.drawString("(" + nrSamplesPerX[1] + ")", margin + d * 200 + 50 + 17, height - 15 - 10);
                g2d.drawString("(" + nrSamplesPerX[2] + ")", margin + d * 200 + 100 + 17, height - 15 - 10);
                g2d.setColor(black);
                g2d.setFont(new Font("Arial", 1, 9));
                g2d.drawString("Corr:", margin + d * 200, height - 2 - 10);
                g2d.drawString("R2:", margin + d * 200 + 75, height - 2 - 10);
                g2d.setFont(new Font("Arial", 0, 9));
                g2d.drawString(correlationString, margin + d * 200 + 37, height - 2 - 10);
                g2d.drawString(r2String, margin + d * 200 + 75 + 37, height - 2 - 10);
                double zScore = results.zscores[d][pid];
                if (wp.getFlipSNPAlleles()[d].booleanValue()) {
                    zScore *= -1.0;
                }
                String zScoreString = df5.format(zScore);
                if (zScore < 100.0) {
                    zScoreString = df6.format(zScore);
                }
                double pValue = Descriptives.convertZscoreToPvalue(zScore);
                String pValueString = df5.format(pValue);
                if (pValue > 0.001) {
                    pValueString = df6.format(pValue);
                }
                g2d.setColor(black);
                g2d.setFont(new Font("Arial", 1, 9));
                g2d.drawString("Z-Score:", margin + d * 200, height - 2);
                g2d.drawString("P-Value:", margin + d * 200 + 75, height - 2);
                g2d.setFont(new Font("Arial", 0, 9));
                g2d.drawString(zScoreString, margin + d * 200 + 37, height - 2);
                g2d.drawString(pValueString, margin + d * 200 + 75 + 37, height - 2);
                int probeCount = currentDataset.getExpressionData().getProbes().length;
                double[] means = new double[probeCount];
                for (int p = 0; p < probeCount; ++p) {
                    means[p] = currentDataset.getExpressionData().getOriginalProbeMean()[probe];
                }
                double probeOriginalMeanRank = this.m_rda.rank(means, this.m_giveTiesSameRank)[probe];
                for (int p = 0; p < probeCount; ++p) {
                    means[p] = currentDataset.getExpressionData().getProbeMean()[probe];
                }
                double probeMeanRank = this.m_rda.rank(means, this.m_giveTiesSameRank)[probe];
                g2d.setColor(lightgray);
                g2d.drawLine(margin + d * 200 + 140, y0, margin + d * 200 + 140, y1);
                g2d.drawLine(margin + d * 200 + 138, y0, margin + d * 200 + 142, y0);
                g2d.drawLine(margin + d * 200 + 138, y1, margin + d * 200 + 142, y1);
                g2d.setColor(medgray);
                int pixelYOriginal = y1 - (int)(probeOriginalMeanRank / (double)probeCount * (double)innerHeight);
                g2d.drawLine(margin + d * 200 + 135, pixelYOriginal, margin + d * 200 + 145, pixelYOriginal);
                g2d.setColor(darkgray);
                int pixelY = y1 - (int)(probeMeanRank / (double)probeCount * (double)innerHeight);
                g2d.drawLine(margin + d * 200 + 135, pixelY, margin + d * 200 + 145, pixelY);
                continue;
            }
            g2d.setColor(black);
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
            g2d.setFont(new Font("Arial", 1, 9));
            g2d.drawString("eQTL not available", margin + d * 200, 70);
            g2d.setFont(new Font("Arial", 0, 9));
            currentSNP = snps[d];
            if (currentSNP == null) {
                g2d.drawString("SNP has not been genotyped.", margin + d * 200, 90);
                continue;
            }
            if (!currentSNP.passesQC()) {
                g2d.drawString("SNP does not pass QC:", margin + d * 200, 90);
                String callRateString = df1.format(currentSNP.getCR() * 100.0);
                g2d.drawString("- Call rate: " + callRateString + "%", margin + d * 200, 100);
                String mafString = df1.format(currentSNP.getMAF() * 100.0);
                g2d.drawString("- MAF: " + mafString + "%", margin + d * 200, 110);
                String hweString = df2.format(currentSNP.getHWEP());
                g2d.drawString("- HWE P-Value: " + hweString, margin + d * 200, 120);
            } else if (currentDataset.getExpressionData().getProbeToId().get((Object)probeName) != null) {
                if (this.m_cisOnly) {
                    g2d.setColor(red);
                    g2d.drawString("Cis-probe maps too far away.", margin + d * 200, 90);
                    g2d.drawString("You probably have different probe", margin + d * 200, 100);
                    g2d.drawString("mappings in the various datasets!", margin + d * 200, 110);
                    g2d.setColor(red);
                } else if (currentDataset.getExpressionData().getProbeToId().get((Object)probeName) != null) {
                    g2d.setColor(red);
                    g2d.drawString("Unknown why not included!", margin + d * 200, 90);
                    g2d.drawString("This suggests a bug.", margin + d * 200, 100);
                    g2d.setColor(black);
                }
            }
            if (currentDataset.getExpressionData().getProbeToId().get((Object)probeName) != null) continue;
            if (currentSNP.passesQC()) {
                g2d.drawString("Probe not present.", margin + d * 200, 90);
                continue;
            }
            g2d.drawString("Probe not present.", margin + d * 200, 140);
        }
        if (this.outputPlotsFileType == 1) {
            try {
                ImageIO.write((RenderedImage)bi, "png", file);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                System.out.println(e.getStackTrace());
            }
        } else {
            g2d.dispose();
            cb.restoreState();
            document.close();
            writer.close();
        }
    }

    private double[] toArray(ArrayList<Double> vals) {
        double[] rrrr = new double[vals.size()];
        for (int i = 0; i < rrrr.length; ++i) {
            rrrr[i] = vals.get(i);
        }
        return rrrr;
    }
}

