/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.metaqtl3.containers;

import eqtlmappingpipeline.Main;
import eqtlmappingpipeline.metaqtl3.FDR;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.TriTyperGeneticalGenomicsDatasetSettings;
import umcg.genetica.io.trityper.util.ChrAnnotation;

public class Settings
extends TriTyperGeneticalGenomicsDatasetSettings {
    public String settingsTextToReplace = null;
    public String settingsTextReplaceWith = null;
    public String settingsTextToReplace2 = null;
    public String settingsTextReplace2With = null;
    public boolean createSNPPValueSummaryStatisticsFile = false;
    public boolean createSNPSummaryStatisticsFile = false;
    public boolean createEQTLPValueTable = false;
    public String outputReportsDir;
    public boolean performParametricAnalysis = false;
    public boolean useAbsoluteZScorePValue = false;
    public int ciseQTLAnalysMaxSNPProbeMidPointDistance = 1000000;
    public int maxNrMostSignificantEQTLs = 500000;
    public boolean performParametricAnalysisGetAccuratePValueEstimates;
    public Integer nrThreads;
    public double fdrCutOff = 0.05;
    public int nrPermutationsFDR = 1;
    public FDR.FDRMethod fdrType = FDR.FDRMethod.ALL;
    public boolean fullFdrOutput = true;
    public boolean performEQTLAnalysisOnSNPProbeCombinationSubset;
    public Byte confineToSNPsThatMapToChromosome;
    public boolean expressionDataLoadOnlyProbesThatMapToChromosome = false;
    public HashSet<String> tsSNPsConfine = null;
    public HashMap<String, HashSet<String>> tsSNPProbeCombinationsConfine;
    public double plotOutputPValueCutOff;
    public String plotOutputDirectory;
    public boolean runOnlyPermutations = false;
    public Integer startWithPermutation;
    public Boolean confineSNPsToSNPsPresentInAllDatasets = true;
    public boolean confineProbesToProbesPresentInAllDatasets;
    public ArrayList<TriTyperGeneticalGenomicsDatasetSettings> datasetSettings;
    public String regressOutEQTLEffectFileName;
    public boolean regressOutEQTLEffectsSaveOutput = true;
    public double snpQCCallRateThreshold = 0.95;
    public double snpQCHWEThreshold = 1.0E-4;
    public double snpQCMAFThreshold = 0.01;
    public Byte confineToProbesThatMapToChromosome;
    public boolean createBinaryOutputFiles;
    public boolean createTEXTOutputFiles;
    public String strConfineSNP;
    public String strConfineProbe;
    public String strConfineSNPProbe;
    public boolean provideFoldChangeData = false;
    public boolean provideBetasAndStandardErrors = true;
    public boolean equalRankForTies = false;
    public boolean createQQPlot = true;
    public boolean createDotPlot = true;
    public boolean metaAnalyseInteractionTerms = false;
    public boolean metaAnalyseModelCorrelationYHat = false;
    public String pathwayDefinition = null;
    public boolean snpProbeConfineBasedOnChrPos = false;
    private static final Pattern TAB_PATTERN = Pattern.compile("\\t");
    public boolean permuteCovariates;
    public long rSeed = System.currentTimeMillis();
    public Random randomNumberGenerator = new Random(this.rSeed);

    public void load(String settings) throws IOException, ConfigurationException {
        String[] data;
        TextFile in;
        XMLConfiguration config = new XMLConfiguration(settings);
        String analysisType = null;
        String correlationType = null;
        Boolean useAbsPVal = null;
        Integer nrthread = null;
        Integer cisDist = null;
        Double MAF = null;
        Double HWE = null;
        Double callrate = null;
        String correctiontype = null;
        Integer randomseed = null;
        String fdrtype = "probe";
        boolean largeFdrFileOut = true;
        Double mtThreshold = null;
        Integer numPermutations = null;
        String outdir = null;
        Double outputplotthreshold = null;
        String outputplotdirectory = null;
        try {
            callrate = config.getDouble("defaults.qc.snpqccallratethreshold");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.snpQCCallRateThreshold = callrate != null ? callrate : 0.95;
        try {
            HWE = config.getDouble("defaults.qc.snpqchwethreshold");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.snpQCHWEThreshold = HWE != null ? HWE : 1.0E-7;
        try {
            MAF = config.getDouble("defaults.qc.snpqcmafthreshold", null);
        }
        catch (Exception e) {
            MAF = null;
        }
        if (MAF != null) {
            this.snpQCMAFThreshold = MAF;
        }
        try {
            analysisType = config.getString("defaults.analysis.analysistype");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.createQQPlot = config.getBoolean("defaults.analysis.createqqplot", true);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.createDotPlot = config.getBoolean("defaults.analysis.createdotplot", true);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.runOnlyPermutations = config.getBoolean("defaults.analysis.onlypermutations", false);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (analysisType != null) {
            if (analysisType.toLowerCase().equals("cis")) {
                this.cisAnalysis = true;
                this.transAnalysis = false;
            } else if (analysisType.toLowerCase().equals("trans")) {
                this.cisAnalysis = false;
                this.transAnalysis = true;
            } else if (analysisType.toLowerCase().equals("cistrans")) {
                this.cisAnalysis = true;
                this.transAnalysis = true;
            }
        } else {
            this.cisAnalysis = true;
            this.transAnalysis = false;
        }
        try {
            cisDist = config.getInteger("defaults.analysis.cisanalysisprobedistance", null);
        }
        catch (Exception e) {
            cisDist = null;
        }
        if (cisDist != null) {
            this.ciseQTLAnalysMaxSNPProbeMidPointDistance = cisDist;
        }
        try {
            correlationType = config.getString("defaults.analysis.correlationtype", null);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.performParametricAnalysis = correlationType != null ? correlationType.toLowerCase().equals("parametric") : true;
        Boolean useIdenticalRanksForTies = null;
        try {
            useIdenticalRanksForTies = config.getBoolean("defaults.analysis.equalrankforties", null);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.equalRankForTies = useIdenticalRanksForTies != null ? useIdenticalRanksForTies : false;
        this.metaAnalyseInteractionTerms = false;
        Boolean metaAnalyzeInteractionTermsB = null;
        try {
            metaAnalyzeInteractionTermsB = config.getBoolean("defaults.analysis.metaAnalyseInteractionTerms", null);
            this.metaAnalyseInteractionTerms = metaAnalyzeInteractionTermsB;
        }
        catch (Exception e) {
            this.metaAnalyseInteractionTerms = false;
        }
        this.permuteCovariates = false;
        try {
            this.permuteCovariates = config.getBoolean("defaults.analysis.permuteCovariates", false);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.metaAnalyseInteractionTerms = metaAnalyzeInteractionTermsB != null ? metaAnalyzeInteractionTermsB : false;
        Boolean metaAnalyseModelCorrelationYHatB = null;
        try {
            metaAnalyseModelCorrelationYHatB = config.getBoolean("defaults.analysis.metaAnalyseModelCorrelationYHat", null);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.metaAnalyseModelCorrelationYHat = metaAnalyseModelCorrelationYHatB != null ? metaAnalyseModelCorrelationYHatB : false;
        try {
            useAbsPVal = config.getBoolean("defaults.analysis.useabsolutepvalue", false);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.useAbsoluteZScorePValue = useAbsPVal == null ? false : useAbsPVal;
        try {
            nrthread = config.getInteger("defaults.analysis.threads", null);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (nrthread == null) {
            this.nrThreads = Runtime.getRuntime().availableProcessors() - 1;
        } else {
            int numProcs = Runtime.getRuntime().availableProcessors();
            this.nrThreads = nrthread > numProcs || nrthread < 1 ? Integer.valueOf(numProcs) : nrthread;
        }
        try {
            randomseed = config.getInteger("defaults.analysis.randomseed", null);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (randomseed != null) {
            this.rSeed = randomseed.intValue();
            this.randomNumberGenerator = new Random(this.rSeed);
        }
        try {
            correctiontype = config.getString("defaults.multipletesting.type", null);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (correctiontype != null) {
            // empty if block
        }
        try {
            mtThreshold = config.getDouble("defaults.multipletesting.threshold", null);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.fdrCutOff = mtThreshold != null ? mtThreshold : 0.05;
        try {
            numPermutations = config.getInteger("defaults.multipletesting.permutations", null);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (numPermutations != null) {
            this.nrPermutationsFDR = numPermutations;
        }
        try {
            fdrtype = config.getString("defaults.multipletesting.fdrtype", "full");
            fdrtype = fdrtype.toLowerCase();
            fdrtype = fdrtype.replaceAll("-", "");
            fdrtype = fdrtype.replaceAll("level", "");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (numPermutations != null) {
            if (fdrtype.equals("gene")) {
                this.fdrType = FDR.FDRMethod.GENELEVEL;
                this.createDotPlot = false;
            } else if (fdrtype.equals("probe")) {
                this.fdrType = FDR.FDRMethod.PROBELEVEL;
                this.createDotPlot = false;
            } else if (fdrtype.equals("snpprobe") || fdrtype.equals("full")) {
                this.fdrType = FDR.FDRMethod.FULL;
            }
        }
        try {
            largeFdrFileOut = config.getBoolean("defaults.multipletesting.fullFdrOutput", true);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!largeFdrFileOut) {
            this.createDotPlot = false;
            this.fullFdrOutput = false;
        }
        try {
            outdir = config.getString("defaults.output.outputdirectory", null);
            if (this.settingsTextToReplace != null && outdir.contains(this.settingsTextToReplace)) {
                outdir = outdir.replace(this.settingsTextToReplace, this.settingsTextReplaceWith);
            }
            if (this.settingsTextToReplace2 != null && outdir.contains(this.settingsTextToReplace2)) {
                outdir = outdir.replace(this.settingsTextToReplace2, this.settingsTextReplace2With);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (outdir != null) {
            this.outputReportsDir = outdir;
            if (!this.outputReportsDir.endsWith(Gpio.getFileSeparator())) {
                this.outputReportsDir = this.outputReportsDir + Gpio.getFileSeparator();
            }
            if (!Gpio.exists(outdir)) {
                Gpio.createDir(outdir);
            }
            config.save(this.outputReportsDir + "metaqtlsettings.xml");
        } else {
            System.out.println("Error: please supply an output directory.");
            System.exit(-1);
        }
        try {
            this.createBinaryOutputFiles = config.getBoolean("defaults.output.binaryoutput", false);
            this.createTEXTOutputFiles = config.getBoolean("defaults.output.textoutput", true);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            outputplotthreshold = config.getDouble("defaults.output.outputplotthreshold", null);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.plotOutputPValueCutOff = outputplotthreshold != null ? outputplotthreshold : Double.MAX_VALUE;
        try {
            outputplotdirectory = config.getString("defaults.output.outputplotdirectory", null);
            if (this.settingsTextToReplace != null && outputplotdirectory.contains(this.settingsTextToReplace)) {
                outputplotdirectory = outputplotdirectory.replace(this.settingsTextToReplace, this.settingsTextReplaceWith);
            }
            if (this.settingsTextToReplace2 != null && outputplotdirectory.contains(this.settingsTextToReplace2)) {
                outputplotdirectory = outputplotdirectory.replace(this.settingsTextToReplace2, this.settingsTextReplace2With);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (outputplotdirectory != null) {
            this.plotOutputDirectory = outputplotdirectory;
            if (!this.plotOutputDirectory.endsWith(Gpio.getFileSeparator())) {
                this.plotOutputDirectory = this.plotOutputDirectory + Gpio.getFileSeparator();
            }
        } else {
            this.plotOutputDirectory = outdir + "/plots/";
        }
        if (this.plotOutputPValueCutOff != 0.0 && !Gpio.exists(this.plotOutputDirectory)) {
            Gpio.createDir(this.plotOutputDirectory);
        }
        try {
            this.createSNPPValueSummaryStatisticsFile = config.getBoolean("defaults.output.generatesnppvaluesummarystatistics", false);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.provideFoldChangeData = config.getBoolean("defaults.output.generatefoldchangevalues", false);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.provideBetasAndStandardErrors = config.getBoolean("defaults.output.generatebetaandfoldchanges", false);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.createSNPSummaryStatisticsFile = config.getBoolean("defaults.output.generatesnpsummarystatistics", false);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.createEQTLPValueTable = config.getBoolean("defaults.output.generateeqtlpvaluetable", false);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.maxNrMostSignificantEQTLs = config.getInt("defaults.output.maxnreqtlresults", 150000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.expressionDataLoadOnlyProbesThatMapToChromosome = config.getBoolean("defaults.confine.confineProbesThatMapToKnownChromosome", false);
        }
        catch (Exception e) {
            // empty catch block
        }
        String confineSNP = null;
        String confineProbe = null;
        String snpProbeConfine = null;
        this.confineSNPsToSNPsPresentInAllDatasets = null;
        try {
            confineSNP = config.getString("defaults.confine.snp", null);
            if (this.settingsTextToReplace != null && confineSNP.contains(this.settingsTextToReplace)) {
                confineSNP = confineSNP.replace(this.settingsTextToReplace, this.settingsTextReplaceWith);
            }
            if (this.settingsTextToReplace2 != null && confineSNP.contains(this.settingsTextToReplace2)) {
                confineSNP = confineSNP.replace(this.settingsTextToReplace2, this.settingsTextReplace2With);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            confineProbe = config.getString("defaults.confine.probe", null);
            if (this.settingsTextToReplace != null && confineProbe.contains(this.settingsTextToReplace)) {
                confineProbe = confineProbe.replace(this.settingsTextToReplace, this.settingsTextReplaceWith);
            }
            if (this.settingsTextToReplace2 != null && confineProbe.contains(this.settingsTextToReplace2)) {
                confineProbe = confineProbe.replace(this.settingsTextToReplace2, this.settingsTextReplace2With);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            snpProbeConfine = config.getString("defaults.confine.snpProbe", null);
            if (this.settingsTextToReplace != null && snpProbeConfine.contains(this.settingsTextToReplace)) {
                snpProbeConfine = snpProbeConfine.replace(this.settingsTextToReplace, this.settingsTextReplaceWith);
            }
            if (this.settingsTextToReplace2 != null && snpProbeConfine.contains(this.settingsTextToReplace2)) {
                snpProbeConfine = snpProbeConfine.replace(this.settingsTextToReplace2, this.settingsTextReplace2With);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.snpProbeConfineBasedOnChrPos = config.getBoolean("defaults.confine.snpProbeConfineBasedOnChrPos", false);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (confineSNP != null && confineSNP.trim().length() > 0 && Gpio.exists(confineSNP)) {
            this.strConfineSNP = confineSNP;
            in = new TextFile(confineSNP, false);
            this.tsSNPsConfine = new HashSet();
            for (String d : data = in.readAsArray()) {
                if ((d = d.trim()).length() <= 0) continue;
                String[] elems = TAB_PATTERN.split(d);
                d = elems[0].trim();
                this.tsSNPsConfine.add(d.intern());
            }
            in.close();
        } else if (confineSNP != null && confineSNP.trim().length() > 0 && !Gpio.exists(confineSNP)) {
            throw new IOException("Error! SNP confinement file: " + confineSNP + " could not be found.");
        }
        if (confineProbe != null && confineProbe.trim().length() > 0 && Gpio.exists(confineProbe)) {
            this.strConfineProbe = confineProbe;
            in = new TextFile(confineProbe, false);
            this.tsProbesConfine = new HashSet();
            for (String d : data = in.readAsArray()) {
                d = d.trim();
                while (d.startsWith(" ")) {
                    d = d.substring(1);
                }
                this.tsProbesConfine.add(new String(d.getBytes("UTF-8")));
            }
            in.close();
        } else if (confineProbe != null && confineProbe.trim().length() > 0 && !Gpio.exists(confineProbe)) {
            throw new IOException("Error! Probe confinement file: " + confineProbe + " could not be found.");
        }
        if (snpProbeConfine != null && snpProbeConfine.trim().length() > 0 && Gpio.exists(snpProbeConfine)) {
            this.loadSNPProbeConfinement(snpProbeConfine);
        } else if (snpProbeConfine != null && snpProbeConfine.trim().length() > 0 && !Gpio.exists(snpProbeConfine)) {
            if (!new File(snpProbeConfine).exists()) {
                throw new IOException("Error! SNP-Probe confinement file: " + snpProbeConfine + " could not be found.");
            }
            if (!new File(snpProbeConfine).canRead()) {
                throw new IOException("Error! SNP-Probe confinement file: " + snpProbeConfine + " could not be read.");
            }
            throw new IOException("Error! SNP-Probe confinement file: " + snpProbeConfine + " read error.");
        }
        try {
            this.confineSNPsToSNPsPresentInAllDatasets = config.getBoolean("defaults.confine.confineSNPsToSNPsPresentInAllDatasets", false);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String confineStr = config.getString("defaults.confine.confineToSNPsThatMapToChromosome", null);
            if (confineStr == null || confineStr.trim().length() == 0) {
                this.confineToSNPsThatMapToChromosome = null;
            } else {
                this.confineToSNPsThatMapToChromosome = ChrAnnotation.parseChr(confineStr);
                if (this.confineToSNPsThatMapToChromosome < 1) {
                    this.confineToSNPsThatMapToChromosome = null;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.confineProbesToProbesPresentInAllDatasets = false;
        try {
            this.confineProbesToProbesPresentInAllDatasets = config.getBoolean("defaults.confine.confineToProbesPresentInAllDatasets", false);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.regressOutEQTLEffectFileName = null;
        try {
            this.regressOutEQTLEffectFileName = config.getString("defaults.analysis.regressOutEQTLEffects", null);
            if (this.regressOutEQTLEffectFileName.equals("")) {
                this.regressOutEQTLEffectFileName = null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.regressOutEQTLEffectsSaveOutput = true;
        try {
            this.regressOutEQTLEffectsSaveOutput = config.getBoolean("defaults.analysis.regressOutEQTLEffectsSaveOutput", true);
        }
        catch (Exception e) {
            // empty catch block
        }
        String pathwayDef = null;
        try {
            pathwayDef = config.getString("defaults.analysis.pathwaydefinition", null);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (pathwayDef != null && !pathwayDef.equals("")) {
            this.pathwayDefinition = pathwayDef;
        }
        int i = 0;
        String dataset = config.getString("datasets.dataset(" + i + ").name", null);
        if (this.settingsTextToReplace != null && dataset.contains(this.settingsTextToReplace)) {
            dataset = dataset.replace(this.settingsTextToReplace, this.settingsTextReplaceWith);
        }
        if (this.settingsTextToReplace2 != null && dataset.contains(this.settingsTextToReplace2)) {
            dataset = dataset.replace(this.settingsTextToReplace2, this.settingsTextReplace2With);
        }
        this.datasetSettings = new ArrayList();
        while (dataset != null) {
            String expressionData = null;
            String dataloc = null;
            String genToExpCoupling = null;
            Boolean qnorm = false;
            Boolean logtr = false;
            TriTyperGeneticalGenomicsDatasetSettings s = new TriTyperGeneticalGenomicsDatasetSettings();
            s.name = dataset;
            this.datasetSettings.add(s);
            s.cisAnalysis = this.cisAnalysis;
            s.transAnalysis = this.transAnalysis;
            try {
                expressionData = config.getString("datasets.dataset(" + i + ").expressiondata", null);
                if (this.settingsTextToReplace != null && expressionData.contains(this.settingsTextToReplace)) {
                    expressionData = expressionData.replace(this.settingsTextToReplace, this.settingsTextReplaceWith);
                }
                if (this.settingsTextToReplace2 != null && expressionData.contains(this.settingsTextToReplace2)) {
                    expressionData = expressionData.replace(this.settingsTextToReplace2, this.settingsTextReplace2With);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            String expressionPlatform = null;
            try {
                expressionPlatform = config.getString("datasets.dataset(" + i + ").expressionplatform", null);
                if (this.settingsTextToReplace != null && expressionData.contains(this.settingsTextToReplace)) {
                    expressionPlatform = expressionPlatform.replace(this.settingsTextToReplace, this.settingsTextReplaceWith);
                }
                if (this.settingsTextToReplace2 != null && expressionData.contains(this.settingsTextToReplace2)) {
                    expressionPlatform = expressionPlatform.replace(this.settingsTextToReplace2, this.settingsTextReplace2With);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.probeannotation = null;
            try {
                this.probeannotation = config.getString("datasets.dataset(" + i + ").probeannotation", null);
                if (this.settingsTextToReplace != null && this.probeannotation.contains(this.settingsTextToReplace)) {
                    this.probeannotation = this.probeannotation.replace(this.settingsTextToReplace, this.settingsTextReplaceWith);
                }
                if (this.settingsTextToReplace2 != null && this.probeannotation.contains(this.settingsTextToReplace2)) {
                    this.probeannotation = this.probeannotation.replace(this.settingsTextToReplace2, this.settingsTextReplace2With);
                }
                if (this.probeannotation.length() == 0) {
                    this.probeannotation = null;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            s.expressionplatform = expressionPlatform;
            s.probeannotation = this.probeannotation;
            s.expressionLocation = expressionData;
            try {
                dataloc = config.getString("datasets.dataset(" + i + ").location", null);
                if (this.settingsTextToReplace != null && dataloc.contains(this.settingsTextToReplace)) {
                    dataloc = dataloc.replace(this.settingsTextToReplace, this.settingsTextReplaceWith);
                }
                if (this.settingsTextToReplace2 != null && dataloc.contains(this.settingsTextToReplace2)) {
                    dataloc = dataloc.replace(this.settingsTextToReplace2, this.settingsTextReplace2With);
                }
            }
            catch (Exception e) {
                System.out.println("Please provide a location on your disk where " + dataset + " is located");
                System.exit(-1);
            }
            Gpio.formatAsDirectory(dataloc);
            s.genotypeLocation = dataloc;
            String covariateFile = null;
            try {
                covariateFile = config.getString("datasets.dataset(" + i + ").covariates", null);
                if (covariateFile.equals("")) {
                    covariateFile = null;
                }
                if (this.settingsTextToReplace != null && covariateFile.contains(this.settingsTextToReplace)) {
                    covariateFile = covariateFile.replace(this.settingsTextToReplace, this.settingsTextReplaceWith);
                }
                if (this.settingsTextToReplace2 != null && covariateFile.contains(this.settingsTextToReplace2)) {
                    covariateFile = covariateFile.replace(this.settingsTextToReplace2, this.settingsTextReplace2With);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            s.covariateFile = covariateFile;
            try {
                genToExpCoupling = config.getString("datasets.dataset(" + i + ").genometoexpressioncoupling", null);
                if (this.settingsTextToReplace != null && genToExpCoupling.contains(this.settingsTextToReplace)) {
                    genToExpCoupling = genToExpCoupling.replace(this.settingsTextToReplace, this.settingsTextReplaceWith);
                }
                if (this.settingsTextToReplace2 != null && genToExpCoupling.contains(this.settingsTextToReplace2)) {
                    genToExpCoupling = genToExpCoupling.replace(this.settingsTextToReplace2, this.settingsTextReplace2With);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            s.genotypeToExpressionCoupling = genToExpCoupling;
            try {
                qnorm = config.getBoolean("datasets.dataset(" + i + ").quantilenormalize", false);
            }
            catch (Exception e) {
                // empty catch block
            }
            s.quantilenormalize = qnorm;
            try {
                logtr = config.getBoolean("datasets.dataset(" + i + ").logtranform", false);
            }
            catch (Exception e) {
                // empty catch block
            }
            s.logtransform = logtr;
            dataset = null;
            ++i;
            try {
                dataset = config.getString("datasets.dataset(" + i + ").name", null);
                if (this.settingsTextToReplace != null && dataset.contains(this.settingsTextToReplace)) {
                    dataset = dataset.replace(this.settingsTextToReplace, this.settingsTextReplaceWith);
                }
                if (this.settingsTextToReplace2 != null && dataset.contains(this.settingsTextToReplace2)) {
                    dataset = dataset.replace(this.settingsTextToReplace2, this.settingsTextReplace2With);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            s.confineProbesToProbesMappingToAnyChromosome = this.confineProbesToProbesMappingToAnyChromosome;
            s.confineProbesToProbesThatMapToChromosome = this.confineProbesToProbesThatMapToChromosome;
            s.tsProbesConfine = this.tsProbesConfine;
        }
    }

    public String summarize() {
        Date currentDataTime = new Date();
        String summary = "QTL mapping was performed using metaqtl version: " + Main.VERSION + "\nCurrent date and time: " + Main.DATE_TIME_FORMAT.format(currentDataTime) + "\n\n" + "Following settings will be applied:\n" + "Settings\n----\n" + "settingsTextToReplace\t" + this.settingsTextToReplace + "\n" + "settingsTextReplaceWith\t" + this.settingsTextReplaceWith + "\n" + "settingsTextToReplace2\t" + this.settingsTextToReplace2 + "\n" + "settingsTextReplace2With\t" + this.settingsTextReplace2With + "\n" + "\nOutput\n----\n" + "createSNPPValueSummaryStatisticsFile\t" + this.createSNPPValueSummaryStatisticsFile + "\n" + "createEQTLPValueTable\t" + this.createEQTLPValueTable + "\n" + "outputReportsDir\t" + this.outputReportsDir + "\n" + "\nAnalysis\n----\n" + "randomseed\t" + this.rSeed + "\n" + "performCiseQTLAnalysis\t" + this.cisAnalysis + "\n" + "performTranseQTLAnalysis\t" + this.transAnalysis + "\n" + "performParametricAnalysis\t" + this.performParametricAnalysis + "\n" + "useAbsoluteZScorePValue\t" + this.useAbsoluteZScorePValue + "\n" + "ciseQTLAnalysMaxSNPProbeMidPointDistance\t" + this.ciseQTLAnalysMaxSNPProbeMidPointDistance + "\n" + "maxNrMostSignificantEQTLs\t" + this.maxNrMostSignificantEQTLs + "\n" + "performParametricAnalysisGetAccuratePValueEstimates\t" + this.performParametricAnalysisGetAccuratePValueEstimates + "\n" + "nrThreads\t" + this.nrThreads + "\n" + "fdrCutOff\t" + this.fdrCutOff + "\n" + "fdrType\t" + (Object)((Object)this.fdrType) + "\n" + "nrPermutationsFDR\t" + this.nrPermutationsFDR + "\n" + "regressOutEQTLEffectFileName\t" + this.regressOutEQTLEffectFileName + "\n" + "snpQCCallRateThreshold\t" + this.snpQCCallRateThreshold + "\n" + "snpQCHWEThreshold\t" + this.snpQCHWEThreshold + "\n" + "snpQCMAFThreshold\t" + this.snpQCMAFThreshold + "\n" + "\nConfinements\n----\n" + "performEQTLAnalysisOnSNPProbeCombinationSubset\t" + this.performEQTLAnalysisOnSNPProbeCombinationSubset + "\n" + "confineToSNPsThatMapToChromosome\t" + this.confineToSNPsThatMapToChromosome + "\n" + "expressionDataLoadOnlyProbesThatMapToChromosome\t" + this.expressionDataLoadOnlyProbesThatMapToChromosome + "\n" + "confineSNPsToSNPsPresentInAllDatasets\t" + this.confineSNPsToSNPsPresentInAllDatasets + "\n" + "confineProbesToProbesPresentInAllDatasets\t" + this.confineProbesToProbesPresentInAllDatasets + "\n" + "confineToProbesThatMapToChromosome\t" + this.confineToProbesThatMapToChromosome + "\n" + "expressionDataLoadOnlyProbesThatMapToChromosome\t" + this.expressionDataLoadOnlyProbesThatMapToChromosome + "\n" + "\n";
        if (this.tsProbesConfine != null) {
            summary = summary + "Confining to: " + this.tsProbesConfine.size() + " probes from: " + this.strConfineProbe + "\n";
        }
        if (this.tsSNPProbeCombinationsConfine != null) {
            summary = summary + "Confining to: " + this.tsSNPProbeCombinationsConfine.size() + " SNP-probe combinations from: " + this.strConfineSNPProbe + "\n";
        }
        if (this.tsSNPsConfine != null) {
            summary = summary + "Confining to: " + this.tsSNPsConfine.size() + " SNPs  from: " + this.strConfineSNP + "\n";
        }
        summary = summary + "\nDatasets\n----\n";
        for (TriTyperGeneticalGenomicsDatasetSettings settings : this.datasetSettings) {
            summary = summary + "DatasetName\t" + settings.name + "\n";
            summary = summary + "ExpressionData\t" + settings.expressionLocation + "\n";
            summary = summary + "ExpressionPlatform\t" + settings.expressionplatform + "\n";
            summary = summary + "LogTransform\t" + settings.logtransform + "\n";
            summary = summary + "QuantileNormalize\t" + settings.quantilenormalize + "\n";
            summary = summary + "GenotypeData\t" + settings.genotypeLocation + "\n";
            summary = summary + "GTE\t" + settings.genotypeToExpressionCoupling + "\n";
            summary = summary + "ProbaAnnotation\t" + settings.probeannotation + "\n";
        }
        return summary;
    }

    public void writeSettingsToDisk() throws Exception {
        TextFile tf = new TextFile(this.outputReportsDir + "/UsedSettings.txt", true);
        tf.write(this.summarize());
        tf.close();
    }

    public void loadSNPProbeConfinement(String snpProbeConfine) throws IOException {
        this.strConfineSNPProbe = snpProbeConfine;
        TextFile in = new TextFile(snpProbeConfine, false);
        this.tsSNPProbeCombinationsConfine = new HashMap();
        String[] elems = in.readLineElemsReturnReference(TextFile.tab);
        System.out.println("Loading SNP Probe pairs from: " + snpProbeConfine);
        while (elems != null) {
            if (elems.length > 1) {
                String snp = new String(elems[0].getBytes("UTF-8"));
                snp = snp.trim();
                while (snp.startsWith(" ")) {
                    snp = snp.substring(1);
                }
                if (this.tsSNPsConfine != null && this.tsSNPsConfine.contains(snp) || this.tsSNPsConfine == null) {
                    HashSet<String> probes = this.tsSNPProbeCombinationsConfine.get(snp);
                    if (probes == null) {
                        probes = new HashSet();
                    }
                    String probe = new String(elems[1].getBytes("UTF-8"));
                    probe = probe.trim();
                    while (probe.startsWith(" ")) {
                        probe = probe.substring(1);
                    }
                    if (this.tsProbesConfine != null && this.tsProbesConfine.contains(probe) || this.tsProbesConfine == null) {
                        probes.add(probe);
                    }
                    this.tsSNPProbeCombinationsConfine.put(snp, probes);
                }
            }
            elems = in.readLineElemsReturnReference(TextFile.tab);
        }
        in.close();
    }
}

