/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.metaqtl3.containers;

import cern.colt.matrix.tint.IntMatrix2D;
import eqtlmappingpipeline.metaqtl3.containers.WorkPackage;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import umcg.genetica.io.trityper.SNP;
import umcg.genetica.io.trityper.TriTyperGeneticalGenomicsDataset;
import umcg.genetica.io.trityper.util.BaseAnnot;

public class QTL
implements Comparable<QTL> {
    private double pvalue = Double.MAX_VALUE;
    private int pid = -1;
    private int sid = -1;
    private byte alleleAssessed;
    private double zscore = 0.0;
    private byte[] alleles;
    private double[] datasetZScores;
    private int[] datasetsSamples;
    private double[] correlations;
    private double[] datasetfc;
    private double[] datasetbeta;
    private double[] datasetbetase;
    private double finalbeta;
    private double finalbetase;
    private static final DecimalFormat format = new DecimalFormat("###.#######", new DecimalFormatSymbols(Locale.US));
    private static final DecimalFormat smallFormat = new DecimalFormat("0.#####E0", new DecimalFormatSymbols(Locale.US));

    public QTL(int datasets) {
        this.alleles = null;
        this.datasetZScores = null;
        this.datasetsSamples = null;
        this.correlations = null;
    }

    public QTL() {
    }

    public QTL(double pval, int pid, int sid, byte assessedAllele, double zscore, byte[] alleles, double[] zscores, int[] numSamples, double[] correlations, double[] fc, double[] beta, double[] betase, double finalbeta, double finalbetase) {
        this.pvalue = pval;
        this.pid = pid;
        this.sid = sid;
        this.alleleAssessed = assessedAllele;
        this.zscore = zscore;
        this.alleles = alleles;
        this.datasetZScores = zscores;
        this.datasetsSamples = numSamples;
        this.correlations = correlations;
        this.datasetfc = fc;
        this.datasetbeta = beta;
        this.datasetbetase = betase;
        this.finalbeta = finalbeta;
        this.finalbetase = finalbetase;
    }

    @Override
    public int compareTo(QTL o) {
        if (this.pvalue == o.pvalue) {
            if (Math.abs(this.zscore) == Math.abs(o.zscore)) {
                return 0;
            }
            if (Math.abs(this.zscore) < Math.abs(o.zscore)) {
                return 1;
            }
            return -1;
        }
        if (this.pvalue > o.pvalue) {
            return 1;
        }
        return -1;
    }

    public boolean equals(QTL o) {
        if (this.pvalue == o.pvalue) {
            return Math.abs(this.zscore) == Math.abs(o.zscore);
        }
        return false;
    }

    public void cleanUp() {
        int i;
        this.alleles = null;
        if (this.datasetZScores != null) {
            for (i = 0; i < this.datasetZScores.length; ++i) {
                this.datasetZScores[i] = Double.NaN;
            }
            this.datasetZScores = null;
        }
        if (this.datasetsSamples != null) {
            for (i = 0; i < this.datasetsSamples.length; ++i) {
                this.datasetsSamples[i] = -9;
            }
            this.datasetsSamples = null;
        }
        if (this.correlations != null) {
            for (i = 0; i < this.correlations.length; ++i) {
                this.correlations[i] = Double.NaN;
            }
            this.correlations = null;
        }
    }

    public double getPvalue() {
        return this.pvalue;
    }

    public double getZscore() {
        return this.zscore;
    }

    public double[] getCorrelations() {
        return this.correlations;
    }

    public String getDescription(WorkPackage[] workPackages, IntMatrix2D probeTranslation, TriTyperGeneticalGenomicsDataset[] gg, int maxCisDistance) {
        if (this.sid == -1 && this.pid == -1) {
            return null;
        }
        String sepStr = ";";
        String nullstr = "-";
        char tabStr = '\t';
        StringBuilder out = new StringBuilder();
        if (this.pvalue < 1.0E-4) {
            out.append(smallFormat.format(this.pvalue));
        } else {
            out.append(format.format(this.pvalue));
        }
        out.append(tabStr);
        String rsName = null;
        String rsChr = nullstr;
        String rsChrPos = nullstr;
        WorkPackage currentWP = workPackages[this.sid];
        SNP[] snps = workPackages[this.sid].getSnps();
        for (int d = 0; d < snps.length; ++d) {
            if (snps[d] == null) continue;
            rsName = snps[d].getName();
            rsChr = String.valueOf(snps[d].getChr());
            rsChrPos = String.valueOf(snps[d].getChrPos());
            break;
        }
        String probe = nullstr;
        String probeChr = nullstr;
        String probeChrPos = nullstr;
        for (int d = 0; d < snps.length; ++d) {
            if (probeTranslation.get(d, this.pid) == -9) continue;
            int probeId = probeTranslation.get(d, this.pid);
            probe = gg[d].getExpressionData().getProbes()[probeId];
            probeChr = String.valueOf(gg[d].getExpressionData().getChr()[probeId]);
            probeChrPos = String.valueOf((gg[d].getExpressionData().getChrStart()[probeId] + gg[d].getExpressionData().getChrStop()[probeId]) / 2);
            break;
        }
        out.append(rsName);
        out.append(tabStr);
        out.append(rsChr);
        out.append(tabStr);
        out.append(rsChrPos);
        out.append(tabStr);
        out.append(probe);
        out.append(tabStr);
        out.append(probeChr);
        out.append(tabStr);
        out.append(probeChrPos);
        out.append(tabStr);
        String eQTLType = "trans";
        if (!(rsChr.equals(nullstr) || probeChr.equals(nullstr) || probeChrPos.equals(nullstr) || rsChrPos.equals(nullstr) || !rsChr.equals(probeChr) || Math.abs(Integer.parseInt(probeChrPos) - Integer.parseInt(rsChrPos)) >= maxCisDistance)) {
            eQTLType = "cis";
        }
        out.append(eQTLType);
        out.append(tabStr);
        if (this.alleles == null) {
            System.err.println(rsName + " has null alleles..?'\n" + out.toString());
            return null;
        }
        out.append(BaseAnnot.toString(this.alleles[0])).append("/").append(BaseAnnot.toString(this.alleles[1]));
        out.append(tabStr);
        out.append(BaseAnnot.toString(this.alleleAssessed));
        out.append(tabStr);
        if (Math.abs(this.zscore) < 1.0E-4) {
            out.append(smallFormat.format(this.zscore));
        } else {
            out.append(format.format(this.zscore));
        }
        out.append(tabStr);
        String[] ds = new String[gg.length];
        Double[] probevars = new Double[gg.length];
        Double[] probemeans = new Double[gg.length];
        String hugo = nullstr;
        for (int d = 0; d < gg.length; ++d) {
            if (!Double.isNaN(this.correlations[d])) {
                ds[d] = gg[d].getSettings().name;
                if (probeTranslation.get(d, this.pid) != -9) {
                    int probeId = probeTranslation.get(d, this.pid);
                    probevars[d] = gg[d].getExpressionData().getOriginalProbeVariance()[probeId];
                    probemeans[d] = gg[d].getExpressionData().getOriginalProbeMean()[probeId];
                    hugo = gg[d].getExpressionData().getAnnotation()[probeId];
                    continue;
                }
                System.out.println("ERROR!!!");
                continue;
            }
            ds[d] = null;
            probevars[d] = null;
            probemeans[d] = null;
        }
        StringBuilder outcorrs = new StringBuilder();
        StringBuilder outzscores = new StringBuilder();
        StringBuilder outsamples = new StringBuilder();
        StringBuilder outmeans = new StringBuilder();
        StringBuilder outvars = new StringBuilder();
        StringBuilder outfc = new StringBuilder();
        StringBuilder outbeta = new StringBuilder();
        if (ds == null) {
            out.append(nullstr);
            out.append(tabStr);
            out.append(nullstr);
            out.append(tabStr);
            out.append(nullstr);
            out.append(tabStr);
            out.append(nullstr);
            out.append(tabStr);
            out.append(nullstr);
            out.append(tabStr);
            out.append(nullstr);
            out.append(tabStr);
            out.append(nullstr);
        } else {
            for (int d = 0; d < ds.length; ++d) {
                DecimalFormat f;
                sepStr = d == 0 ? "" : ";";
                if (ds[d] == null) {
                    out.append(sepStr).append(nullstr);
                } else {
                    out.append(sepStr).append(ds[d]);
                }
                if (this.correlations == null || Double.isNaN(this.correlations[d])) {
                    outcorrs.append(sepStr).append(nullstr);
                } else {
                    f = format;
                    if (Math.abs(this.correlations[d]) < 1.0E-4) {
                        f = smallFormat;
                    }
                    if (currentWP.getFlipSNPAlleles()[d].booleanValue()) {
                        outcorrs.append(sepStr).append(f.format(-this.correlations[d]));
                    } else {
                        outcorrs.append(sepStr).append(f.format(this.correlations[d]));
                    }
                }
                if (this.datasetZScores == null || Double.isNaN(this.datasetZScores[d])) {
                    outzscores.append(sepStr).append(nullstr);
                } else {
                    f = format;
                    if (Math.abs(this.datasetZScores[d]) < 1.0E-4) {
                        f = smallFormat;
                    }
                    if (currentWP.getFlipSNPAlleles()[d].booleanValue()) {
                        outzscores.append(sepStr).append(f.format(-this.datasetZScores[d]));
                    } else {
                        outzscores.append(sepStr).append(f.format(this.datasetZScores[d]));
                    }
                }
                if (this.datasetsSamples == null || this.datasetsSamples[d] == -9) {
                    outsamples.append(sepStr).append(nullstr);
                } else {
                    outsamples.append(sepStr).append(this.datasetsSamples[d]);
                }
                if (probemeans == null || probemeans[d] == null) {
                    outmeans.append(sepStr).append(nullstr);
                } else {
                    outmeans.append(sepStr).append(format.format(probemeans[d]));
                }
                if (probevars == null || probevars[d] == null) {
                    outvars.append(sepStr).append(nullstr);
                } else {
                    outvars.append(sepStr).append(format.format(probevars[d]));
                }
                if (this.datasetfc == null || Double.isNaN(this.datasetfc[d])) {
                    outfc.append(sepStr).append(nullstr);
                } else {
                    outfc.append(sepStr).append(format.format(this.datasetfc[d]));
                }
                if (this.datasetbeta == null || Double.isNaN(this.datasetbeta[d])) {
                    outbeta.append(sepStr).append(nullstr);
                    continue;
                }
                f = format;
                if (Math.abs(this.datasetbeta[d]) < 1.0E-4) {
                    f = smallFormat;
                }
                DecimalFormat f2 = format;
                if (Math.abs(this.datasetbetase[d]) < 1.0E-4) {
                    f2 = smallFormat;
                }
                if (currentWP.getFlipSNPAlleles()[d].booleanValue()) {
                    outbeta.append(sepStr).append(f.format(-this.datasetbeta[d])).append(" (").append(f2.format(this.datasetbetase[d])).append(")");
                    continue;
                }
                outbeta.append(sepStr).append(f.format(this.datasetbeta[d])).append(" (").append(f2.format(this.datasetbetase[d])).append(")");
            }
            out.append(tabStr);
            out.append(outzscores.toString());
            out.append(tabStr);
            out.append(outsamples.toString());
            out.append(tabStr);
            out.append(outmeans.toString());
            out.append(tabStr);
            out.append(outvars.toString());
            out.append(tabStr);
            out.append(hugo);
            out.append(tabStr);
            out.append(outcorrs.toString());
            out.append(tabStr);
            DecimalFormat f = format;
            if (Math.abs(this.finalbeta) < 1.0E-4) {
                f = smallFormat;
            }
            DecimalFormat f2 = format;
            if (Math.abs(this.finalbetase) < 1.0E-4) {
                f2 = smallFormat;
            }
            out.append(f.format(this.finalbeta)).append(" (").append(f2.format(this.finalbetase)).append(")");
            out.append(tabStr);
            out.append(outbeta.toString());
            out.append(tabStr);
            out.append(outfc.toString());
        }
        return out.toString();
    }

    public String getPermutationDescription(WorkPackage[] workPackages, IntMatrix2D probeTranslation, TriTyperGeneticalGenomicsDataset[] gg, int maxCisDistance) {
        if (this.sid == -1 && this.pid == -1) {
            return null;
        }
        String nullstr = "-";
        char tabStr = '\t';
        StringBuilder out = new StringBuilder();
        if (this.pvalue < 1.0E-4) {
            out.append(smallFormat.format(this.pvalue));
        } else {
            out.append(format.format(this.pvalue));
        }
        out.append(tabStr);
        String rsName = null;
        SNP[] snps = workPackages[this.sid].getSnps();
        for (int d = 0; d < snps.length; ++d) {
            if (snps[d] == null) continue;
            rsName = snps[d].getName();
            break;
        }
        String probe = nullstr;
        for (int d = 0; d < snps.length; ++d) {
            if (probeTranslation.get(d, this.pid) == -9) continue;
            int probeId = probeTranslation.get(d, this.pid);
            probe = gg[d].getExpressionData().getProbes()[probeId];
            break;
        }
        out.append(rsName);
        out.append(tabStr);
        out.append(probe);
        out.append(tabStr);
        String hugo = nullstr;
        for (int d = 0; d < gg.length; ++d) {
            if (Double.isNaN(this.correlations[d]) || probeTranslation.get(d, this.pid) == -9) continue;
            int probeId = probeTranslation.get(d, this.pid);
            hugo = gg[d].getExpressionData().getAnnotation()[probeId];
            if (hugo != null) continue;
            hugo = nullstr;
        }
        out.append(hugo);
        out.append(tabStr);
        if (this.alleles == null) {
            System.err.println(rsName + " has null alleles..?'\n" + out.toString());
            return null;
        }
        out.append(BaseAnnot.toString(this.alleles[0])).append("/").append(BaseAnnot.toString(this.alleles[1]));
        out.append(tabStr);
        out.append(BaseAnnot.toString(this.alleleAssessed));
        out.append(tabStr);
        if (this.zscore < 1.0E-4) {
            out.append(smallFormat.format(this.zscore));
        } else {
            out.append(format.format(this.zscore));
        }
        return out.toString();
    }
}

