/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.metaqtl3;

import cern.colt.matrix.tint.IntMatrix2D;
import eqtlmappingpipeline.metaqtl3.containers.Settings;
import eqtlmappingpipeline.metaqtl3.containers.WorkPackage;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.SNP;
import umcg.genetica.io.trityper.SNPLoader;
import umcg.genetica.io.trityper.TriTyperGeneticalGenomicsDataset;
import umcg.genetica.io.trityper.util.BaseAnnot;

class WorkPackageProducer
extends Thread {
    private String[] m_snpList;
    private TriTyperGeneticalGenomicsDataset[] m_gg;
    private LinkedBlockingQueue<WorkPackage> m_queue;
    private WorkPackage[] m_workPackages;
    private SNPLoader[] m_SNPLoaders;
    private Settings m_settings;
    private double m_mafthreshold;
    private double m_hwethreshold;
    private double m_callratethreshold;
    public boolean done;
    public boolean semaphore;
    private boolean m_permuting;
    private final String m_outputdir;

    WorkPackageProducer(LinkedBlockingQueue<WorkPackage> packageQueue, WorkPackage[] workPackages, String[] snpList, String[] probeList, IntMatrix2D probeTranslationTable, IntMatrix2D snpTranslationTable, TriTyperGeneticalGenomicsDataset[] gg, SNPLoader[] snploaders, Settings settings, boolean permuting) {
        this.m_workPackages = workPackages;
        this.m_queue = packageQueue;
        this.m_snpList = snpList;
        this.m_gg = gg;
        this.m_SNPLoaders = snploaders;
        this.m_settings = settings;
        this.m_mafthreshold = settings.snpQCMAFThreshold;
        this.m_hwethreshold = settings.snpQCHWEThreshold;
        this.m_callratethreshold = settings.snpQCCallRateThreshold;
        this.m_permuting = permuting;
        this.m_outputdir = settings.outputReportsDir;
    }

    @Override
    public void run() {
        int i;
        this.done = false;
        this.semaphore = false;
        int workPackageBufferSize = 1;
        double sumaveragesnpsize = 0.0;
        try {
            for (int d = 0; d < this.m_SNPLoaders.length; ++d) {
                sumaveragesnpsize += this.m_SNPLoaders[d].getAverageSNPSize(this.m_gg[d].getGenotypeData().getSNPs().length);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        workPackageBufferSize = (int)Math.floor(5.24288E7 / (sumaveragesnpsize /= (double)this.m_SNPLoaders.length));
        if (this.m_workPackages.length < workPackageBufferSize) {
            workPackageBufferSize = this.m_workPackages.length;
        }
        int workPackagesPassingQC = 0;
        int numProcessed = 0;
        TextFile snplog = null;
        try {
            if (!this.m_permuting) {
                int d;
                snplog = new TextFile(this.m_outputdir + "SNPQCLog.txt.gz", true);
                String ln = "-";
                for (d = 0; d < this.m_gg.length; ++d) {
                    ln = ln + "\t" + this.m_gg[d].getSettings().name + "\t\t\t\t\t\t\t";
                }
                snplog.writeln(ln);
                ln = "SNP";
                for (d = 0; d < this.m_gg.length; ++d) {
                    ln = ln + "\tSNPId\tAlleles\tFreqAA\tFreqAB\tFreqBB\tCR\tMAF\tHWE\tPassesQC";
                }
                snplog.writeln(ln);
            }
            while (numProcessed < this.m_workPackages.length) {
                if (numProcessed + workPackageBufferSize > this.m_workPackages.length) {
                    workPackageBufferSize = this.m_workPackages.length - numProcessed;
                }
                WorkPackage[] workPackageBuffer = new WorkPackage[workPackageBufferSize];
                StringBuilder[] qcBuffer = null;
                if (!this.m_permuting) {
                    qcBuffer = new StringBuilder[workPackageBufferSize];
                }
                int numInBuffer = 0;
                while (numInBuffer < workPackageBufferSize && numProcessed < this.m_workPackages.length) {
                    WorkPackage toAdd = this.m_workPackages[numProcessed];
                    if (toAdd != null) {
                        workPackageBuffer[numInBuffer] = toAdd;
                        ++numInBuffer;
                    }
                    ++numProcessed;
                }
                for (int d = 0; d < this.m_gg.length; ++d) {
                    SNP[] snps;
                    SNP dSNP;
                    WorkPackage wp;
                    int i2;
                    SNPLoader loader = this.m_SNPLoaders[d];
                    boolean dosageAvailable = loader.hasDosageInformation();
                    for (i2 = 0; i2 < workPackageBufferSize; ++i2) {
                        wp = workPackageBuffer[i2];
                        if (!this.m_permuting && qcBuffer[i2] == null) {
                            qcBuffer[i2] = new StringBuilder();
                        }
                        if (this.m_gg.length > 1) {
                            wp.setDatasetToSortSNPs(d + 1);
                        }
                        if ((dSNP = (snps = wp.getSnps())[d]) != null) {
                            loader.loadGenotypes(dSNP);
                            if (!dSNP.passesQC() || dSNP.getCR() < this.m_callratethreshold || dSNP.getMAF() < this.m_mafthreshold || dSNP.getHWEP() < this.m_hwethreshold || dSNP.getAlleleItr() > 2) {
                                snps[d].setPassesQC(false);
                            } else {
                                short dsPassingQC = wp.getDatasetsPassingQC();
                                dsPassingQC = (short)(dsPassingQC + 1);
                                wp.setDatasetsPassingQC(dsPassingQC);
                            }
                            if (!this.m_permuting) {
                                Integer snpid = this.m_gg[d].getGenotypeData().getSnpToSNPId().get((Object)dSNP.getName());
                                qcBuffer[i2].append("\t").append(snpid).append("\t").append(BaseAnnot.getAllelesDescription(dSNP.getAlleles())).append("\t").append(dSNP.getGenotypeFreq()[0]).append(" (").append(BaseAnnot.toString(dSNP.getAlleles()[0])).append(BaseAnnot.toString(dSNP.getAlleles()[0])).append(")").append("\t").append(dSNP.getGenotypeFreq()[1]).append(" (").append(BaseAnnot.toString(dSNP.getAlleles()[0])).append(BaseAnnot.toString(dSNP.getAlleles()[1])).append(")").append("\t").append(dSNP.getGenotypeFreq()[2]).append(" (").append(BaseAnnot.toString(dSNP.getAlleles()[1])).append(BaseAnnot.toString(dSNP.getAlleles()[1])).append(")").append("\t").append(dSNP.getCR()).append("\t").append(dSNP.getMAF()).append("\t").append(dSNP.getHWEP()).append("\t").append(dSNP.passesQC());
                            }
                            if (dSNP.passesQC()) continue;
                            snps[d].clearGenotypes();
                            snps[d] = null;
                            continue;
                        }
                        if (this.m_permuting) continue;
                        qcBuffer[i2].append("\tNA\t-\t-\t-\t-");
                    }
                    if (!dosageAvailable) continue;
                    for (i2 = 0; i2 < workPackageBufferSize; ++i2) {
                        wp = workPackageBuffer[i2];
                        snps = wp.getSnps();
                        dSNP = snps[d];
                        if (wp.getDatasetsPassingQC() <= 0 || dSNP == null || !dSNP.passesQC()) continue;
                        loader.loadDosage(dSNP);
                    }
                }
                for (i = 0; i < workPackageBufferSize; ++i) {
                    WorkPackage wp = workPackageBuffer[i];
                    if (!this.m_permuting) {
                        String snpName = this.m_snpList[wp.getMetaSNPId()];
                        SNP[] snps = wp.getSnps();
                        boolean notequal = false;
                        for (int d = 0; d < snps.length; ++d) {
                            SNP snp = snps[d];
                            if (snp == null || snpName.equals(snp.getName())) continue;
                            System.out.println("ERROR! SNP names not equal: " + d + "-" + snp.getName());
                            notequal = true;
                        }
                        if (notequal) {
                            System.exit(0);
                        }
                        StringBuilder finalQCString = new StringBuilder().append(this.m_snpList[wp.getMetaSNPId()]).append(qcBuffer[i].toString());
                        snplog.writeln(finalQCString.toString());
                    }
                    if (this.m_settings.confineSNPsToSNPsPresentInAllDatasets == false && wp.getDatasetsPassingQC() > 0 || this.m_settings.confineSNPsToSNPsPresentInAllDatasets != false && wp.getDatasetsPassingQC() == this.m_gg.length || this.m_settings.confineSNPsToSNPsPresentInAllDatasets.booleanValue() && this.m_permuting && wp.getDatasetsPassingQC() > 0) {
                        boolean allelesOk = this.detmermineAlleleFlips(wp, snplog);
                        if (!allelesOk) continue;
                        try {
                            this.m_queue.put(wp);
                            ++workPackagesPassingQC;
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                        }
                        continue;
                    }
                    wp = null;
                }
            }
            if (!this.m_permuting && snplog != null) {
                snplog.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int remaining = this.m_queue.remainingCapacity();
        int prevSize = Integer.MAX_VALUE;
        int realsize = this.m_queue.size() - remaining;
        while (realsize > 0) {
            realsize = this.m_queue.size() - remaining;
            if (realsize >= prevSize || realsize <= 0) continue;
            if (this.m_settings.transAnalysis) {
                // empty if block
            }
            prevSize = realsize;
        }
        for (i = 0; i < this.m_settings.nrThreads * 2; ++i) {
            WorkPackage bomb = new WorkPackage();
            bomb.setIsKillPackage(true);
            this.m_queue.offer(bomb);
        }
    }

    private byte[] convertToComplementaryAlleles(byte[] allelesToCompare) {
        byte[] allelesComplementary = new byte[2];
        for (int a = 0; a < 2; ++a) {
            allelesComplementary[a] = BaseAnnot.getComplement(allelesToCompare[a]);
        }
        return allelesComplementary;
    }

    private boolean detmermineAlleleFlips(WorkPackage wp, TextFile snplog) throws IOException {
        SNP[] snps = wp.getSnps();
        int firstDatasetToPassQC = -1;
        byte[] firstDatasetPassinQCAlleles = null;
        Boolean[] flipAlleles = new Boolean[this.m_gg.length];
        byte firstminor = -1;
        for (int d = 0; d < this.m_gg.length; ++d) {
            int b;
            int a;
            SNP dSNP = snps[d];
            if (dSNP == null) continue;
            if (firstDatasetToPassQC == -1) {
                byte minor;
                firstDatasetToPassQC = d;
                firstDatasetPassinQCAlleles = dSNP.getAlleles();
                flipAlleles[d] = firstDatasetPassinQCAlleles[1] == (minor = dSNP.getMinorAllele()) ? Boolean.valueOf(false) : Boolean.valueOf(true);
                firstminor = minor;
                continue;
            }
            byte[] allelesToCompare = dSNP.getAlleles();
            int nrAllelesIdentical = 0;
            byte minor = dSNP.getMinorAllele();
            boolean flipalleles = false;
            boolean minorAlleleNum = false;
            if (allelesToCompare[0] != minor) {
                minorAlleleNum = true;
            }
            for (a = 0; a < 2; ++a) {
                for (b = 0; b < 2; ++b) {
                    if (firstDatasetPassinQCAlleles[a] != allelesToCompare[b]) continue;
                    ++nrAllelesIdentical;
                }
            }
            if (nrAllelesIdentical != 2) {
                allelesToCompare = this.convertToComplementaryAlleles(allelesToCompare);
                minor = BaseAnnot.getComplement(minor);
            }
            nrAllelesIdentical = 0;
            for (a = 0; a < 2; ++a) {
                for (b = 0; b < 2; ++b) {
                    if (firstDatasetPassinQCAlleles[a] != allelesToCompare[b]) continue;
                    ++nrAllelesIdentical;
                }
            }
            if (nrAllelesIdentical != 2) {
                if (!this.m_permuting) {
                    String snp1Alleles = BaseAnnot.toString(firstDatasetPassinQCAlleles[0]) + "/" + BaseAnnot.toString(firstDatasetPassinQCAlleles[1]);
                    String snp2Alleles = BaseAnnot.toString(allelesToCompare[0]) + "/" + BaseAnnot.toString(allelesToCompare[1]);
                    String output = "SNP alleles are not identical between datasets for SNP: " + wp.getSnps()[d].getName() + "\tSNP1 (" + this.m_gg[firstDatasetToPassQC].getSettings().name + "): " + snp1Alleles + "\tSNP2 (" + this.m_gg[d].getSettings().name + "): " + snp2Alleles;
                    System.err.println(output);
                    snplog.writeln(output);
                }
                return false;
            }
            flipalleles = minor != firstminor ? minorAlleleNum : allelesToCompare[0] == minor;
            flipAlleles[d] = flipalleles;
        }
        wp.setFlipSNPAlleles(flipAlleles);
        return true;
    }

    void kill() {
        this.done = true;
    }

    WorkPackage[] getWorkPackages() {
        return this.m_workPackages;
    }
}

