/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.metaqtl3;

import cern.colt.matrix.tint.IntMatrix2D;
import eqtlmappingpipeline.metaqtl3.containers.QTL;
import eqtlmappingpipeline.metaqtl3.containers.Result;
import eqtlmappingpipeline.metaqtl3.containers.Settings;
import eqtlmappingpipeline.metaqtl3.containers.WorkPackage;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.LinkedBlockingQueue;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import umcg.genetica.console.ProgressBar;
import umcg.genetica.io.bin.BinaryFile;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.SNP;
import umcg.genetica.io.trityper.TriTyperGeneticalGenomicsDataset;
import umcg.genetica.io.trityper.eQTLTextFile;
import umcg.genetica.io.trityper.util.BaseAnnot;

public class ResultProcessorThread
extends Thread {
    long nrZ = 0L;
    private boolean m_createBinaryFiles = false;
    private TriTyperGeneticalGenomicsDataset[] m_gg = null;
    private boolean m_cisOnly;
    private IntMatrix2D m_probeTranslation;
    private int m_midpointprobedist;
    private final String m_outputdir;
    private final boolean m_permuting;
    private final int m_permutationround;
    private final boolean m_createTEXTFiles;
    private final String[] m_probeList;
    private final LinkedBlockingQueue<WorkPackage> m_queue;
    private final WorkPackage[] m_availableWorkPackages;
    private long nrTestsPerformed = 0L;
    private QTL[] finalEQTLs;
    private double maxSavedPvalue = -1.7976931348623157E308;
    private int locationToStoreResult = 0;
    private boolean bufferHasOverFlown = false;
    private boolean sorted = false;
    private int m_maxResults = 0;
    public double highestP = Double.MAX_VALUE;
    private int nrSNPsTested = 0;
    private final boolean m_useAbsoluteZScore;
    private BinaryFile[] zScoreBinaryFile;
    private BinaryFile zScoreMetaAnalysisFile;
    private TextFile zScoreMetaAnalysisRowNamesFile;
    private TextFile[] zScoreRowNamesFile;

    public ResultProcessorThread(int nrThreads, LinkedBlockingQueue<WorkPackage> queue, boolean chargeOutput, TriTyperGeneticalGenomicsDataset[] gg, Settings settings, IntMatrix2D pprobeTranslation, boolean permuting, int round, String[] snplist, String[] probelist, WorkPackage[] allPackages) {
        this.m_availableWorkPackages = allPackages;
        this.m_createBinaryFiles = settings.createBinaryOutputFiles;
        this.m_createTEXTFiles = settings.createTEXTOutputFiles;
        this.m_useAbsoluteZScore = settings.useAbsoluteZScorePValue;
        this.m_queue = queue;
        this.m_outputdir = settings.outputReportsDir;
        this.m_permuting = permuting;
        this.m_permutationround = round;
        this.m_probeTranslation = pprobeTranslation;
        this.m_gg = gg;
        this.m_midpointprobedist = settings.ciseQTLAnalysMaxSNPProbeMidPointDistance;
        this.m_cisOnly = settings.cisAnalysis && !settings.transAnalysis;
        this.m_probeList = probelist;
        this.m_maxResults = settings.maxNrMostSignificantEQTLs;
        int tmpbuffersize = this.m_maxResults / 10;
        if (tmpbuffersize == 0) {
            tmpbuffersize = 10;
        } else if (tmpbuffersize > 250000) {
            tmpbuffersize = 250000;
        }
        this.finalEQTLs = new QTL[this.m_maxResults + tmpbuffersize];
        this.nrSNPsTested = 0;
    }

    @Override
    public void run() {
        try {
            if (this.m_createBinaryFiles) {
                this.zScoreBinaryFile = new BinaryFile[this.m_gg.length];
                this.zScoreRowNamesFile = new TextFile[this.m_gg.length];
                if (this.m_gg.length > 1) {
                    String metaAnalysisFileName = this.m_outputdir + "MetaAnalysis";
                    if (this.m_permuting) {
                        metaAnalysisFileName = metaAnalysisFileName + "-PermutationRound-" + this.m_permutationround;
                    }
                    this.zScoreMetaAnalysisFile = new BinaryFile(metaAnalysisFileName + ".dat", true);
                    if (this.m_cisOnly) {
                        this.zScoreMetaAnalysisFile.writeInt(1);
                    } else {
                        this.zScoreMetaAnalysisFile.writeInt(0);
                    }
                    this.zScoreMetaAnalysisRowNamesFile = new TextFile(metaAnalysisFileName + "-RowNames.txt.gz", true);
                    this.zScoreMetaAnalysisRowNamesFile.writeln("SNP\tAlleles\tMinorAllele\tAlleleAssessed\tNrCalled");
                    TextFile tf = new TextFile(metaAnalysisFileName + "-ColNames.txt.gz", true);
                    tf.writeList(Arrays.asList(this.m_probeList));
                    tf.close();
                }
                for (int d = 0; d < this.m_gg.length; ++d) {
                    String fileName = this.m_outputdir + this.m_gg[d].getSettings().name;
                    if (this.m_permuting) {
                        fileName = fileName + "-PermutationRound-" + this.m_permutationround;
                    }
                    this.zScoreBinaryFile[d] = new BinaryFile(fileName + ".dat", true);
                    if (this.m_cisOnly) {
                        this.zScoreBinaryFile[d].writeInt(1);
                    } else {
                        this.zScoreBinaryFile[d].writeInt(0);
                    }
                    TextFile tf = new TextFile(fileName + "-ColNames.txt.gz", true);
                    tf.writeList(Arrays.asList(this.m_probeList));
                    tf.close();
                    this.zScoreRowNamesFile[d] = new TextFile(fileName + "-RowNames.txt.gz", true);
                    this.zScoreRowNamesFile[d].writeln("SNP\tAlleles\tMinorAllele\tAlleleAssessed\tNrCalled\tMaf\tHWE\tCallRate");
                }
            }
            ProgressBar progressbar = new ProgressBar(this.m_availableWorkPackages.length);
            boolean poison = false;
            while (!poison) {
                WorkPackage wp = this.m_queue.take();
                Result r = wp.results;
                if (wp.getHasResults()) {
                    ++this.nrSNPsTested;
                }
                if (r.poison) {
                    poison = true;
                } else if (r.pvalues != null) {
                    this.nrTestsPerformed += (long)wp.getNumTested();
                    double[] pvalues = r.pvalues;
                    if (this.m_createBinaryFiles && !poison) {
                        this.writeBinaryResult(r);
                    }
                    if (this.m_createTEXTFiles && !poison) {
                        for (int p = 0; p < pvalues.length; ++p) {
                            int d;
                            double pval = pvalues[p];
                            if (Double.isNaN(pval) || !(pval <= this.highestP)) continue;
                            double[][] corr = r.correlations;
                            double[] correlations = new double[corr.length];
                            double[] zscores = new double[corr.length];
                            int[] samples = new int[corr.length];
                            double[] fc = new double[corr.length];
                            double[] beta = new double[corr.length];
                            double[] betase = new double[corr.length];
                            for (int d2 = 0; d2 < correlations.length; ++d2) {
                                if (Double.isNaN(corr[d2][p])) {
                                    correlations[d2] = Double.NaN;
                                    zscores[d2] = Double.NaN;
                                    samples[d2] = -9;
                                    fc[d2] = Double.NaN;
                                    beta[d2] = Double.NaN;
                                    betase[d2] = Double.NaN;
                                    continue;
                                }
                                correlations[d2] = corr[d2][p];
                                zscores[d2] = this.m_useAbsoluteZScore ? Math.abs(r.zscores[d2][p]) : r.zscores[d2][p];
                                samples[d2] = r.numSamples[d2];
                                fc[d2] = r.fc[d2][p];
                                beta[d2] = r.beta[d2][p];
                                betase[d2] = r.se[d2][p];
                            }
                            byte allele = -1;
                            byte[] alleles = null;
                            SNP[] snps = wp.getSnps();
                            for (d = 0; d < snps.length; ++d) {
                                if (snps[d] == null) continue;
                                allele = snps[d].getMinorAllele();
                                alleles = snps[d].getAlleles();
                                break;
                            }
                            if (alleles == null) {
                                System.err.println("SNP has null alleles: ");
                                for (d = 0; d < snps.length; ++d) {
                                    if (snps[d] == null) continue;
                                    allele = snps[d].getMinorAllele();
                                    System.err.println(allele);
                                    alleles = snps[d].getAlleles();
                                    System.err.println(alleles);
                                    break;
                                }
                            }
                            double Zfinal = r.finalZScore[p];
                            double finalbeta = r.finalBeta[p];
                            double finalbetase = r.finalBetaSe[p];
                            int pid = this.m_cisOnly ? wp.getProbes()[p] : p;
                            this.addEQTL(pid, wp.getId(), pval, Zfinal, correlations, zscores, samples, alleles, allele, fc, beta, betase, finalbeta, finalbetase);
                        }
                    }
                }
                if (wp.results != null) {
                    wp.clearResults();
                }
                progressbar.iterate();
            }
            progressbar.close();
            if (this.m_createBinaryFiles) {
                String fileName = "check";
                if (this.m_permuting) {
                    fileName = fileName + "-PermutationRound-" + this.m_permutationround;
                }
                fileName = fileName + ".md5";
                HexBinaryAdapter md5Parser = new HexBinaryAdapter();
                BufferedWriter md5writer = new BufferedWriter(new FileWriter(this.m_outputdir + fileName));
                for (int d = 0; d < this.m_gg.length; ++d) {
                    this.zScoreBinaryFile[d].close();
                    fileName = this.m_gg[d].getSettings().name;
                    if (this.m_permuting) {
                        fileName = fileName + "-PermutationRound-" + this.m_permutationround;
                    }
                    fileName = fileName + ".dat";
                    md5writer.write(md5Parser.marshal(this.zScoreBinaryFile[d].getWrittenHash()) + "  " + fileName + '\n');
                    this.zScoreRowNamesFile[d].close();
                }
                if (this.m_gg.length > 1) {
                    this.zScoreMetaAnalysisFile.close();
                    fileName = "MetaAnalysis";
                    if (this.m_permuting) {
                        fileName = fileName + "-PermutationRound-" + this.m_permutationround;
                    }
                    fileName = fileName + ".dat";
                    md5writer.write(md5Parser.marshal(this.zScoreMetaAnalysisFile.getWrittenHash()) + "  " + fileName + '\n');
                    this.zScoreMetaAnalysisRowNamesFile.close();
                }
                md5writer.close();
            }
            if (this.m_createTEXTFiles) {
                if (!this.sorted && this.locationToStoreResult != 0) {
                    Arrays.sort(this.finalEQTLs, 0, this.locationToStoreResult);
                }
                this.writeTextResults();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
    }

    private void writeBinaryResult(Result r) throws IOException {
        if (r != null) {
            int[] numSamples = null;
            try {
                numSamples = r.numSamples;
            }
            catch (NullPointerException e) {
                System.out.println("ERROR: null result?");
            }
            int wpId = r.wpid;
            WorkPackage currentWP = this.m_availableWorkPackages[wpId];
            double[][] zscores = r.zscores;
            if (zscores != null) {
                SNP[] snps = currentWP.getSnps();
                int numDatasets = zscores.length;
                double[] finalZscores = r.finalZScore;
                String snpoutput = null;
                if (this.m_gg.length > 1) {
                    int totalSampleNr = 0;
                    String snpname = null;
                    for (int d = 0; d < numDatasets; ++d) {
                        if (snps[d] == null) continue;
                        snpname = snps[d].getName();
                        byte[] alleles = snps[d].getAlleles();
                        byte minorAllele = snps[d].getMinorAllele();
                        byte alleleassessed = alleles[1];
                        if (currentWP.getFlipSNPAlleles()[d].booleanValue()) {
                            alleleassessed = alleles[0];
                        }
                        if (snpoutput == null) {
                            snpoutput = snpname + "\t" + BaseAnnot.getAllelesDescription(alleles) + "\t" + BaseAnnot.toString(minorAllele) + "\t" + BaseAnnot.toString(alleleassessed);
                        }
                        totalSampleNr += r.numSamples[d];
                    }
                    StringBuilder sb = null;
                    for (int p = 0; p < finalZscores.length; ++p) {
                        float z = (float)finalZscores[p];
                        if (this.m_cisOnly) {
                            int[] probes = currentWP.getProbes();
                            int probeId = probes[p];
                            String probeName = this.m_probeList[probeId];
                            if (sb == null) {
                                sb = new StringBuilder();
                            } else {
                                sb.append("\t");
                            }
                            sb.append(probeName);
                            this.zScoreMetaAnalysisFile.writeFloat(z);
                            continue;
                        }
                        this.zScoreMetaAnalysisFile.writeFloat(z);
                    }
                    if (sb != null) {
                        this.zScoreMetaAnalysisRowNamesFile.writeln(snpoutput + "\t" + totalSampleNr + "\t-\t-\t-\t" + finalZscores.length + "\t" + sb.toString());
                    } else {
                        this.zScoreMetaAnalysisRowNamesFile.writeln(snpoutput + "\t" + totalSampleNr + "\t-\t-\t-\t" + finalZscores.length + "\t-");
                    }
                }
                for (int d = 0; d < numDatasets; ++d) {
                    double[] datasetZScores = zscores[d];
                    SNP datasetSNP = snps[d];
                    if (datasetSNP == null) continue;
                    BinaryFile outfile = this.zScoreBinaryFile[d];
                    String snpname = datasetSNP.getName();
                    byte[] alleles = datasetSNP.getAlleles();
                    byte minorAllele = datasetSNP.getMinorAllele();
                    byte alleleassessed = alleles[1];
                    double hwe = datasetSNP.getHWEP();
                    double cr = datasetSNP.getCR();
                    double maf = datasetSNP.getMAF();
                    if (currentWP.getFlipSNPAlleles()[d].booleanValue()) {
                        alleleassessed = alleles[0];
                    }
                    TextFile snpfile = this.zScoreRowNamesFile[d];
                    StringBuilder sb = null;
                    for (int p = 0; p < datasetZScores.length; ++p) {
                        float z = (float)datasetZScores[p];
                        if (currentWP.getFlipSNPAlleles()[d].booleanValue()) {
                            z *= -1.0f;
                        }
                        if (this.m_cisOnly) {
                            int[] probes = currentWP.getProbes();
                            int probeId = probes[p];
                            String probeName = this.m_probeList[probeId];
                            outfile.writeFloat(z);
                            if (sb == null) {
                                sb = new StringBuilder();
                            } else {
                                sb.append("\t");
                            }
                            sb.append(probeName);
                            continue;
                        }
                        outfile.writeFloat(z);
                    }
                    if (sb != null) {
                        snpfile.writeln(snpname + "\t" + BaseAnnot.getAllelesDescription(alleles) + "\t" + BaseAnnot.toString(minorAllele) + "\t" + BaseAnnot.toString(alleleassessed) + "\t" + datasetSNP.getNrCalled() + "\t" + maf + "\t" + hwe + "\t" + cr + "\t" + datasetZScores.length + "\t" + sb.toString());
                        continue;
                    }
                    snpfile.writeln(snpname + "\t" + BaseAnnot.getAllelesDescription(alleles) + "\t" + BaseAnnot.toString(minorAllele) + "\t" + BaseAnnot.toString(alleleassessed) + "\t" + datasetSNP.getNrCalled() + "\t" + maf + "\t" + hwe + "\t" + cr + "\t" + datasetZScores.length + "\t-");
                }
            }
        }
    }

    private void addEQTL(int pid, int sid, double pval, double zscore, double[] correlations, double[] zscores, int[] numSamples, byte[] alleles, byte assessedAllele, double[] fc, double[] beta, double[] betase, double finalbeta, double finalbetase) {
        if (this.bufferHasOverFlown) {
            if (pval <= this.maxSavedPvalue) {
                this.sorted = false;
                this.finalEQTLs[this.locationToStoreResult] = new QTL(pval, pid, sid, assessedAllele, zscore, alleles, zscores, numSamples, correlations, fc, beta, betase, finalbeta, finalbetase);
                ++this.locationToStoreResult;
                if (this.locationToStoreResult == this.finalEQTLs.length) {
                    Arrays.sort(this.finalEQTLs);
                    this.sorted = true;
                    this.locationToStoreResult = this.m_maxResults;
                    this.maxSavedPvalue = this.finalEQTLs[this.m_maxResults - 1].getPvalue();
                }
            }
        } else {
            if (pval > this.maxSavedPvalue) {
                this.maxSavedPvalue = pval;
            }
            this.finalEQTLs[this.locationToStoreResult] = new QTL(pval, pid, sid, assessedAllele, zscore, alleles, zscores, numSamples, correlations, fc, beta, betase, finalbeta, finalbetase);
            ++this.locationToStoreResult;
            if (this.locationToStoreResult == this.m_maxResults) {
                this.bufferHasOverFlown = true;
            }
        }
    }

    private void writeTextResults() throws IOException {
        int nrOfEntriesToWrite = this.m_maxResults;
        if (this.locationToStoreResult < this.m_maxResults) {
            nrOfEntriesToWrite = this.locationToStoreResult;
        }
        System.out.println("Writing " + nrOfEntriesToWrite + " results out of " + this.nrTestsPerformed + " tests performed. " + this.nrSNPsTested + " SNPs finally tested.");
        if (this.m_permuting) {
            TextFile gz = new TextFile(this.m_outputdir + "PermutedEQTLsPermutationRound" + this.m_permutationround + ".txt.gz", true);
            gz.writeln("PValue\tSNP\tProbe\tGene\tAlleles\tAlleleAssessed\tZScore");
            for (int i = 0; i < nrOfEntriesToWrite; ++i) {
                gz.writeln(this.finalEQTLs[i].getPermutationDescription(this.m_availableWorkPackages, this.m_probeTranslation, this.m_gg, this.m_midpointprobedist));
            }
            gz.close();
        } else {
            eQTLTextFile et = new eQTLTextFile(this.m_outputdir + "eQTLs.txt.gz", true);
            for (int i = 0; i < nrOfEntriesToWrite; ++i) {
                et.writeln(this.finalEQTLs[i].getDescription(this.m_availableWorkPackages, this.m_probeTranslation, this.m_gg, this.m_midpointprobedist));
            }
            et.close();
        }
    }
}

