/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.metaqtl3;

import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.DenseIntMatrix2D;
import cern.colt.matrix.tint.impl.DenseLargeIntMatrix2D;
import com.lowagie.text.DocumentException;
import eqtlmappingpipeline.metaqtl3.CalculationThread;
import eqtlmappingpipeline.metaqtl3.EQTLRegression;
import eqtlmappingpipeline.metaqtl3.FDR;
import eqtlmappingpipeline.metaqtl3.ResultProcessorThread;
import eqtlmappingpipeline.metaqtl3.WorkPackageProducer;
import eqtlmappingpipeline.metaqtl3.containers.Result;
import eqtlmappingpipeline.metaqtl3.containers.Settings;
import eqtlmappingpipeline.metaqtl3.containers.WorkPackage;
import eqtlmappingpipeline.metaqtl3.graphics.EQTLDotPlot;
import eqtlmappingpipeline.metaqtl3.graphics.EQTLPlotter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import umcg.genetica.console.ProgressBar;
import umcg.genetica.containers.Pair;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.SNP;
import umcg.genetica.io.trityper.SNPLoader;
import umcg.genetica.io.trityper.TriTyperExpressionData;
import umcg.genetica.io.trityper.TriTyperGeneticalGenomicsDataset;
import umcg.genetica.io.trityper.TriTyperGeneticalGenomicsDatasetSettings;
import umcg.genetica.io.trityper.TriTyperGenotypeData;
import umcg.genetica.math.matrix.DoubleMatrixDataset;
import umcg.genetica.math.stats.Correlation;
import umcg.genetica.math.stats.Descriptives;
import umcg.genetica.util.RunTimer;

public class MetaQTL3 {
    protected Settings m_settings;
    protected TriTyperGeneticalGenomicsDataset[] m_gg = null;
    protected String[] m_snpList;
    protected String[] m_probeList;
    protected IntMatrix2D m_probeTranslationTable;
    protected IntMatrix2D m_snpTranslationTable;
    protected int numAvailableInds;
    protected WorkPackage[] m_workPackages;
    private boolean dataHasCovariates;
    private Pair<List<String>, List<List<String>>> pathwayDefinitions;

    public MetaQTL3() {
    }

    public MetaQTL3(Settings settings) throws IOException, Exception {
        this.m_settings = settings;
        this.initialize(null, null, null, null, null, null, null, null, null, null, null, true, true, 0, true, false, null, null, null, null, null, false, false, null, null, null);
    }

    public void setOutputPlotThreshold(double d) {
        this.m_settings.plotOutputPValueCutOff = d;
        this.m_settings.plotOutputDirectory = this.m_settings.outputReportsDir;
    }

    public void initialize(String xmlSettingsFile, String texttoreplace, String texttoreplacewith, String texttoreplace2, String texttoreplace2with, String ingt, String inexp, String inexpplatform, String inexpannot, String gte, String out, boolean cis, boolean trans, int perm, boolean textout, boolean binout, String snpfile, Integer threads, Integer maxNrResults, String regressouteqtls, String snpprobecombofile, boolean skipdotplot, boolean skipqqplot, Long rseed, Double maf, Double hwe) throws IOException, Exception {
        if (this.m_settings == null && xmlSettingsFile == null && ingt != null) {
            boolean settingsOk = true;
            if (inexp == null || inexp.trim().length() == 0) {
                System.err.println("ERROR: you did not specify a gene expression file.");
                settingsOk = false;
            }
            if (inexpannot != null && inexpannot.trim().length() != 0 && (inexpplatform == null || inexpplatform.trim().length() == 0)) {
                System.err.println("ERROR: you specified " + inexpannot + " but you did not specify the platform (using --inexpplatform)!");
                settingsOk = false;
            }
            if (out == null || out.trim().length() == 0) {
                System.err.println("ERROR: you did not specify an output directory.");
                settingsOk = false;
            }
            if (!settingsOk) {
                System.out.println();
                System.exit(0);
            }
            this.m_settings = new Settings();
            TriTyperGeneticalGenomicsDatasetSettings s = new TriTyperGeneticalGenomicsDatasetSettings();
            s.name = "Dataset";
            s.expressionLocation = inexp;
            s.expressionplatform = inexpplatform;
            s.probeannotation = inexpannot;
            s.genotypeLocation = ingt;
            s.genotypeToExpressionCoupling = gte;
            s.cisAnalysis = cis;
            s.transAnalysis = trans;
            this.m_settings.cisAnalysis = cis;
            this.m_settings.transAnalysis = trans;
            boolean cistrans = false;
            if (this.m_settings.cisAnalysis && this.m_settings.transAnalysis) {
                this.m_settings.confineProbesToProbesMappingToAnyChromosome = true;
            }
            this.m_settings.datasetSettings = new ArrayList();
            this.m_settings.regressOutEQTLEffectFileName = regressouteqtls;
            this.m_settings.datasetSettings.add(s);
            this.m_settings.nrThreads = threads;
            this.m_settings.cisAnalysis = cis;
            this.m_settings.transAnalysis = trans;
            this.m_settings.nrPermutationsFDR = perm;
            if (maf != null && maf > 0.0 && maf < 1.0) {
                this.m_settings.snpQCMAFThreshold = maf;
            }
            if (hwe != null && hwe >= 0.0 && hwe <= 1.0) {
                this.m_settings.snpQCHWEThreshold = hwe;
            }
            if (!out.endsWith("/")) {
                out = out + "/";
            }
            if (!Gpio.exists(out)) {
                Gpio.createDir(out);
            }
            if (snpfile != null) {
                this.m_settings.tsSNPsConfine = new HashSet();
                TextFile ts = new TextFile(snpfile, false);
                this.m_settings.strConfineSNP = snpfile;
                this.m_settings.tsSNPsConfine.addAll(ts.readAsArrayList());
                ts.close();
            }
            if (snpprobecombofile != null) {
                this.m_settings.loadSNPProbeConfinement(snpprobecombofile);
            }
            this.m_settings.outputReportsDir = out;
            this.m_settings.createTEXTOutputFiles = textout;
            this.m_settings.createBinaryOutputFiles = binout;
            if (maxNrResults != null && maxNrResults > 0) {
                this.m_settings.maxNrMostSignificantEQTLs = maxNrResults;
            }
            this.m_settings.createDotPlot = !skipdotplot;
            boolean bl = this.m_settings.createQQPlot = !skipqqplot;
            if (rseed != null) {
                this.m_settings.rSeed = rseed;
                this.m_settings.randomNumberGenerator = new Random(this.m_settings.rSeed);
            }
        } else if (this.m_settings == null && xmlSettingsFile != null) {
            this.m_settings = new Settings();
            this.m_settings.settingsTextReplaceWith = texttoreplacewith;
            this.m_settings.settingsTextToReplace = texttoreplace;
            this.m_settings.settingsTextReplace2With = texttoreplace2with;
            this.m_settings.settingsTextToReplace2 = texttoreplace2;
            this.m_settings.load(xmlSettingsFile);
        } else if (this.m_settings == null) {
            System.out.println("ERROR: No input specified");
            System.exit(0);
        }
        if (!this.m_settings.cisAnalysis && !this.m_settings.transAnalysis) {
            System.err.println("! WARNING: defaulting to CIS analysis (override with --trans or --trans and --cis))");
            this.m_settings.cisAnalysis = true;
        }
        this.m_settings.writeSettingsToDisk();
        int numDatasets = this.m_settings.datasetSettings.size();
        this.m_gg = new TriTyperGeneticalGenomicsDataset[numDatasets];
        this.numAvailableInds = 0;
        int nrOfDatasetsWithGeneExpressionData = 0;
        int nrDatasetsWithCovariates = 0;
        for (int i = 0; i < numDatasets; ++i) {
            String covariateFile = this.m_settings.datasetSettings.get((int)i).covariateFile;
            if (covariateFile == null || !Gpio.exists(covariateFile)) continue;
            ++nrDatasetsWithCovariates;
        }
        if (nrDatasetsWithCovariates >= 1 && nrDatasetsWithCovariates != this.m_gg.length) {
            System.err.println("Covariate files have not been specified for all datasets.");
            System.exit(-1);
        }
        if (nrDatasetsWithCovariates >= 1) {
            this.dataHasCovariates = true;
        }
        if (this.m_settings.pathwayDefinition != null) {
            ArrayList<String> pathwayNames = new ArrayList<String>();
            ArrayList ensgsInPathways = new ArrayList();
            if (Gpio.exists(this.m_settings.pathwayDefinition)) {
                String line;
                TextFile tf = new TextFile(this.m_settings.pathwayDefinition, false);
                while ((line = tf.readLine()) != null) {
                    ArrayList<String> ensgsThisPathway = new ArrayList<String>();
                    String[] split = line.split("\t");
                    for (int i = 2; i < split.length; ++i) {
                        ensgsThisPathway.add(split[i]);
                    }
                    pathwayNames.add(split[0]);
                    ensgsInPathways.add(ensgsThisPathway);
                }
                tf.close();
                System.out.println("Read " + pathwayNames.size() + " pathways from " + this.m_settings.pathwayDefinition);
                this.pathwayDefinitions = new Pair(pathwayNames, ensgsInPathways);
                this.m_settings.cisAnalysis = true;
                this.m_settings.transAnalysis = true;
                for (int d = 0; d < numDatasets; ++d) {
                    this.m_settings.datasetSettings.get((int)d).cisAnalysis = true;
                    this.m_settings.datasetSettings.get((int)d).transAnalysis = true;
                }
            } else {
                System.err.println("Pathway defnition defined as: " + this.m_settings.pathwayDefinition + ", but file does not exist.");
                System.exit(-1);
            }
        } else {
            this.pathwayDefinitions = null;
        }
        for (int i = 0; i < numDatasets; ++i) {
            System.out.println("- Loading dataset: " + this.m_settings.datasetSettings.get((int)i).name + "");
            this.m_settings.datasetSettings.get((int)i).confineProbesToProbesMappingToAnyChromosome = this.m_settings.confineProbesToProbesMappingToAnyChromosome;
            System.out.println("-------------------------------------------------------------------------------\n");
            this.m_gg[i] = new TriTyperGeneticalGenomicsDataset(this.m_settings.datasetSettings.get(i), this.pathwayDefinitions);
            if (!this.m_gg[i].isExpressionDataLoadedCorrectly()) continue;
            ++nrOfDatasetsWithGeneExpressionData;
        }
        if (nrOfDatasetsWithGeneExpressionData == 0) {
            System.out.println("Error: none of your datasets contain any gene expression data for the settings you have specified");
            System.exit(0);
        }
        if (nrOfDatasetsWithGeneExpressionData != this.m_gg.length) {
            System.out.println("WARNING: was able to load gene expression data for " + nrOfDatasetsWithGeneExpressionData + " while you specified " + this.m_gg.length + " datasets in the settings.");
            TriTyperGeneticalGenomicsDataset[] tmp_gg = new TriTyperGeneticalGenomicsDataset[nrOfDatasetsWithGeneExpressionData];
            int ctr = 0;
            for (TriTyperGeneticalGenomicsDataset d : this.m_gg) {
                if (!d.isExpressionDataLoadedCorrectly()) continue;
                tmp_gg[ctr] = d;
            }
            this.m_gg = tmp_gg;
        }
        for (int i = 0; i < numDatasets; ++i) {
            if (!this.m_settings.performParametricAnalysis) {
                this.m_gg[i].getExpressionData().rankAllExpressionData(this.m_settings.equalRankForTies);
            }
            this.m_gg[i].getExpressionData().calcAndSubtractMean();
            this.m_gg[i].getExpressionData().calcMeanAndVariance();
            this.numAvailableInds += this.m_gg[i].getExpressionToGenotypeIdArray().length;
        }
        if (this.m_settings.regressOutEQTLEffectFileName != null && this.m_settings.regressOutEQTLEffectFileName.trim().length() > 0) {
            if (!Gpio.exists(this.m_settings.regressOutEQTLEffectFileName)) {
                System.err.println("ERROR: you have specified an eQTL file to regress out, but the file was not found " + this.m_settings.regressOutEQTLEffectFileName);
                System.exit(0);
            }
            EQTLRegression eqr = new EQTLRegression();
            eqr.regressOutEQTLEffects(this.m_settings.regressOutEQTLEffectFileName, this.m_settings.regressOutEQTLEffectsSaveOutput, this.m_gg);
        }
        System.out.println("-------------------------------------------------------------------------------\n");
        System.out.println("");
        Arrays.sort(this.m_gg, Collections.reverseOrder());
        System.out.println("Accumulating available data...");
        System.out.print("-------------------------------------------------------------------------------\n");
        this.createSNPList();
        this.createProbeList();
        this.determineSNPProbeCombinations();
        if (this.m_workPackages == null || this.m_workPackages.length == 0) {
            System.err.println("Error: No work detected");
            System.exit(0);
        }
        if (this.m_settings.nrThreads == null) {
            this.m_settings.nrThreads = Runtime.getRuntime().availableProcessors();
        } else {
            int numProcs = Runtime.getRuntime().availableProcessors();
            if (this.m_settings.nrThreads > numProcs || this.m_settings.nrThreads < 1) {
                this.m_settings.nrThreads = numProcs;
            }
        }
        if (this.m_workPackages.length < this.m_settings.nrThreads) {
            this.m_settings.nrThreads = this.m_workPackages.length;
        }
        this.printSummary();
    }

    protected void createSNPList() throws IOException {
        ArrayList<String> availableSNPs = new ArrayList<String>();
        HashSet<String> chrYSNPs = new HashSet<String>();
        HashSet<String> unknownPos = new HashSet<String>();
        HashSet<String> unknownchr = new HashSet<String>();
        TextFile excludedSNPs = new TextFile(this.m_settings.outputReportsDir + "excludedSNPsBySNPFilter.txt.gz", true);
        HashSet<String> tmpAvailableSNPs = new HashSet<String>();
        HashSet<String> duplicatesWithinDataset = new HashSet<String>();
        for (TriTyperGeneticalGenomicsDataset m_gg1 : this.m_gg) {
            String[] snps = m_gg1.getGenotypeData().getSNPs();
            HashSet<String> seenSNPs = new HashSet<String>();
            for (String s : snps) {
                if (this.m_settings.tsSNPsConfine != null && !this.m_settings.tsSNPsConfine.contains(s)) continue;
                if (seenSNPs.contains(s)) {
                    duplicatesWithinDataset.add(s);
                } else {
                    seenSNPs.add(s);
                }
                tmpAvailableSNPs.add(s);
            }
        }
        String[] snps = tmpAvailableSNPs.toArray(new String[0]);
        for (int s = 0; s < snps.length; ++s) {
            boolean excludeSNP;
            int chrPos1;
            Byte chr1;
            String snpName = snps[s];
            if (this.m_settings.tsSNPsConfine != null && !this.m_settings.tsSNPsConfine.contains(snpName)) continue;
            StringBuilder reason = new StringBuilder(snps[s]).append("\t");
            if (this.m_gg.length == 1) {
                TriTyperGenotypeData ds = this.m_gg[0].getGenotypeData();
                Integer snpId = ds.getSnpToSNPId().get((Object)snpName);
                chr1 = ds.getChr(snpId);
                chrPos1 = ds.getChrPos(snpId);
                excludeSNP = false;
                if (chr1 >= 24) {
                    chrYSNPs.add(snpName);
                    reason.append("\tSNP is located on Y, MT, XY chromosome");
                    excludeSNP = true;
                } else if (chrPos1 < 0) {
                    unknownPos.add(snpName);
                    reason.append("\tSNP has unknown mapping");
                    excludeSNP = true;
                }
                if (duplicatesWithinDataset.contains(snpName)) {
                    reason.append("\tSNP is present twice in one of the datasets");
                    excludeSNP = true;
                }
                if (excludeSNP) {
                    excludedSNPs.writeln(reason.toString());
                    continue;
                }
                availableSNPs.add(snpName);
                continue;
            }
            boolean identicalMapping = true;
            boolean presentInAllDatasets = true;
            chr1 = null;
            chrPos1 = -1;
            excludeSNP = false;
            for (int d = 0; d < this.m_gg.length; ++d) {
                TriTyperGenotypeData ds = this.m_gg[d].getGenotypeData();
                Integer snpId = ds.getSnpToSNPId().get((Object)snpName);
                if (snpId == -9) {
                    presentInAllDatasets = false;
                    reason.append(";Not present in dataset ").append(d);
                    continue;
                }
                Byte chr2 = ds.getChr(snpId);
                int chrPos2 = ds.getChrPos(snpId);
                if (chr1 == null && chr2 != null) {
                    chr1 = ds.getChr(snpId);
                    chrPos1 = ds.getChrPos(snpId);
                    continue;
                }
                if (chr1 != null && chr2 == null) {
                    identicalMapping = false;
                    reason.append(";SNP has no chromosome position in dataset: ").append(d);
                    continue;
                }
                if (chr1 == null || chr2 == null) continue;
                if (!chr1.equals(chr2)) {
                    identicalMapping = false;
                    reason.append(";SNP maps to different chromosome in dataset: ").append(d).append("-chr").append(chr2);
                    continue;
                }
                if (chrPos1 == chrPos2) continue;
                identicalMapping = false;
                reason.append(";SNP maps to different chromosome position in dataset: ").append(d).append("-chr").append(chr2);
            }
            if (!(this.m_settings.confineToSNPsThatMapToChromosome == null || chr1 != null && chr1.equals(this.m_settings.confineToSNPsThatMapToChromosome))) {
                reason.append("\tSNP does not map to chromosome ").append(this.m_settings.confineToSNPsThatMapToChromosome).append(": chr").append(chr1);
                excludeSNP = true;
            }
            if (this.m_settings.confineSNPsToSNPsPresentInAllDatasets.booleanValue() && !presentInAllDatasets) {
                reason.append("\tSNP is not present in all datasets.");
                excludeSNP = true;
            }
            if (chr1 == null) {
                unknownchr.add(snpName);
                reason.append("\tSNP has unknown chromosome");
                excludeSNP = true;
            } else if (chr1 >= 24) {
                chrYSNPs.add(snpName);
                reason.append("\tSNP is located on Y, MT, XY chromosome");
                excludeSNP = true;
            } else if (chrPos1 < 0) {
                unknownPos.add(snpName);
                reason.append("\tSNP has unknown mapping");
                excludeSNP = true;
            }
            if (!identicalMapping) {
                reason.append("\tSNP has different mapping in different datasets");
                excludeSNP = true;
            }
            if (duplicatesWithinDataset.contains(snpName)) {
                reason.append("\tSNP is present twice in one of the datasets");
                excludeSNP = true;
            }
            if (excludeSNP) {
                excludedSNPs.writeln(reason.toString());
                continue;
            }
            availableSNPs.add(snpName);
        }
        System.out.println("- " + chrYSNPs.size() + " chromosome Y, MT or XY SNPs, " + unknownPos.size() + " SNPS with unknown position, " + unknownchr.size() + " with unknown chromosome.");
        System.out.println("- Remaining SNPs: " + availableSNPs.size());
        this.m_snpList = availableSNPs.toArray(new String[0]);
        this.m_snpTranslationTable = (long)this.m_gg.length * (long)this.m_snpList.length < 0x7FFFFFFDL ? new DenseIntMatrix2D(this.m_gg.length, this.m_snpList.length) : new DenseLargeIntMatrix2D(this.m_gg.length, this.m_snpList.length);
        for (int p = 0; p < this.m_snpList.length; ++p) {
            String snp = this.m_snpList[p];
            for (int d = 0; d < this.m_gg.length; ++d) {
                Integer tmp = this.m_gg[d].getGenotypeData().getSnpToSNPId().get((Object)snp);
                if (tmp == -9) {
                    this.m_snpTranslationTable.setQuick(d, p, -9);
                    continue;
                }
                this.m_snpTranslationTable.setQuick(d, p, tmp.intValue());
            }
        }
        excludedSNPs.close();
        if (this.m_settings.tsSNPsConfine != null) {
            Iterator<String> it = this.m_settings.tsSNPsConfine.iterator();
            if (this.m_settings.tsSNPsConfine.isEmpty()) {
                System.err.println("ERROR: a SNP confinement file is specified in the settings, but it is apparently empty? " + this.m_settings.strConfineSNP);
            } else {
                String next = it.next();
                TextFile querySNPNotPresent = new TextFile(this.m_settings.outputReportsDir + "querySNPsNotPresentInDataset.txt.gz", true);
                while (it.hasNext()) {
                    boolean isPresentInAnyDataset = false;
                    for (int d = 0; d < this.m_gg.length; ++d) {
                        Integer id = this.m_gg[d].getGenotypeData().getSnpToSNPId().get((Object)next);
                        if (id == -9) continue;
                        isPresentInAnyDataset = true;
                    }
                    if (!isPresentInAnyDataset) {
                        querySNPNotPresent.writeln(next);
                    }
                    next = it.next();
                }
                querySNPNotPresent.close();
            }
        }
    }

    protected void createProbeList() throws IOException {
        String[] duplicates;
        TextFile probeLog = new TextFile(this.m_settings.outputReportsDir + "ProbeQCLog.txt.gz", true);
        System.out.println("- Determining available probes.");
        System.out.println("\t- Saving logfile to: " + this.m_settings.outputReportsDir + "ProbeQCLog.txt.gz");
        if (this.m_settings.confineProbesToProbesPresentInAllDatasets) {
            System.out.println("\t- Confining to probes present in all datasets");
        } else {
            System.out.println("\t- Not confining to probes present in all datasets");
        }
        if (this.m_settings.confineProbesToProbesMappingToAnyChromosome) {
            System.out.println("\t- Confining to probes that map to any chromosome (including probes without a valid position)");
        } else {
            System.out.println("\t- Confining to probes that map to autosomes, X, Y and MT chromosomes");
        }
        if (this.m_settings.confineToProbesThatMapToChromosome != null) {
            System.out.println("\t- Confining to probes that map to chromosome: " + this.m_settings.confineToProbesThatMapToChromosome);
        }
        boolean numExcluded = false;
        HashSet<String> duplicateProbes = new HashSet<String>();
        HashSet<String> allAvailableProbes = new HashSet<String>();
        for (int d = 0; d < this.m_gg.length; ++d) {
            String[] probes;
            HashSet<String> availableProbes = new HashSet<String>();
            for (String probe : probes = this.m_gg[d].getExpressionData().getProbes()) {
                if (availableProbes.contains(probe)) {
                    duplicateProbes.add(probe);
                    probeLog.writeln("Removing probe:\t" + probe + "\tis a duplicate");
                }
                availableProbes.add(probe);
                allAvailableProbes.add(probe);
            }
        }
        System.out.println("\t- " + allAvailableProbes.size() + " available probes for all datasets. Will now look for duplicate probes.");
        for (String duplicate : duplicates = duplicateProbes.toArray(new String[duplicateProbes.size()])) {
            allAvailableProbes.remove(duplicate);
        }
        System.out.println("\t- " + allAvailableProbes.size() + " available probes for all datasets after removing " + duplicateProbes.size() + " duplicates");
        String[] availableProbeArray = allAvailableProbes.toArray(new String[0]);
        if (this.m_settings.tsProbesConfine != null) {
            System.out.println("Probe confinement list has " + this.m_settings.tsProbesConfine.size() + " probes");
            availableProbeArray = this.m_settings.tsProbesConfine.toArray(new String[0]);
        }
        int mappingToDifferentPositionsAcrossDatasets = 0;
        int mapToWrongChromosome = 0;
        int invalidMappingPosition = 0;
        int nrProbesNotInAllDatasets = 0;
        HashSet<String> finalProbeList = new HashSet<String>();
        for (String probe : availableProbeArray) {
            int presence = 0;
            Byte chr = null;
            int chrPosStart = -1;
            int chrPosEnd = -1;
            boolean hasIdenticalMappingAcrossDatasets = true;
            String mappingOutput = "";
            for (int d = 0; d < this.m_gg.length; ++d) {
                Integer probeId = (Integer)this.m_gg[d].getExpressionData().getProbeToId().get((Object)probe);
                if (probeId == null) continue;
                ++presence;
                if (chr == null) {
                    chr = this.m_gg[d].getExpressionData().getChr()[probeId];
                    if (chr == -1) {
                        chr = null;
                    }
                    chrPosStart = this.m_gg[d].getExpressionData().getChrStart()[probeId];
                    chrPosEnd = this.m_gg[d].getExpressionData().getChrStop()[probeId];
                    mappingOutput = mappingOutput + "\t" + this.m_gg[d].getSettings().name + ": Chr " + chr + "; Pos " + chrPosStart + "-" + chrPosEnd;
                    continue;
                }
                Byte chr2 = this.m_gg[d].getExpressionData().getChr()[probeId];
                if (chr2 == -1) {
                    chr2 = null;
                }
                int chrPosStart2 = this.m_gg[d].getExpressionData().getChrStart()[probeId];
                int chrPosEnd2 = this.m_gg[d].getExpressionData().getChrStop()[probeId];
                if (chr2 == null) {
                    hasIdenticalMappingAcrossDatasets = false;
                } else if (chrPosStart2 == -1 && chrPosStart != -1) {
                    hasIdenticalMappingAcrossDatasets = false;
                } else if (chrPosEnd2 == -1 && chrPosEnd != -1) {
                    hasIdenticalMappingAcrossDatasets = false;
                } else if (!chr.equals(chr2)) {
                    hasIdenticalMappingAcrossDatasets = false;
                } else if (chrPosStart != chrPosStart2) {
                    hasIdenticalMappingAcrossDatasets = false;
                } else if (chrPosEnd != chrPosEnd2) {
                    hasIdenticalMappingAcrossDatasets = false;
                }
                mappingOutput = mappingOutput + "\t" + this.m_gg[d].getSettings().name + ": Chr " + chr2 + "; Pos " + chrPosStart2 + "-" + chrPosEnd2;
            }
            boolean includeProbe = true;
            if (this.m_settings.tsProbesConfine != null && this.m_settings.tsProbesConfine.contains(probe)) {
                includeProbe = true;
            } else if (this.m_settings.cisAnalysis && this.m_settings.transAnalysis) {
                includeProbe = true;
            } else if (this.m_settings.confineProbesToProbesPresentInAllDatasets && presence < this.m_gg.length) {
                includeProbe = false;
                ++nrProbesNotInAllDatasets;
                probeLog.writeln("Removing probe:\t" + probe + "\tpresent in " + presence + " / " + this.m_gg.length + "\tdatasets");
            } else if (chr == null || chr >= 25 || chr <= 0) {
                if (!this.m_settings.confineProbesToProbesMappingToAnyChromosome) {
                    includeProbe = false;
                    ++invalidMappingPosition;
                    probeLog.writeln("Removing probe:\t" + probe + "\t has no valid mapping position in any dataset: " + mappingOutput);
                }
            } else if (this.m_settings.confineToProbesThatMapToChromosome != null && !chr.equals(this.m_settings.confineToProbesThatMapToChromosome)) {
                includeProbe = false;
                ++mapToWrongChromosome;
                probeLog.writeln("Removing probe:\t" + probe + "\tmaps to wrong chromosome: " + mappingOutput);
            } else if (!hasIdenticalMappingAcrossDatasets) {
                includeProbe = false;
                ++mappingToDifferentPositionsAcrossDatasets;
                probeLog.writeln("Removing probe:\t" + probe + "\tmaps to different positions in datasets: " + mappingOutput);
            }
            if (!includeProbe) continue;
            finalProbeList.add(probe);
        }
        System.out.println("\t- " + finalProbeList.size() + "\tprobes finally included: ");
        if (this.m_settings.confineProbesToProbesPresentInAllDatasets) {
            System.out.println("\t\t- " + nrProbesNotInAllDatasets + " are not present in all datasets");
        }
        if (!this.m_settings.confineProbesToProbesMappingToAnyChromosome) {
            System.out.println("\t\t- " + invalidMappingPosition + " have an invalid mapping position");
        }
        System.out.println("\t\t- " + mappingToDifferentPositionsAcrossDatasets + " probes map to different positions in one or more datasets");
        if (this.m_settings.confineToProbesThatMapToChromosome != null) {
            System.out.println("\t\t- " + mapToWrongChromosome + " probes map to a different chromosome than the one selected (Chr: " + this.m_settings.confineToProbesThatMapToChromosome + ")");
        }
        if (finalProbeList.isEmpty()) {
            System.err.println("Error: no probes remaining after filter. Are your settings correct?");
            probeLog.close();
            System.exit(0);
        }
        this.m_probeList = finalProbeList.toArray(new String[finalProbeList.size()]);
        this.m_probeTranslationTable = (long)this.m_gg.length * (long)this.m_probeList.length < 0x7FFFFFFDL ? new DenseIntMatrix2D(this.m_gg.length, this.m_probeList.length) : new DenseLargeIntMatrix2D(this.m_gg.length, this.m_probeList.length);
        for (int p = 0; p < this.m_probeList.length; ++p) {
            String probe = this.m_probeList[p];
            for (int d = 0; d < this.m_gg.length; ++d) {
                Integer tmp = (Integer)this.m_gg[d].getExpressionData().getProbeToId().get((Object)probe);
                if (tmp == null) {
                    this.m_probeTranslationTable.setQuick(d, p, -9);
                    continue;
                }
                this.m_probeTranslationTable.setQuick(d, p, tmp.intValue());
            }
        }
        probeLog.close();
    }

    public void mapEQTLs() throws IOException {
        int d;
        RunTimer t = new RunTimer();
        CalculationThread[] pool = new CalculationThread[this.m_settings.nrThreads.intValue()];
        SNPLoader[] snploaders = new SNPLoader[this.m_gg.length];
        TriTyperExpressionData[] expressiondata = new TriTyperExpressionData[this.m_gg.length];
        for (int d2 = 0; d2 < snploaders.length; ++d2) {
            snploaders[d2] = this.m_gg[d2].getGenotypeData().createSNPLoader();
            expressiondata[d2] = this.m_gg[d2].getExpressionData();
        }
        int maxNrSamples = 0;
        for (int d3 = 0; d3 < this.m_gg.length; ++d3) {
            if (this.m_gg[d3].getExpressionToGenotypeIdArray().length <= maxNrSamples) continue;
            maxNrSamples = this.m_gg[d3].getExpressionToGenotypeIdArray().length;
        }
        Correlation.correlationToZScore(maxNrSamples);
        Descriptives.lookupSqrt(this.numAvailableInds);
        Descriptives.initializeZScoreToPValue();
        boolean permuting = false;
        System.out.println("Will write output to dir: " + this.m_settings.outputReportsDir);
        int permStart = 0;
        int permEnd = this.m_settings.nrPermutationsFDR + 1;
        if (this.m_settings.startWithPermutation != null) {
            permStart = this.m_settings.startWithPermutation;
            permEnd = permStart + this.m_settings.nrPermutationsFDR + 1;
        }
        boolean hasResults = true;
        DoubleMatrixDataset[] covariateData = null;
        if (this.dataHasCovariates) {
            covariateData = new DoubleMatrixDataset[this.m_gg.length];
            for (d = 0; d < this.m_gg.length; ++d) {
                covariateData[d] = this.m_gg[d].getCovariateData();
            }
        }
        for (int permutationRound = permStart; permutationRound < permEnd; ++permutationRound) {
            RunTimer permtime = new RunTimer();
            if (permutationRound > 0) {
                System.out.print("Permuting data, round: " + permutationRound + " of " + this.m_settings.nrPermutationsFDR + "\n" + "-------------------------------------------------------------------------------\n");
                for (int d4 = 0; d4 < this.m_gg.length; ++d4) {
                    this.m_gg[d4].permuteSampleLables(this.m_settings.randomNumberGenerator);
                    if (!this.m_settings.permuteCovariates) continue;
                    this.m_gg[d4].permuteCovariates(this.m_settings.randomNumberGenerator);
                }
                permuting = true;
            } else {
                System.out.print("Running real eQTL analysis\n-------------------------------------------------------------------------------\n");
            }
            int[][] expressionToGenotypeIds = new int[this.m_gg.length][0];
            for (int d5 = 0; d5 < this.m_gg.length; ++d5) {
                expressionToGenotypeIds[d5] = this.m_gg[d5].getExpressionToGenotypeIdArray();
            }
            LinkedBlockingQueue<WorkPackage> resultQueue = new LinkedBlockingQueue<WorkPackage>(100);
            ResultProcessorThread resultthread = new ResultProcessorThread(this.m_settings.nrThreads, resultQueue, this.m_settings.createBinaryOutputFiles, this.m_gg, this.m_settings, this.m_probeTranslationTable, permuting, permutationRound, this.m_snpList, this.m_probeList, this.m_workPackages);
            resultthread.setName("ResultProcessorThread");
            resultthread.start();
            LinkedBlockingQueue<WorkPackage> packageQueue = new LinkedBlockingQueue<WorkPackage>(100000);
            WorkPackageProducer producer = new WorkPackageProducer(packageQueue, this.m_workPackages, this.m_snpList, this.m_probeList, this.m_probeTranslationTable, this.m_snpTranslationTable, this.m_gg, snploaders, this.m_settings, permuting);
            producer.setName("WorkPackageProducerThread");
            producer.start();
            for (int tnum = 0; tnum < pool.length; ++tnum) {
                EQTLPlotter plotter = null;
                if (!permuting) {
                    plotter = new EQTLPlotter(this.m_gg, this.m_settings, this.m_probeList, this.m_probeTranslationTable);
                }
                pool[tnum] = new CalculationThread(permutationRound, packageQueue, resultQueue, expressiondata, covariateData, this.m_probeTranslationTable, expressionToGenotypeIds, this.m_settings, plotter, this.m_settings.createBinaryOutputFiles, this.m_settings.useAbsoluteZScorePValue, this.m_settings.confineSNPsToSNPsPresentInAllDatasets);
                pool[tnum].setName("CalcThread-" + tnum);
                pool[tnum].start();
            }
            try {
                producer.join();
                for (int threadNum = 0; threadNum < this.m_settings.nrThreads; ++threadNum) {
                    pool[threadNum].join();
                }
                WorkPackage poison = new WorkPackage();
                poison.results = new Result(true);
                resultQueue.put(poison);
                resultthread.join();
            }
            catch (InterruptedException e) {
                System.err.println("Exception: Main Thread interrupted.");
            }
            System.out.print("-------------------------------------------------------------------------------\n");
            System.out.println("Round done. Elapsed time:\t" + permtime.getTimeDesc());
            System.out.println("");
            resultQueue.clear();
            packageQueue.clear();
            resultQueue = null;
            packageQueue = null;
            permtime = null;
            producer = null;
            resultthread = null;
            expressionToGenotypeIds = null;
            for (int i = 0; i < pool.length; ++i) {
                pool[i] = null;
            }
            if (!this.m_settings.createTEXTOutputFiles) continue;
            String fileName = permutationRound > 0 ? this.m_settings.outputReportsDir + "PermutedEQTLsPermutationRound" + permutationRound + ".txt.gz" : this.m_settings.outputReportsDir + "eQTLs.txt.gz";
            TextFile tf = new TextFile(fileName, false);
            tf.readLine();
            int lnCounter = 0;
            String line = tf.readLine();
            while (line != null && ++lnCounter <= 1) {
                line = tf.readLine();
            }
            tf.close();
            if (lnCounter != 0) continue;
            System.err.println("WARNING: QTL Mapping did not yield any results.");
            hasResults = false;
        }
        for (d = 0; d < snploaders.length; ++d) {
            snploaders[d].close();
        }
        if (!this.m_settings.runOnlyPermutations && hasResults && this.m_settings.createTEXTOutputFiles && this.m_settings.nrPermutationsFDR > 0) {
            System.out.println("Calculating FDR:\n-------------------------------------------------------------------------------\n");
            FDR.calculateFDR(this.m_settings.outputReportsDir, this.m_settings.nrPermutationsFDR, this.m_settings.maxNrMostSignificantEQTLs, this.m_settings.fdrCutOff, this.m_settings.createQQPlot, null, null, this.m_settings.fdrType, this.m_settings.fullFdrOutput);
            if (this.m_settings.createDotPlot) {
                EQTLDotPlot edp = new EQTLDotPlot();
                try {
                    edp.draw(this.m_settings.outputReportsDir + "/eQTLsFDR" + this.m_settings.fdrCutOff + ".txt", this.m_settings.outputReportsDir + "/DotPlot-FDR" + this.m_settings.fdrCutOff + ".pdf", EQTLDotPlot.Output.PDF);
                }
                catch (DocumentException ex) {
                    Logger.getLogger(MetaQTL3.class.getName()).log(Level.SEVERE, null, ex);
                }
                edp = null;
            }
        }
        System.out.print("===============================================================================\n");
        System.out.println("eQTL mapping elapsed:\t" + t.getTimeDesc() + "\n");
    }

    protected long determineSNPProbeCombinations() throws IOException {
        String loc = this.m_settings.outputReportsDir + "excludedSNPsBySNPProbeCombinationFilter.txt.gz";
        TextFile excludedSNPs = new TextFile(loc, true);
        long maxNrTestsToPerform = 0L;
        int[] midpoint = new int[this.m_probeList.length];
        byte[] chr = new byte[this.m_probeList.length];
        HashMap<Byte, ArrayList<Integer>> chrToProbe = new HashMap<Byte, ArrayList<Integer>>();
        System.out.println("- Calculating probe midpoint positions");
        HashSet<String> visitedProbes = new HashSet<String>();
        for (int p = 0; p < this.m_probeList.length; ++p) {
            for (int d = 0; d < this.m_gg.length; ++d) {
                if (this.m_probeTranslationTable.get(d, p) == -9 || visitedProbes.contains(this.m_probeList[p])) continue;
                int pid = this.m_probeTranslationTable.get(d, p);
                int start = this.m_gg[d].getExpressionData().getChrStart()[pid];
                int stop = this.m_gg[d].getExpressionData().getChrStop()[pid];
                midpoint[p] = (int)Math.floor((double)(stop + start) / 2.0);
                chr[p] = this.m_gg[d].getExpressionData().getChr()[pid];
                ArrayList<Integer> probes = (ArrayList<Integer>)chrToProbe.get(chr[p]);
                if (probes == null) {
                    probes = new ArrayList<Integer>();
                }
                probes.add(p);
                chrToProbe.put(chr[p], probes);
                visitedProbes.add(this.m_probeList[p]);
            }
        }
        WorkPackage[] workPackages = new WorkPackage[this.m_snpList.length];
        int numWorkPackages = 0;
        System.out.println("- Determining SNP-Probe combinations to test");
        boolean cisOnly = false;
        boolean cisTrans = false;
        boolean transOnly = false;
        if (this.m_settings.cisAnalysis && !this.m_settings.transAnalysis) {
            cisOnly = true;
        } else if (!this.m_settings.cisAnalysis && this.m_settings.transAnalysis) {
            transOnly = true;
        } else if (this.m_settings.cisAnalysis && this.m_settings.transAnalysis) {
            cisTrans = true;
        }
        HashMap<String, Integer> probeNameToId = null;
        if (this.m_settings.tsSNPProbeCombinationsConfine != null) {
            int i;
            this.m_settings.cisAnalysis = true;
            this.m_settings.transAnalysis = false;
            for (i = 0; i < this.m_gg.length; ++i) {
                this.m_gg[i].getSettings().cisAnalysis = true;
                this.m_gg[i].getSettings().transAnalysis = false;
            }
            cisTrans = false;
            cisOnly = true;
            transOnly = false;
            probeNameToId = new HashMap<String, Integer>();
            for (i = 0; i < this.m_probeList.length; ++i) {
                probeNameToId.put(this.m_probeList[i], i);
            }
        }
        boolean prevProc = false;
        ProgressBar pb = new ProgressBar(this.m_snpList.length);
        for (int s = 0; s < this.m_snpList.length; ++s) {
            WorkPackage output = null;
            SNP[] snps = new SNP[this.m_gg.length];
            byte snpchr = -1;
            int snppos = -1;
            int dreq = 0;
            String snpname = "";
            for (int d = 0; d < this.m_gg.length; ++d) {
                Integer snpId = this.m_snpTranslationTable.getQuick(d, s);
                if (snpId == -9) continue;
                snps[d] = this.m_gg[d].getGenotypeData().getSNPObject(snpId);
                snpchr = snps[d].getChr();
                snppos = snps[d].getChrPos();
                snpname = snps[d].getName();
                dreq = d;
            }
            ArrayList probeOnChr = (ArrayList)chrToProbe.get(snpchr);
            if (cisTrans) {
                output = new WorkPackage();
                output.setMetaSNPId(s);
                output.setSnps(snps);
                output.setProbes(null);
                ++numWorkPackages;
                maxNrTestsToPerform += (long)this.m_probeList.length;
                workPackages[s] = output;
            } else {
                ArrayList<Integer> probeToTest = null;
                if (this.m_settings.tsSNPProbeCombinationsConfine != null) {
                    HashSet<String> probesSelected = this.m_settings.snpProbeConfineBasedOnChrPos ? this.m_settings.tsSNPProbeCombinationsConfine.get(snpchr + ":" + snppos) : this.m_settings.tsSNPProbeCombinationsConfine.get(snpname);
                    if (probesSelected != null && probeNameToId != null) {
                        probeToTest = new ArrayList();
                        for (String probe : probesSelected) {
                            Integer probeId = (Integer)probeNameToId.get(probe);
                            if (probeId == null) {
                                System.err.println("You selected the following SNP-Probe combination, but probe not present in dataset.\t" + snpname + "\t-\t" + probe);
                                continue;
                            }
                            probeToTest.add(probeId);
                        }
                    }
                } else if (probeOnChr != null && !probeOnChr.isEmpty()) {
                    probeToTest = new ArrayList<Integer>();
                    for (int e = 0; e < probeOnChr.size(); ++e) {
                        int p = (Integer)probeOnChr.get(e);
                        if (Math.abs(midpoint[p] - snppos) >= this.m_settings.ciseQTLAnalysMaxSNPProbeMidPointDistance) continue;
                        probeToTest.add(p);
                    }
                }
                if (cisOnly && (probeToTest == null || probeToTest.isEmpty())) {
                    workPackages[s] = null;
                    if (this.m_settings.tsSNPsConfine == null || this.m_settings.tsSNPsConfine.contains(this.m_snpList[s])) {
                        excludedSNPs.write(snpname + "\tNo probes to test.\n");
                    }
                } else {
                    int[] testprobes = new int[]{};
                    if (probeToTest != null) {
                        testprobes = new int[probeToTest.size()];
                        for (int p = 0; p < testprobes.length; ++p) {
                            testprobes[p] = (Integer)probeToTest.get(p);
                        }
                    }
                    output = new WorkPackage();
                    output.setMetaSNPId(s);
                    output.setSnps(snps);
                    output.setProbes(testprobes);
                    workPackages[s] = output;
                    ++numWorkPackages;
                    maxNrTestsToPerform = cisOnly ? (maxNrTestsToPerform += (long)testprobes.length) : (testprobes.length != 0 ? (maxNrTestsToPerform += (long)(this.m_probeList.length - testprobes.length)) : (maxNrTestsToPerform += (long)this.m_probeList.length));
                }
            }
            pb.iterate();
        }
        pb.close();
        System.out.println("");
        if (numWorkPackages != this.m_snpList.length) {
            this.m_workPackages = new WorkPackage[numWorkPackages];
            int q = 0;
            for (int i = 0; i < workPackages.length; ++i) {
                if (workPackages[i] == null) continue;
                this.m_workPackages[q] = workPackages[i];
                this.m_workPackages[q].setId(q);
                ++q;
            }
        } else {
            for (int i = 0; i < workPackages.length; ++i) {
                workPackages[i].setId(i);
            }
            this.m_workPackages = workPackages;
        }
        excludedSNPs.close();
        System.out.println("The maximum number of SNPs to test: " + this.m_workPackages.length);
        System.out.println("The maximum number of SNP-Probe combinations: " + maxNrTestsToPerform);
        if ((long)this.m_settings.maxNrMostSignificantEQTLs > maxNrTestsToPerform) {
            this.m_settings.maxNrMostSignificantEQTLs = (int)maxNrTestsToPerform;
        }
        return maxNrTestsToPerform;
    }

    protected void printSummary() {
        System.out.print("\nSummary\n===============================================================================\n");
        int totalSamples = 0;
        for (TriTyperGeneticalGenomicsDataset m_gg1 : this.m_gg) {
            System.out.print("Dataset:\t" + m_gg1.getSettings().name);
            System.out.print("\tprobes:\t" + m_gg1.getExpressionData().getProbes().length);
            System.out.print("\tSNPs:\t" + m_gg1.getGenotypeData().getSNPs().length);
            totalSamples += m_gg1.getTotalGGSamples();
            System.out.println("\tsamples:\t" + m_gg1.getTotalGGSamples());
        }
        System.out.println("");
        System.out.print("\nTotals\n===============================================================================\n");
        System.out.println("Total number of datasets:\t" + this.m_gg.length);
        System.out.println("Total number of samples:\t" + totalSamples);
        System.out.println("Maximum number of SNPs to test:\t" + this.m_workPackages.length);
        System.out.println("Maximum number of Probes to test:\t" + this.m_probeList.length);
        if (totalSamples == 0) {
            System.err.println("ERROR!: No samples detected");
            System.exit(-1);
        }
        System.out.println("");
        System.out.print("\nAnalysis\n===============================================================================\n");
        if (this.m_settings.cisAnalysis && this.m_settings.transAnalysis) {
            System.out.println("- cis/trans analysis");
        } else if (this.m_settings.cisAnalysis && !this.m_settings.transAnalysis) {
            System.out.println("- cis analysis");
        } else if (!this.m_settings.cisAnalysis && this.m_settings.transAnalysis) {
            System.out.println("- trans analysis");
        }
        if (this.m_settings.metaAnalyseInteractionTerms) {
            System.out.println("- interaction analysis");
            if (!this.m_settings.performParametricAnalysis) {
                System.out.println("- WARNING: running interaction model on non-parametric data!");
            }
        }
        if (!this.m_settings.performParametricAnalysis) {
            System.out.println("- non-parametric (Spearman ranked) correlation");
        } else {
            System.out.println("- parametric (Pearson) correlation");
        }
        System.out.println("- Mid-point distance:\t" + this.m_settings.ciseQTLAnalysMaxSNPProbeMidPointDistance);
        System.out.println("- FDR cutoff:\t" + this.m_settings.fdrCutOff);
        System.out.println("- Nr. permutations:\t" + this.m_settings.nrPermutationsFDR);
        System.out.println("- Nr. Threads:\t" + this.m_settings.nrThreads);
        System.out.println("- Max nr results:\t" + this.m_settings.maxNrMostSignificantEQTLs);
        if (this.m_settings.createBinaryOutputFiles) {
            System.out.println("- creating BINARY output");
        }
        if (this.m_settings.createTEXTOutputFiles) {
            System.out.println("- creating TEXT output");
        }
        System.out.println("");
    }
}

