/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.metaqtl3;

import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseLargeDoubleMatrix2D;
import eqtlmappingpipeline.metaqtl3.graphics.QQPlot;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.map.hash.TDoubleIntHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.eQTLTextFile;
import umcg.genetica.text.Strings;

public class FDR {
    public static void calculateFDR(String eQTLTextFileLoc, int nrPermutationsFDR, int maxNrMostSignificantEQTLs, double fdrcutoff, boolean createQQPlot, String outputDir, String permutationDir, FDRMethod fdrType, boolean createLargeFdrFiles) throws IOException {
        if (eQTLTextFileLoc == null || eQTLTextFileLoc.length() == 0) {
            throw new IllegalArgumentException("File containing real effects is not specified.");
        }
        if (nrPermutationsFDR < 1) {
            throw new IllegalArgumentException("Need at least one permutation to determine FDR");
        }
        if (maxNrMostSignificantEQTLs < 1) {
            throw new IllegalArgumentException("Need at least a single effect to perform FDR estimation");
        }
        if (fdrcutoff < 0.0 || fdrcutoff > 1.0) {
            throw new IllegalArgumentException("FDR threshold should be between 0.0 and 1.0! (Specified: " + fdrcutoff + ")");
        }
        if (permutationDir == null) {
            permutationDir = eQTLTextFileLoc;
        }
        if (outputDir == null) {
            outputDir = eQTLTextFileLoc;
        }
        String fileString = permutationDir + "/PermutedEQTLsPermutationRound" + 1 + ".txt.gz";
        TextFile tf = new TextFile(fileString, false);
        tf.readLine();
        String[] elems = tf.readLineElems(TextFile.tab);
        int nrColsInPermutedFiles = elems.length;
        tf.close();
        System.out.println(nrColsInPermutedFiles + " columns in permuted QTL file.");
        if (nrColsInPermutedFiles > 7) {
            System.out.println("Large permutation files detected.");
            if (fdrType.equals((Object)FDRMethod.PROBELEVEL) || fdrType.equals((Object)FDRMethod.ALL)) {
                FDR.runFDR(eQTLTextFileLoc, nrPermutationsFDR, maxNrMostSignificantEQTLs, fdrcutoff, FileFormat.LARGE, FDRMethod.PROBELEVEL, outputDir, permutationDir, createQQPlot, createLargeFdrFiles);
            }
            if (fdrType.equals((Object)FDRMethod.GENELEVEL) || fdrType.equals((Object)FDRMethod.ALL)) {
                FDR.runFDR(eQTLTextFileLoc, nrPermutationsFDR, maxNrMostSignificantEQTLs, fdrcutoff, FileFormat.LARGE, FDRMethod.GENELEVEL, outputDir, permutationDir, createQQPlot, createLargeFdrFiles);
            }
            if (fdrType.equals((Object)FDRMethod.FULL) || fdrType.equals((Object)FDRMethod.ALL)) {
                FDR.runFDR(eQTLTextFileLoc, nrPermutationsFDR, maxNrMostSignificantEQTLs, fdrcutoff, FileFormat.LARGE, FDRMethod.FULL, outputDir, permutationDir, createQQPlot, createLargeFdrFiles);
            }
        } else {
            if (fdrType.equals((Object)FDRMethod.PROBELEVEL) || fdrType.equals((Object)FDRMethod.ALL)) {
                FDR.runFDR(eQTLTextFileLoc, nrPermutationsFDR, maxNrMostSignificantEQTLs, fdrcutoff, FileFormat.REDUCED, FDRMethod.PROBELEVEL, outputDir, permutationDir, createQQPlot, createLargeFdrFiles);
            }
            if (fdrType.equals((Object)FDRMethod.GENELEVEL) || fdrType.equals((Object)FDRMethod.ALL) && nrColsInPermutedFiles >= 4) {
                FDR.runFDR(eQTLTextFileLoc, nrPermutationsFDR, maxNrMostSignificantEQTLs, fdrcutoff, FileFormat.REDUCED, FDRMethod.GENELEVEL, outputDir, permutationDir, createQQPlot, createLargeFdrFiles);
            }
            if (fdrType.equals((Object)FDRMethod.FULL) || fdrType.equals((Object)FDRMethod.ALL)) {
                FDR.runFDR(eQTLTextFileLoc, nrPermutationsFDR, maxNrMostSignificantEQTLs, fdrcutoff, FileFormat.REDUCED, FDRMethod.FULL, outputDir, permutationDir, createQQPlot, createLargeFdrFiles);
            }
        }
    }

    private static void runFDR(String baseDir, int nrPermutationsFDR, int maxNrMostSignificantEQTLs, double fdrcutoff, FileFormat f, FDRMethod m, String outputDir, String permutationDir, boolean createQQPlot, boolean createLargeFdrFiles) throws IOException {
        String fileString;
        System.out.println("");
        if (m == FDRMethod.GENELEVEL) {
            System.out.println("Performing gene level FDR");
        } else if (m == FDRMethod.PROBELEVEL) {
            System.out.println("Performing probe level FDR");
        } else if (m == FDRMethod.FULL) {
            System.out.println("Determining the FDR using all data");
        }
        TDoubleIntHashMap permutedPvalues = new TDoubleIntHashMap(10000, 0.5f);
        System.out.println("Reading permuted files");
        for (int permutationRound = 0; permutationRound < nrPermutationsFDR; ++permutationRound) {
            String fileString2 = permutationDir + "/PermutedEQTLsPermutationRound" + (permutationRound + 1) + ".txt.gz";
            System.out.println(fileString2);
            TextFile gz = new TextFile(fileString2, false);
            String[] header = gz.readLineElems(TextFile.tab);
            int snpcol = -1;
            int pvalcol = -1;
            int probecol = -1;
            int genecol = -1;
            if (f == FileFormat.REDUCED) {
                for (int col = 0; col < header.length; ++col) {
                    if (header[col].equals("PValue")) {
                        pvalcol = col;
                    }
                    if (header[col].equals("SNP")) {
                        snpcol = col;
                    }
                    if (header[col].equals("Probe")) {
                        probecol = col;
                    }
                    if (!header[col].equals("Gene")) continue;
                    genecol = col;
                }
                if (snpcol == -1 || pvalcol == -1 || probecol == -1 && genecol == -1) {
                    System.out.println("Column not found in permutation file: " + fileString2);
                    System.out.println("PValue: " + pvalcol);
                    System.out.println("SNP: " + snpcol);
                    System.out.println("Probe: " + probecol);
                    System.out.println("Gene: " + genecol);
                }
            }
            String[] data = gz.readLineElemsReturnReference(TextFile.tab);
            int itr = 0;
            HashSet<String> visitedEffects = new HashSet<String>();
            while (data != null) {
                if (data.length == 0) continue;
                if (itr > maxNrMostSignificantEQTLs - 1) {
                    System.out.println("Breaking because: " + itr);
                    break;
                }
                String fdrId = null;
                if (f == FileFormat.REDUCED) {
                    if (m == FDRMethod.PROBELEVEL) {
                        fdrId = data[probecol];
                    } else if (m == FDRMethod.GENELEVEL && data.length > 3) {
                        fdrId = data[genecol];
                    }
                } else if (m == FDRMethod.GENELEVEL) {
                    fdrId = data[eQTLTextFile.HUGO];
                } else if (m == FDRMethod.PROBELEVEL) {
                    fdrId = data[4];
                }
                if (m == FDRMethod.FULL || !fdrId.equals("-") && !visitedEffects.contains(fdrId)) {
                    double permutedP;
                    if (m != FDRMethod.FULL) {
                        visitedEffects.add(fdrId);
                    }
                    if (permutedPvalues.containsKey(permutedP = Double.parseDouble(data[0]))) {
                        permutedPvalues.increment(permutedP);
                    } else {
                        permutedPvalues.put(permutedP, 1);
                    }
                    ++itr;
                }
                data = gz.readLineElemsReturnReference(TextFile.tab);
            }
            gz.close();
        }
        double[] uniquePermutedPvalues = permutedPvalues.keys();
        Arrays.sort(uniquePermutedPvalues);
        double[] uniquePermutedPvaluesCounts = new double[uniquePermutedPvalues.length];
        long cummulativeCount = 0L;
        double nrPermutationsFDRd = nrPermutationsFDR;
        for (int i = 0; i < uniquePermutedPvalues.length; ++i) {
            uniquePermutedPvaluesCounts[i] = (double)(cummulativeCount += (long)permutedPvalues.get(uniquePermutedPvalues[i])) / nrPermutationsFDRd;
        }
        permutedPvalues = null;
        System.out.println("Number of unique permutation p-values: " + uniquePermutedPvalues.length);
        if (outputDir == null) {
            outputDir = baseDir;
        }
        String fileSuffix = "";
        if (m == FDRMethod.GENELEVEL) {
            fileSuffix = "-GeneLevel";
        } else if (m == FDRMethod.PROBELEVEL) {
            fileSuffix = "-ProbeLevel";
        }
        String outFileName = outputDir + "/eQTLsFDR" + fdrcutoff + fileSuffix + ".txt";
        String outFileNameSnps = outputDir + "/eQTLSNPsFDR" + fdrcutoff + fileSuffix + ".txt";
        String outFileNameProbes = outputDir + "/eQTLProbesFDR" + fdrcutoff + fileSuffix + ".txt";
        String outFileNameAll = outputDir + "/eQTLsFDR" + fileSuffix + ".txt.gz";
        TextFile outputWriterSignificant = new TextFile(outFileName, true);
        TextFile outputWriterESNPs = new TextFile(outFileNameSnps, true);
        TextFile outputWriterEProbes = new TextFile(outFileNameProbes, true);
        TextFile outputWriterAll = null;
        if (createLargeFdrFiles) {
            outputWriterAll = new TextFile(outFileNameAll, true);
        }
        if (!Gpio.exists(fileString = baseDir + "/eQTLs.txt.gz")) {
            System.out.println("Could not find file: " + fileString + " trying un-GZipped file....");
            fileString = baseDir + "/eQTLs.txt";
        }
        if (!Gpio.exists(fileString)) {
            System.out.println("Could not find file: " + fileString);
            System.exit(0);
        }
        TextFile realEQTLs = new TextFile(fileString, false);
        String header = realEQTLs.readLine();
        if (createLargeFdrFiles) {
            outputWriterAll.append(header);
            outputWriterAll.append("\tFDR\n");
        }
        outputWriterEProbes.append(header);
        outputWriterEProbes.append("\tFDR\n");
        outputWriterESNPs.append(header);
        outputWriterESNPs.append("\tFDR\n");
        outputWriterSignificant.append(header);
        outputWriterSignificant.append("\tFDR\n");
        String str = realEQTLs.readLine();
        int itr = 0;
        HashSet<String> visitedEffects = new HashSet<String>();
        HashSet<String> visitedSnps = new HashSet<String>();
        HashSet<String> visitedProbes = new HashSet<String>();
        double lastEqtlPvalue = 0.0;
        double currentPvalue = 0.0;
        ArrayList<String> currentPvalueEqtls = new ArrayList<String>();
        ArrayList<String> currentPvalueEqtlSnps = new ArrayList<String>();
        ArrayList<String> currentPvalueEqtlProbes = new ArrayList<String>();
        TDoubleArrayList pValueRealData = new TDoubleArrayList();
        ArrayList<Boolean> significantPvalue = new ArrayList<Boolean>();
        int lastUsedPermutedPvalueIndex = 0;
        int nrSignificantEQTLs = 0;
        while (str != null && itr <= maxNrMostSignificantEQTLs - 1) {
            String fdrId = null;
            String[] data = Strings.tab.split(str);
            if (m == FDRMethod.GENELEVEL) {
                fdrId = data[eQTLTextFile.HUGO];
            } else if (m == FDRMethod.PROBELEVEL) {
                fdrId = data[4];
            }
            double eQtlPvalue = Double.parseDouble(data[0]);
            if (itr > 0 && lastEqtlPvalue > eQtlPvalue) {
                System.err.println("Sorted P-Value list is not perfectly sorted!!!!");
                System.exit(-1);
            }
            if (eQtlPvalue > currentPvalue) {
                double fdr = 0.0;
                if (currentPvalue >= uniquePermutedPvalues[0]) {
                    while (uniquePermutedPvalues[lastUsedPermutedPvalueIndex + 1] <= currentPvalue && lastUsedPermutedPvalueIndex < uniquePermutedPvalues.length - 2) {
                        ++lastUsedPermutedPvalueIndex;
                    }
                    fdr = uniquePermutedPvaluesCounts[lastUsedPermutedPvalueIndex] / (double)itr;
                    if (fdr > 1.0) {
                        fdr = 1.0;
                    }
                }
                for (int i = 0; i < currentPvalueEqtls.size(); ++i) {
                    String cachedEqtls = (String)currentPvalueEqtls.get(i);
                    String cachedEqtlsProbe = (String)currentPvalueEqtlProbes.get(i);
                    String cachedEqtlsSnps = (String)currentPvalueEqtlSnps.get(i);
                    StringBuilder currentString = new StringBuilder();
                    currentString.append(cachedEqtls).append('\t').append(String.valueOf(fdr)).append('\n');
                    pValueRealData.add(currentPvalue);
                    if (createLargeFdrFiles) {
                        outputWriterAll.append(currentString.toString());
                    }
                    if (fdr <= fdrcutoff) {
                        if (!visitedProbes.contains(cachedEqtlsProbe)) {
                            outputWriterEProbes.append(currentString.toString());
                            visitedProbes.add(cachedEqtlsProbe);
                        }
                        if (!visitedSnps.contains(cachedEqtlsSnps)) {
                            outputWriterESNPs.append(currentString.toString());
                            visitedSnps.add(cachedEqtlsSnps);
                        }
                        significantPvalue.add(true);
                        outputWriterSignificant.append(currentString.toString());
                        ++nrSignificantEQTLs;
                        continue;
                    }
                    significantPvalue.add(false);
                }
                currentPvalue = eQtlPvalue;
                currentPvalueEqtls.clear();
                currentPvalueEqtlProbes.clear();
                currentPvalueEqtlSnps.clear();
                currentPvalueEqtls.add(str);
                currentPvalueEqtlProbes.add(data[eQTLTextFile.PROBE]);
                currentPvalueEqtlSnps.add(data[eQTLTextFile.SNP]);
            } else {
                currentPvalueEqtls.add(str);
                currentPvalueEqtlProbes.add(data[eQTLTextFile.PROBE]);
                currentPvalueEqtlSnps.add(data[eQTLTextFile.SNP]);
            }
            lastEqtlPvalue = eQtlPvalue;
            if (m == FDRMethod.FULL || !fdrId.equals("-") && !visitedEffects.contains(fdrId)) {
                ++itr;
                visitedEffects.add(fdrId);
            }
            str = realEQTLs.readLine();
        }
        double fdr = 0.0;
        if (currentPvalue >= uniquePermutedPvalues[0]) {
            while (uniquePermutedPvalues[lastUsedPermutedPvalueIndex + 1] <= currentPvalue && lastUsedPermutedPvalueIndex < uniquePermutedPvalues.length - 2) {
                ++lastUsedPermutedPvalueIndex;
            }
            fdr = uniquePermutedPvaluesCounts[lastUsedPermutedPvalueIndex] / (double)itr;
            if (fdr > 1.0) {
                fdr = 1.0;
            }
        }
        for (int i = 0; i < currentPvalueEqtls.size(); ++i) {
            String cachedEqtls = (String)currentPvalueEqtls.get(i);
            String cachedEqtlsProbe = (String)currentPvalueEqtlProbes.get(i);
            String cachedEqtlsSnps = (String)currentPvalueEqtlSnps.get(i);
            StringBuilder currentString = new StringBuilder();
            currentString.append(cachedEqtls).append('\t').append(String.valueOf(fdr)).append('\n');
            pValueRealData.add(currentPvalue);
            if (createLargeFdrFiles) {
                outputWriterAll.append(currentString.toString());
            }
            if (fdr <= fdrcutoff) {
                if (!visitedProbes.contains(cachedEqtlsProbe)) {
                    outputWriterEProbes.append(currentString.toString());
                    visitedProbes.add(cachedEqtlsProbe);
                }
                if (!visitedSnps.contains(cachedEqtlsSnps)) {
                    outputWriterESNPs.append(currentString.toString());
                    visitedSnps.add(cachedEqtlsSnps);
                }
                significantPvalue.add(true);
                outputWriterSignificant.append(currentString.toString());
                ++nrSignificantEQTLs;
                continue;
            }
            significantPvalue.add(false);
        }
        realEQTLs.close();
        if (createLargeFdrFiles) {
            outputWriterAll.close();
        }
        outputWriterEProbes.close();
        outputWriterESNPs.close();
        outputWriterSignificant.close();
        System.out.println("Number of significant eQTLs:\t" + nrSignificantEQTLs);
        System.out.println(" - Number of unique SNPs, constituting an eQTL:\t" + visitedSnps.size());
        System.out.println(" - Number of unique probes, constituting an eQTL:\t" + visitedProbes.size());
        if (createQQPlot) {
            System.out.println("Creating QQ plot. This might take a while...");
            String fileName = baseDir + "/eQTLsFDR" + fdrcutoff + fileSuffix + "-QQPlot.pdf";
            if (maxNrMostSignificantEQTLs > pValueRealData.size()) {
                FDR.createQQPlots(permutationDir, nrPermutationsFDR, pValueRealData.size(), fdrcutoff, f, m, pValueRealData.toArray(), significantPvalue, nrSignificantEQTLs, fileName);
            } else if (maxNrMostSignificantEQTLs > 100000) {
                System.out.println("Only taking the top 100,000 for QQplot creation.");
                FDR.createQQPlots(permutationDir, nrPermutationsFDR, 100000, fdrcutoff, f, m, pValueRealData.toArray(), significantPvalue, nrSignificantEQTLs, fileName);
            } else {
                FDR.createQQPlots(permutationDir, nrPermutationsFDR, maxNrMostSignificantEQTLs, fdrcutoff, f, m, pValueRealData.toArray(), significantPvalue, nrSignificantEQTLs, fileName);
            }
        }
    }

    private static void createQQPlots(String permutationDir, int nrPermutationsFDR, int maxNrMostSignificantEQTLs, double fdrcutoff, FileFormat f, FDRMethod m, double[] pValueRealData, ArrayList<Boolean> significantPvalue, int nrSignificantEQTLs, String fileName) throws IOException {
        Object permutedPValues = (long)nrPermutationsFDR * (long)maxNrMostSignificantEQTLs < 0x7FFFFFFDL ? new DenseDoubleMatrix2D(nrPermutationsFDR, maxNrMostSignificantEQTLs) : new DenseLargeDoubleMatrix2D(nrPermutationsFDR, maxNrMostSignificantEQTLs);
        int nrEQTLs = -1;
        permutedPValues.assign(1.0);
        for (int permutationRound = 0; permutationRound < nrPermutationsFDR; ++permutationRound) {
            String fileString = permutationDir + "/PermutedEQTLsPermutationRound" + (permutationRound + 1) + ".txt.gz";
            TextFile gz = new TextFile(fileString, false);
            String[] header = gz.readLineElems(TextFile.tab);
            int snpcol = -1;
            int pvalcol = -1;
            int probecol = -1;
            int genecol = -1;
            for (int col = 0; col < header.length; ++col) {
                if (header[col].equals("PValue")) {
                    pvalcol = col;
                }
                if (header[col].equals("SNP")) {
                    snpcol = col;
                }
                if (header[col].equals("Probe")) {
                    probecol = col;
                }
                if (!header[col].equals("Gene")) continue;
                genecol = col;
            }
            if (f == FileFormat.REDUCED && (snpcol == -1 || pvalcol == -1 || probecol == -1 && genecol == -1)) {
                System.out.println("Column not found in permutation file: " + fileString);
                System.out.println("PValue: " + pvalcol);
                System.out.println("SNP: " + snpcol);
                System.out.println("Probe: " + probecol);
                System.out.println("Gene: " + genecol);
            }
            String[] data = gz.readLineElemsReturnReference(TextFile.tab);
            int itr = 0;
            HashSet<String> visitedEffects = new HashSet<String>();
            while (data != null) {
                int filteronColumn;
                String fdrId;
                if (data.length == 0) continue;
                if (itr > maxNrMostSignificantEQTLs - 1) break;
                if (f == FileFormat.REDUCED) {
                    if (m == FDRMethod.FULL) {
                        fdrId = data[snpcol] + "-" + data[probecol];
                        filteronColumn = probecol;
                    } else if (m == FDRMethod.GENELEVEL && data.length > 3) {
                        fdrId = data[genecol];
                        filteronColumn = genecol;
                    } else {
                        fdrId = data[probecol];
                        filteronColumn = probecol;
                    }
                } else if (m == FDRMethod.GENELEVEL) {
                    fdrId = data[eQTLTextFile.HUGO];
                    filteronColumn = eQTLTextFile.HUGO;
                } else if (m == FDRMethod.PROBELEVEL) {
                    fdrId = data[4];
                    filteronColumn = 4;
                } else {
                    fdrId = data[1] + "-" + data[4];
                    filteronColumn = 4;
                }
                if (data.length > filteronColumn) {
                    if (!fdrId.equals("-") && !visitedEffects.contains(fdrId)) {
                        permutedPValues.setQuick(permutationRound, itr, Double.parseDouble(data[0]));
                        visitedEffects.add(fdrId);
                        if (itr > 0 && permutedPValues.getQuick(permutationRound, itr - 1) > permutedPValues.getQuick(permutationRound, itr)) {
                            System.err.println("Sorted P-Value list is not perfectly sorted!!!!");
                            System.exit(-1);
                        }
                        ++itr;
                    }
                } else {
                    System.out.println(Strings.concat(data, Strings.tab));
                }
                data = gz.readLineElemsReturnReference(TextFile.tab);
            }
            gz.close();
            if (nrEQTLs != -1) continue;
            nrEQTLs = itr;
        }
        boolean[] significant = new boolean[significantPvalue.size()];
        int pos = 0;
        for (Boolean i : significantPvalue) {
            significant[pos] = i;
            ++pos;
        }
        QQPlot qq = new QQPlot();
        qq.draw(fileName, fdrcutoff, nrPermutationsFDR, maxNrMostSignificantEQTLs, permutedPValues.toArray(), pValueRealData, significant, nrSignificantEQTLs);
    }

    public static void calculateFDR2(String eQTLTextFileLoc, int nrPermutationsFDR, int maxNrMostSignificantEQTLs, double fdrcutoff, boolean createQQPlot, String outputDir, String permutationDir, FDRMethod fdrType, boolean createLargeFdrFiles, String snpselectionlist, String snpprobeselectionlist) throws IOException {
        if (eQTLTextFileLoc == null || eQTLTextFileLoc.length() == 0) {
            throw new IllegalArgumentException("File containing real effects is not specified.");
        }
        if (nrPermutationsFDR < 1) {
            throw new IllegalArgumentException("Need at least one permutation to determine FDR");
        }
        if (maxNrMostSignificantEQTLs < 1) {
            throw new IllegalArgumentException("Need at least a single effect to perform FDR estimation");
        }
        if (fdrcutoff < 0.0 || fdrcutoff > 1.0) {
            throw new IllegalArgumentException("FDR threshold should be between 0.0 and 1.0! (Specified: " + fdrcutoff + ")");
        }
        if (permutationDir == null) {
            permutationDir = eQTLTextFileLoc;
        }
        if (outputDir == null) {
            outputDir = eQTLTextFileLoc;
        }
        String fileString = permutationDir + "/PermutedEQTLsPermutationRound" + 1 + ".txt.gz";
        TextFile tf = new TextFile(fileString, false);
        tf.readLine();
        String[] elems = tf.readLineElems(TextFile.tab);
        int nrColsInPermutedFiles = elems.length;
        tf.close();
        System.out.println(nrColsInPermutedFiles + " columns in permuted QTL file.");
        if (nrColsInPermutedFiles > 7) {
            System.out.println("Large permutation files detected.");
            if (fdrType.equals((Object)FDRMethod.PROBELEVEL) || fdrType.equals((Object)FDRMethod.ALL)) {
                FDR.runFDR2(eQTLTextFileLoc, nrPermutationsFDR, maxNrMostSignificantEQTLs, fdrcutoff, FileFormat.LARGE, FDRMethod.PROBELEVEL, outputDir, permutationDir, createQQPlot, createLargeFdrFiles, snpselectionlist, snpprobeselectionlist);
            }
            if (fdrType.equals((Object)FDRMethod.GENELEVEL) || fdrType.equals((Object)FDRMethod.ALL)) {
                FDR.runFDR2(eQTLTextFileLoc, nrPermutationsFDR, maxNrMostSignificantEQTLs, fdrcutoff, FileFormat.LARGE, FDRMethod.GENELEVEL, outputDir, permutationDir, createQQPlot, createLargeFdrFiles, snpselectionlist, snpprobeselectionlist);
            }
            if (fdrType.equals((Object)FDRMethod.FULL) || fdrType.equals((Object)FDRMethod.ALL)) {
                FDR.runFDR2(eQTLTextFileLoc, nrPermutationsFDR, maxNrMostSignificantEQTLs, fdrcutoff, FileFormat.LARGE, FDRMethod.FULL, outputDir, permutationDir, createQQPlot, createLargeFdrFiles, snpselectionlist, snpprobeselectionlist);
            }
        } else {
            if (fdrType.equals((Object)FDRMethod.PROBELEVEL) || fdrType.equals((Object)FDRMethod.ALL)) {
                FDR.runFDR2(eQTLTextFileLoc, nrPermutationsFDR, maxNrMostSignificantEQTLs, fdrcutoff, FileFormat.REDUCED, FDRMethod.PROBELEVEL, outputDir, permutationDir, createQQPlot, createLargeFdrFiles, snpselectionlist, snpprobeselectionlist);
            }
            if (fdrType.equals((Object)FDRMethod.GENELEVEL) || fdrType.equals((Object)FDRMethod.ALL) && nrColsInPermutedFiles >= 4) {
                FDR.runFDR2(eQTLTextFileLoc, nrPermutationsFDR, maxNrMostSignificantEQTLs, fdrcutoff, FileFormat.REDUCED, FDRMethod.GENELEVEL, outputDir, permutationDir, createQQPlot, createLargeFdrFiles, snpselectionlist, snpprobeselectionlist);
            }
            if (fdrType.equals((Object)FDRMethod.FULL) || fdrType.equals((Object)FDRMethod.ALL)) {
                FDR.runFDR2(eQTLTextFileLoc, nrPermutationsFDR, maxNrMostSignificantEQTLs, fdrcutoff, FileFormat.REDUCED, FDRMethod.FULL, outputDir, permutationDir, createQQPlot, createLargeFdrFiles, snpselectionlist, snpprobeselectionlist);
            }
        }
    }

    private static void runFDR2(String baseDir, int nrPermutationsFDR, int maxNrMostSignificantEQTLs, double fdrcutoff, FileFormat f, FDRMethod m, String outputDir, String permutationDir, boolean createQQPlot, boolean createLargeFdrFiles, String snpselectionlist, String snpprobeselectionlist) throws IOException {
        String fileString;
        System.out.println("");
        if (m == FDRMethod.GENELEVEL) {
            System.out.println("Performing gene level FDR");
        } else if (m == FDRMethod.PROBELEVEL) {
            System.out.println("Performing probe level FDR");
        } else if (m == FDRMethod.FULL) {
            System.out.println("Determining the FDR using all data");
        }
        HashSet<String> selectionOfSnps = null;
        if (snpselectionlist != null) {
            System.out.println("Reading: " + snpselectionlist);
            TextFile t = new TextFile(snpselectionlist, false);
            selectionOfSnps = new HashSet<String>(Arrays.asList(t.readAsArray()));
        }
        HashSet<String> selectionOfSnpProbes = null;
        if (snpprobeselectionlist != null) {
            System.out.println("Reading: " + snpprobeselectionlist);
            TextFile t = new TextFile(snpprobeselectionlist, false);
            selectionOfSnpProbes = new HashSet<String>(Arrays.asList(t.readAsArray()));
        }
        TDoubleIntHashMap permutedPvalues = new TDoubleIntHashMap(10000, 0.5f);
        System.out.println("Reading permuted files");
        for (int permutationRound = 0; permutationRound < nrPermutationsFDR; ++permutationRound) {
            String fileString2 = permutationDir + "/PermutedEQTLsPermutationRound" + (permutationRound + 1) + ".txt.gz";
            System.out.print(fileString2);
            TextFile gz = new TextFile(fileString2, false);
            String[] header = gz.readLineElems(TextFile.tab);
            int snpcol = -1;
            int pvalcol = -1;
            int probecol = -1;
            int genecol = -1;
            if (f == FileFormat.REDUCED) {
                for (int col = 0; col < header.length; ++col) {
                    if (header[col].equals("PValue")) {
                        pvalcol = col;
                    }
                    if (header[col].equals("SNP")) {
                        snpcol = col;
                    }
                    if (header[col].equals("Probe")) {
                        probecol = col;
                    }
                    if (!header[col].equals("Gene")) continue;
                    genecol = col;
                }
                if (snpcol == -1 || pvalcol == -1 || probecol == -1 && genecol == -1) {
                    System.out.println("Column not found in permutation file: " + fileString2);
                    System.out.println("PValue: " + pvalcol);
                    System.out.println("SNP: " + snpcol);
                    System.out.println("Probe: " + probecol);
                    System.out.println("Gene: " + genecol);
                }
            }
            String[] data = gz.readLineElemsReturnReference(TextFile.tab);
            int itr = 0;
            HashSet<String> visitedEffects = new HashSet<String>();
            while (data != null) {
                double permutedP;
                if (data.length == 0) continue;
                if (itr > maxNrMostSignificantEQTLs - 1) {
                    System.out.println("Breaking because: " + itr);
                    break;
                }
                String fdrId = null;
                if (f == FileFormat.REDUCED) {
                    if (m == FDRMethod.PROBELEVEL) {
                        fdrId = data[probecol];
                    } else if (m == FDRMethod.GENELEVEL && data.length > 3) {
                        fdrId = data[genecol];
                    }
                } else if (m == FDRMethod.GENELEVEL) {
                    fdrId = data[eQTLTextFile.HUGO];
                } else if (m == FDRMethod.PROBELEVEL) {
                    fdrId = data[4];
                }
                if (selectionOfSnpProbes != null || selectionOfSnps != null) {
                    if (selectionOfSnps != null && selectionOfSnps.contains(data[snpcol]) && selectionOfSnpProbes != null && selectionOfSnpProbes.contains(data[snpcol] + "-" + data[probecol])) {
                        if (m == FDRMethod.FULL || !fdrId.equals("-") && !visitedEffects.contains(fdrId)) {
                            if (m != FDRMethod.FULL) {
                                visitedEffects.add(fdrId);
                            }
                            if (permutedPvalues.containsKey(permutedP = Double.parseDouble(data[0]))) {
                                permutedPvalues.increment(permutedP);
                            } else {
                                permutedPvalues.put(permutedP, 1);
                            }
                            ++itr;
                        }
                    } else if (selectionOfSnps != null && selectionOfSnps.contains(data[snpcol])) {
                        if (m == FDRMethod.FULL || !fdrId.equals("-") && !visitedEffects.contains(fdrId)) {
                            if (m != FDRMethod.FULL) {
                                visitedEffects.add(fdrId);
                            }
                            if (permutedPvalues.containsKey(permutedP = Double.parseDouble(data[0]))) {
                                permutedPvalues.increment(permutedP);
                            } else {
                                permutedPvalues.put(permutedP, 1);
                            }
                            ++itr;
                        }
                    } else if (selectionOfSnpProbes != null && selectionOfSnpProbes.contains(data[snpcol] + "-" + data[probecol]) && (m == FDRMethod.FULL || !fdrId.equals("-") && !visitedEffects.contains(fdrId))) {
                        if (m != FDRMethod.FULL) {
                            visitedEffects.add(fdrId);
                        }
                        if (permutedPvalues.containsKey(permutedP = Double.parseDouble(data[0]))) {
                            permutedPvalues.increment(permutedP);
                        } else {
                            permutedPvalues.put(permutedP, 1);
                        }
                        ++itr;
                    }
                } else if (m == FDRMethod.FULL || !fdrId.equals("-") && !visitedEffects.contains(fdrId)) {
                    if (m != FDRMethod.FULL) {
                        visitedEffects.add(fdrId);
                    }
                    if (permutedPvalues.containsKey(permutedP = Double.parseDouble(data[0]))) {
                        permutedPvalues.increment(permutedP);
                    } else {
                        permutedPvalues.put(permutedP, 1);
                    }
                    ++itr;
                }
                data = gz.readLineElemsReturnReference(TextFile.tab);
            }
            System.out.println("\tUsed from permutation " + permutationRound + " : " + itr + " rows.");
            gz.close();
        }
        double[] uniquePermutedPvalues = permutedPvalues.keys();
        Arrays.sort(uniquePermutedPvalues);
        double[] uniquePermutedPvaluesCounts = new double[uniquePermutedPvalues.length];
        long cummulativeCount = 0L;
        double nrPermutationsFDRd = nrPermutationsFDR;
        for (int i = 0; i < uniquePermutedPvalues.length; ++i) {
            uniquePermutedPvaluesCounts[i] = (double)(cummulativeCount += (long)permutedPvalues.get(uniquePermutedPvalues[i])) / nrPermutationsFDRd;
        }
        permutedPvalues = null;
        System.out.println("Number of unique permutation p-values: " + uniquePermutedPvalues.length);
        if (outputDir == null) {
            outputDir = baseDir;
        }
        String fileSuffix = "";
        if (m == FDRMethod.GENELEVEL) {
            fileSuffix = "-GeneLevel";
        } else if (m == FDRMethod.PROBELEVEL) {
            fileSuffix = "-ProbeLevel";
        }
        String outFileName = outputDir + "/eQTLsFDR" + fdrcutoff + fileSuffix + ".txt";
        String outFileNameSnps = outputDir + "/eQTLSNPsFDR" + fdrcutoff + fileSuffix + ".txt";
        String outFileNameProbes = outputDir + "/eQTLProbesFDR" + fdrcutoff + fileSuffix + ".txt";
        String outFileNameAll = outputDir + "/eQTLsFDR" + fileSuffix + ".txt.gz";
        TextFile outputWriterSignificant = new TextFile(outFileName, true);
        TextFile outputWriterESNPs = new TextFile(outFileNameSnps, true);
        TextFile outputWriterEProbes = new TextFile(outFileNameProbes, true);
        TextFile outputWriterAll = null;
        if (createLargeFdrFiles) {
            outputWriterAll = new TextFile(outFileNameAll, true);
        }
        if (!Gpio.exists(fileString = baseDir + "/eQTLs.txt.gz")) {
            System.out.println("Could not find file: " + fileString + " trying un-GZipped file....");
            fileString = baseDir + "/eQTLs.txt";
        }
        if (!Gpio.exists(fileString)) {
            System.out.println("Could not find file: " + fileString);
            System.exit(0);
        }
        TextFile realEQTLs = new TextFile(fileString, false);
        String header = realEQTLs.readLine();
        if (createLargeFdrFiles) {
            outputWriterAll.append(header);
            outputWriterAll.append("\tFDR\n");
        }
        outputWriterEProbes.append(header);
        outputWriterEProbes.append("\tFDR\n");
        outputWriterESNPs.append(header);
        outputWriterESNPs.append("\tFDR\n");
        outputWriterSignificant.append(header);
        outputWriterSignificant.append("\tFDR\n");
        String str = realEQTLs.readLine();
        int itr = 0;
        HashSet<String> visitedEffects = new HashSet<String>();
        HashSet<String> visitedSnps = new HashSet<String>();
        HashSet<String> visitedProbes = new HashSet<String>();
        double lastEqtlPvalue = 0.0;
        boolean foundHigherFDRThanDesiredCutOff = false;
        double currentPvalue = 0.0;
        ArrayList<String> currentPvalueEqtls = new ArrayList<String>();
        ArrayList<String> currentPvalueEqtlSnps = new ArrayList<String>();
        ArrayList<String> currentPvalueEqtlProbes = new ArrayList<String>();
        TDoubleArrayList pValueRealData = new TDoubleArrayList();
        ArrayList<Boolean> significantPvalue = new ArrayList<Boolean>();
        int lastUsedPermutedPvalueIndex = 0;
        int nrSignificantEQTLs = 0;
        while ((str = realEQTLs.readLine()) != null && itr <= maxNrMostSignificantEQTLs - 1) {
            String fdrId = null;
            String[] data = Strings.tab.split(str);
            if (selectionOfSnps != null && !selectionOfSnps.contains(data[eQTLTextFile.SNP]) || selectionOfSnpProbes != null && !selectionOfSnpProbes.contains(data[eQTLTextFile.SNP] + "-" + data[eQTLTextFile.PROBE])) continue;
            if (m == FDRMethod.GENELEVEL) {
                fdrId = data[eQTLTextFile.HUGO];
            } else if (m == FDRMethod.PROBELEVEL) {
                fdrId = data[4];
            }
            double eQtlPvalue = Double.parseDouble(data[0]);
            if (itr > 0 && lastEqtlPvalue > eQtlPvalue) {
                System.err.println("Sorted P-Value list is not perfectly sorted!!!!");
                System.exit(-1);
            }
            if (eQtlPvalue > currentPvalue) {
                double fdr = 0.0;
                if (currentPvalue >= uniquePermutedPvalues[0]) {
                    while (uniquePermutedPvalues[lastUsedPermutedPvalueIndex + 1] <= currentPvalue && lastUsedPermutedPvalueIndex < uniquePermutedPvalues.length - 2) {
                        ++lastUsedPermutedPvalueIndex;
                    }
                    fdr = uniquePermutedPvaluesCounts[lastUsedPermutedPvalueIndex] / (double)itr;
                    if (fdr > 1.0) {
                        fdr = 1.0;
                    }
                }
                for (int i = 0; i < currentPvalueEqtls.size(); ++i) {
                    String cachedEqtls = (String)currentPvalueEqtls.get(i);
                    String cachedEqtlsProbe = (String)currentPvalueEqtlProbes.get(i);
                    String cachedEqtlsSnps = (String)currentPvalueEqtlSnps.get(i);
                    StringBuilder currentString = new StringBuilder();
                    currentString.append(cachedEqtls).append('\t').append(String.valueOf(fdr)).append('\n');
                    pValueRealData.add(currentPvalue);
                    if (createLargeFdrFiles) {
                        outputWriterAll.append(currentString.toString());
                    }
                    if (fdr <= fdrcutoff) {
                        foundHigherFDRThanDesiredCutOff = true;
                        if (!visitedProbes.contains(cachedEqtlsProbe)) {
                            outputWriterEProbes.append(currentString.toString());
                            visitedProbes.add(cachedEqtlsProbe);
                        }
                        if (!visitedSnps.contains(cachedEqtlsSnps)) {
                            outputWriterESNPs.append(currentString.toString());
                            visitedSnps.add(cachedEqtlsSnps);
                        }
                        significantPvalue.add(true);
                        outputWriterSignificant.append(currentString.toString());
                        ++nrSignificantEQTLs;
                        continue;
                    }
                    significantPvalue.add(false);
                }
                currentPvalue = eQtlPvalue;
                currentPvalueEqtls.clear();
                currentPvalueEqtlProbes.clear();
                currentPvalueEqtlSnps.clear();
                currentPvalueEqtls.add(str);
                currentPvalueEqtlProbes.add(data[eQTLTextFile.PROBE]);
                currentPvalueEqtlSnps.add(data[eQTLTextFile.SNP]);
            } else {
                currentPvalueEqtls.add(str);
                currentPvalueEqtlProbes.add(data[eQTLTextFile.PROBE]);
                currentPvalueEqtlSnps.add(data[eQTLTextFile.SNP]);
            }
            lastEqtlPvalue = eQtlPvalue;
            if (m != FDRMethod.FULL && (fdrId.equals("-") || visitedEffects.contains(fdrId))) continue;
            ++itr;
            visitedEffects.add(fdrId);
        }
        double fdr = 0.0;
        if (currentPvalue >= uniquePermutedPvalues[0]) {
            while (uniquePermutedPvalues[lastUsedPermutedPvalueIndex + 1] <= currentPvalue && lastUsedPermutedPvalueIndex < uniquePermutedPvalues.length - 2) {
                ++lastUsedPermutedPvalueIndex;
            }
            fdr = uniquePermutedPvaluesCounts[lastUsedPermutedPvalueIndex] / (double)itr;
            if (fdr > 1.0) {
                fdr = 1.0;
            }
        }
        for (int i = 0; i < currentPvalueEqtls.size(); ++i) {
            String cachedEqtls = (String)currentPvalueEqtls.get(i);
            String cachedEqtlsProbe = (String)currentPvalueEqtlProbes.get(i);
            String cachedEqtlsSnps = (String)currentPvalueEqtlSnps.get(i);
            StringBuilder currentString = new StringBuilder();
            currentString.append(cachedEqtls).append('\t').append(String.valueOf(fdr)).append('\n');
            pValueRealData.add(currentPvalue);
            if (createLargeFdrFiles) {
                outputWriterAll.append(currentString.toString());
            }
            if (fdr <= fdrcutoff) {
                foundHigherFDRThanDesiredCutOff = true;
                if (!visitedProbes.contains(cachedEqtlsProbe)) {
                    outputWriterEProbes.append(currentString.toString());
                    visitedProbes.add(cachedEqtlsProbe);
                }
                if (!visitedSnps.contains(cachedEqtlsSnps)) {
                    outputWriterESNPs.append(currentString.toString());
                    visitedSnps.add(cachedEqtlsSnps);
                }
                significantPvalue.add(true);
                outputWriterSignificant.append(currentString.toString());
                ++nrSignificantEQTLs;
                continue;
            }
            significantPvalue.add(false);
        }
        realEQTLs.close();
        if (createLargeFdrFiles) {
            outputWriterAll.close();
        }
        outputWriterEProbes.close();
        outputWriterESNPs.close();
        outputWriterSignificant.close();
        if (!foundHigherFDRThanDesiredCutOff) {
            System.out.println("Warning: Not enough results stored. Need more results for desired FDR threshold.");
        }
        System.out.println("Number of significant eQTLs:\t" + nrSignificantEQTLs);
        System.out.println(" - Number of unique SNPs, constituting an eQTL:\t" + visitedSnps.size());
        System.out.println(" - Number of unique probes, constituting an eQTL:\t" + visitedProbes.size());
        if (createQQPlot) {
            System.out.println("Creating QQ plot. This might take a while...");
            String fileName = baseDir + "/eQTLsFDR" + fdrcutoff + fileSuffix + "-QQPlot.pdf";
            if (maxNrMostSignificantEQTLs > pValueRealData.size()) {
                FDR.createQQPlots(permutationDir, nrPermutationsFDR, pValueRealData.size(), fdrcutoff, f, m, pValueRealData.toArray(), significantPvalue, nrSignificantEQTLs, fileName);
            } else if (maxNrMostSignificantEQTLs > 100000) {
                System.out.println("Only taking the top 100,000 for QQplot creation.");
                FDR.createQQPlots(permutationDir, nrPermutationsFDR, 100000, fdrcutoff, f, m, pValueRealData.toArray(), significantPvalue, nrSignificantEQTLs, fileName);
            } else {
                FDR.createQQPlots(permutationDir, nrPermutationsFDR, maxNrMostSignificantEQTLs, fdrcutoff, f, m, pValueRealData.toArray(), significantPvalue, nrSignificantEQTLs, fileName);
            }
        }
    }

    public static enum FileFormat {
        LARGE,
        REDUCED;

    }

    public static enum FDRMethod {
        PROBELEVEL,
        GENELEVEL,
        FULL,
        ALL;

    }
}

