/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.metaqtl3;

import JSci.maths.ArrayMath;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.jet.random.tdouble.StudentT;
import cern.jet.random.tdouble.engine.DRand;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;
import cern.jet.stat.tdouble.Probability;
import eqtlmappingpipeline.metaqtl3.containers.Result;
import eqtlmappingpipeline.metaqtl3.containers.Settings;
import eqtlmappingpipeline.metaqtl3.containers.WorkPackage;
import eqtlmappingpipeline.metaqtl3.graphics.EQTLPlotter;
import java.util.HashSet;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.math3.distribution.FDistribution;
import org.apache.commons.math3.stat.correlation.SpearmansCorrelation;
import org.apache.commons.math3.stat.regression.OLSMultipleLinearRegression;
import umcg.genetica.io.trityper.SNP;
import umcg.genetica.io.trityper.TriTyperExpressionData;
import umcg.genetica.math.matrix.DoubleMatrixDataset;
import umcg.genetica.math.stats.Correlation;
import umcg.genetica.math.stats.Descriptives;
import umcg.genetica.math.stats.ZScores;

class CalculationThread
extends Thread {
    final TriTyperExpressionData[] m_expressiondata;
    final IntMatrix2D m_probeTranslation;
    int m_name;
    private int m_numProbes;
    private int m_numDatasets;
    private final int[][] m_expressionToGenotypeIds;
    private final double[][] probeVariance;
    private final double[][] probeMean;
    private final String[][] probeName;
    private final LinkedBlockingQueue<WorkPackage> m_workpackage_queue;
    private final LinkedBlockingQueue<WorkPackage> m_result_queue;
    int testsPerformed = 0;
    public boolean done = false;
    private boolean cisOnly;
    private boolean transOnly;
    private final EQTLPlotter m_eQTLPlotter;
    private final double m_pvaluePlotThreshold;
    private boolean determinebeta = false;
    private boolean determinefoldchange = false;
    private WorkPackage currentWP;
    private final DoubleMatrixDataset<String, String>[] m_covariates;
    private final boolean m_useAbsoluteZScores;
    private final boolean testSNPsPresentInBothDatasets;
    private boolean metaAnalyseInteractionTerms = false;
    private boolean metaAnalyseModelCorrelationYHat = false;
    private static DRand randomEngine = new DRand();
    private int tmpbuffersize = 4096;

    CalculationThread(int i, LinkedBlockingQueue<WorkPackage> packageQueue, LinkedBlockingQueue<WorkPackage> resultQueue, TriTyperExpressionData[] expressiondata, DoubleMatrixDataset<String, String>[] covariates, IntMatrix2D probeTranslationTable, int[][] expressionToGenotypeIds, Settings settings, EQTLPlotter plotter, boolean binaryoutput, boolean useAbsoluteZScores, boolean testSNPsPresentInBothDatasets) {
        this.m_name = i;
        this.m_workpackage_queue = packageQueue;
        this.m_result_queue = resultQueue;
        this.m_probeTranslation = probeTranslationTable;
        this.m_expressiondata = expressiondata;
        boolean m_cis = settings.cisAnalysis;
        boolean m_trans = settings.transAnalysis;
        this.metaAnalyseInteractionTerms = settings.metaAnalyseInteractionTerms;
        this.metaAnalyseModelCorrelationYHat = settings.metaAnalyseModelCorrelationYHat;
        this.m_useAbsoluteZScores = useAbsoluteZScores;
        this.m_name = i;
        this.m_numProbes = this.m_probeTranslation.columns();
        this.m_numDatasets = this.m_probeTranslation.rows();
        this.m_expressionToGenotypeIds = expressionToGenotypeIds;
        this.probeVariance = new double[this.m_numDatasets][0];
        this.probeMean = new double[this.m_numDatasets][0];
        this.probeName = new String[this.m_numDatasets][0];
        for (int d = 0; d < this.m_numDatasets; ++d) {
            this.probeVariance[d] = expressiondata[d].getProbeVariance();
            this.probeMean[d] = expressiondata[d].getProbeMean();
            this.probeName[d] = expressiondata[d].getProbes();
        }
        this.m_covariates = covariates;
        this.testSNPsPresentInBothDatasets = testSNPsPresentInBothDatasets;
        this.cisOnly = false;
        this.transOnly = false;
        this.determinebeta = settings.provideBetasAndStandardErrors;
        this.determinefoldchange = settings.provideFoldChangeData;
        if (m_cis && !m_trans) {
            this.cisOnly = true;
        } else if (!m_cis && m_trans) {
            this.transOnly = true;
        }
        this.m_eQTLPlotter = plotter;
        this.m_pvaluePlotThreshold = settings.plotOutputPValueCutOff;
    }

    @Override
    public void run() {
        boolean poison = false;
        while (!poison) {
            try {
                WorkPackage pack = this.m_workpackage_queue.take();
                if (!pack.getPoison()) {
                    this.analyze(pack);
                    continue;
                }
                poison = pack.getPoison();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void kill() {
        this.done = true;
    }

    private void analyze(WorkPackage wp) {
        SNP dSNP;
        int d;
        this.testsPerformed = 0;
        this.currentWP = wp;
        wp.setNumTested(0);
        SNP[] snps = wp.getSnps();
        int[] probes = wp.getProbes();
        Result dsResults = null;
        double[] snpvariances = new double[this.m_numDatasets];
        double[][] snpmeancorrectedgenotypes = new double[this.m_numDatasets][0];
        double[][] originalgenotypes = new double[this.m_numDatasets][0];
        boolean[][] includeExpressionSample = new boolean[this.m_numDatasets][0];
        for (d = 0; d < this.m_numDatasets; ++d) {
            dSNP = snps[d];
            if (dSNP == null) continue;
            double[] x = dSNP.selectGenotypes(this.m_expressionToGenotypeIds[d], false, true);
            originalgenotypes[d] = dSNP.selectGenotypes(this.m_expressionToGenotypeIds[d], false, false);
            int xLen = x.length;
            double meanX = ArrayMath.mean((double[])x);
            snpmeancorrectedgenotypes[d] = new double[xLen];
            for (int i = 0; i < xLen; ++i) {
                snpmeancorrectedgenotypes[d][i] = x[i] - meanX;
            }
            double varianceX = ArrayMath.variance((double[])x);
            if (varianceX != 0.0) {
                snpvariances[d] = varianceX;
                int[] inds = this.m_expressionToGenotypeIds[d];
                int sampleCount = this.m_expressionToGenotypeIds[d].length;
                includeExpressionSample[d] = new boolean[sampleCount];
                byte[] genotypes = dSNP.getGenotypes();
                for (int s = 0; s < sampleCount; ++s) {
                    int ind = inds[s];
                    double valX = genotypes[ind];
                    includeExpressionSample[d][s] = valX != -1.0;
                }
                continue;
            }
            dSNP.clearGenotypes();
            dSNP = null;
            wp.getFlipSNPAlleles()[d] = null;
            snps[d] = null;
        }
        if (this.cisOnly) {
            dsResults = new Result(this.m_numDatasets, wp.getProbes().length, wp.getId());
            for (d = 0; d < this.m_numDatasets; ++d) {
                dSNP = snps[d];
                if (dSNP != null) {
                    dsResults.numSamples[d] = snpmeancorrectedgenotypes[d].length;
                    double[][] rawData = this.m_expressiondata[d].getMatrix();
                    double[] varY = this.m_expressiondata[d].getProbeVariance();
                    double[] meanY = this.m_expressiondata[d].getProbeMean();
                    int samplecount = this.m_expressiondata[d].getIndividuals().length;
                    double[][] covariates = null;
                    if (this.m_covariates != null) {
                        DoubleMatrixDataset<String, String> covariateData = this.m_covariates[d];
                        covariates = covariateData.rawData;
                    }
                    for (int p = 0; p < probes.length; ++p) {
                        int pid = probes[p];
                        Integer probeId = this.m_probeTranslation.get(d, pid);
                        if (probeId != -9) {
                            CalculationThread.test(d, p, probeId, snpmeancorrectedgenotypes[d], originalgenotypes[d], snpvariances[d], varY[probeId], meanY[probeId], includeExpressionSample[d], samplecount, rawData, covariates, dsResults, this.currentWP, this.metaAnalyseModelCorrelationYHat, this.metaAnalyseInteractionTerms, this.determinefoldchange);
                            continue;
                        }
                        dsResults.correlations[d][p] = Double.NaN;
                        dsResults.zscores[d][p] = Double.NaN;
                    }
                    continue;
                }
                for (int p = 0; p < probes.length; ++p) {
                    dsResults.correlations[d][p] = Double.NaN;
                    dsResults.zscores[d][p] = Double.NaN;
                }
            }
        } else if (this.transOnly) {
            HashSet<Integer> probestoExclude = null;
            if (probes != null) {
                probestoExclude = new HashSet<Integer>();
                for (int p = 0; p < probes.length; ++p) {
                    probestoExclude.add(probes[p]);
                }
            }
            dsResults = new Result(this.m_numDatasets, this.m_numProbes, wp.getId());
            for (int d2 = 0; d2 < this.m_numDatasets; ++d2) {
                SNP dSNP2 = snps[d2];
                dsResults.numSamples[d2] = snpmeancorrectedgenotypes[d2].length;
                double[][] rawData = this.m_expressiondata[d2].getMatrix();
                double[] varY = this.m_expressiondata[d2].getProbeVariance();
                double[] meanY = this.m_expressiondata[d2].getProbeMean();
                int samplecount = this.m_expressiondata[d2].getIndividuals().length;
                if (dSNP2 != null) {
                    dsResults.numSamples[d2] = snpmeancorrectedgenotypes[d2].length;
                    for (int pid = 0; pid < this.m_numProbes; ++pid) {
                        if (probestoExclude == null || !probestoExclude.contains(pid)) {
                            Integer probeId = this.m_probeTranslation.get(d2, pid);
                            if (probeId != -9) {
                                CalculationThread.test(d2, pid, probeId, snpmeancorrectedgenotypes[d2], originalgenotypes[d2], snpvariances[d2], varY[probeId], meanY[probeId], includeExpressionSample[d2], samplecount, rawData, null, dsResults, this.currentWP, this.metaAnalyseModelCorrelationYHat, this.metaAnalyseInteractionTerms, this.determinefoldchange);
                                continue;
                            }
                            dsResults.correlations[d2][pid] = Double.NaN;
                            dsResults.zscores[d2][pid] = Double.NaN;
                            continue;
                        }
                        dsResults.correlations[d2][pid] = Double.NaN;
                        dsResults.zscores[d2][pid] = Double.NaN;
                    }
                    continue;
                }
                for (int p = 0; p < this.m_numProbes; ++p) {
                    dsResults.correlations[d2][p] = Double.NaN;
                    dsResults.zscores[d2][p] = Double.NaN;
                }
            }
        } else {
            dsResults = new Result(this.m_numDatasets, this.m_numProbes, wp.getId());
            for (d = 0; d < this.m_numDatasets; ++d) {
                dSNP = snps[d];
                dsResults.numSamples[d] = snpmeancorrectedgenotypes[d].length;
                double[][] rawData = this.m_expressiondata[d].getMatrix();
                double[] varY = this.m_expressiondata[d].getProbeVariance();
                double[] meanY = this.m_expressiondata[d].getProbeMean();
                int samplecount = this.m_expressiondata[d].getIndividuals().length;
                if (dSNP != null) {
                    dsResults.numSamples[d] = snpmeancorrectedgenotypes[d].length;
                    for (int pid = 0; pid < this.m_numProbes; ++pid) {
                        Integer probeId = this.m_probeTranslation.get(d, pid);
                        if (probeId != -9) {
                            CalculationThread.test(d, pid, probeId, snpmeancorrectedgenotypes[d], originalgenotypes[d], snpvariances[d], varY[probeId], meanY[probeId], includeExpressionSample[d], samplecount, rawData, null, dsResults, this.currentWP, this.metaAnalyseModelCorrelationYHat, this.metaAnalyseInteractionTerms, this.determinefoldchange);
                            continue;
                        }
                        dsResults.correlations[d][pid] = Double.NaN;
                        dsResults.zscores[d][pid] = Double.NaN;
                    }
                    continue;
                }
                for (int p = 0; p < this.m_numProbes; ++p) {
                    dsResults.correlations[d][p] = Double.NaN;
                    dsResults.zscores[d][p] = Double.NaN;
                }
            }
        }
        this.convertResultsToPValues(wp, dsResults);
        if (this.m_eQTLPlotter != null) {
            for (int p = 0; p < dsResults.pvalues.length; ++p) {
                double pval = dsResults.pvalues[p];
                if (Double.isNaN(pval) || !(pval < this.m_pvaluePlotThreshold)) continue;
                this.ploteQTL(wp, p);
            }
        }
        if ((snps = wp.getSnps()) != null) {
            for (SNP snp : snps) {
                if (snp == null) continue;
                snp.clearGenotypes();
            }
        }
        try {
            wp.setNumTested(this.testsPerformed);
            this.m_result_queue.put(wp);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected static void test(int d, int p, Integer probeId, double[] x, double[] originalGenotypes, double varianceX, double varianceY, double meanY, boolean[] includeExpressionSample, int sampleCount, double[][] rawData, double[][] covariateRawData, Result r, WorkPackage wp, boolean metaAnalyseModelCorrelationYHat, boolean metaAnalyseInteractionTerms, boolean determinefoldchange) {
        double[] y;
        double[][] covariates = covariateRawData;
        if (x.length != sampleCount) {
            y = new double[x.length];
            int itr = 0;
            double sum = 0.0;
            double[] tmpY = rawData[probeId];
            for (int s = 0; s < sampleCount; ++s) {
                if (!includeExpressionSample[s]) continue;
                y[itr] = tmpY[s];
                sum += y[itr];
                ++itr;
            }
            meanY = sum / (double)itr;
            if (meanY != 0.0) {
                for (int i = 0; i < y.length; ++i) {
                    y[i] = y[i] - meanY;
                }
                meanY = 0.0;
            }
            varianceY = Descriptives.variance(y, meanY);
            if (covariates != null) {
                int covariateitr = 0;
                covariates = new double[covariateRawData.length][0];
                for (int covariate = 0; covariate < covariateRawData.length; ++covariate) {
                    covariates[covariate] = new double[x.length];
                    for (int s = 0; s < sampleCount; ++s) {
                        if (!includeExpressionSample[s]) continue;
                        covariates[covariate][covariateitr] = covariateRawData[covariate][s];
                        ++covariateitr;
                    }
                }
            }
        } else {
            y = new double[x.length];
            System.arraycopy(rawData[probeId], 0, y, 0, x.length);
        }
        double meanX = ArrayMath.mean((double[])x);
        if (meanY > 1.0E-9 || meanY < -1.0E-8 || meanX > 1.0E-9 || meanX < -1.0E-8) {
            double res = 0.0;
            for (double y2 : y) {
                res += y2;
            }
            res /= (double)y.length;
            double res2 = 0.0;
            for (double x2 : x) {
                res2 += x2;
            }
            throw new RuntimeException("Error in eQTL calculation, mean of X or Y was not 0, specified mean y: " + meanY + " and really is: " + res + ", specifief mean x: " + meanX + " and really is: " + (res2 /= (double)x.length));
        }
        if (varianceY == 0.0) {
            r.zscores[d][p] = Double.NaN;
            r.correlations[d][p] = Double.NaN;
        } else if (covariates != null) {
            double[][] olsXFullWithInteraction = new double[x.length][3];
            for (int i = 0; i < x.length; ++i) {
                double xi = x[i];
                double covi = covariates[0][i];
                olsXFullWithInteraction[i][0] = xi;
                olsXFullWithInteraction[i][1] = covi;
                olsXFullWithInteraction[i][2] = covi * xi;
            }
            OLSMultipleLinearRegression regressionFullWithInteraction = new OLSMultipleLinearRegression();
            regressionFullWithInteraction.newSampleData(y, olsXFullWithInteraction);
            if (metaAnalyseModelCorrelationYHat) {
                double zScore;
                double[] regressionParameters = regressionFullWithInteraction.estimateRegressionParameters();
                double[] yInferred = new double[y.length];
                for (int s = 0; s < y.length; ++s) {
                    yInferred[s] = regressionParameters[0];
                    for (int a = 0; a < 3; ++a) {
                        int n = s;
                        yInferred[n] = yInferred[n] + regressionParameters[a + 1] * olsXFullWithInteraction[s][a];
                    }
                }
                SpearmansCorrelation spearman = new SpearmansCorrelation();
                double correlationspearman = spearman.correlation(y, yInferred);
                r.zscores[d][p] = zScore = Correlation.convertCorrelationToZScore(y.length, correlationspearman);
                r.correlations[d][p] = correlationspearman;
                r.beta[d][p] = regressionFullWithInteraction.calculateRSquared();
            } else if (metaAnalyseInteractionTerms) {
                double zScoreInteraction;
                double pValueInteraction;
                double[] regressionParameters = regressionFullWithInteraction.estimateRegressionParameters();
                double[] regressionStandardErrors = regressionFullWithInteraction.estimateRegressionParametersStandardErrors();
                double betaInteraction = regressionParameters[3];
                double seInteraction = regressionStandardErrors[3];
                double tInteraction = betaInteraction / seInteraction;
                StudentT tDistColt = new StudentT((double)(x.length - 4), (DoubleRandomEngine)randomEngine);
                if (tInteraction < 0.0) {
                    pValueInteraction = tDistColt.cdf(tInteraction);
                    if (pValueInteraction < 2.0E-323) {
                        pValueInteraction = 2.0E-323;
                    }
                    zScoreInteraction = Probability.normalInverse((double)pValueInteraction);
                } else {
                    pValueInteraction = tDistColt.cdf(-tInteraction);
                    if (pValueInteraction < 2.0E-323) {
                        pValueInteraction = 2.0E-323;
                    }
                    zScoreInteraction = -Probability.normalInverse((double)pValueInteraction);
                }
                pValueInteraction *= 2.0;
                r.zscores[d][p] = zScoreInteraction;
                r.correlations[d][p] = regressionFullWithInteraction.calculateRSquared();
                r.se[d][p] = seInteraction;
                r.beta[d][p] = betaInteraction;
            } else {
                double residualSS = regressionFullWithInteraction.calculateResidualSumOfSquares();
                double r2 = regressionFullWithInteraction.calculateRSquared();
                double totalSS = regressionFullWithInteraction.calculateTotalSumOfSquares();
                double modelSS = totalSS - residualSS;
                double dfmodel = olsXFullWithInteraction[0].length;
                double dferror = (double)x.length - dfmodel - 1.0;
                double msm = modelSS / dfmodel;
                double mse = residualSS / dferror;
                double f = msm / mse;
                FDistribution fDist = new FDistribution(dfmodel, dferror);
                double pvalmodel = 1.0 - fDist.cumulativeProbability(f);
                double zscore = 0.0;
                if (pvalmodel == 1.0) {
                    zscore = 0.0;
                } else if (pvalmodel == 0.0) {
                    pvalmodel = 1.0E-16;
                }
                try {
                    zscore = ZScores.pToZ(pvalmodel);
                }
                catch (IllegalArgumentException e) {
                    System.out.println(f + "\t" + pvalmodel + "\t" + zscore);
                    for (int i = 0; i < x.length; ++i) {
                        System.out.println(i + "\t" + x[i] + "\t" + y[i] + "\t" + covariates[0][i]);
                    }
                    System.exit(-1);
                }
                r.zscores[d][p] = zscore;
                r.correlations[d][p] = r2;
            }
        } else {
            double stdevx;
            double stdevy = Math.sqrt(varianceY);
            double correlation = Correlation.correlateMeanCenteredData(x, y, stdevy * (stdevx = Math.sqrt(varianceX)));
            if (correlation >= -1.0 && correlation <= 1.0) {
                double zScore = Correlation.convertCorrelationToZScore(x.length, correlation);
                double[] xcopy = new double[x.length];
                for (int i = 0; i < y.length; ++i) {
                    int n = i;
                    y[n] = y[n] / stdevy;
                    xcopy[i] = x[i] / stdevx;
                }
                CalculationThread.calculateRegressionCoefficients(xcopy, y, r, d, p);
                if (determinefoldchange) {
                    CalculationThread.determineFoldchange(originalGenotypes, y, r, d, p, wp);
                }
                r.zscores[d][p] = zScore;
                r.correlations[d][p] = correlation;
            } else {
                System.err.println("Error! correlation invalid: " + correlation + "; genotype variance = " + varianceX + "; expression variance = " + varianceY);
                r.zscores[d][p] = Double.NaN;
                r.correlations[d][p] = Double.NaN;
            }
        }
    }

    private static void calculateRegressionCoefficients(double[] x, double[] y, Result r, int d, int p) {
        double sxx = 0.0;
        double sxy = 0.0;
        for (int i = 0; i < y.length; ++i) {
            sxx += x[i] * x[i];
            sxy += y[i] * x[i];
        }
        double beta = sxy / sxx;
        double ssxy = 0.0;
        for (int i = 0; i < y.length; ++i) {
            ssxy += (y[i] - beta * x[i]) * (y[i] - beta * x[i]);
        }
        r.beta[d][p] = beta;
        r.se[d][p] = Math.sqrt(ssxy / (double)(y.length - 2) / sxx);
    }

    private static void calculateRegressionCoefficients(double[] x, double meanx, double[] y, double meany, Result r, int d, int p) {
        double sxx = 0.0;
        double sxy = 0.0;
        double b = 0.0;
        for (int i = 0; i < y.length; ++i) {
            sxx += (x[i] - meanx) * (x[i] - meanx);
            sxy += (y[i] - meany) * (x[i] - meanx);
        }
        double beta = sxy / sxx;
        double alpha = meany - beta * meanx;
        double ssxy = 0.0;
        for (int i = 0; i < y.length; ++i) {
            double yexp = alpha + beta * x[i];
            ssxy += (y[i] - yexp) * (y[i] - yexp);
        }
        double se = Math.sqrt(ssxy / (double)(y.length - 2)) / Math.sqrt(sxx);
        r.beta[d][p] = beta;
        r.se[d][p] = se;
    }

    private static void determineFoldchange(double[] genotypes, double[] expression, Result r, int d, int p, WorkPackage wp) {
        int numAA = 0;
        int numBB = 0;
        double sumAA = 0.0;
        double sumBB = 0.0;
        for (int i = 0; i < genotypes.length; ++i) {
            if (genotypes[i] == 0.0) {
                sumAA += expression[i] * 2.0;
                numAA += 2;
            }
            if (genotypes[i] == 1.0) {
                sumAA += expression[i];
                sumBB += expression[i];
                ++numAA;
                ++numBB;
            }
            if (genotypes[i] != 2.0) continue;
            sumBB += expression[i] * 2.0;
            numBB += 2;
        }
        double min = sumAA /= (double)numAA;
        if ((sumBB /= (double)numBB) < min) {
            min = sumBB;
        }
        if (min < 0.0) {
            sumAA += Math.abs(min) + 1.0;
            sumBB += Math.abs(min) + 1.0;
        }
        r.fc[d][p] = wp.getFlipSNPAlleles()[d] != false ? sumAA / sumBB : sumBB / sumAA;
    }

    private void convertResultsToPValues(WorkPackage wp, Result dsResults) {
        int numProbes = dsResults.zscores[0].length;
        boolean hasResults = false;
        for (int p = 0; p < numProbes; ++p) {
            int nrDatasetsPassingQC = 0;
            int nrTotalSamples = 0;
            double zSum = 0.0;
            double betasum = 0.0;
            for (int d = 0; d < this.m_numDatasets; ++d) {
                double zscore = dsResults.zscores[d][p];
                double correlation = dsResults.correlations[d][p];
                Integer numSamples = dsResults.numSamples[d];
                if (Double.isNaN(correlation)) continue;
                boolean flipalleles = wp.getFlipSNPAlleles()[d];
                if (this.m_useAbsoluteZScores) {
                    zscore = Math.abs(zscore);
                    dsResults.zscores[d][p] = Math.abs(zscore);
                    dsResults.correlations[d][p] = Math.abs(correlation);
                    if (!Double.isNaN(dsResults.beta[d][p])) {
                        dsResults.beta[d][p] = Math.abs(dsResults.beta[d][p]);
                    }
                    wp.getFlipSNPAlleles()[d] = false;
                } else if (flipalleles) {
                    zscore = -zscore;
                }
                ++nrDatasetsPassingQC;
                double weight = Descriptives.getSqrt(numSamples);
                zSum += zscore * weight;
                nrTotalSamples += numSamples.intValue();
                if (!this.determinebeta) continue;
                if (flipalleles) {
                    betasum += -dsResults.beta[d][p] * (double)numSamples.intValue();
                    dsResults.beta[d][p] = -dsResults.beta[d][p];
                    continue;
                }
                betasum += dsResults.beta[d][p] * (double)numSamples.intValue();
            }
            if (nrTotalSamples > 0 && this.testSNPsPresentInBothDatasets && nrDatasetsPassingQC == this.m_numDatasets || !this.testSNPsPresentInBothDatasets && nrDatasetsPassingQC > 0) {
                double pValueOverall;
                ++this.testsPerformed;
                hasResults = true;
                double sqrtSample = Descriptives.getSqrt(nrTotalSamples);
                double zScore = zSum / sqrtSample;
                dsResults.pvalues[p] = pValueOverall = Descriptives.convertZscoreToPvalue(zScore);
                dsResults.finalZScore[p] = zScore;
                if (!this.determinebeta) continue;
                double metase = 1.0 / Math.sqrt(nrTotalSamples);
                dsResults.finalBeta[p] = betasum /= (double)nrTotalSamples;
                dsResults.finalBetaSe[p] = metase;
                continue;
            }
            dsResults.pvalues[p] = Double.NaN;
            dsResults.finalZScore[p] = Double.NaN;
        }
        wp.setHasResults(hasResults);
        wp.setResult(dsResults);
    }

    private void ploteQTL(WorkPackage wp, int p) {
        this.m_eQTLPlotter.draw(wp, p);
    }
}

