/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.interactionanalysis;

import cern.jet.random.tdouble.StudentT;
import cern.jet.random.tdouble.engine.DRand;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;
import cern.jet.stat.tdouble.Probability;
import java.awt.Color;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.math3.distribution.FDistribution;
import org.apache.commons.math3.stat.regression.OLSMultipleLinearRegression;
import umcg.genetica.containers.Triple;
import umcg.genetica.graphics.ScatterPlot;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.SNP;
import umcg.genetica.io.trityper.SNPLoader;
import umcg.genetica.io.trityper.TriTyperGenotypeData;
import umcg.genetica.io.trityper.util.BaseAnnot;
import umcg.genetica.math.matrix.DoubleMatrixDataset;

public class InteractionPlotter {
    public InteractionPlotter(String interactionFile, String genotypeDir, String expressionDataFile, String covariateDataFile, String gteFile, String outdir) throws IOException {
        outdir = Gpio.formatAsDirectory(outdir);
        Gpio.createDir(outdir);
        Map<String, String> gte = null;
        if (gteFile != null) {
            TextFile tf = new TextFile(gteFile, false);
            gte = tf.readAsHashMap(0, 1);
            tf.close();
        }
        HashSet<String> expressionProbes = new HashSet<String>();
        TextFile tf = new TextFile(interactionFile, false);
        String[] elems = tf.readLineElems(TextFile.tab);
        ArrayList<Triple<String, Object, String>> triples = new ArrayList<Triple<String, Object, String>>();
        while (elems != null) {
            String snp;
            if (elems.length == 2) {
                snp = elems[0];
                String probe = elems[1];
                expressionProbes.add(probe);
                triples.add(new Triple<String, Object, String>(snp, null, probe));
            } else if (elems.length == 3) {
                snp = elems[0];
                String covariate = elems[1];
                String probe = elems[2];
                expressionProbes.add(probe);
                triples.add(new Triple<String, String, String>(snp, covariate, probe));
            }
            elems = tf.readLineElems(TextFile.tab);
        }
        tf.close();
        System.out.println(triples.size() + " SNP - covariate - probe combinations read from: " + interactionFile);
        DoubleMatrixDataset expressionData = new DoubleMatrixDataset(expressionDataFile, expressionProbes);
        DoubleMatrixDataset covariateData = new DoubleMatrixDataset(covariateDataFile);
        int samplesHaveCovariatesOnCols = 0;
        int samplesHaveCovariatesOnRows = 0;
        for (int i = 0; i < expressionData.colObjects.size(); ++i) {
            String expSample = (String)expressionData.colObjects.get(i);
            Integer id1 = (Integer)covariateData.hashCols.get(expSample);
            Integer id2 = (Integer)covariateData.hashRows.get(expSample);
            if (id1 != null) {
                ++samplesHaveCovariatesOnCols;
            }
            if (id2 == null) continue;
            ++samplesHaveCovariatesOnRows;
        }
        if (samplesHaveCovariatesOnRows > samplesHaveCovariatesOnCols) {
            System.out.println("Rows contain covariate samples in covariate file. Transposing covariates.");
            covariateData.transposeDataset();
        }
        TriTyperGenotypeData geno = new TriTyperGenotypeData(genotypeDir);
        SNPLoader loader = geno.createSNPLoader();
        int[] genotypeToCovariate = new int[geno.getIndividuals().length];
        int[] genotypeToExpression = new int[geno.getIndividuals().length];
        String[] genoIndividuals = geno.getIndividuals();
        for (int i = 0; i < genotypeToCovariate.length; ++i) {
            String genoSample = genoIndividuals[i];
            if (geno.getIsIncluded()[i] != null && geno.getIsIncluded()[i].booleanValue()) {
                if (gte != null) {
                    genoSample = gte.get(genoSample);
                }
                Integer covariateSample = (Integer)covariateData.hashCols.get(genoSample);
                Integer expressionSample = (Integer)expressionData.hashCols.get(genoSample);
                if (genoSample != null && covariateSample != null && expressionSample != null) {
                    genotypeToCovariate[i] = covariateSample;
                    genotypeToExpression[i] = expressionSample;
                    continue;
                }
                genotypeToCovariate[i] = -9;
                genotypeToExpression[i] = -9;
                continue;
            }
            genotypeToCovariate[i] = -9;
            genotypeToExpression[i] = -9;
        }
        OLSMultipleLinearRegression regressionFullWithInteraction = new OLSMultipleLinearRegression();
        StudentT tDistColt = null;
        FDistribution fDist = null;
        DRand randomEngine = null;
        Color[] colorarray = new Color[]{new Color(171, 178, 114), new Color(98, 175, 255), new Color(204, 86, 78)};
        DecimalFormat decFormat = new DecimalFormat("#.###");
        DecimalFormat decFormatSmall = new DecimalFormat("0.#E0");
        for (Triple triple : triples) {
            String snp = (String)triple.getLeft();
            String covariate = (String)triple.getMiddle();
            String probe = (String)triple.getRight();
            Integer snpId = geno.getSnpToSNPId().get((Object)snp);
            Integer probeId = (Integer)expressionData.hashRows.get(probe);
            int startCovariate = -1;
            int endCovariate = -1;
            if (covariate == null) {
                startCovariate = 0;
                endCovariate = covariateData.nrRows;
            } else {
                Integer covariateId = (Integer)covariateData.hashRows.get(covariate);
                if (covariateId != null) {
                    startCovariate = covariateId;
                    endCovariate = covariateId + 1;
                }
            }
            if (snpId < 0 || probeId == null || startCovariate < 0) continue;
            SNP snpObj = geno.getSNPObject(snpId);
            loader.loadGenotypes(snpObj);
            if (loader.hasDosageInformation()) {
                loader.loadDosage(snpObj);
            }
            double signInteractionEffectDirection = 1.0;
            String[] genotypeDescriptions = new String[3];
            if (snpObj.getAlleles()[1] == snpObj.getMinorAllele()) {
                signInteractionEffectDirection = -1.0;
                genotypeDescriptions[2] = BaseAnnot.toString(snpObj.getAlleles()[0]) + "" + BaseAnnot.toString(snpObj.getAlleles()[0]);
                genotypeDescriptions[1] = BaseAnnot.toString(snpObj.getAlleles()[0]) + "" + BaseAnnot.toString(snpObj.getAlleles()[1]);
                genotypeDescriptions[0] = BaseAnnot.toString(snpObj.getAlleles()[1]) + "" + BaseAnnot.toString(snpObj.getAlleles()[1]);
            } else {
                genotypeDescriptions[0] = BaseAnnot.toString(snpObj.getAlleles()[0]) + "" + BaseAnnot.toString(snpObj.getAlleles()[0]);
                genotypeDescriptions[1] = BaseAnnot.toString(snpObj.getAlleles()[0]) + "" + BaseAnnot.toString(snpObj.getAlleles()[1]);
                genotypeDescriptions[2] = BaseAnnot.toString(snpObj.getAlleles()[1]) + "" + BaseAnnot.toString(snpObj.getAlleles()[1]);
            }
            for (int q = startCovariate; q < endCovariate; ++q) {
                System.out.println("Plotting: " + snp + "\t" + (String)covariateData.rowObjects.get(q) + "\t" + probe);
                System.out.println("Individual\tAllele1\tAllele2\tGenotype\tGenotypeFlipped\tCovariate\tExpression");
                byte[] alleles1 = snpObj.getAllele1();
                byte[] alleles2 = snpObj.getAllele2();
                byte[] genotypes = snpObj.getGenotypes();
                ArrayList<Byte> genotypeArr = new ArrayList<Byte>();
                ArrayList<Double> covariateArr = new ArrayList<Double>();
                ArrayList<Double> expressionArr = new ArrayList<Double>();
                int nrCalled = 0;
                for (int i = 0; i < genoIndividuals.length; ++i) {
                    if (genotypes[i] == -1 || genotypeToCovariate[i] == -9 || genotypeToExpression[i] == -9 || Double.isNaN(covariateData.rawData[q][genotypeToCovariate[i]])) continue;
                    int genotypeflipped = genotypes[i];
                    if (signInteractionEffectDirection == -1.0) {
                        genotypeflipped = 2 - genotypeflipped;
                    }
                    String output = genoIndividuals[i] + "\t" + BaseAnnot.toString(alleles1[i]) + "\t" + BaseAnnot.toString(alleles2[i]) + "\t" + genotypes[i] + "\t" + genotypeflipped + "\t" + covariateData.rawData[q][genotypeToCovariate[i]] + "\t" + expressionData.rawData[probeId][genotypeToExpression[i]];
                    System.out.println(output);
                    genotypeArr.add(genotypes[i]);
                    covariateArr.add(covariateData.rawData[q][genotypeToCovariate[i]]);
                    expressionArr.add(expressionData.rawData[probeId][genotypeToExpression[i]]);
                    ++nrCalled;
                }
                System.out.println("");
                double[] olsY = new double[nrCalled];
                double[][] olsXFullWithInteraction = new double[nrCalled][3];
                int itr = 0;
                double[] dataExp = new double[nrCalled];
                double[] dataCov = new double[nrCalled];
                int[] dataGen = new int[nrCalled];
                for (int s = 0; s < nrCalled; ++s) {
                    int originalGenotype;
                    int genotype = originalGenotype = ((Byte)genotypeArr.get(s)).byteValue();
                    if (signInteractionEffectDirection == -1.0) {
                        genotype = 2 - genotype;
                    }
                    olsY[s] = (Double)expressionArr.get(s);
                    olsXFullWithInteraction[s][0] = genotype;
                    olsXFullWithInteraction[s][1] = (Double)covariateArr.get(s);
                    olsXFullWithInteraction[s][2] = olsXFullWithInteraction[s][0] * olsXFullWithInteraction[s][1];
                    dataExp[s] = olsY[s];
                    dataGen[s] = genotype;
                    dataCov[s] = (Double)covariateArr.get(s);
                    ++itr;
                }
                regressionFullWithInteraction.newSampleData(olsY, olsXFullWithInteraction);
                double rss2 = regressionFullWithInteraction.calculateResidualSumOfSquares();
                double[] regressionParameters = regressionFullWithInteraction.estimateRegressionParameters();
                double[] regressionStandardErrors = regressionFullWithInteraction.estimateRegressionParametersStandardErrors();
                double betaInteraction = regressionParameters[3];
                double seInteraction = regressionStandardErrors[3];
                double tInteraction = betaInteraction / seInteraction;
                double pValueInteraction = 1.0;
                double zScoreInteraction = 0.0;
                if (fDist == null) {
                    fDist = new FDistribution(1.0, (double)(olsY.length - 3));
                    randomEngine = new DRand();
                    tDistColt = new StudentT((double)(olsY.length - 4), (DoubleRandomEngine)randomEngine);
                }
                if (tInteraction < 0.0) {
                    pValueInteraction = tDistColt.cdf(tInteraction);
                    if (pValueInteraction < 2.0E-323) {
                        pValueInteraction = 2.0E-323;
                    }
                    zScoreInteraction = Probability.normalInverse((double)pValueInteraction);
                } else {
                    pValueInteraction = tDistColt.cdf(-tInteraction);
                    if (pValueInteraction < 2.0E-323) {
                        pValueInteraction = 2.0E-323;
                    }
                    zScoreInteraction = -Probability.normalInverse((double)pValueInteraction);
                }
                String pvalFormatted = "";
                pvalFormatted = pValueInteraction >= 0.001 ? decFormat.format(pValueInteraction) : decFormatSmall.format(pValueInteraction *= 2.0);
                ScatterPlot scatterPlot = new ScatterPlot(500, 500, dataCov, dataExp, dataGen, genotypeDescriptions, colorarray, ScatterPlot.OUTPUTFORMAT.PDF, "Interaction between SNP " + snp + ", probe " + probe + " and covariate " + (String)covariateData.rowObjects.get(q), "Z: " + decFormat.format(zScoreInteraction) + " Pvalue: " + pvalFormatted + " n: " + nrCalled, outdir + snp + "-" + probe + "-" + (String)covariateData.rowObjects.get(q) + ".pdf", false);
            }
            snpObj.clearGenotypes();
        }
        loader.close();
    }
}

