/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.interactionanalysis;

import JSci.maths.ArrayMath;
import cern.jet.random.tdouble.StudentT;
import cern.jet.random.tdouble.engine.DRand;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;
import cern.jet.stat.tdouble.Probability;
import eqtlmappingpipeline.interactionanalysis.InteractionAnalysisResults;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.apache.commons.math3.distribution.FDistribution;
import org.apache.commons.math3.stat.regression.OLSMultipleLinearRegression;
import umcg.genetica.containers.Pair;
import umcg.genetica.io.trityper.SNP;
import umcg.genetica.io.trityper.TriTyperExpressionData;
import umcg.genetica.io.trityper.util.BaseAnnot;
import umcg.genetica.io.trityper.util.ChrAnnotation;
import umcg.genetica.math.matrix.DoubleMatrixDataset;
import umcg.genetica.math.stats.Correlation;

public class InteractionAnalysisTask
implements Callable<InteractionAnalysisResults> {
    private SNP eQTLSNPObj;
    private double[][] pcCorrectedData;
    private int[] wgaId;
    private String[] expInds;
    private DoubleMatrixDataset<String, String> covariateData;
    private TriTyperExpressionData expressionDataPCCorrected;
    private ArrayList<Pair<String, String>> eQTLsForSNP;

    public InteractionAnalysisTask(SNP snpObj, ArrayList<Pair<String, String>> eQTLsForSNP, double[][] pcCorrectedData, int[] wgaId, String[] expInds, DoubleMatrixDataset<String, String> expressionDataRaw, TriTyperExpressionData expressionDataPCCorrected) {
        this.eQTLSNPObj = snpObj;
        this.eQTLsForSNP = eQTLsForSNP;
        this.pcCorrectedData = pcCorrectedData;
        this.wgaId = wgaId;
        this.expInds = expInds;
        this.expressionDataPCCorrected = expressionDataPCCorrected;
        this.covariateData = expressionDataRaw;
    }

    @Override
    public InteractionAnalysisResults call() throws Exception {
        ArrayList<Pair<String, String>> eQTLsTested = new ArrayList<Pair<String, String>>();
        int nrTotalCovariates = this.covariateData.nrRows;
        double[][] interactionZScoreMatrix = new double[this.eQTLsForSNP.size()][nrTotalCovariates];
        double[][] SNPZResultMatrix = new double[this.eQTLsForSNP.size()][nrTotalCovariates];
        double[][] covariateZResultMatrix = new double[this.eQTLsForSNP.size()][nrTotalCovariates];
        double[][] maineffectZResultMatrix = new double[this.eQTLsForSNP.size()][nrTotalCovariates];
        int[][] nMatrix = new int[this.eQTLsForSNP.size()][nrTotalCovariates];
        double signInteractionEffectDirection = 1.0;
        if (this.eQTLSNPObj.getAlleles()[1] == this.eQTLSNPObj.getMinorAllele()) {
            signInteractionEffectDirection = -1.0;
        }
        String qcString = null;
        Integer nrGenotypesCalled = null;
        FDistribution fDist = null;
        DRand randomEngine = null;
        StudentT tDistColt = null;
        OLSMultipleLinearRegression regression = new OLSMultipleLinearRegression();
        OLSMultipleLinearRegression regressionFullWithInteraction = new OLSMultipleLinearRegression();
        int startWithCovariate = 0;
        for (int e = 0; e < this.eQTLsForSNP.size(); ++e) {
            Pair<String, String> eqtl = this.eQTLsForSNP.get(e);
            String eQTLProbeName = eqtl.getRight();
            eQTLsTested.add(eqtl);
            Integer eQTLProbeId = (Integer)this.expressionDataPCCorrected.getProbeToId().get((Object)eQTLProbeName);
            double[] valsX = this.eQTLSNPObj.selectGenotypes(this.wgaId, true, true);
            double[] valsY = this.pcCorrectedData[eQTLProbeId];
            for (int covariate = startWithCovariate; covariate < nrTotalCovariates; ++covariate) {
                double[] tmpVarCelCount = null;
                tmpVarCelCount = new double[valsY.length];
                for (int i = 0; i < tmpVarCelCount.length; ++i) {
                    String sampleName = this.expInds[i];
                    Integer individualIdInCovariateData = (Integer)this.covariateData.hashCols.get(sampleName);
                    tmpVarCelCount[i] = individualIdInCovariateData != null ? this.covariateData.rawData[covariate][individualIdInCovariateData] : Double.NaN;
                }
                double[] covariateValues = tmpVarCelCount;
                int nrCalled = 0;
                for (int i = 0; i < this.wgaId.length; ++i) {
                    if (this.wgaId[i] == -1 || Double.isNaN(covariateValues[i]) || valsX[i] == -1.0) continue;
                    ++nrCalled;
                }
                double[] olsY = new double[nrCalled];
                double[] genotypesCalled = new double[nrCalled];
                double[][] olsX = new double[nrCalled][2];
                double[][] olsXFullWithInteraction = new double[nrCalled][3];
                int itr = 0;
                for (int s = 0; s < valsX.length; ++s) {
                    double genotype = valsX[s];
                    if (genotype == -1.0 || Double.isNaN(covariateValues[s])) continue;
                    if (signInteractionEffectDirection == -1.0) {
                        genotype = 2.0 - genotype;
                    }
                    genotypesCalled[itr] = genotype;
                    olsY[itr] = valsY[s];
                    olsX[itr][0] = genotype;
                    olsXFullWithInteraction[itr][0] = genotype;
                    olsX[itr][1] = covariateValues[s];
                    olsXFullWithInteraction[itr][1] = covariateValues[s];
                    olsXFullWithInteraction[itr][2] = olsXFullWithInteraction[itr][0] * olsXFullWithInteraction[itr][1];
                    ++itr;
                }
                regression.newSampleData(olsY, olsX);
                regressionFullWithInteraction.newSampleData(olsY, olsXFullWithInteraction);
                double rss1 = regression.calculateResidualSumOfSquares();
                double rss2 = regressionFullWithInteraction.calculateResidualSumOfSquares();
                double anovaF = (rss1 - rss2) / 1.0 / (rss2 / (double)(olsY.length - 3));
                if (fDist == null) {
                    fDist = new FDistribution(1.0, (double)(olsY.length - 3));
                    randomEngine = new DRand();
                    tDistColt = new StudentT((double)(olsY.length - 4), (DoubleRandomEngine)randomEngine);
                }
                double anovaFTestP = -1.0;
                try {
                    anovaFTestP = 1.0 - fDist.cumulativeProbability(anovaF);
                    if (anovaFTestP < 1.0E-16) {
                        anovaFTestP = 1.0E-16;
                    }
                }
                catch (Exception err) {
                    // empty catch block
                }
                double[] regressionParameters = regressionFullWithInteraction.estimateRegressionParameters();
                double[] regressionStandardErrors = regressionFullWithInteraction.estimateRegressionParametersStandardErrors();
                double betaInteraction = regressionParameters[3];
                double seInteraction = regressionStandardErrors[3];
                double tInteraction = betaInteraction / seInteraction;
                double pValueInteraction = 1.0;
                double zScoreInteraction = 0.0;
                if (tInteraction < 0.0) {
                    pValueInteraction = tDistColt.cdf(tInteraction);
                    if (pValueInteraction < 2.0E-323) {
                        pValueInteraction = 2.0E-323;
                    }
                    zScoreInteraction = Probability.normalInverse((double)pValueInteraction);
                } else {
                    pValueInteraction = tDistColt.cdf(-tInteraction);
                    if (pValueInteraction < 2.0E-323) {
                        pValueInteraction = 2.0E-323;
                    }
                    zScoreInteraction = -Probability.normalInverse((double)pValueInteraction);
                }
                pValueInteraction *= 2.0;
                if (qcString == null) {
                    qcString = this.eQTLSNPObj.getName() + "\t" + ChrAnnotation.parseByte(this.eQTLSNPObj.getChr()) + "\t" + this.eQTLSNPObj.getChrPos() + "\t" + BaseAnnot.toString(this.eQTLSNPObj.getAlleles()[0]) + "/" + BaseAnnot.toString(this.eQTLSNPObj.getAlleles()[1]) + "\t" + BaseAnnot.toString(this.eQTLSNPObj.getMinorAllele()) + "\t" + this.eQTLSNPObj.getMAF() + "\t" + this.eQTLSNPObj.getCR() + "\t" + this.eQTLSNPObj.getHWEP() + "\t" + genotypesCalled.length;
                    nrGenotypesCalled = genotypesCalled.length;
                } else if (genotypesCalled.length != nrGenotypesCalled) {
                    System.err.println("ERROR: the number of available values has changed. Does your gene expression data or cell count file contain missing values?");
                    System.exit(0);
                }
                double corr = ArrayMath.correlation((double[])genotypesCalled, (double[])olsY);
                double mainZ = Correlation.convertCorrelationToZScore(genotypesCalled.length, corr);
                double betaSNP = regressionParameters[1];
                double seSNP = regressionStandardErrors[1];
                double tSNP = betaSNP / seSNP;
                double pValueSNP = 1.0;
                double zScoreSNP = 0.0;
                if (tSNP < 0.0) {
                    pValueSNP = tDistColt.cdf(tSNP);
                    if (pValueSNP < 2.0E-323) {
                        pValueSNP = 2.0E-323;
                    }
                    zScoreSNP = Probability.normalInverse((double)pValueSNP);
                } else {
                    pValueSNP = tDistColt.cdf(-tSNP);
                    if (pValueSNP < 2.0E-323) {
                        pValueSNP = 2.0E-323;
                    }
                    zScoreSNP = -Probability.normalInverse((double)pValueSNP);
                }
                pValueSNP *= 2.0;
                double betaCellType = regressionParameters[2];
                double seCellType = regressionStandardErrors[2];
                double tCellType = betaCellType / seCellType;
                double pValueCellType = 1.0;
                double zScoreCovariate = 0.0;
                if (tCellType < 0.0) {
                    pValueCellType = tDistColt.cdf(tCellType);
                    if (pValueCellType < 2.0E-323) {
                        pValueCellType = 2.0E-323;
                    }
                    zScoreCovariate = Probability.normalInverse((double)pValueCellType);
                } else {
                    pValueCellType = tDistColt.cdf(-tCellType);
                    if (pValueCellType < 2.0E-323) {
                        pValueCellType = 2.0E-323;
                    }
                    zScoreCovariate = -Probability.normalInverse((double)pValueCellType);
                }
                pValueCellType *= 2.0;
                interactionZScoreMatrix[e][covariate] = zScoreInteraction;
                SNPZResultMatrix[e][covariate] = zScoreSNP;
                covariateZResultMatrix[e][covariate] = zScoreCovariate;
                maineffectZResultMatrix[e][covariate] = mainZ;
                nMatrix[e][covariate] = nrCalled;
            }
        }
        InteractionAnalysisResults result = new InteractionAnalysisResults(qcString, eQTLsTested, interactionZScoreMatrix, SNPZResultMatrix, covariateZResultMatrix, maineffectZResultMatrix, nMatrix);
        this.eQTLSNPObj.clearGenotypes();
        this.eQTLSNPObj = null;
        return result;
    }
}

