/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.interactionanalysis;

import JSci.maths.ArrayMath;
import eqtlmappingpipeline.interactionanalysis.InteractionAnalysisResults;
import eqtlmappingpipeline.interactionanalysis.InteractionAnalysisTask;
import eqtlmappingpipeline.normalization.Normalizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import umcg.genetica.console.ProgressBar;
import umcg.genetica.containers.Pair;
import umcg.genetica.graphics.ScatterPlot;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.SNP;
import umcg.genetica.io.trityper.SNPLoader;
import umcg.genetica.io.trityper.TriTyperExpressionData;
import umcg.genetica.io.trityper.TriTyperGeneticalGenomicsDataset;
import umcg.genetica.io.trityper.TriTyperGeneticalGenomicsDatasetSettings;
import umcg.genetica.io.trityper.TriTyperGenotypeData;
import umcg.genetica.math.matrix.DoubleMatrixDataset;
import umcg.genetica.math.stats.Correlation;
import umcg.genetica.math.stats.Descriptives;
import umcg.genetica.math.stats.Log2Transform;
import umcg.genetica.math.stats.QuantileNormalization;
import umcg.genetica.math.stats.concurrent.ConcurrentCorrelation;

public class InteractionAnalysisMultiThreaded {
    private int nrInOutput;

    public void prepareDataForCelltypeSpecificEQTLMapping(String inexpraw, String outdirectory, Double correlationThreshold, String celltypeSpecificProbeFile, String mdsComponentFile, String cellCountFile, String gte, Integer threads) throws IOException {
        int i;
        String rawExpressionDataFile = inexpraw;
        Normalizer n = new Normalizer();
        if (correlationThreshold == null) {
            correlationThreshold = 0.9;
        }
        if (rawExpressionDataFile == null || rawExpressionDataFile.trim().length() == 0 || !Gpio.exists(rawExpressionDataFile)) {
            throw new IllegalArgumentException("Error: Raw gene expression file: " + rawExpressionDataFile + "  either does not exist or was not provided to the program.");
        }
        if (outdirectory == null || outdirectory.trim().length() == 0) {
            throw new IllegalArgumentException("Error: output directory not provided");
        }
        if (Math.abs(correlationThreshold) > 1.0 || Math.abs(correlationThreshold) < 0.0) {
            throw new IllegalArgumentException("Error: PC1 sample correlation threshold should be between 0 and 1");
        }
        if (celltypeSpecificProbeFile == null || celltypeSpecificProbeFile.trim().length() == 0 || !Gpio.exists(celltypeSpecificProbeFile)) {
            throw new IllegalArgumentException("Error: Cell type specific probe list has not been provided or does not exist: " + celltypeSpecificProbeFile);
        }
        if (mdsComponentFile == null || mdsComponentFile.trim().length() == 0 || !Gpio.exists(mdsComponentFile)) {
            System.err.println("Warning: will not correct for possible population stratification effects!");
            mdsComponentFile = null;
        }
        outdirectory = Gpio.formatAsDirectory(outdirectory);
        Gpio.createDir(outdirectory);
        String expressionOutputDirectory = outdirectory + "ExpressionData/";
        Gpio.createDir(expressionOutputDirectory);
        HashSet<String> expressionSamplestoInclude = null;
        if (gte != null) {
            System.out.println("Loading genotype to expression coupling: " + gte);
            expressionSamplestoInclude = new HashSet<String>();
            TextFile tf = new TextFile(gte, false);
            String[] elems = tf.readLineElems(TextFile.tab);
            while (elems != null) {
                if (elems.length > 1) {
                    expressionSamplestoInclude.add(elems[1]);
                }
                elems = tf.readLineElems(TextFile.tab);
            }
            tf.close();
            System.out.println("Your genotype to expression coupling file has: " + expressionSamplestoInclude.size() + " individuals.");
        }
        System.out.println("Loading list of cell type specific probes from: " + celltypeSpecificProbeFile);
        HashSet<String> cellTypeSpecificProbeSet = new HashSet<String>();
        TextFile cellSpecificProbeTF = new TextFile(celltypeSpecificProbeFile, false);
        cellTypeSpecificProbeSet.addAll(cellSpecificProbeTF.readAsArrayList());
        cellSpecificProbeTF.close();
        if (cellTypeSpecificProbeSet.isEmpty()) {
            System.err.println("Error: " + celltypeSpecificProbeFile + " is empty!");
            System.exit(-1);
        } else {
            System.out.println(cellTypeSpecificProbeSet.size() + " cell type specific probes loaded.");
        }
        System.out.println("Loading gene expression data.");
        DoubleMatrixDataset<String, String> rawExpressionDataset = new DoubleMatrixDataset<String, String>(rawExpressionDataFile, null, expressionSamplestoInclude);
        double[][] rawExpressionData = rawExpressionDataset.getRawData();
        int probeCounter = 0;
        List probes = rawExpressionDataset.rowObjects;
        for (int i2 = 0; i2 < probes.size(); ++i2) {
            if (!cellTypeSpecificProbeSet.contains(probes.get(i2))) continue;
            ++probeCounter;
        }
        if (probeCounter == 0) {
            System.err.println("Error: none of the cell type specific probes defined in " + celltypeSpecificProbeFile + " are present in expression dataset: " + rawExpressionDataset.fileName);
            System.exit(-1);
        } else {
            System.out.println(probeCounter + " of the cell type specific probes are in your dataset.");
        }
        if (expressionSamplestoInclude != null) {
            rawExpressionDataset.save(expressionOutputDirectory + "ExpressionDataForSamplesWithGenotypes.txt.gz");
        }
        QuantileNormalization.quantilenormalize(rawExpressionData);
        Log2Transform.log2transform(rawExpressionData);
        if (mdsComponentFile != null) {
            String file = n.adjustCovariates(rawExpressionDataset, expressionOutputDirectory + "ExpressionDataRaw-QNormLog2Transformed", mdsComponentFile, true, 0.0);
            System.out.println("MDS component corrected file: " + file + ".txt.gz");
            rawExpressionDataset = new DoubleMatrixDataset(file + ".txt.gz");
        } else {
            rawExpressionDataset.save(expressionOutputDirectory + "ExpressionDataRaw-QNormLog2Transformed.txt.gz");
        }
        rawExpressionDataset.transposeDataset();
        rawExpressionData = rawExpressionDataset.getRawData();
        for (int i3 = 0; i3 < rawExpressionData.length; ++i3) {
            double mean = Descriptives.mean(rawExpressionData[i3]);
            double var = Descriptives.variance(rawExpressionData[i3]);
            double sd = Math.sqrt(var);
            int j = 0;
            while (j < rawExpressionData[i3].length) {
                double[] dArray = rawExpressionData[i3];
                int n2 = j;
                dArray[n2] = dArray[n2] - mean;
                double[] dArray2 = rawExpressionData[i3];
                int n3 = j++;
                dArray2[n3] = dArray2[n3] / sd;
            }
        }
        System.out.println("Will now determine the sample correlation matrix");
        ConcurrentCorrelation correlator = null;
        correlator = threads != null ? new ConcurrentCorrelation(threads) : new ConcurrentCorrelation();
        double[][] sampleCorrelationMatrix = correlator.pairwiseCorrelation(rawExpressionData);
        DoubleMatrixDataset sampleCorrelationMatrixOut = new DoubleMatrixDataset();
        sampleCorrelationMatrixOut.rawData = sampleCorrelationMatrix;
        sampleCorrelationMatrixOut.colObjects = rawExpressionDataset.rowObjects;
        sampleCorrelationMatrixOut.rowObjects = rawExpressionDataset.rowObjects;
        sampleCorrelationMatrixOut.recalculateHashMaps();
        sampleCorrelationMatrixOut.save(outdirectory + "SampleCorrelationMatrix.txt");
        rawExpressionDataset.transposeDataset();
        Pair<DoubleMatrixDataset<String, String>, DoubleMatrixDataset<String, String>> PCAResults = n.calculatePCA(rawExpressionDataset, sampleCorrelationMatrix, expressionOutputDirectory + "PCAResults", 1);
        DoubleMatrixDataset<String, String> pcScores = PCAResults.getLeft();
        pcScores.transposeDataset();
        double[] firstPC = pcScores.rawData[0];
        TextFile sampleToPCScoreCorrelationOut = new TextFile(outdirectory + "SamplePC1Correlations.txt", true);
        rawExpressionDataset.transposeDataset();
        rawExpressionData = rawExpressionDataset.getRawData();
        List individuals = rawExpressionDataset.rowObjects;
        HashSet<String> individualsPassingQC = new HashSet<String>();
        sampleToPCScoreCorrelationOut.writeln("Individual\tSpearmanCorrelationWithPC1\tPearsonCorrelationWithPC1");
        for (int i4 = 0; i4 < individuals.size(); ++i4) {
            String individual = (String)individuals.get(i4);
            double[] x = rawExpressionData[i4];
            double[] y = firstPC;
            double pearson = Correlation.correlate(x, y);
            double spearman = Correlation.rankCorrelate(x, y);
            if (Math.abs(pearson) > correlationThreshold) {
                individualsPassingQC.add(individual);
            } else {
                System.out.println(individual + "\tDid not pass QC. Correlation with PC1: " + Math.abs(pearson));
            }
            sampleToPCScoreCorrelationOut.writeln(individual + "\t" + spearman + "\t" + pearson);
        }
        sampleToPCScoreCorrelationOut.close();
        if ((double)individualsPassingQC.size() < (double)rawExpressionDataset.rowObjects.size() * 0.1) {
            System.err.println("Error: QC method includes less than 10% of your samples (" + individualsPassingQC.size() + "/" + rawExpressionDataset.rowObjects.size() + "). There may be something wrong with your data! Please contact us!");
            System.exit(-1);
        } else {
            System.out.println("QC method includes " + individualsPassingQC.size() + " out of " + rawExpressionDataset.rowObjects.size() + " samples.");
        }
        pcScores = null;
        PCAResults = null;
        individuals = null;
        String rawExpressionFileToUseForNextStep = null;
        System.out.println("Now reloading the gene expression data for the samples that passed the QC.");
        rawExpressionDataset = new DoubleMatrixDataset(rawExpressionDataFile, null, individualsPassingQC);
        rawExpressionData = rawExpressionDataset.getRawData();
        QuantileNormalization.quantilenormalize(rawExpressionData);
        Log2Transform.log2transform(rawExpressionData);
        if (mdsComponentFile != null) {
            System.out.println("Correcting for MDS components..");
            String file = n.adjustCovariates(rawExpressionDataset, expressionOutputDirectory + "ExpressionDataSamplePCQC-QNormLog2Transform", mdsComponentFile, true, 0.0);
            System.out.println("MDS component corrected file: " + file + ".txt.gz");
            rawExpressionDataset = new DoubleMatrixDataset(file + ".txt.gz");
            rawExpressionFileToUseForNextStep = file + ".txt.gz";
        } else {
            rawExpressionDataset.save(outdirectory + "ExpressionData/ExpressionDataSamplePCQC-QNormLog2Transform.txt.gz");
            rawExpressionFileToUseForNextStep = outdirectory + "ExpressionData/ExpressionDataSamplePCQC-QNormLog2Transform.txt.gz";
        }
        rawExpressionData = rawExpressionDataset.rawData;
        double[][] probeData = new double[probeCounter][rawExpressionDataset.colObjects.size()];
        probeCounter = 0;
        ArrayList cellTypeSpecificProbeDatasetRowNames = new ArrayList();
        for (int i5 = 0; i5 < probes.size(); ++i5) {
            if (!cellTypeSpecificProbeSet.contains(probes.get(i5))) continue;
            probeData[probeCounter] = rawExpressionData[i5];
            cellTypeSpecificProbeDatasetRowNames.add(probes.get(i5));
            ++probeCounter;
        }
        double[][] celltypeSpecificCorrelationMatrix = new double[probeCounter][probeCounter];
        for (int i6 = 0; i6 < probeCounter; ++i6) {
            for (int j = i6 + 1; j < probeCounter; ++j) {
                double r;
                celltypeSpecificCorrelationMatrix[i6][j] = r = Correlation.correlate(probeData[i6], probeData[j]);
                celltypeSpecificCorrelationMatrix[j][i6] = r;
            }
            celltypeSpecificCorrelationMatrix[i6][i6] = 1.0;
        }
        DoubleMatrixDataset probeCorrelationMatrixOut = new DoubleMatrixDataset();
        probeCorrelationMatrixOut.colObjects = cellTypeSpecificProbeDatasetRowNames;
        probeCorrelationMatrixOut.rowObjects = cellTypeSpecificProbeDatasetRowNames;
        probeCorrelationMatrixOut.rawData = celltypeSpecificCorrelationMatrix;
        probeCorrelationMatrixOut.recalculateHashMaps();
        probeCorrelationMatrixOut.save(outdirectory + "CelltypeSpecificProbeCorrelationMatrix.txt.gz");
        DoubleMatrixDataset<String, String> cellTypeSpecificDataset = new DoubleMatrixDataset<String, String>(probeData);
        cellTypeSpecificDataset.colObjects = rawExpressionDataset.colObjects;
        cellTypeSpecificDataset.rowObjects = cellTypeSpecificProbeDatasetRowNames;
        cellTypeSpecificDataset.save(expressionOutputDirectory + "CellTypeSpecificProbeExpression.txt.gz");
        cellTypeSpecificDataset.transposeDataset();
        PCAResults = n.calculatePCA(cellTypeSpecificDataset, celltypeSpecificCorrelationMatrix, outdirectory + "CellTypeSpecificProbePCA", 1);
        DoubleMatrixDataset<String, String> cellSpecificPCScores = PCAResults.getLeft();
        double[] pcScoresSamples = new double[cellSpecificPCScores.nrRows];
        for (int i7 = 0; i7 < cellSpecificPCScores.nrRows; ++i7) {
            pcScoresSamples[i7] = cellSpecificPCScores.rawData[i7][0];
        }
        cellTypeSpecificDataset.transposeDataset();
        int nrProbesCorrelatingPositively = 0;
        for (i = 0; i < cellTypeSpecificDataset.rawData.length; ++i) {
            double corr = ArrayMath.correlation((double[])pcScoresSamples, (double[])cellTypeSpecificDataset.rawData[i]);
            if (corr >= 0.0) {
                ++nrProbesCorrelatingPositively;
                continue;
            }
            --nrProbesCorrelatingPositively;
        }
        if (nrProbesCorrelatingPositively < 0) {
            for (i = 0; i < cellSpecificPCScores.nrRows; ++i) {
                cellSpecificPCScores.rawData[i][0] = -cellSpecificPCScores.rawData[i][0];
            }
        }
        TextFile tfOutCellSpecific = new TextFile(outdirectory + "CellTypeProxyFile.txt", true);
        tfOutCellSpecific.writeln("Sample\tCellCountProxyValue");
        for (int i8 = 0; i8 < cellSpecificPCScores.nrRows; ++i8) {
            tfOutCellSpecific.writeln((String)cellSpecificPCScores.rowObjects.get(i8) + "\t" + cellSpecificPCScores.rawData[i8][0]);
        }
        tfOutCellSpecific.close();
        if (cellCountFile != null) {
            HashMap<String, Double> cellCounts = new HashMap<String, Double>();
            TextFile cellcountfile = new TextFile(cellCountFile, false);
            cellcountfile.readLine();
            String[] elems = cellcountfile.readLineElems(TextFile.tab);
            while (elems != null) {
                if (elems.length > 1) {
                    String sample = elems[0];
                    try {
                        Double d = Double.parseDouble(elems[1]);
                        cellCounts.put(sample, d);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Error parsing number in " + cellCountFile + ": " + elems[1]);
                    }
                }
                elems = cellcountfile.readLineElems(TextFile.tab);
            }
            cellcountfile.close();
            if (cellCounts.isEmpty()) {
                System.err.println("ERROR: none of the cell counts in " + cellCountFile + " could be parsed.");
            } else {
                ArrayList<Double> x = new ArrayList<Double>();
                ArrayList y = new ArrayList();
                for (int i9 = 0; i9 < cellSpecificPCScores.rowObjects.size(); ++i9) {
                    String sample = (String)cellSpecificPCScores.rowObjects.get(i9);
                    if (!cellCounts.containsKey(sample)) continue;
                    x.add(cellSpecificPCScores.rawData[i9][0]);
                    y.add(cellCounts.get(sample));
                }
                double[] xArr = this.toPrimitiveArr(x.toArray(new Double[0]));
                double[] yArr = this.toPrimitiveArr(y.toArray(new Double[0]));
                double r = Correlation.correlate(xArr, yArr);
                for (int q = 0; q < xArr.length; ++q) {
                    System.out.println(q + "\t" + xArr[q] + "\t" + yArr[q]);
                }
                ScatterPlot plot = new ScatterPlot(500, 500, xArr, yArr, ScatterPlot.OUTPUTFORMAT.PDF, outdirectory + "plot.pdf");
                TextFile tfout = new TextFile(outdirectory + "ComparisonToCellCount.txt", true);
                System.out.println("Correlation between actual cell counts and PC1 scores: " + r + "\tr2: " + r * r + "\tn: " + xArr.length);
                tfout.writeln("Correlation between actual cell counts and PC1 scores: " + r + "\tr2: " + r * r + "\tn: " + xArr.length);
                tfout.close();
            }
        }
        System.out.println("");
        System.out.println("PLEASE NOTE:");
        System.out.println("For the next step, you can use the following file as raw expression data (--inexpraw): " + rawExpressionFileToUseForNextStep);
        System.out.println("For the cell count proxy file, please use the following file for the next step (--cellcounts): " + tfOutCellSpecific.getFileName());
        System.out.println("");
    }

    public void runInteractionAnalysis(String inExpPCCorrected, String covariateFile, String ingt, String gte, String snpprobecombinationfile, Integer nrThreads, String out, String covariateList) throws IOException, Exception {
        Object probeannot = null;
        double mafthreshold = 0.05;
        double hwepthreshold = 0.001;
        double crthreshold = 0.95;
        if (snpprobecombinationfile == null || !Gpio.exists(snpprobecombinationfile)) {
            throw new IllegalArgumentException("ERROR: please provide snpprobe combination file");
        }
        out = Gpio.formatAsDirectory(out);
        Gpio.createDir(out);
        HashSet<Pair<String, String>> snpprobeCombos = null;
        TextFile tf = new TextFile(snpprobecombinationfile, false);
        snpprobeCombos = tf.readAsPairs(0, 1);
        tf.close();
        if (snpprobeCombos.isEmpty()) {
            System.err.println("Error: no SNP-probe combinations loaded from file: " + snpprobecombinationfile);
            System.exit(-1);
        } else {
            System.out.println(snpprobeCombos.size() + " SNP-Probe combinations loaded from: " + snpprobecombinationfile);
        }
        HashSet includeTheseIndividuals = null;
        System.out.println("Now loading eQTL dataset.");
        TriTyperGeneticalGenomicsDatasetSettings settings = new TriTyperGeneticalGenomicsDatasetSettings();
        settings.cisAnalysis = true;
        settings.transAnalysis = true;
        settings.expressionLocation = inExpPCCorrected;
        settings.expressionplatform = null;
        settings.genotypeLocation = ingt;
        settings.genotypeToExpressionCoupling = gte;
        settings.logtransform = false;
        settings.quantilenormalize = false;
        settings.name = "Dataset";
        settings.probeannotation = probeannot;
        TriTyperGeneticalGenomicsDataset ds = new TriTyperGeneticalGenomicsDataset(settings);
        TriTyperGenotypeData genotypeData = ds.getGenotypeData();
        TriTyperExpressionData pcCorrectedExpressionData = ds.getExpressionData();
        HashMap<String, String> gteHash = ds.getGenotypeToExpressionCouplings();
        HashSet<String> expressionIndividualsInPCCorrectedData = new HashSet<String>();
        for (String genotypeSample : genotypeData.getIndividuals()) {
            if (!gteHash.containsKey(genotypeSample) || includeTheseIndividuals != null && !includeTheseIndividuals.contains(gteHash.get(genotypeSample))) continue;
            expressionIndividualsInPCCorrectedData.add(gteHash.get(genotypeSample));
        }
        System.out.println("Now loading covariate data file");
        Set<String> covariateHash = null;
        if (covariateList != null) {
            TextFile tfcovariatelist = new TextFile(covariateList, false);
            covariateHash = tfcovariatelist.readAsSet(0, TextFile.tab);
            tfcovariatelist.close();
        }
        DoubleMatrixDataset<String, String> covariateData = new DoubleMatrixDataset<String, String>(covariateFile, covariateHash, expressionIndividualsInPCCorrectedData);
        HashSet<Pair<String, String>> snpProbeCombinationsToTest = new HashSet<Pair<String, String>>();
        HashSet<String> snpsPassingQC = new HashSet<String>();
        HashSet<String> snpsVisited = new HashSet<String>();
        SNPLoader loader = genotypeData.createSNPLoader();
        TextFile tfOut = new TextFile(out + "eQTLsNotPassingQC.txt", true);
        for (Pair<String, String> p : snpprobeCombos) {
            String snp = p.getLeft();
            String probe = p.getRight();
            Integer snpId = genotypeData.getSnpToSNPId().get((Object)snp);
            Integer probeIdInPCCorrectedData = (Integer)pcCorrectedExpressionData.getProbeToId().get((Object)probe);
            if (snpId != -9 && probeIdInPCCorrectedData != null) {
                if (snpsPassingQC.contains(snp)) {
                    snpProbeCombinationsToTest.add(p);
                } else if (!snpsVisited.contains(snp)) {
                    SNP snpObj = genotypeData.getSNPObject(snpId);
                    loader.loadGenotypes(snpObj);
                    if (snpObj.getMAF() >= mafthreshold && snpObj.getHWEP() >= hwepthreshold && snpObj.getCR() >= crthreshold) {
                        snpsPassingQC.add(snp);
                        snpProbeCombinationsToTest.add(p);
                    } else {
                        tfOut.writeln(p.toString() + "\tSNP fails QC (MAF/HWEP/CR)\t" + snpObj.getMAF() + "\t" + snpObj.getHWEP() + "\t" + snpObj.getCR());
                    }
                    snpObj.clearGenotypes();
                }
            } else {
                tfOut.writeln(p.toString() + "\tProbe or SNP not on platform\t" + probe + " ID:(" + probeIdInPCCorrectedData + ")\t" + snp + " ID: (" + snpId + ")");
            }
            snpsVisited.add(snp);
        }
        tfOut.close();
        if (snpProbeCombinationsToTest.isEmpty()) {
            System.err.println("None of the specified SNP-probe combinations to test are present in the dataset!");
            System.exit(-1);
        } else {
            System.out.println(snpProbeCombinationsToTest.size() + " eQTLs can be tested in your dataset, using " + covariateData.nrRows + " covariates.");
        }
        String[] expInds = pcCorrectedExpressionData.getIndividuals();
        out = Gpio.formatAsDirectory(out);
        Gpio.createDir(out);
        ArrayList rowNames = new ArrayList();
        rowNames.addAll(covariateData.rowObjects);
        Correlation.correlationToZScore(covariateData.nrCols);
        System.out.println("Output matrix will be " + snpProbeCombinationsToTest.size() + "(x5) x " + rowNames.size());
        double[][] expressiondata = pcCorrectedExpressionData.getMatrix();
        int[] wgaId = ds.getExpressionToGenotypeIdArray();
        TextFile snpFile = new TextFile(out + "SNPSummaryStatistics.txt", true);
        snpFile.writeln("SNP\tChr\tChrPos\tAlleles\tMinorAllele\tMAF\tCallRate\tHWE\tGenotypesCalled");
        String[] snpsPassingQCArr = snpsPassingQC.toArray(new String[0]);
        int nrSubmitted = 0;
        if (nrThreads == null) {
            nrThreads = Runtime.getRuntime().availableProcessors();
        }
        ExecutorService threadPool = Executors.newFixedThreadPool(nrThreads);
        ExecutorCompletionService<InteractionAnalysisResults> pool = new ExecutorCompletionService<InteractionAnalysisResults>(threadPool);
        this.nrInOutput = 0;
        TextFile outputFile = new TextFile(out + "InteractionResults.txt", true);
        String outputheader = "SNP\tProbe\tCovariate\tZ-SNP\tZ-Cov\tZ-Interaction\tZ-Main\tN";
        outputFile.writeln(outputheader);
        ProgressBar pb = new ProgressBar(snpProbeCombinationsToTest.size(), "Now testing available eQTL effects for cell type specificity.");
        int maxbuffer = nrThreads * 8;
        for (int i = 0; i < snpsPassingQCArr.length; ++i) {
            String snp = snpsPassingQCArr[i];
            ArrayList<Pair<String, String>> eQTLsForSNP = new ArrayList<Pair<String, String>>();
            for (Pair pair : snpProbeCombinationsToTest) {
                if (!((String)pair.getLeft()).equals(snp)) continue;
                eQTLsForSNP.add(pair);
            }
            if (eQTLsForSNP.size() > 0) {
                Integer snpId = genotypeData.getSnpToSNPId().get((Object)snp);
                SNP sNP = genotypeData.getSNPObject(snpId);
                loader.loadGenotypes(sNP);
                if (loader.hasDosageInformation()) {
                    loader.loadDosage(sNP);
                }
                InteractionAnalysisTask t = new InteractionAnalysisTask(sNP, eQTLsForSNP, expressiondata, wgaId, expInds, covariateData, pcCorrectedExpressionData);
                pool.submit(t);
                ++nrSubmitted;
            }
            if (nrSubmitted % maxbuffer != 0) continue;
            for (int nrRetrieved = 0; nrRetrieved < nrSubmitted; ++nrRetrieved) {
                try {
                    InteractionAnalysisResults interactionAnalysisResults = (InteractionAnalysisResults)pool.take().get();
                    if (interactionAnalysisResults == null) continue;
                    this.processResult(interactionAnalysisResults, outputFile, snpFile, covariateData, pb);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            nrSubmitted = 0;
        }
        pb.close();
        if (nrSubmitted > 0) {
            for (int nrRetrieved = 0; nrRetrieved < nrSubmitted; ++nrRetrieved) {
                try {
                    InteractionAnalysisResults result = (InteractionAnalysisResults)pool.take().get();
                    if (result == null) continue;
                    this.processResult(result, outputFile, snpFile, covariateData, pb);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            nrSubmitted = 0;
        }
        threadPool.shutdown();
        snpFile.close();
        outputFile.close();
        loader.close();
        System.out.println("Done.");
    }

    private void processResult(InteractionAnalysisResults result, TextFile outputFile, TextFile snpFile, DoubleMatrixDataset<String, String> covariateData, ProgressBar pb) throws IOException {
        double[][] interactionZScoreMatrix = result.getInteractionZScoreMatrix();
        double[][] SNPZResultMatrix = result.getSNPZResultMatrix();
        double[][] covariateZResultMatrix = result.getCovariateZResultMatrix();
        double[][] maineffectZResultMatrix = result.getMaineffectZResultMatrix();
        int[][] nMatrix = result.getnMatrix();
        ArrayList<Pair<String, String>> eqtls = result.geteQTLsTested();
        for (int e = 0; e < eqtls.size(); ++e) {
            Pair<String, String> eqtl = eqtls.get(e);
            for (int c = 0; c < SNPZResultMatrix[e].length; ++c) {
                String outputForeQTL = eqtl.getLeft() + "\t" + eqtl.getRight() + "\t" + (String)covariateData.rowObjects.get(c);
                block9: for (int param = 0; param < 5; ++param) {
                    switch (param) {
                        case 0: {
                            outputForeQTL = outputForeQTL + "\t" + SNPZResultMatrix[e][c];
                            continue block9;
                        }
                        case 1: {
                            outputForeQTL = outputForeQTL + "\t" + covariateZResultMatrix[e][c];
                            continue block9;
                        }
                        case 2: {
                            outputForeQTL = outputForeQTL + "\t" + interactionZScoreMatrix[e][c];
                            continue block9;
                        }
                        case 3: {
                            outputForeQTL = outputForeQTL + "\t" + maineffectZResultMatrix[e][c];
                            continue block9;
                        }
                        case 4: {
                            outputForeQTL = outputForeQTL + "\t" + nMatrix[e][c];
                        }
                    }
                }
                outputFile.writeln(outputForeQTL);
            }
            ++this.nrInOutput;
            pb.iterate();
        }
        snpFile.writeln(result.getQcString());
    }

    private double[] toPrimitiveArr(Double[] toArray) {
        double[] arr = new double[toArray.length];
        for (int i = 0; i < toArray.length; ++i) {
            arr[i] = toArray[i];
        }
        return arr;
    }
}

