/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.gui;

import eqtlmappingpipeline.Main;
import eqtlmappingpipeline.ase.AnnotateAseWithSnpEffVcf;
import eqtlmappingpipeline.ase.Ase;
import eqtlmappingpipeline.causalinference.IVConsoleGUI;
import eqtlmappingpipeline.chromosomeyexpressionplotter.ChrYExpressionPlotConsoleGUI;
import eqtlmappingpipeline.conditionalanalysis.ConditionalAnalysisConsoleGUI;
import eqtlmappingpipeline.eQTLFoldChangeCalculator.eQTLFoldChangeCalculatorGUI;
import eqtlmappingpipeline.interactionanalysis.InteractionAnalysisConsoleGUI;
import eqtlmappingpipeline.metaqtl3.MetaQTL3ConsoleGUI;
import eqtlmappingpipeline.metaqtl4.MetaQTL4ConsoleUI;
import eqtlmappingpipeline.mixupmapper.MixupMapperConsoleGUI;
import eqtlmappingpipeline.normalization.NormalizationConsoleGUI;
import eqtlmappingpipeline.pcaoptimum.PCAOptimumConsoleGUI;
import eqtlmappingpipeline.qcpca.QCPCAConsoleGui;
import eqtlmappingpipeline.util.UtilConsoleGUI;
import eqtlmappingpipeline.util.eQTLFileCompare;
import imputationtool.ImputationTool;
import java.util.Arrays;
import umcg.genetica.io.pileup.PileupToVcf;

public class EQTLMappingPipelineConsole {
    public void main(String[] args) throws Exception {
        if (args == null || args.length == 0) {
            this.printHeader();
            this.printUsage();
            System.out.println("\nERROR: Please supply --mode\n");
            return;
        }
        String mode = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            String val = null;
            if (i + 1 < args.length) {
                val = args[i + 1];
            }
            if (arg.equals("--imputationtool")) {
                ImputationTool.main((String[])args);
            }
            if (arg.equals("--metamode")) {
                eqtlmappingpipeline.binarymeta.Main.main(args);
                System.exit(0);
            }
            if (!arg.equals("--mode")) continue;
            mode = val;
        }
        if (mode == null) {
            System.out.println("ERROR: Please supply --mode");
            this.printUsage();
        } else if (mode.equals("metaqtl")) {
            MetaQTL3ConsoleGUI metaQTL = new MetaQTL3ConsoleGUI(args);
        } else if (mode.equals("metaqtl4")) {
            MetaQTL4ConsoleUI mui = new MetaQTL4ConsoleUI(args);
        } else if (mode.equals("mixupmapper")) {
            MixupMapperConsoleGUI m = new MixupMapperConsoleGUI(args);
        } else if (mode.equals("normalize")) {
            NormalizationConsoleGUI p = new NormalizationConsoleGUI(args);
        } else if (mode.equals("compare")) {
            eQTLFileCompare r = new eQTLFileCompare(args);
        } else if (mode.equals("chryplot")) {
            ChrYExpressionPlotConsoleGUI r = new ChrYExpressionPlotConsoleGUI(args);
        } else if (mode.equals("pcaoptimum")) {
            PCAOptimumConsoleGUI g = new PCAOptimumConsoleGUI(args);
        } else if (mode.equals("foldchange")) {
            eQTLFoldChangeCalculatorGUI g = new eQTLFoldChangeCalculatorGUI(args);
        } else if (mode.equals("util")) {
            UtilConsoleGUI g = new UtilConsoleGUI(args);
        } else if (mode.equals("qcpca")) {
            QCPCAConsoleGui q = new QCPCAConsoleGui(args);
        } else if (mode.equals("conditional")) {
            ConditionalAnalysisConsoleGUI q = new ConditionalAnalysisConsoleGUI(args);
        } else if (mode.equals("iv") || mode.equals("causalinference")) {
            IVConsoleGUI q = new IVConsoleGUI(args);
        } else if (mode.equals("celltypespecific") || mode.equals("interaction")) {
            InteractionAnalysisConsoleGUI interactionAnalysisConsoleGUI = new InteractionAnalysisConsoleGUI(args);
        } else {
            if (mode.equals("ase")) {
                Ase.main(Arrays.copyOfRange(args, 2, args.length));
                return;
            }
            if (mode.equals("pileupToVcf")) {
                PileupToVcf.main(Arrays.copyOfRange(args, 2, args.length));
                return;
            }
            if (mode.equals("aseSnpEff")) {
                AnnotateAseWithSnpEffVcf.annotateAseWithSnpEffVcf(args[2], args[3], args[4]);
                return;
            }
            this.printUsage();
        }
        System.out.println("===============================================================================\n");
    }

    private void printHeader() {
        System.out.println("\n===============================================================================\nVersion: " + Main.VERSION + "\n" + "Department of Genetics, University Medical Center Groningen\n" + "www.molgenis.org/systemsgenetics\n" + "Harm-Jan Westra, Patrick Deelen, Marc Jan Bonder, Dasha Zhernakova and Lude Franke\n" + "===============================================================================\n" + "\n");
    }

    private void printUsage() {
        System.out.println("");
        System.out.print("\nCommand line options\n-------------------------------------------------------------------------------\n");
        System.out.println("       metaqtl\t\tPerform QTL mapping on the dataset\n       mixupmapper\tPerform MixUp mapping on the dataset\n       normalize\tPerform and Remove principal components from expression data\n       pcaoptimum\tDetermine optimum PCs to subtract from the data\n       conditional\tPerform conditional eQTL analysis given a set of SNPs\n       causalinference\t\tPerform instrumental variable analysis\n       celltypespecific\tCell type specific eQTL mapping\n       interaction\teQTL mapping using interaction model\n       util\tSmall utilities\n       ase\t\tAllele Specific Expression mapping\n       pileupToVcf\tConvert a pileup file to vcf for usage in ASE mapping");
        System.out.println("");
        System.out.println("More information: www.molgenis.org/systemsgenetics/QTL-mapping-pipeline");
    }
}

