/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.graphics.map;

import eqtlmappingpipeline.graphics.map.Heatmap;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;

public class MixupMapperHeatMap
extends Heatmap {
    private double[] rowEigenVector = null;
    private double[] colEigenVector = null;
    private int[] bestGenotypeMatches = null;
    private boolean familyDataLoaded;
    private HashMap<String, String> expressionToGenotypeCouplingNames;
    private String xLab;
    private String yLab;

    public MixupMapperHeatMap(int width, int height) {
        super(width, height);
    }

    public MixupMapperHeatMap(int width, int height, boolean outputPDF, String outputLoc) {
        super(width, height, outputPDF, outputLoc);
    }

    @Override
    public void plot(double[][] matrix) {
        this.graphWidth = this.desiredWidth;
        this.graphHeight = this.desiredHeight;
        this.calcDrawArea();
        int numRows = matrix.length;
        int numCols = matrix[numRows - 1].length;
        int boxWidth = (int)Math.floor((double)this.drawWidth / (double)numCols);
        int boxHeight = (int)Math.floor((double)this.drawHeight / (double)numRows);
        if (boxWidth == 0 || boxHeight == 0) {
            boxWidth = 1;
            boxHeight = 1;
        }
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < numCols; ++col) {
                double val = matrix[row][col];
                if (val > max) {
                    max = val;
                }
                if (!(val < min)) continue;
                min = val;
            }
        }
        double range = min < 0.0 && max > 0.0 ? max + Math.abs(min) : Math.abs(max - min);
        if (boxWidth == 0 || boxHeight == 0) {
            System.out.println("Cannot plot a heatmap on " + this.drawWidth + "x" + this.drawHeight + " for a matrix of " + numRows + "x" + numCols);
        } else {
            DecimalFormat df;
            Color oldColor;
            Stroke oldStroke;
            int wdth;
            int xCoord;
            int calculatedHeight;
            Double d;
            int i$;
            int len$;
            double[] arr$;
            int calculatedWidth;
            if (boxWidth > boxHeight) {
                boxWidth = boxHeight;
            } else {
                boxHeight = boxWidth;
            }
            this.setFont(boxWidth, "Verdana");
            int maxRowNameLength = 0;
            int maxColNameLength = 0;
            if (this.rowNames != null) {
                maxRowNameLength = this.getMaxStringLength(this.rowNames);
            }
            if (this.colNames != null) {
                maxColNameLength = this.getMaxStringLength(this.colNames);
            }
            int correlationBoxWidth = 100;
            if (this.rowEigenVector == null && this.colEigenVector == null) {
                correlationBoxWidth = 0;
            }
            double minRowEigenVectorValue = Double.MAX_VALUE;
            double maxRowEigenVectorValue = Double.MIN_VALUE;
            double minColEigenVectorValue = Double.MAX_VALUE;
            double maxColEigenVectorValue = Double.MIN_VALUE;
            if (this.rowEigenVector != null) {
                calculatedWidth = this.marginLeft + boxWidth * numCols + 2 * maxColNameLength + boxWidth + correlationBoxWidth + boxWidth + this.marginRight;
                arr$ = this.rowEigenVector;
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    d = arr$[i$];
                    if (d > maxRowEigenVectorValue) {
                        maxRowEigenVectorValue = d;
                    }
                    if (!(d < minRowEigenVectorValue)) continue;
                    minRowEigenVectorValue = d;
                }
            } else {
                calculatedWidth = this.marginLeft + boxWidth * numCols + 2 * maxColNameLength + boxWidth + this.marginRight;
            }
            if (this.colEigenVector != null) {
                calculatedHeight = this.marginTop + boxWidth * numRows + maxColNameLength + boxWidth + correlationBoxWidth + boxWidth + this.marginBottom;
                arr$ = this.colEigenVector;
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    d = arr$[i$];
                    if (d > maxColEigenVectorValue) {
                        maxColEigenVectorValue = d;
                    }
                    if (!(d < minColEigenVectorValue)) continue;
                    minColEigenVectorValue = d;
                }
            } else {
                calculatedHeight = this.marginTop + boxWidth * numRows + maxColNameLength + boxWidth + this.marginBottom;
            }
            this.init(calculatedWidth, calculatedHeight);
            this.setMargins(50);
            this.setFont(15, "Verdana");
            this.setColor(128, 128, 128, 255);
            this.drawText(this.graphWidth - this.marginRight + (int)Math.floor(this.marginRight / 2) + 10, (int)Math.floor(this.graphWidth / 2), -90, this.yLab);
            this.drawText((int)Math.floor(this.graphWidth / 2) - (int)Math.floor(this.getStringWidth(this.xLab)), this.graphHeight - (int)Math.floor(this.marginBottom / 2), this.xLab);
            this.drawGrid(numRows, numCols, boxWidth);
            if (!this.colSorted) {
                this.colOrder = new int[numCols];
                for (int i = 0; i < numCols; ++i) {
                    this.colOrder[i] = i;
                }
            }
            if (!this.rowSorted) {
                this.rowOrder = new int[numRows];
                for (int rownum = 0; rownum < numRows; ++rownum) {
                    this.rowOrder[rownum] = rownum;
                }
            }
            for (int row = 0; row < numRows; ++row) {
                int rowPosition = this.rowOrder[row];
                if (this.rowEigenVector != null) {
                    this.r = 0;
                    this.g = 0;
                    this.b = 0;
                    this.a = 0;
                    this.setColor(128, 128, 128, 128);
                    xCoord = this.marginLeft + boxWidth * numCols;
                    int yCoord = rowPosition * boxWidth + this.marginTop;
                    wdth = (int)Math.floor((double)correlationBoxWidth * this.rowEigenVector[row]);
                    this.g2d.fillRect(xCoord, yCoord, wdth, boxHeight);
                    oldStroke = this.g2d.getStroke();
                    oldColor = this.g2d.getColor();
                    this.g2d.setColor(new Color(200, 200, 200));
                    this.setStroke(1);
                    this.g2d.draw(new Rectangle2D.Double(xCoord, yCoord, wdth, boxHeight));
                    this.g2d.setColor(oldColor);
                    this.g2d.setStroke(oldStroke);
                    this.setColor(0, 0, 0, 255);
                    this.setFont(boxWidth, "Verdana");
                    df = new DecimalFormat("0.00");
                    this.drawText(xCoord + boxWidth, yCoord + boxWidth, df.format(this.rowEigenVector[row]));
                }
                for (int col = 0; col < numCols; ++col) {
                    int colPosition = this.colOrder[col];
                    double val = matrix[row][col];
                    this.invertGradient = false;
                    this.r = 0;
                    this.g = 0;
                    this.b = 0;
                    this.a = 0;
                    if (this.bestGenotypeMatches != null && this.bestGenotypeMatches[col] == row) {
                        this.invertGradient = true;
                        this.r = 0;
                        this.g = 0;
                        this.b = 0;
                        this.a = 0;
                    }
                    this.determineColor(val, min, range);
                    int y = rowPosition * boxWidth + this.marginTop;
                    int x = colPosition * boxWidth + this.marginLeft;
                    this.drawRect(x, y, boxWidth, boxHeight, true);
                    this.invertGradient = false;
                }
            }
            for (int col = 0; col < numCols; ++col) {
                int colPosition = this.colOrder[col];
                if (this.colEigenVector == null) continue;
                this.r = 0;
                this.g = 0;
                this.b = 0;
                this.a = 0;
                this.setColor(128, 128, 128, 128);
                xCoord = this.marginLeft + colPosition * boxWidth;
                int yCoord = this.marginTop + boxWidth * numRows;
                wdth = (int)Math.floor((double)correlationBoxWidth * this.colEigenVector[col]);
                this.g2d.fillRect(xCoord, yCoord, boxWidth, wdth);
                oldStroke = this.g2d.getStroke();
                oldColor = this.g2d.getColor();
                this.g2d.setColor(new Color(200, 200, 200));
                this.setStroke(1);
                this.g2d.draw(new Rectangle2D.Double(xCoord, yCoord, boxWidth, wdth));
                this.g2d.setColor(oldColor);
                this.g2d.setStroke(oldStroke);
                this.setColor(0, 0, 0, 255);
                this.setFont(boxWidth, "Verdana");
                df = new DecimalFormat("0.00");
                this.drawText(xCoord + boxWidth, yCoord + 3 * boxWidth, -90, df.format(this.colEigenVector[col]));
            }
            this.r = 0;
            this.g = 0;
            this.b = 0;
            this.a = 255;
            this.setColor(0, 0, 0, 255);
            this.drawLabels(numRows, numCols, boxWidth, correlationBoxWidth);
            this.invertGradient = false;
            this.r = 0;
            this.g = 0;
            this.b = 0;
            this.a = 0;
            this.drawLegend(numRows, numCols, boxWidth, min, range);
        }
    }

    @Override
    public void setAxisLabels(String xlab, String ylab) {
        this.xLab = xlab;
        this.yLab = ylab;
    }

    public void setBestGenotypeMatches(int[] matches) {
        this.bestGenotypeMatches = matches;
    }

    public void setPC1EigenVector(double[] rowEig, double[] colEig) {
        this.rowEigenVector = rowEig;
        this.colEigenVector = colEig;
    }

    public void setFamilyData(HashMap<String, String> sampleToFamilyId, HashMap<String, ArrayList<String>> familyToSampleIds, HashMap<String, String> etgNames) {
        this.familyDataLoaded = true;
        this.expressionToGenotypeCouplingNames = etgNames;
    }
}

