/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.graphics.map;

import eqtlmappingpipeline.graphics.Graphics;
import java.text.DecimalFormat;
import java.util.Arrays;

public class Heatmap
extends Graphics {
    protected int r;
    protected int g;
    protected int b;
    protected int a;
    protected boolean useAlphaGradient;
    protected boolean colSorted;
    protected boolean rowSorted;
    protected String[] rowNames;
    protected String[] colNames;
    protected int[] rowOrder;
    protected int[] colOrder;
    protected int desiredWidth;
    protected int desiredHeight;
    protected boolean invertGradient;

    public Heatmap(int width, int height) {
        this.desiredWidth = width;
        this.desiredHeight = height;
        this.r = 0;
        this.g = 0;
        this.b = 255;
        this.a = 0;
        this.useAlphaGradient = true;
        this.invertGradient = false;
        this.colSorted = false;
        this.rowSorted = false;
        this.rowNames = null;
        this.colNames = null;
        this.rowOrder = null;
        this.colOrder = null;
        this.setMargins(50);
    }

    public Heatmap(int width, int height, boolean outputPDF, String outputLoc) {
        super(width, height, outputPDF, outputLoc);
        this.desiredWidth = width;
        this.desiredHeight = height;
        this.r = 0;
        this.g = 0;
        this.b = 255;
        this.a = 0;
        this.useAlphaGradient = true;
        this.invertGradient = false;
        this.colSorted = false;
        this.rowSorted = false;
        this.rowNames = null;
        this.colNames = null;
        this.rowOrder = null;
        this.colOrder = null;
        this.setMargins(50);
    }

    public void plot(int[][] matrix) {
    }

    public void plot(double[][] matrix) {
        double val;
        int col;
        int row;
        this.graphWidth = this.desiredWidth;
        this.graphHeight = this.desiredHeight;
        this.calcDrawArea();
        int numRows = matrix.length;
        int numCols = matrix[numRows - 1].length;
        int boxWidth = (int)Math.floor((double)this.drawWidth / (double)numCols);
        int boxHeight = (int)Math.floor((double)this.drawHeight / (double)numRows);
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (row = 0; row < numRows; ++row) {
            for (col = 0; col < numCols; ++col) {
                val = matrix[row][col];
                if (val > max) {
                    max = val;
                }
                if (!(val < min)) continue;
                min = val;
            }
        }
        if (min < 0.0) {
            min = Math.abs(min);
            for (row = 0; row < numRows; ++row) {
                for (col = 0; col < numCols; ++col) {
                    val = matrix[row][col];
                    matrix[row][col] = val + min;
                }
            }
            max += min;
            min = 0.0;
        }
        double range = max;
        if (boxWidth == 0 || boxHeight == 0) {
            System.out.println("Cannot plot a heatmap on " + this.drawWidth + "x" + this.drawHeight + " for a matrix of " + numRows + "x" + numCols);
        } else {
            if (boxWidth > boxHeight) {
                boxWidth = boxHeight;
            } else {
                boxHeight = boxWidth;
            }
            this.setFont(boxWidth, "Monospaced");
            int maxRowNameLength = 0;
            int maxColNameLength = 0;
            if (this.rowNames != null) {
                maxRowNameLength = this.getMaxStringLength(this.rowNames);
            }
            if (this.colNames != null) {
                maxColNameLength = this.getMaxStringLength(this.colNames);
            }
            int calculatedWidth = this.marginLeft + boxWidth * numCols + maxColNameLength + boxWidth + this.marginRight;
            int calculatedHeight = this.marginTop + boxWidth * numRows + maxRowNameLength + boxWidth + this.marginBottom;
            this.init(calculatedWidth, calculatedHeight);
            this.setMargins(50);
            this.setFont(15, "Georgia");
            this.drawGrid(numRows, numCols, boxWidth);
            if (this.colSorted && this.rowSorted) {
                for (int row2 = 0; row2 < numRows; ++row2) {
                    int rowPosition = this.rowOrder[row2];
                    for (int col2 = 0; col2 < numCols; ++col2) {
                        int colPosition = this.colOrder[col2];
                        double val2 = matrix[row2][col2];
                        this.determineColor(val2, min, range);
                        int y = rowPosition * boxWidth + this.marginTop;
                        int x = colPosition * boxWidth + this.marginLeft;
                        this.drawRect(x, y, boxWidth, boxHeight, true);
                    }
                }
            } else if (this.colSorted && !this.rowSorted) {
                for (int row3 = 0; row3 < numRows; ++row3) {
                    int rowPosition = row3;
                    for (int col3 = 0; col3 < numCols; ++col3) {
                        int colPosition = this.colOrder[col3];
                        double val3 = matrix[row3][col3];
                        this.determineColor(val3, min, range);
                        int y = rowPosition * boxWidth + this.marginTop;
                        int x = colPosition * boxWidth + this.marginLeft;
                        this.drawRect(x, y, boxWidth, boxHeight, true);
                    }
                }
            } else if (this.rowSorted && !this.colSorted) {
                for (int row4 = 0; row4 < numRows; ++row4) {
                    int rowPosition = this.rowOrder[row4];
                    for (int col4 = 0; col4 < numCols; ++col4) {
                        int colPosition = col4;
                        double val4 = matrix[row4][col4];
                        this.determineColor(val4, min, range);
                        int y = rowPosition * boxWidth + this.marginTop;
                        int x = colPosition * boxWidth + this.marginLeft;
                        this.drawRect(x, y, boxWidth, boxHeight, true);
                    }
                }
            } else {
                for (int row5 = 0; row5 < numRows; ++row5) {
                    for (int col5 = 0; col5 < numCols; ++col5) {
                        double val5 = matrix[row5][col5];
                        this.determineColor(val5, min, range);
                        int y = row5 * boxWidth + this.marginTop;
                        int x = col5 * boxWidth + this.marginLeft;
                        this.drawRect(x, y, boxWidth, boxHeight, true);
                    }
                }
            }
            this.drawLabels(numRows, numCols, boxWidth, 0);
        }
    }

    protected void drawLabels(int numRows, int numCols, int boxWidth, int margin) {
        block9: {
            int col;
            int y;
            this.setColor(128, 128, 128, 255);
            this.setFont(boxWidth, "Verdana");
            if (this.rowNames != null) {
                int row;
                int x = numCols * boxWidth + this.marginLeft + boxWidth + margin;
                if (this.rowSorted) {
                    for (row = 0; row < numRows; ++row) {
                        int yPos = this.rowOrder[row];
                        y = yPos * boxWidth + this.marginTop + boxWidth - 2;
                        this.drawText(x, y, this.rowNames[row]);
                    }
                } else {
                    for (row = 0; row < numRows; ++row) {
                        int y2 = row * boxWidth + this.marginTop + boxWidth - 2;
                        this.drawText(x, y2, this.rowNames[row]);
                    }
                }
            }
            if (this.colNames == null) break block9;
            if (this.colSorted) {
                for (col = 0; col < numCols; ++col) {
                    int xPos = this.colOrder[col];
                    int x = xPos * boxWidth + this.marginTop + boxWidth - 1;
                    int stringWidth = this.getStringWidth(this.colNames[col]);
                    int y3 = numRows * boxWidth + boxWidth + stringWidth + this.marginTop + margin;
                    this.drawText(x, y3, -90, this.colNames[col]);
                }
            } else {
                for (col = 0; col < numCols; ++col) {
                    int x = col * boxWidth + this.marginTop + boxWidth - 1;
                    int stringWidth = this.getStringWidth(this.colNames[col]);
                    y = numRows * boxWidth + boxWidth + stringWidth + this.marginTop + margin;
                    this.drawText(x, y, -90, this.colNames[col]);
                }
            }
        }
    }

    public void drawLegend(int numRows, int numCols, int boxWidth, double min, double range) {
        double increments = range / 20.0;
        int tickheight = 3;
        double val = min - increments;
        for (int i = 0; i < 20; ++i) {
            this.determineColor(val += increments, min, range);
            int x = numCols * boxWidth + 2 * boxWidth + this.marginLeft;
            int y = this.marginTop + numRows * boxWidth + i * tickheight + boxWidth;
            this.drawRect(x, y, boxWidth, tickheight, true);
        }
        DecimalFormat df = new DecimalFormat("#.##");
        this.setFont(boxWidth, "Verdana");
        this.setColor(128, 128, 128, 255);
        int y = this.marginTop + numRows * boxWidth + 2 * boxWidth;
        int x = numCols * boxWidth + boxWidth + this.marginLeft + 2 * boxWidth;
        this.drawText(x, y, df.format(min));
        y = this.marginTop + numRows * boxWidth + 20 * tickheight + 2 * boxWidth;
        this.drawText(x, y, df.format(min + range));
    }

    public void setLabels(String[] rowLabels, String[] colLabels) {
        this.rowNames = rowLabels;
        this.colNames = colLabels;
    }

    public void sortByLabels(boolean sortRows, boolean sortCols) {
        int i;
        if (sortRows && this.rowNames != null) {
            String[] sortedRows = Arrays.copyOf(this.rowNames, this.rowNames.length);
            Arrays.sort(sortedRows, String.CASE_INSENSITIVE_ORDER);
            this.rowOrder = new int[this.rowNames.length];
            for (i = 0; i < this.rowNames.length; ++i) {
                this.rowOrder[i] = this.getIndexOfValue(sortedRows, this.rowNames[i]);
            }
            this.rowSorted = true;
        }
        if (sortCols && this.colNames != null) {
            String[] sortedCols = Arrays.copyOf(this.colNames, this.colNames.length);
            Arrays.sort(sortedCols, String.CASE_INSENSITIVE_ORDER);
            this.colOrder = new int[this.colNames.length];
            for (i = 0; i < this.colNames.length; ++i) {
                this.colOrder[i] = this.getIndexOfValue(sortedCols, this.colNames[i]);
            }
            this.colSorted = true;
        }
    }

    protected int getIndexOfValue(String[] data, String value) {
        for (int i = 0; i < data.length; ++i) {
            if (!data[i].equals(value)) continue;
            return i;
        }
        return -1;
    }

    protected void drawGrid(int numRows, int numCols, int boxWidth) {
        int x2;
        int y2;
        int x1;
        int y1;
        this.setColor(196, 196, 196, 255);
        this.setStroke(1);
        for (int row = 0; row < numRows; row += 5) {
            if (row % 25 == 0) {
                this.setColor(128, 128, 128, 255);
                this.setStroke(2);
            }
            y1 = row * boxWidth + this.marginTop;
            x1 = this.marginLeft;
            y2 = row * boxWidth + this.marginTop;
            x2 = this.graphWidth - this.marginRight + boxWidth;
            this.drawLine(x1, y1, x2, y2);
            this.setColor(196, 196, 196, 255);
            this.setStroke(1);
        }
        this.setColor(196, 196, 196, 255);
        this.setStroke(1);
        for (int col = 0; col < numCols; col += 5) {
            if (col % 25 == 0) {
                this.setColor(128, 128, 128, 255);
                this.setStroke(2);
            }
            y1 = this.marginTop;
            x1 = col * boxWidth + this.marginLeft;
            y2 = this.graphHeight - this.marginBottom + boxWidth;
            x2 = col * boxWidth + this.marginLeft;
            this.drawLine(x1, y1, x2, y2);
            this.setStroke(1);
            this.setColor(196, 196, 196, 255);
        }
    }

    public void useAlphaGradient() {
        this.useAlphaGradient &= false;
    }

    public void setBaseColor(int r, int g, int b, int a) {
    }

    public void setMaxColor(int r, int g, int b, int a) {
    }

    protected void determineColor(double value, double min, double range) {
        if (this.useAlphaGradient) {
            double perc = 0.0;
            perc = min < 0.0 ? (value + Math.abs(min)) / range : Math.abs(value - min) / range;
            int alpha = (int)Math.floor(perc * 255.0);
            if (this.invertGradient) {
                alpha = 255 - alpha;
            }
            if (alpha > 255) {
                alpha = 255;
                System.out.println("Warming: value for alpha higher than max!: " + value + "\t" + range);
            }
            if (alpha < 0) {
                alpha = 0;
                System.out.println("Warming: value for alpha lower than min!: " + value + "\t" + range);
            }
            this.setColor(this.r, this.g, this.b, alpha);
        }
    }
}

