/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.graphics.histogram;

import eqtlmappingpipeline.graphics.histogram.FrequencyDistributionHistogram;
import eqtlmappingpipeline.mixupmapper.stat.dist.Bin;
import eqtlmappingpipeline.mixupmapper.stat.dist.DiscreteDist;
import java.awt.Color;

public class MultiFrequencyDistributionHistogram
extends FrequencyDistributionHistogram {
    private boolean plotCumulative;

    public MultiFrequencyDistributionHistogram(int width, int height) {
        super(width, height);
    }

    public MultiFrequencyDistributionHistogram(int width, int height, boolean outputPDF, String outputLoc) {
        super(width, height, outputPDF, outputLoc);
    }

    public void plot(DiscreteDist[] a) {
        if (this.graphWidth > 150 && this.graphHeight > 150) {
            this.setMargins(100);
            boolean sameXRange = true;
            double prevMax = 0.0;
            double prevMin = 0.0;
            double newRangeMax = Double.MIN_VALUE;
            double newRangeMin = Double.MAX_VALUE;
            for (int i = 0; i < a.length; ++i) {
                double minX = a[i].getMin();
                double maxX = a[i].getMax();
                if (minX < newRangeMin) {
                    newRangeMin = minX;
                }
                if (maxX > newRangeMax) {
                    newRangeMax = maxX;
                }
                if (i == 0) {
                    prevMax = maxX;
                    prevMin = minX;
                    continue;
                }
                if (prevMax != maxX) {
                    if (sameXRange) {
                        // empty if block
                    }
                    sameXRange = false;
                }
                if (prevMin == minX) continue;
                if (sameXRange) {
                    // empty if block
                }
                sameXRange = false;
            }
            if (sameXRange) {
                int i;
                double yRange = Double.MIN_VALUE;
                for (i = 0; i < a.length; ++i) {
                    a[i].resetIterator();
                    Bin currentbin = a[i].getNext();
                    if (currentbin.getFrequency() > yRange) {
                        yRange = currentbin.getFrequency();
                    }
                    while (a[i].hasNext()) {
                        currentbin = a[i].getNext();
                        if (!(currentbin.getFrequency() > yRange)) continue;
                        yRange = currentbin.getFrequency();
                    }
                }
                for (i = 0; i < a.length; ++i) {
                    int numBins = a[i].getNumBins();
                    double barsize = Math.floor(this.drawWidth / numBins);
                    this.drawWidth = (int)Math.floor(barsize * (double)numBins);
                    this.determineColor(i);
                    if (this.plotCumulative) {
                        this.calcScalingDoNotRecalculateDrawArea(numBins, 1.0);
                        this.plotCumulative(a[i]);
                    } else {
                        this.calcScalingDoNotRecalculateDrawArea(numBins, yRange);
                    }
                    this.plotDist(a[i]);
                }
                this.plotYAxis(0.01, 0.0, yRange);
                double xticksevery = 0.0;
                xticksevery = prevMin > 0.0 && prevMax < 1.0 ? 0.1 : 0.5;
                this.plotXAxis(xticksevery, prevMin, prevMax);
                this.setAxisLabels("Score", "Frequency");
            }
        }
    }

    private void determineColor(int i) {
        Color[] colors = new Color[]{new Color(0, 0, 0, 128), new Color(128, 128, 128, 128), new Color(192, 192, 192, 64), new Color(0, 0, 255, 128), new Color(255, 255, 0, 128), new Color(0, 255, 255, 128), new Color(255, 0, 255, 128)};
        while (i > colors.length - 1) {
            i -= colors.length - 1;
        }
        this.setColor(colors[i]);
    }
}

