/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.graphics.histogram;

import eqtlmappingpipeline.graphics.histogram.Histogram;
import eqtlmappingpipeline.mixupmapper.stat.dist.Bin;
import eqtlmappingpipeline.mixupmapper.stat.dist.DiscreteDist;
import java.awt.Color;

public class MultiDistrubutionHistogram
extends Histogram {
    public MultiDistrubutionHistogram(int width, int height) {
        super(width, height);
    }

    public MultiDistrubutionHistogram(int width, int height, boolean outputPDF, String outputLoc) {
        super(width, height, outputPDF, outputLoc);
    }

    public void plot(DiscreteDist[] dists) {
        if (this.graphWidth > 150 && this.graphHeight > 150) {
            this.setMargins(100);
            boolean sameXRange = true;
            double prevMax = 0.0;
            double prevMin = 0.0;
            double newRangeMax = Double.MIN_VALUE;
            double newRangeMin = Double.MAX_VALUE;
            for (int i = 0; i < dists.length; ++i) {
                double minX = dists[i].getMin();
                double maxX = dists[i].getMax();
                if (minX < newRangeMin) {
                    newRangeMin = minX;
                }
                if (maxX > newRangeMax) {
                    newRangeMax = maxX;
                }
                if (i == 0) {
                    prevMax = maxX;
                    prevMin = minX;
                    continue;
                }
                if (prevMax != maxX) {
                    if (sameXRange) {
                        // empty if block
                    }
                    sameXRange = false;
                }
                if (prevMin == minX) continue;
                if (sameXRange) {
                    // empty if block
                }
                sameXRange = false;
            }
            if (sameXRange) {
                int i;
                int yRange = 0;
                double maxY = Double.MIN_VALUE;
                double minY = 0.0;
                for (i = 0; i < dists.length; ++i) {
                    dists[i].resetIterator();
                    Bin currentBin = dists[i].getNext();
                    int count = currentBin.getCount();
                    if ((double)count > maxY) {
                        maxY = count;
                    }
                    while (dists[i].hasNext()) {
                        currentBin = dists[i].getNext();
                        count = currentBin.getCount();
                        if (!((double)count > maxY)) continue;
                        maxY = count;
                    }
                }
                yRange = (int)maxY;
                for (i = 0; i < dists.length; ++i) {
                    int numBins = dists[i].getNumBins();
                    double barsize = Math.floor(this.drawWidth / numBins);
                    this.drawWidth = (int)Math.floor(barsize * (double)numBins);
                    this.calcScalingDoNotRecalculateDrawArea(numBins, yRange);
                    this.determineColor(i);
                    this.plotDist(dists[i]);
                }
                double yticksevery = 0.05;
                if (yRange < 1) {
                    yticksevery = 0.1;
                } else if (yRange < 10) {
                    yticksevery = 0.5;
                } else if (yRange < 100) {
                    yticksevery = 5.0;
                } else if (yRange < 1000) {
                    yticksevery = 50.0;
                } else if (yRange < 10000) {
                    yticksevery = 500.0;
                } else if (yRange < 1000000) {
                    yticksevery = 50000.0;
                }
                this.plotYAxis(yticksevery, 0.0, (double)yRange);
                double xticksevery = 0.0;
                xticksevery = prevMin > 0.0 && prevMax < 1.0 ? 0.1 : 0.5;
                this.plotXAxis(xticksevery, prevMin, prevMax);
                this.setAxisLabels("Score", "Count");
            }
        }
    }

    private void determineColor(int i) {
        Color[] colors = new Color[]{new Color(0, 0, 0, 128), new Color(128, 128, 128, 128), new Color(192, 192, 192, 64), new Color(0, 0, 255, 128), new Color(255, 255, 0, 128), new Color(0, 255, 255, 128), new Color(255, 0, 255, 128)};
        while (i > colors.length - 1) {
            i -= colors.length - 1;
        }
        this.setColor(colors[i]);
    }

    private void plotDist(DiscreteDist dist) {
        int barWidth = (int)Math.floor((double)this.drawWidth / (double)dist.getNumBins());
        int iterator = 0;
        dist.resetIterator();
        System.out.println(dist.getNumBins());
        while (dist.hasNext()) {
            Bin currentBin = dist.getNext();
            int count = currentBin.getCount();
            double xCoord = this.getXCoord(iterator);
            int iXCoord = (int)Math.floor(xCoord);
            int height = (int)Math.floor(this.scalingY * (double)count);
            int yCoord = this.getYCoord(0) - height;
            this.drawRect(iXCoord, yCoord, barWidth, height, true);
            ++iterator;
        }
        dist.resetIterator();
    }
}

