/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.graphics.histogram;

import eqtlmappingpipeline.graphics.Graphics;
import eqtlmappingpipeline.mixupmapper.stat.dist.Bin;
import eqtlmappingpipeline.mixupmapper.stat.dist.DiscreteDist;
import java.text.DecimalFormat;

public class Histogram
extends Graphics {
    public Histogram(int width, int height) {
        super(width, height);
    }

    public Histogram(int width, int height, boolean outputPDF, String outputLoc) {
        super(width, height, outputPDF, outputLoc);
    }

    public void plot(DiscreteDist dist) {
        this.setMargins(50);
        double maxX = dist.getMax();
        double minX = dist.getMin();
        int numBins = dist.getNumBins();
        double binInterval = dist.getBinInterval();
        int yRange = dist.getTotalNumValues();
        this.calcScaling(numBins, yRange);
        int xpos = 0;
        int ypos = 0;
        this.setStroke(3, 1);
        this.setColor(196, 196, 196, 64);
        this.plotDist(dist, xpos, ypos);
        double median = dist.getMedian();
        double medianpos = median / binInterval;
        this.setColor(196, 196, 196, 64);
        this.drawLine(this.getXCoord(medianpos), this.getYCoord(yRange / 2 - yRange / 8), this.getXCoord(medianpos), this.getYCoord(yRange / 2 + yRange / 8));
        this.setColor(196, 196, 196, 128);
        this.plotCumulative(dist, xpos, ypos);
        this.setColor(0, 0, 0, 200);
        this.plotXAxis(binInterval, numBins, minX, xpos, ypos);
        this.plotYAxis(xpos, yRange);
    }

    protected void plotDist(DiscreteDist dist, int startX, int startY) {
        int barWidth = (int)Math.floor((double)this.drawWidth / (double)dist.getNumBins());
        int iterator = 0;
        while (dist.hasNext()) {
            Bin currentBin = dist.getNext();
            int freq = currentBin.getCount();
            double xCoord = this.getXCoord(iterator);
            int iXCoord = (int)Math.floor(xCoord + (double)startX);
            int height = (int)Math.floor(this.scalingY * (double)freq);
            int yCoord = this.getYCoord(startY) - height;
            this.drawRect(iXCoord, yCoord, barWidth, height, true);
            this.drawText(iXCoord, yCoord - 20, String.valueOf(freq));
            ++iterator;
        }
        dist.resetIterator();
    }

    protected void plotCumulative(DiscreteDist dist, int startX, int startY) {
        int iterator = 0;
        dist.calcCumulative();
        int[] x = new int[dist.getNumBins()];
        int[] y = new int[dist.getNumBins()];
        int freq = 0;
        while (dist.hasNext()) {
            Bin currentBin = dist.getNext();
            double xCoord = this.getXCoord(iterator);
            int iXCoord = (int)Math.floor(xCoord + (double)startX);
            freq = currentBin.getCumulative();
            int height = (int)Math.floor(this.scalingY * (double)freq);
            int yCoord = this.getYCoord(startY) - height;
            x[iterator] = iXCoord;
            y[iterator] = yCoord;
            ++iterator;
        }
        int xCoord1 = 0;
        int xCoord2 = 0;
        int yCoord1 = 0;
        int yCoord2 = 0;
        for (int i = 0; i < x.length; ++i) {
            if (i == 0) {
                xCoord1 = this.getXCoord(0);
                yCoord1 = this.getYCoord(0);
            } else {
                xCoord1 = x[i - 1];
                yCoord1 = y[i - 1];
            }
            xCoord2 = x[i];
            yCoord2 = y[i];
            this.drawLine(xCoord1, yCoord1, xCoord2, yCoord2);
        }
        dist.resetIterator();
    }

    protected void plotYAxis(int numTicks, double minY, double maxY) {
        this.setColor(0, 0, 0, 255);
        this.setStroke(1);
        int xCoord1 = this.marginLeft;
        int xCoord2 = this.marginLeft;
        int yCoord1 = this.marginTop;
        int yCoord2 = this.graphHeight - this.marginBottom;
        this.drawLine(xCoord1, yCoord1, xCoord2, yCoord2);
        DecimalFormat dformat = new DecimalFormat("0.00");
        int tickInterval = (int)Math.floor((double)(yCoord2 - yCoord1) / (double)numTicks);
        double interval = Math.abs(maxY - minY) / (double)numTicks;
        for (int i = 0; i < numTicks; ++i) {
            int yPos = yCoord2 - tickInterval * i;
            int xPos = xCoord1 - 2;
            if (i != 0) {
                this.drawLine(xPos, yPos, xPos + 4, yPos);
            }
            double value = minY + interval * (double)i;
            int stringWidth = this.getStringWidth(dformat.format(value));
            this.drawText(xPos - stringWidth - 2, yPos, dformat.format(value));
        }
        int yPos = yCoord2 - tickInterval * numTicks;
        int xPos = xCoord1 - 2;
        this.drawLine(xPos, yPos, xPos + 4, yPos);
        double value = minY + interval * (double)numTicks;
        int stringWidth = this.getStringWidth(dformat.format(value));
        this.drawText(xPos - stringWidth - 2, yPos, dformat.format(value));
    }

    protected void plotYAxis(double ticksEvery, double minY, double maxY) {
        int stringWidth;
        double value;
        int xPos;
        int yPos;
        double prevTick;
        this.setColor(0, 0, 0, 255);
        this.setStroke(1);
        this.setFont(12, "Verdana");
        int xCoord1 = this.marginLeft;
        int xCoord2 = this.marginLeft;
        int yCoord1 = this.marginTop;
        int yCoord2 = this.graphHeight - this.marginBottom;
        this.drawLine(xCoord1, yCoord1, xCoord2, yCoord2);
        DecimalFormat dformat = new DecimalFormat("0.00");
        double yrange = Math.abs(maxY) - Math.abs(minY);
        if (minY < 0.0 && maxY > 0.0) {
            yrange = Math.abs(maxY) + Math.abs(minY);
        }
        double yscaling = (double)this.drawHeight / yrange;
        for (prevTick = 0.0; prevTick <= maxY; prevTick += ticksEvery) {
            yPos = yCoord2 - (int)Math.floor(prevTick * yscaling);
            xPos = xCoord1 - 2;
            this.drawLine(xPos, yPos, xPos + 4, yPos);
            value = prevTick;
            stringWidth = this.getStringWidth(dformat.format(value));
            this.drawText(xPos - stringWidth - 12, yPos, dformat.format(value));
        }
        for (prevTick = 0.0 - ticksEvery; prevTick >= minY; prevTick -= ticksEvery) {
            yPos = yCoord2 - (int)Math.floor(prevTick * yscaling);
            xPos = xCoord1 - 2;
            this.drawLine(xPos, yPos, xPos + 4, yPos);
            value = prevTick;
            stringWidth = this.getStringWidth(dformat.format(value));
            this.drawText(xPos - stringWidth - 12, yPos, dformat.format(value));
        }
    }

    protected void plotXAxis(double ticksEvery, double minX, double maxX) {
        int stringWidth;
        double value;
        int yPos;
        int xPos;
        double prevTick;
        this.setColor(0, 0, 0, 255);
        this.setStroke(1);
        this.setFont(12, "Verdana");
        int xCoord1 = this.marginLeft;
        int xCoord2 = this.graphWidth - this.marginRight;
        int yCoord1 = this.graphHeight - this.marginBottom;
        int yCoord2 = this.graphHeight - this.marginBottom;
        this.drawLine(xCoord1, yCoord1, xCoord2, yCoord2);
        DecimalFormat dformat = new DecimalFormat("0.00");
        double xrange = Math.abs(maxX) - Math.abs(minX);
        if (minX < 0.0 && maxX > 0.0) {
            xrange = Math.abs(maxX) + Math.abs(minX);
        }
        double xscaling = (double)this.drawWidth / xrange;
        for (prevTick = 0.0; prevTick <= maxX; prevTick += ticksEvery) {
            xPos = (int)Math.floor((double)xCoord1 + xscaling * (prevTick + Math.abs(minX)));
            yPos = yCoord1 - 2;
            this.drawLine(xPos, yPos, xPos, yPos + 4);
            value = prevTick;
            stringWidth = this.getStringWidth(dformat.format(value));
            this.drawText(xPos + 6, yPos + stringWidth + 10, -90, dformat.format(value));
        }
        for (prevTick = 0.0 - ticksEvery; prevTick >= minX; prevTick -= ticksEvery) {
            xPos = (int)Math.floor((double)xCoord1 + xscaling * (prevTick + Math.abs(minX)));
            yPos = yCoord1 - 2;
            this.drawLine(xPos, yPos, xPos, yPos + 4);
            value = prevTick;
            stringWidth = this.getStringWidth(dformat.format(value));
            this.drawText(xPos + 6, yPos + stringWidth + 10, -90, dformat.format(value));
        }
    }

    protected void plotXAxis(int numTicks, double minX, double maxX) {
        this.setColor(0, 0, 0, 255);
        this.setStroke(1);
        int xCoord1 = this.marginLeft;
        int xCoord2 = this.graphWidth - this.marginRight;
        int yCoord1 = this.graphHeight - this.marginBottom;
        int yCoord2 = this.graphHeight - this.marginBottom;
        this.drawLine(xCoord1, yCoord1, xCoord2, yCoord2);
        DecimalFormat dformat = new DecimalFormat("0.00");
        int tickInterval = (int)Math.floor((double)(xCoord2 - xCoord1) / (double)numTicks);
        double interval = Math.abs(maxX - minX) / (double)numTicks;
        for (int i = 0; i < numTicks; ++i) {
            if (i == 0) continue;
            int xPos = xCoord1 + tickInterval * i;
            int yPos = yCoord1 - 2;
            this.drawLine(xPos, yPos, xPos, yPos + 4);
            double value = minX + interval * (double)i;
            int stringWidth = this.getStringWidth(dformat.format(value));
            this.drawText(xPos, yPos + stringWidth + 5, -90, dformat.format(value));
        }
        int xPos = xCoord1 + tickInterval * numTicks;
        int yPos = yCoord1 - 2;
        this.drawLine(xPos, yPos, xPos, yPos + 4);
        double value = minX + interval * (double)numTicks;
        int stringWidth = this.getStringWidth(dformat.format(value));
        this.drawText(xPos, yPos + stringWidth + 5, -90, dformat.format(value));
    }

    protected void plotYAxis(int startX, int stopY) {
        this.drawLine(this.getXCoord(startX) - 5, this.getYCoord(0) + 5, this.getXCoord(startX) - 5, this.getYCoord(stopY) - 5);
        this.drawText(this.getXCoord(startX) - 30, this.getYCoord(0), "0");
        this.drawText(this.getXCoord(startX) - 30, this.getYCoord(stopY / 2), String.valueOf((int)Math.floor(stopY / 2)));
        this.drawText(this.getXCoord(startX) - 30, this.getYCoord(stopY), String.valueOf(stopY));
    }

    protected void plotXAxis(double binInterval, int numBins, double minX, int startX, int startY) {
        this.drawLine(this.getXCoord(startX) - 5, this.getYCoord(startY) + 5, this.drawWidth + this.marginLeft + 5, this.getYCoord(startY) + 5);
        for (int i = 0; i < numBins; ++i) {
            if (i != 0 && i != numBins - 1 && i != (int)Math.floor((double)numBins / 2.0)) continue;
            double axisValue = minX + binInterval * (double)i;
            double xCoord = this.getXCoord(i);
            int iXCoord = (int)Math.floor(xCoord + (double)startX);
            this.drawText(iXCoord, this.getYCoord(startY) + 25, String.valueOf(axisValue));
        }
    }
}

