/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.graphics.histogram;

import eqtlmappingpipeline.graphics.histogram.Histogram;
import eqtlmappingpipeline.mixupmapper.stat.dist.Bin;
import eqtlmappingpipeline.mixupmapper.stat.dist.DiscreteDist;

public class FrequencyDistributionHistogram
extends Histogram {
    public FrequencyDistributionHistogram(int width, int height) {
        super(width, height);
    }

    public FrequencyDistributionHistogram(int width, int height, boolean outputPDF, String outputLoc) {
        super(width, height, outputPDF, outputLoc);
    }

    @Override
    public void plot(DiscreteDist a) {
        if (this.graphWidth > 150 && this.graphHeight > 150) {
            this.setMargins(50);
            boolean yRange = true;
            int numBins = a.getNumBins();
            double barsize = Math.floor(this.drawWidth / numBins);
            this.drawWidth = (int)Math.floor(barsize * (double)numBins);
            this.calcScalingDoNotRecalculateDrawArea(numBins, (double)yRange);
            this.setColor(0, 0, 0, 128);
            this.plotDist(a);
            this.plotCumulative(a);
            this.plotYAxis(4, 0.0, 1.0);
            this.plotXAxis(4, a.getMin(), a.getMin());
        }
    }

    protected void plotDist(DiscreteDist dist) {
        int barWidth = (int)Math.ceil((double)this.drawWidth / (double)dist.getNumBins());
        int iterator = 0;
        dist.resetIterator();
        this.setStroke(0);
        while (dist.hasNext()) {
            Bin currentBin = dist.getNext();
            double freq = currentBin.getFrequency();
            double xCoord = this.getXCoord(iterator);
            int iXCoord = (int)Math.floor(xCoord);
            int height = (int)Math.floor(this.scalingY * freq);
            int yCoord = this.getYCoord(0) - height;
            this.drawRect(iXCoord, yCoord, barWidth, height, true);
            ++iterator;
        }
        dist.resetIterator();
    }

    protected void plotCumulative(DiscreteDist dist) {
        int iterator = 0;
        dist.resetIterator();
        int[] x = new int[dist.getNumBins()];
        int[] y = new int[dist.getNumBins()];
        double freq = 0.0;
        while (dist.hasNext()) {
            Bin currentBin = dist.getNext();
            double xCoord = this.getXCoord(iterator);
            int iXCoord = (int)Math.floor(xCoord);
            freq = currentBin.getCumulativeFrequency();
            int height = (int)Math.floor(this.scalingY * freq);
            int yCoord = this.getYCoord(0) - height;
            if (iterator == 0) {
                yCoord = this.getYCoord(0);
            }
            x[iterator] = iXCoord;
            y[iterator] = yCoord;
            ++iterator;
        }
        int xCoord1 = 0;
        int xCoord2 = 0;
        int yCoord1 = 0;
        int yCoord2 = 0;
        for (int i = 0; i < x.length; ++i) {
            if (i == 0) {
                xCoord1 = this.getXCoord(0);
                yCoord1 = this.getYCoord(0);
            } else {
                xCoord1 = x[i - 1];
                yCoord1 = y[i - 1];
            }
            xCoord2 = x[i];
            yCoord2 = y[i];
            this.drawLine(xCoord1, yCoord1, xCoord2, yCoord2);
        }
        dist.resetIterator();
    }
}

