/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.graphics.curve;

import eqtlmappingpipeline.graphics.curve.Curve;
import java.text.DecimalFormat;

public class ROCCurve
extends Curve {
    public ROCCurve(int width, int height, boolean outputPDF, String outputLoc) {
        super(width, height, outputPDF, outputLoc);
    }

    public void plot(double[] TP, double[] TN) {
        this.setMargins(50);
        this.calcScaling(1.0, 1.0);
        this.drawGrid(10);
        this.setColor(255, 0, 0, 128);
        this.setStroke(2);
        int xCoord1 = this.getXCoord(0.0);
        int xCoord2 = this.getXCoord(1.0);
        int yCoord1 = this.getYCoord(0.0);
        int yCoord2 = this.getYCoord(1.0);
        this.drawLine(xCoord1, yCoord1, xCoord2, yCoord2);
        double xInterval = 1.0 / (double)TP.length;
        this.setColor(0, 0, 0, 128);
        this.setStroke(5);
        this.drawCurve(TP, TN, 0.0125);
        this.setColor(255, 0, 0, 128);
        this.setStroke(5);
        this.drawCurve(TP, TN, 0.025);
        this.setColor(0, 255, 0, 128);
        this.setStroke(5);
        this.drawCurve(TP, TN, 0.05);
        this.setColor(0, 0, 255, 128);
        this.setStroke(5);
        this.drawCurve(TP, TN, 0.1);
        this.setColor(255, 255, 0, 128);
        this.setStroke(5);
        this.drawCurve(TP, TN, 0.25);
        this.setColor(0, 255, 255, 128);
        this.setStroke(5);
        this.drawCurve(TP, TN, 0.5);
    }

    public void drawCurve(double[] TP, double[] TN, double apriori) {
        for (int i = 0; i < TP.length - 1; ++i) {
            int xCoord1 = this.getXCoord(TN[i]);
            int xCoord2 = this.getXCoord(TN[i + 1]);
            int yCoord1 = this.getYCoord(TP[i]);
            int yCoord2 = this.getYCoord(TP[i + 1]);
            this.drawLine(xCoord1, yCoord1, xCoord2, yCoord2);
        }
    }

    public void drawGrid(int numLines) {
        int yCoord2;
        int yCoord1;
        int xCoord2;
        int xCoord1;
        DecimalFormat df = new DecimalFormat("0.00");
        for (int i = 0; i < 10; ++i) {
            if (i == 0) {
                this.setColor(0, 0, 0, 255);
                this.setStroke(2);
            } else {
                this.setColor(0, 0, 0, 128);
                this.setStroke(1);
            }
            double linelbl = (double)i / (double)numLines;
            xCoord2 = xCoord1 = this.getXCoord(linelbl);
            yCoord1 = this.getYCoord(1.0);
            yCoord2 = this.getYCoord(0.0);
            this.drawLine(xCoord1, yCoord1, xCoord2, yCoord2);
            String lineLabel = df.format(linelbl);
            int labelHeight = this.getStringHeight(lineLabel);
            int labelWidth = this.getStringWidth(lineLabel);
            if (i > 0) {
                this.drawText(xCoord1, yCoord2 + labelWidth + 5, -90, lineLabel);
            }
            xCoord1 = this.getXCoord(0.0);
            xCoord2 = this.getXCoord(1.0);
            yCoord2 = yCoord1 = this.getYCoord(linelbl);
            this.drawLine(xCoord1, yCoord1, xCoord2, yCoord2);
            if (i <= 0) continue;
            this.drawText(xCoord1 - labelWidth - 5, yCoord2, lineLabel);
        }
        this.setColor(0, 0, 0, 128);
        this.setStroke(1);
        String lineLabel = df.format(0.0);
        int labelHeight = this.getStringHeight(lineLabel);
        int labelWidth = this.getStringWidth(lineLabel);
        xCoord2 = xCoord1 = this.getXCoord(0.0);
        yCoord2 = yCoord1 = this.getYCoord(0.0);
        this.drawText(xCoord1 - labelWidth, yCoord1 + labelHeight + 10, -45, lineLabel);
        xCoord1 = this.getXCoord(0.0);
        yCoord1 = this.getYCoord(1.0);
        lineLabel = df.format(1.0);
        labelHeight = this.getStringHeight(lineLabel);
        labelWidth = this.getStringWidth(lineLabel);
        this.drawText(xCoord1 - labelWidth - 5, yCoord1 + 5, lineLabel);
        xCoord1 = this.getXCoord(1.0);
        yCoord1 = this.getYCoord(0.0);
        this.drawText(xCoord1, yCoord1 + labelWidth + 5, -90, lineLabel);
        this.setColor(0, 0, 0, 255);
        this.setStroke(2);
        xCoord2 = xCoord1 = this.getXCoord(1.0);
        yCoord1 = this.getYCoord(1.0);
        yCoord2 = this.getYCoord(0.0);
        this.drawLine(xCoord1, yCoord1, xCoord2, yCoord2);
        xCoord1 = this.getXCoord(0.0);
        xCoord2 = this.getXCoord(1.0);
        yCoord2 = yCoord1 = this.getYCoord(1.0);
        this.drawLine(xCoord1, yCoord1, xCoord2, yCoord2);
        this.setStroke(1);
    }

    public void plot(double[][] TPR, double[][] FPR, double[] AUC, double apriori) {
        this.setMargins(50);
        this.calcScaling(1.0, 1.0);
        this.drawGrid(10);
        this.setTitle("Reciever Operator Curve");
        this.setColor(255, 255, 255, 255);
        this.drawRect(this.graphWidth - 40 - 200, this.graphHeight - 40 - 200, 150, 150, true);
        this.setColor(255, 0, 0, 128);
        this.setStroke(2);
        int xCoord1 = this.getXCoord(0.0);
        int xCoord2 = this.getXCoord(1.0);
        int yCoord1 = this.getYCoord(0.0);
        int yCoord2 = this.getYCoord(1.0);
        this.drawLine(xCoord1, yCoord1, xCoord2, yCoord2);
        DecimalFormat df = new DecimalFormat("0.000");
        DecimalFormat df2 = new DecimalFormat("0.0");
        this.drawText(this.graphWidth - 20 - 200 + 20, this.graphHeight - 20 - 200 + 10, "Apriori");
        this.drawText(this.graphWidth - 20 - 200 + 20, this.graphHeight - 20 - 200 + 20, "P-value");
        this.drawText(this.graphWidth - 20 - 200 + 70, this.graphHeight - 20 - 200 + 20, "AUC");
        for (int i = TPR.length - 1; i != 1; --i) {
            if (i == 5) {
                this.setColor(0, 0, 0, 255);
            }
            if (i == 4) {
                this.setColor(0, 0, 0, 225);
            }
            if (i == 3) {
                this.setColor(0, 0, 0, 200);
            }
            if (i == 2) {
                this.setColor(0, 0, 0, 175);
            }
            if (i == 1) {
                this.setColor(0, 0, 0, 150);
            }
            this.setStroke(5);
            this.drawCurve(TPR[i], FPR[i], apriori);
            this.drawText(this.graphWidth - 20 - 200 + 20, this.graphHeight - 20 - 200 + 30 + (5 - i) * 10, df2.format(1.0 - (double)i * apriori));
            this.drawText(this.graphWidth - 20 - 200 + 70, this.graphHeight - 20 - 200 + 30 + (5 - i) * 10, df.format(AUC[i]));
        }
    }
}

