/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.graphics;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.imageio.ImageIO;
import umcg.genetica.util.Primitives;

public class ScatterPlot {
    private Color[] colors = new Color[10];

    public ScatterPlot() {
        this.colors[0] = new Color(122, 217, 76, 200);
        this.colors[1] = new Color(72, 199, 207, 200);
        this.colors[2] = new Color(194, 161, 77, 200);
        this.colors[3] = new Color(190, 190, 190, 130);
        this.colors[4] = new Color(250, 38, 207, 200);
        this.colors[5] = new Color(0, 0, 0, 200);
    }

    protected int getStringWidth(String input, Graphics2D g2d, Font font) {
        FontMetrics metrics = g2d.getFontMetrics(font);
        int adv = metrics.stringWidth(input);
        return adv;
    }

    protected int getStringHeight(String input, Graphics2D g2d, Font font) {
        FontMetrics metrics = g2d.getFontMetrics(font);
        int adv = metrics.getHeight();
        return adv;
    }

    protected Dimension stringBoundingBox(String input, Graphics2D g2d, Font font) {
        FontMetrics metrics = g2d.getFontMetrics(font);
        int hgt = metrics.getHeight();
        int adv = metrics.getHeight();
        Dimension size = new Dimension(adv + 2, hgt + 2);
        return size;
    }

    protected void drawText(int xCoord, int yCoord, int angle, String text, Graphics2D g2d, Font font) {
        AffineTransform fontAT = new AffineTransform();
        fontAT.rotate(Math.toRadians(angle));
        Font theDerivedFont = font.deriveFont(fontAT);
        g2d.setFont(theDerivedFont);
        g2d.drawString(text, xCoord, yCoord);
        g2d.setFont(font);
    }

    public void draw(double[] x, double[] y, String xDesc, String yDesc, String subtitle, String outLoc) {
        int margin;
        double maxX = Primitives.max(x);
        double minX = Primitives.min(x);
        double maxY = Primitives.max(y);
        double minY = Primitives.min(y);
        int width = 1000;
        int height = 1000;
        int x0 = margin = 100;
        int x1 = width - margin;
        int innerWidth = x1 - x0;
        int y0 = margin;
        int y1 = height - margin;
        int innerHeight = y1 - y0;
        BufferedImage bimage = new BufferedImage(width, height + 100, 1);
        Graphics2D g2d = bimage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(new Color(255, 255, 255));
        g2d.fillRect(0, 0, width, height + 100);
        g2d.setColor(new Color(128, 128, 128));
        DecimalFormat df = new DecimalFormat("#.###");
        double xAbs = Math.abs(minX) + Math.abs(maxX);
        double distOfMinToMid = Math.abs(minX) / xAbs;
        double distOfMaxToMid = Math.abs(maxX) / xAbs;
        int distToYAxis = margin + (int)Math.floor(distOfMinToMid * (double)innerWidth);
        if (minY >= 0.0) {
            g2d.drawLine(x0, y1, innerWidth + x0, y1);
            g2d.drawString(xDesc, x0, y1 - 12);
            g2d.drawString(df.format(minX), x0, y1 + 20);
            g2d.drawString(df.format(maxX), x1 - this.getStringWidth(df.format(maxX), g2d, g2d.getFont()), y1 + 20);
            g2d.drawString("0", distToYAxis + 10, y1 + 20);
            g2d.drawString(df.format(minY), distToYAxis + 10, y1 - 12);
            minY = 0.0;
        } else {
            g2d.drawLine(x0, (int)Math.floor((double)height / 2.0), innerWidth + x0, (int)Math.floor((double)height / 2.0));
            g2d.drawString(xDesc, x0, (int)Math.floor((double)height / 2.0) - 15);
            g2d.drawString(df.format(minX), x0, (int)Math.floor((double)height / 2.0) + 20);
            g2d.drawString("0", distToYAxis + 10, (int)Math.floor((double)height / 2.0) + 20);
            g2d.drawString(df.format(minY), distToYAxis + 10, (int)Math.floor((double)height / 2.0) - 20);
        }
        g2d.drawLine(distToYAxis, y0, distToYAxis, y1);
        int strWidth = this.getStringWidth(yDesc, g2d, g2d.getFont());
        this.drawText(distToYAxis - 12, y0 + strWidth, -90, yDesc, g2d, g2d.getFont());
        Font f = g2d.getFont();
        Font font = new Font("Calibri", 1, 30);
        g2d.setFont(font);
        String title = xDesc + " - " + yDesc;
        int theight = this.getStringHeight(title, g2d, font);
        g2d.drawString(title, x0, 10 + theight);
        font = new Font("Georgia", 1, 20);
        g2d.setFont(font);
        g2d.drawString(subtitle, x0, 10 + theight + 30);
        g2d.setFont(f);
        for (int i = 0; i < x.length; ++i) {
            int plotX = x0 + (int)Math.round((x[i] - minX) / (maxX - minX) * (double)innerWidth);
            int plotY = y1 - (int)Math.round((y[i] - minY) / (maxY - minY) * (double)innerHeight);
            g2d.drawRect(plotX - 6, plotY - 6, 12, 12);
            g2d.setColor(this.colors[5]);
            g2d.fillRect(plotX - 6, plotY - 6, 12, 12);
        }
        try {
            ImageIO.write((RenderedImage)bimage, "png", new File(outLoc + xDesc + "-" + yDesc + ".png"));
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public void draw(double[] x, double[] y, String xDesc, String yDesc, int[] gender, int[] group, String subtitle, String outLoc) {
        int margin;
        double maxX = Primitives.max(x);
        double minX = Primitives.min(x);
        double maxY = Primitives.max(y);
        double minY = Primitives.min(y);
        int width = 1000;
        int height = 1000;
        int x0 = margin = 100;
        int x1 = width - margin;
        int innerWidth = x1 - x0;
        int y0 = margin;
        int y1 = height - margin;
        int innerHeight = y1 - y0;
        BufferedImage bimage = new BufferedImage(width, height + 100, 1);
        Graphics2D g2d = bimage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(new Color(255, 255, 255));
        g2d.fillRect(0, 0, width, height + 100);
        g2d.setColor(new Color(128, 128, 128));
        DecimalFormat df = new DecimalFormat("#.###");
        double xAbs = Math.abs(minX) + Math.abs(maxX);
        double distOfMinToMid = Math.abs(minX) / xAbs;
        double distOfMaxToMid = Math.abs(maxX) / xAbs;
        int distToYAxis = margin + (int)Math.floor(distOfMinToMid * (double)innerWidth);
        if (minY >= 0.0) {
            minY = 0.0;
            g2d.drawLine(x0, y1, innerWidth + x0, y1);
            g2d.drawString(xDesc, x0, y1 - 12);
            g2d.drawString(df.format(minX), x0, y1 + 20);
            g2d.drawString(df.format(maxX), x1 - this.getStringWidth(df.format(maxX), g2d, g2d.getFont()), y1 + 20);
            g2d.drawString("0", distToYAxis + 10, y1 + 20);
            g2d.drawString(df.format(minY), distToYAxis + 10, y1 - 12);
        } else {
            g2d.drawLine(x0, (int)Math.floor((double)height / 2.0), innerWidth + x0, (int)Math.floor((double)height / 2.0));
            g2d.drawString(xDesc, x0, (int)Math.floor((double)height / 2.0) - 15);
            g2d.drawString(df.format(minX), x0, (int)Math.floor((double)height / 2.0) + 20);
            g2d.drawString("0", distToYAxis + 10, (int)Math.floor((double)height / 2.0) + 20);
            g2d.drawString(df.format(minY), distToYAxis + 10, (int)Math.floor((double)height / 2.0) - 20);
        }
        g2d.drawLine(distToYAxis, y0, distToYAxis, y1);
        int strWidth = this.getStringWidth(yDesc, g2d, g2d.getFont());
        this.drawText(distToYAxis - 12, y0 + strWidth, -90, yDesc, g2d, g2d.getFont());
        this.drawText(distToYAxis + 10, y0 + 10, 0, df.format(maxY), g2d, g2d.getFont());
        Font f = g2d.getFont();
        Font font = new Font("Calibri", 1, 30);
        g2d.setFont(font);
        String title = xDesc + " - " + yDesc;
        int theight = this.getStringHeight(title, g2d, font);
        g2d.drawString(title, x0, 10 + theight);
        font = new Font("Georgia", 1, 20);
        g2d.setFont(font);
        g2d.drawString(subtitle, x0, 10 + theight + 30);
        g2d.setFont(f);
        for (int i = 0; i < x.length; ++i) {
            int plotX = x0 + (int)Math.round((x[i] - minX) / (maxX - minX) * (double)innerWidth);
            int plotY = y1 - (int)Math.round((y[i] - minY) / (maxY - minY) * (double)innerHeight);
            int sex = gender[i];
            Integer g = group[i];
            if (sex != 0 && sex != 1) {
                g2d.drawRect(plotX - 6, plotY - 6, 12, 12);
                g2d.setColor(this.colors[g]);
                g2d.fillRect(plotX, plotY, 12, 12);
                continue;
            }
            if (sex == 0) {
                g2d.drawOval(plotX - 6, plotY - 6, 12, 12);
                g2d.setColor(this.colors[g]);
                g2d.fillOval(plotX - 6, plotY - 6, 12, 12);
                continue;
            }
            if (sex != 1) continue;
            Polygon poly = new Polygon();
            poly.addPoint(plotX - 6, plotY - 6);
            poly.addPoint(plotX - 6, plotY - 6 + 12);
            poly.addPoint(plotX - 6 + 12, plotY - 6);
            g2d.drawPolygon(poly);
            g2d.setColor(this.colors[g]);
            g2d.fillPolygon(poly);
        }
        try {
            ImageIO.write((RenderedImage)bimage, "png", new File(outLoc + xDesc + "-" + yDesc + ".png"));
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }
}

