/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.graphics;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class Graphics {
    private Document document;
    private boolean usePDF = false;
    protected BufferedImage bi;
    protected Graphics2D g2d;
    protected Color color;
    protected Font font;
    protected int graphHeight;
    protected int graphWidth;
    protected int drawWidth;
    protected int drawHeight;
    protected int marginTop;
    protected int marginBottom;
    protected int marginLeft;
    protected int marginRight;
    protected double scalingX;
    protected double scalingY;
    protected int FILE_TYPE;
    protected PdfContentByte cb;
    protected String outputLoc = "";
    protected PdfWriter writer;

    public Graphics() {
        this.bi = new BufferedImage(100, 100, 1);
        this.g2d = this.bi.createGraphics();
    }

    public Graphics(int width, int height, boolean outputPDF, String outputLoc) {
        this.usePDF = outputPDF;
        this.outputLoc = outputLoc;
        this.init(width, height);
    }

    public Graphics(int width, int height) {
        this.init(width, height);
    }

    protected void init(int width, int height) {
        if (this.usePDF) {
            Rectangle rectangle = new Rectangle((float)width, (float)height);
            this.document = new Document(rectangle);
            this.writer = null;
            try {
                this.writer = PdfWriter.getInstance((Document)this.document, (OutputStream)new FileOutputStream(this.outputLoc));
                this.document.open();
                this.cb = this.writer.getDirectContent();
                this.cb.saveState();
            }
            catch (Exception e) {
                System.out.println("Cannot write to PDF file!:\t" + this.outputLoc);
                System.exit(-1);
            }
            this.usePDF = true;
        }
        this.graphHeight = height;
        this.graphWidth = width;
        this.drawWidth = width;
        this.drawHeight = height;
        if (this.usePDF) {
            this.g2d = this.cb.createGraphics((float)width, (float)height);
        } else {
            this.bi = new BufferedImage(width, height, 1);
            this.g2d = this.bi.createGraphics();
        }
        this.color = new Color(255, 255, 255);
        this.font = new Font("Georgia", 0, 10);
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.g2d.setColor(this.color);
        this.g2d.fillRect(0, 0, this.graphWidth, this.graphHeight);
        this.marginTop = 0;
        this.marginBottom = 0;
        this.marginLeft = 0;
        this.marginRight = 0;
        this.scalingX = 1.0;
        this.scalingY = 1.0;
    }

    public void draw(String outputFile) {
        if (this.usePDF) {
            this.g2d.dispose();
            this.cb.restoreState();
            this.document.close();
            this.writer.close();
        } else {
            try {
                ImageIO.write((RenderedImage)this.bi, "png", new File(outputFile));
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                System.out.println(e.getStackTrace());
            }
        }
    }

    public void close() {
        this.g2d = null;
        this.document = null;
    }

    protected void setGraphBackgroundColor(int r, int g, int b) {
        this.g2d.setColor(new Color(r, g, b));
        this.g2d.fillRect(0, 0, this.graphWidth, this.graphHeight);
        this.g2d.setColor(this.color);
    }

    protected void setDrawBackgroundColor(int r, int g, int b) {
        this.g2d.setColor(new Color(r, g, b));
        this.g2d.fillRect(this.marginLeft, this.marginTop, this.drawWidth, this.drawHeight);
        this.g2d.setColor(this.color);
    }

    protected void setColor(Color newColor) {
        this.color = newColor;
        this.g2d.setColor(this.color);
    }

    protected void setColor(int r, int g, int b, int a) {
        this.color = new Color(r, g, b, a);
        this.g2d.setColor(this.color);
    }

    protected void setMargins(int margin) {
        this.marginTop = margin;
        this.marginBottom = margin;
        this.marginLeft = margin;
        this.marginRight = margin;
        this.calcDrawArea();
    }

    protected void setMargins(int top, int bottom, int left, int right) {
        this.marginTop = top;
        this.marginBottom = bottom;
        this.marginLeft = left;
        this.marginRight = right;
        this.calcDrawArea();
    }

    public void setTitle(String title) {
        if (this.marginTop > 0) {
            Font oldFont = this.font;
            Color oldColor = this.color;
            this.setColor(126, 126, 126, 255);
            this.setFont(20, 1, "Georgia");
            int height = this.getStringHeight(title);
            int ymid = (int)Math.floor(this.marginTop / 2);
            if (height <= this.marginTop) {
                this.drawText(this.marginLeft, ymid, title);
            }
            this.setFont(oldFont);
            this.setColor(oldColor);
        }
    }

    public void setSubTitle(String title) {
        if (this.marginTop > 0) {
            Font oldFont = this.font;
            Color oldColor = this.color;
            this.setColor(126, 126, 126, 255);
            this.setFont(20, 0, "Georgia");
            int titleheight = this.getStringHeight("AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz0123456789[]./';.,{}");
            this.setFont(12, 0, "Georgia");
            int height = this.getStringHeight(title);
            int ymid = this.marginTop - (int)Math.floor(height / 2);
            if (height <= this.marginTop) {
                this.drawText(this.marginLeft, ymid, title);
            }
            this.setFont(oldFont);
            this.setColor(oldColor);
        }
    }

    public void setAxisLabels(String xlab, String ylab) {
        if (this.marginBottom > 0 && this.marginRight > 0) {
            Font oldFont = this.font;
            Color oldColor = this.color;
            this.setColor(126, 126, 126, 255);
            this.setFont(15, 1, "Georgia");
            int width = (int)Math.floor((double)this.getStringWidth(xlab) / 2.0);
            int xmid = (int)Math.floor(this.drawWidth / 2);
            int xpos = this.marginLeft + xmid - width;
            int height = this.getStringHeight(xlab);
            int ymid = (int)Math.floor(this.marginBottom / 2);
            int ypos = this.graphHeight - (ymid - height);
            if (height <= this.marginBottom) {
                this.drawText(xpos, ypos, xlab);
            }
            width = (int)Math.floor((double)this.getStringWidth(ylab) / 2.0);
            ymid = (int)Math.floor(this.drawHeight / 2);
            ypos = this.marginTop + ymid + width;
            height = this.getStringHeight(ylab);
            xmid = (int)Math.floor(this.marginLeft / 2);
            xpos = xmid - (xmid - height);
            if (height <= this.marginRight) {
                this.drawText(xpos, ypos, -90, ylab);
            }
            this.setFont(oldFont);
            this.setColor(oldColor);
        }
    }

    protected void setXAxisLabelPos(int x, int y, int rotation) {
    }

    protected void setYAxisLabelPos(int x, int y, int rotation) {
    }

    protected void setAxis(boolean x, boolean y) {
    }

    protected void setFont(int fontSize, int style, String fontFace) {
        this.font = new Font(fontFace, style, fontSize);
        this.g2d.setFont(this.font);
    }

    protected void setFont(int fontSize, String fontFace) {
        this.font = new Font(fontFace, 0, fontSize);
        this.g2d.setFont(this.font);
    }

    protected void setFont(Font newFont) {
        this.font = newFont;
        this.g2d.setFont(this.font);
    }

    protected void setStroke(int width) {
        this.g2d.setStroke(new BasicStroke(width, 0, 1));
    }

    protected void setStroke(int width, int join) {
        this.g2d.setStroke(new BasicStroke(width, 0, join));
    }

    protected int calcStringWidth(String input) {
        return 0;
    }

    protected int calcStringHeight(String input) {
        return 0;
    }

    protected void drawArea(int x, int y) {
    }

    protected void drawAxis() {
    }

    protected void drawRect(int xCoord1, int yCoord1, int width, int height, boolean filled) {
        if (filled) {
            this.g2d.fillRect(xCoord1, yCoord1, width, height);
        } else {
            this.g2d.draw(new Rectangle2D.Double(xCoord1, yCoord1, width, height));
        }
    }

    protected void drawLine(int xCoord1, int yCoord1, int xCoord2, int yCoord2) {
        this.g2d.draw(new Line2D.Double(xCoord1, yCoord1, xCoord2, yCoord2));
    }

    protected void drawPolyLine(int[] x, int[] y, int width) {
        this.g2d.draw(new Polygon(x, y, x.length));
    }

    protected void drawText(int xCoord, int yCoord, String text) {
        this.g2d.drawString(text, xCoord, yCoord);
    }

    protected void drawText(int xCoord, int yCoord, int angle, String text) {
        AffineTransform fontAT = new AffineTransform();
        fontAT.rotate(Math.toRadians(angle));
        Font theDerivedFont = this.font.deriveFont(fontAT);
        this.g2d.setFont(theDerivedFont);
        this.g2d.drawString(text, xCoord, yCoord);
        this.g2d.setFont(this.font);
    }

    protected void calcDrawArea() {
        this.drawHeight = this.graphHeight - this.marginTop - this.marginBottom;
        this.drawWidth = this.graphWidth - this.marginLeft - this.marginRight;
    }

    protected void calcXScaling(double maxX) {
        this.calcDrawArea();
        this.scalingX = (double)this.drawWidth / maxX;
    }

    protected void calcYScaling(double maxY) {
        this.calcDrawArea();
        this.scalingY = (double)this.drawHeight / maxY;
    }

    protected void calcScaling(double maxX, double maxY) {
        this.calcDrawArea();
        this.scalingY = (double)this.drawWidth / maxY;
        this.scalingX = (double)this.drawHeight / maxX;
    }

    protected void calcScalingDoNotRecalculateDrawArea(double maxX, double maxY) {
        this.scalingY = (double)this.drawWidth / maxY;
        this.scalingX = (double)this.drawHeight / maxX;
    }

    protected int getXCoord(double value) {
        return this.marginLeft + (int)Math.round(this.scalingX * value);
    }

    protected int getYCoord(double value) {
        return this.drawHeight - (int)Math.round(this.scalingY * value) + this.marginTop;
    }

    protected int getXCoord(int value) {
        return this.marginLeft + (int)Math.round(this.scalingX * (double)value);
    }

    protected int getYCoord(int value) {
        return this.drawHeight - (int)Math.round(this.scalingY * (double)value) + this.marginTop;
    }

    protected void setOpacity() {
    }

    protected int getStringWidth(String input) {
        FontMetrics metrics = this.g2d.getFontMetrics(this.font);
        int adv = metrics.stringWidth(input);
        return adv;
    }

    protected int getStringHeight(String input) {
        FontMetrics metrics = this.g2d.getFontMetrics(this.font);
        int adv = metrics.getHeight();
        return adv;
    }

    protected Dimension stringBoundingBox(String input) {
        FontMetrics metrics = this.g2d.getFontMetrics(this.font);
        int hgt = metrics.getHeight();
        int adv = metrics.getHeight();
        Dimension size = new Dimension(adv + 2, hgt + 2);
        return size;
    }

    protected int getMaxStringLength(String[] data) {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < data.length; ++i) {
            if (this.getStringWidth(data[i]) <= max) continue;
            max = this.getStringWidth(data[i]);
        }
        return max;
    }
}

