/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.conditionalanalysis;

import eqtlmappingpipeline.metaqtl3.EQTLRegression;
import eqtlmappingpipeline.metaqtl3.MetaQTL3;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import umcg.genetica.containers.Pair;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.TriTyperGeneticalGenomicsDataset;

public class IterativeConditionalAnalysis
extends MetaQTL3 {
    public void run(String xmlSettingsFile, String texttoreplace, String texttoreplacewith, String ingt, String inexp, String inexpplatform, String inexpannot, String gte, String out, boolean cis, boolean trans, int perm, boolean textout, boolean binout, String snpfile, Integer threads) throws IOException, Exception {
        this.initialize(xmlSettingsFile, texttoreplace, texttoreplacewith, null, null, ingt, inexp, inexpplatform, inexpannot, gte, out, cis, trans, perm, textout, binout, snpfile, threads, null, null, null, true, true, null, null, null);
        double fdrthreshold = this.m_settings.fdrCutOff;
        this.m_settings.provideBetasAndStandardErrors = true;
        this.m_settings.provideFoldChangeData = true;
        String origOutputDir = this.m_settings.outputReportsDir;
        boolean prevIterHasSignResults = true;
        int iteration = 1;
        EQTLRegression eqr = new EQTLRegression();
        while (prevIterHasSignResults) {
            this.m_settings.outputReportsDir = origOutputDir + "/Iteration" + iteration + "/";
            this.m_settings.plotOutputDirectory = origOutputDir + "/Iteration" + iteration + "/";
            Gpio.createDir(this.m_settings.plotOutputDirectory);
            Gpio.createDir(this.m_settings.outputReportsDir);
            System.out.println("Iteration: " + iteration);
            if (iteration == 1) {
                this.mapEQTLs();
            } else {
                String efilename = origOutputDir + "/Iteration" + (iteration - 1) + "/eQTLProbesFDR" + fdrthreshold + "-ProbeLevel.txt";
                if (!Gpio.exists(efilename)) {
                    System.err.println("Previous iteration (" + (iteration - 1) + ") did not have any significant results.");
                    System.err.println("File: " + efilename + " does not exist.");
                    prevIterHasSignResults = false;
                } else {
                    TextFile tf = new TextFile(efilename, false);
                    int nrlns = tf.countLines();
                    tf.close();
                    if (nrlns == 1) {
                        System.err.println("Previous iteration (" + (iteration - 1) + ") did not have any significant results.");
                        System.err.println("File: " + efilename + " has no entries.");
                        prevIterHasSignResults = false;
                    } else {
                        System.err.println("Previous iteration (" + (iteration - 1) + ") yielded " + (nrlns - 1) + " significant results.");
                    }
                }
                if (prevIterHasSignResults) {
                    ArrayList<Pair<String, String>> toRegress = this.collectEQTLs(origOutputDir, iteration, fdrthreshold);
                    this.m_settings.tsProbesConfine = this.collectEQTLProbes(origOutputDir, iteration, fdrthreshold);
                    this.reinit();
                    eqr.regressOutEQTLEffects(toRegress, this.m_gg);
                    this.mapEQTLs();
                }
            }
            ++iteration;
        }
    }

    private void reinit() throws IOException, Exception {
        int i;
        this.m_gg = null;
        int numDatasets = this.m_settings.datasetSettings.size();
        this.m_gg = new TriTyperGeneticalGenomicsDataset[numDatasets];
        this.numAvailableInds = 0;
        for (i = 0; i < numDatasets; ++i) {
            System.out.println("- Loading dataset: " + this.m_settings.datasetSettings.get((int)i).name + "");
            System.out.println("-------------------------------------------------------------------------------\n");
            this.m_gg[i] = new TriTyperGeneticalGenomicsDataset(this.m_settings.datasetSettings.get(i));
        }
        for (i = 0; i < numDatasets; ++i) {
            if (!this.m_settings.performParametricAnalysis) {
                this.m_gg[i].getExpressionData().rankAllExpressionData(this.m_settings.equalRankForTies);
            }
            this.numAvailableInds += this.m_gg[i].getExpressionToGenotypeIdArray().length;
        }
        if (this.m_settings.regressOutEQTLEffectFileName != null && this.m_settings.regressOutEQTLEffectFileName.trim().length() > 0) {
            EQTLRegression eqr = new EQTLRegression();
            eqr.regressOutEQTLEffects(this.m_settings.regressOutEQTLEffectFileName, false, this.m_gg);
        }
        System.out.println("-------------------------------------------------------------------------------\n");
        System.out.println("");
        Arrays.sort(this.m_gg, Collections.reverseOrder());
        System.out.println("Accumulating available data...");
        System.out.print("-------------------------------------------------------------------------------\n");
        this.createSNPList();
        this.createProbeList();
        this.determineSNPProbeCombinations();
        if (this.m_workPackages == null || this.m_workPackages.length == 0) {
            System.err.println("Error: No work detected");
            System.exit(0);
        }
        if (this.m_settings.nrThreads == null) {
            this.m_settings.nrThreads = Runtime.getRuntime().availableProcessors();
        } else {
            int numProcs = Runtime.getRuntime().availableProcessors();
            if (this.m_settings.nrThreads > numProcs || this.m_settings.nrThreads < 1) {
                this.m_settings.nrThreads = numProcs;
            }
        }
        if (this.m_workPackages.length < this.m_settings.nrThreads) {
            this.m_settings.nrThreads = this.m_workPackages.length;
        }
        this.printSummary();
    }

    private ArrayList<Pair<String, String>> collectEQTLs(String origOutputDir, int currentIteration, double fdr) throws IOException {
        HashSet<Pair<String, String>> eqtls = new HashSet<Pair<String, String>>();
        for (int iteration = 1; iteration < currentIteration; ++iteration) {
            String iterationFile = origOutputDir + "/Iteration" + iteration + "/eQTLProbesFDR" + fdr + "-ProbeLevel.txt";
            TextFile tf = new TextFile(iterationFile, false);
            tf.readLineElems(TextFile.tab);
            String[] elems = tf.readLineElems(TextFile.tab);
            while (elems != null) {
                eqtls.add(new Pair<String, String>(elems[1], elems[4]));
                elems = tf.readLineElems(TextFile.tab);
            }
            tf.close();
        }
        ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>();
        pairs.addAll(eqtls);
        return pairs;
    }

    private HashSet<String> collectEQTLProbes(String origOutputDir, int currentIteration, double fdr) throws IOException {
        HashSet<String> output = new HashSet<String>();
        String iterationFile = origOutputDir + "/Iteration" + (currentIteration - 1) + "/eQTLProbesFDR" + fdr + "-ProbeLevel.txt";
        TextFile tf = new TextFile(iterationFile, false);
        tf.readLineElems(TextFile.tab);
        String[] elems = tf.readLineElems(TextFile.tab);
        while (elems != null) {
            output.add(elems[4]);
            elems = tf.readLineElems(TextFile.tab);
        }
        return output;
    }
}

