/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.conditionalanalysis;

import eqtlmappingpipeline.conditionalanalysis.ConditionalAnalysis;
import eqtlmappingpipeline.conditionalanalysis.IterativeConditionalAnalysis;

public class ConditionalAnalysisConsoleGUI {
    public ConditionalAnalysisConsoleGUI(String[] args) {
        String settingsfile = null;
        String settingstexttoreplace = null;
        String settingstexttoreplacewith = null;
        String in = null;
        String out = null;
        boolean cis = false;
        boolean trans = false;
        int perm = 1;
        String outtype = "text";
        String inexp = null;
        String inexpplatform = null;
        String inexpannot = null;
        String gte = null;
        String snpfile = null;
        Integer threads = null;
        boolean textout = false;
        boolean binout = false;
        boolean iterativeConditional = false;
        boolean skipinitialsnpmap = false;
        boolean skipalleqtlmap = false;
        boolean runSNPCentric = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            String val = null;
            if (i + 1 < args.length) {
                val = args[i + 1];
            }
            if (arg.equals("--settings")) {
                settingsfile = val;
                continue;
            }
            if (arg.equals("--replacetext")) {
                settingstexttoreplace = val;
                continue;
            }
            if (arg.equals("--replacetextwith")) {
                settingstexttoreplacewith = val;
                continue;
            }
            if (arg.equals("--in")) {
                in = val;
                continue;
            }
            if (arg.equals("--out")) {
                out = val;
                continue;
            }
            if (arg.equals("--text")) {
                textout = true;
                continue;
            }
            if (arg.equals("--binary")) {
                binout = true;
                continue;
            }
            if (arg.equals("--inexp")) {
                inexp = val;
                continue;
            }
            if (arg.equals("--inexpplatform")) {
                inexpplatform = val;
                continue;
            }
            if (arg.equals("--inexpannot")) {
                inexpannot = val;
                continue;
            }
            if (arg.equals("--gte")) {
                gte = val;
                continue;
            }
            if (arg.equals("--cis")) {
                cis = true;
                continue;
            }
            if (arg.equals("--trans")) {
                trans = true;
                continue;
            }
            if (arg.equals("--snps")) {
                snpfile = val;
                continue;
            }
            if (arg.equals("--perm")) {
                try {
                    perm = Integer.parseInt(val);
                }
                catch (NumberFormatException e) {
                    System.out.println("Please supply an integer for --perm");
                }
                continue;
            }
            if (arg.equals("--threads")) {
                try {
                    threads = Integer.parseInt(val);
                }
                catch (NumberFormatException e) {
                    System.err.println("Error --threads should be an integer");
                }
                continue;
            }
            if (arg.equals("--skip-initial-snpmapping")) {
                skipinitialsnpmap = true;
                continue;
            }
            if (arg.equals("--skip-all-eqtlmapping")) {
                skipalleqtlmap = true;
                continue;
            }
            if (arg.equals("--snpcentric")) {
                runSNPCentric = true;
                continue;
            }
            if (!arg.equals("--iterative")) continue;
            iterativeConditional = true;
        }
        try {
            if (settingsfile == null && in == null) {
                System.out.println("ERROR: Please supply settings file (--settings settings.xml) or --in and --out");
                this.printUsage();
            } else if (iterativeConditional) {
                IterativeConditionalAnalysis m = new IterativeConditionalAnalysis();
                m.run(settingsfile, settingstexttoreplace, settingstexttoreplacewith, in, inexp, inexpplatform, inexpannot, gte, out, cis, trans, perm, textout, binout, snpfile, threads);
            } else {
                ConditionalAnalysis m = new ConditionalAnalysis();
                if (skipinitialsnpmap) {
                    m.setSkipInitialSNPMapping();
                }
                if (skipalleqtlmap) {
                    m.setSkipAllEQTLMapping();
                }
                if (!binout && !textout) {
                    textout = true;
                }
                if (runSNPCentric) {
                    m.runGetResultsForAllSNPs(settingsfile, settingstexttoreplace, settingstexttoreplacewith, in, inexp, inexpplatform, inexpannot, gte, out, cis, trans, perm, textout, binout, snpfile, threads);
                } else {
                    m.run(settingsfile, settingstexttoreplace, settingstexttoreplacewith, in, inexp, inexpplatform, inexpannot, gte, out, cis, trans, perm, textout, binout, snpfile, threads);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private void printUsage() {
        System.out.print("\nMetaQTL3 - Conditional analysis\n-------------------------------------------------------------------------------\n");
        System.out.println("Perform conditional analysis on a set of SNPs");
        System.out.print("Settings file options:\n-------------------------------------------------------------------------------\n");
        System.out.println("--settings\t\tsettings.xml\tLocation of settings file\n--skip-initial-snpmapping\t\tskips initial SNP mapping, but expects SNP-Initial folder in --out. \n--skip-all-eqtlmapping\t\tskips all eQTL mapping (just summarizes and calculates LD between SNPs), but expects SNP-Initial folder in --out. \n--replacetext\t\ttext\t\tText to replace in settings file\n--replacetextwith\ttext\t\tReplace the text in the settings file, defined by --replacetext with the following text (can be empty)\n--iterative\t\tPerform conditional analysis in iterations.");
        System.out.println("");
    }
}

