/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.conditionalanalysis;

import eqtlmappingpipeline.metaqtl3.EQTLRegression;
import eqtlmappingpipeline.metaqtl3.FDR;
import eqtlmappingpipeline.metaqtl3.MetaQTL3;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import umcg.genetica.containers.Pair;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.EQTL;
import umcg.genetica.io.trityper.SNP;
import umcg.genetica.io.trityper.SNPLoader;
import umcg.genetica.io.trityper.TriTyperGeneticalGenomicsDataset;
import umcg.genetica.io.trityper.TriTyperGeneticalGenomicsDatasetSettings;
import umcg.genetica.io.trityper.eQTLTextFile;
import umcg.genetica.io.trityper.util.ChrAnnotation;
import umcg.genetica.io.trityper.util.DetermineLD;
import umcg.genetica.text.Strings;

public class ConditionalAnalysis
extends MetaQTL3 {
    private boolean skipinitialSNPMapping = false;
    private boolean skipAlleQTLMapping = false;

    public void setSkipInitialSNPMapping() {
        this.skipinitialSNPMapping = true;
    }

    public void run(String xmlSettingsFile, String texttoreplace, String texttoreplacewith, String ingt, String inexp, String inexpplatform, String inexpannot, String gte, String out, boolean cis, boolean trans, int perm, boolean textout, boolean binout, String snpfile, Integer threads) throws IOException, Exception {
        String[] gzfiles;
        this.initialize(xmlSettingsFile, texttoreplace, texttoreplacewith, null, null, ingt, inexp, inexpplatform, inexpannot, gte, out, cis, trans, perm, textout, binout, snpfile, threads, null, null, null, true, true, null, null, null);
        double fdrthreshold = this.m_settings.fdrCutOff;
        this.m_settings.provideBetasAndStandardErrors = true;
        this.m_settings.provideFoldChangeData = true;
        String origOutputDir = this.m_settings.outputReportsDir;
        this.m_settings.outputReportsDir = origOutputDir + "SNP-Initial" + Gpio.getFileSeparator();
        this.m_settings.plotOutputDirectory = origOutputDir + "SNP-Initial" + Gpio.getFileSeparator() + "plots" + Gpio.getFileSeparator();
        Gpio.createDir(this.m_settings.plotOutputDirectory);
        Gpio.createDir(this.m_settings.outputReportsDir);
        for (String filename : gzfiles = Gpio.getListOfFiles(origOutputDir, "gz")) {
            File file = new File(filename);
            String f = file.getName();
            Gpio.moveFile(filename, this.m_settings.outputReportsDir + f);
        }
        System.out.println(this.m_settings.outputReportsDir + " is used for output");
        if (!this.skipinitialSNPMapping && !this.skipAlleQTLMapping) {
            this.mapEQTLs();
        }
        HashSet<String> tsSNPConfine = this.m_settings.tsSNPsConfine;
        String fdrSignificantFile = "eQTLsFDR" + fdrthreshold + "-ProbeLevel.txt";
        String fdrAllFile = "eQTLsFDR-ProbeLevel.txt.gz";
        FDR.FDRMethod fdrType = this.m_settings.fdrType;
        if (fdrType.equals((Object)FDR.FDRMethod.GENELEVEL)) {
            fdrSignificantFile = "eQTLsFDR" + fdrthreshold + "-GeneLevel.txt";
            fdrAllFile = "eQTLsFDR-GeneLevel.txt.gz";
        } else if (fdrType.equals((Object)FDR.FDRMethod.ALL)) {
            fdrSignificantFile = "eQTLsFDR" + fdrthreshold + "-ProbeLevel.txt";
            fdrAllFile = "eQTLsFDR-ProbeLevel.txt.gz";
        } else if (fdrType.equals((Object)FDR.FDRMethod.FULL)) {
            fdrSignificantFile = "eQTLsFDR" + fdrthreshold + ".txt";
            fdrAllFile = "eQTLsFDR.txt.gz";
        }
        eQTLTextFile etf = new eQTLTextFile(origOutputDir + "/SNP-Initial/" + fdrSignificantFile, false);
        EQTL[] eQTLsSNPsUnconditional = etf.read();
        etf.close();
        System.out.println("Loaded: " + eQTLsSNPsUnconditional.length + " eQTL from " + origOutputDir + "/SNP-Initial/" + fdrSignificantFile);
        this.m_settings.outputReportsDir = origOutputDir + "/Probe-Initial/";
        this.m_settings.plotOutputDirectory = origOutputDir + "/Probe-Initial/plots/";
        Gpio.createDir(this.m_settings.outputReportsDir);
        Gpio.createDir(this.m_settings.plotOutputDirectory);
        this.m_settings.tsSNPsConfine = null;
        this.m_settings.tsProbesConfine = new HashSet();
        HashMap esnpProbePairs = new HashMap();
        HashMap<String, HashSet<String>> gsnpProbePairs = new HashMap<String, HashSet<String>>();
        for (EQTL e : eQTLsSNPsUnconditional) {
            this.m_settings.tsProbesConfine.add(e.getProbe());
            HashSet<String> probes = (HashSet<String>)gsnpProbePairs.get(e.getRsName());
            if (probes == null) {
                probes = new HashSet<String>();
            }
            probes.add(e.getProbe());
            gsnpProbePairs.put(e.getRsName(), probes);
        }
        for (TriTyperGeneticalGenomicsDatasetSettings s : this.m_settings.datasetSettings) {
            s.tsProbesConfine = this.m_settings.tsProbesConfine;
        }
        System.out.println(this.m_settings.tsProbesConfine.size() + "\tprobes have significant effects.");
        if (!this.skipAlleQTLMapping) {
            this.reinit(null);
            this.mapEQTLs();
        }
        etf = new eQTLTextFile(origOutputDir + "/Probe-Initial/" + fdrAllFile, false);
        EQTL[] eQTLsProbesUnconditional = etf.read();
        etf.close();
        HashSet<String> eSNPsConfine = new HashSet<String>();
        HashMap<String, EQTL> probeeQTLMap = new HashMap<String, EQTL>();
        for (EQTL e : eQTLsProbesUnconditional) {
            if (probeeQTLMap.containsKey(e.getProbe())) continue;
            probeeQTLMap.put(e.getProbe(), e);
            HashSet<String> probes = (HashSet<String>)esnpProbePairs.get(e.getRsName());
            if (probes == null) {
                probes = new HashSet<String>();
            }
            eSNPsConfine.add(e.getRsName());
            probes.add(e.getProbe());
            esnpProbePairs.put(e.getRsName(), probes);
        }
        this.m_settings.outputReportsDir = origOutputDir + "/SNPs-Conditional/";
        this.m_settings.plotOutputDirectory = origOutputDir + "/SNPs-Conditional/plots/";
        Gpio.createDir(this.m_settings.plotOutputDirectory);
        Gpio.createDir(this.m_settings.outputReportsDir);
        ArrayList<EQTL> eQTLsToRegress = new ArrayList<EQTL>();
        HashSet<String> probes = new HashSet<String>();
        for (EQTL e : eQTLsProbesUnconditional) {
            if (probes.contains(e.getProbe())) continue;
            eQTLsToRegress.add(e);
            probes.add(e.getProbe());
        }
        EQTL[] eQTLsToRegressArr = eQTLsToRegress.toArray(new EQTL[0]);
        this.m_settings.tsSNPsConfine = tsSNPConfine;
        this.m_settings.tsSNPProbeCombinationsConfine = gsnpProbePairs;
        this.m_settings.performEQTLAnalysisOnSNPProbeCombinationSubset = true;
        if (!this.skipAlleQTLMapping) {
            this.reinit(eQTLsToRegressArr);
            this.mapEQTLs();
        }
        this.m_settings.outputReportsDir = origOutputDir + "/Probes-Conditional/";
        this.m_settings.plotOutputDirectory = origOutputDir + "/Probes-Conditional/plots/";
        Gpio.createDir(this.m_settings.plotOutputDirectory);
        Gpio.createDir(this.m_settings.outputReportsDir);
        eQTLsToRegress = new ArrayList();
        probes = new HashSet();
        for (EQTL e : eQTLsSNPsUnconditional) {
            if (probes.contains(e.getProbe())) continue;
            eQTLsToRegress.add(e);
            probes.add(e.getProbe());
        }
        eQTLsToRegressArr = eQTLsToRegress.toArray(new EQTL[0]);
        this.m_settings.tsSNPsConfine = eSNPsConfine;
        this.m_settings.tsSNPProbeCombinationsConfine = esnpProbePairs;
        this.m_settings.performEQTLAnalysisOnSNPProbeCombinationSubset = true;
        if (!this.skipAlleQTLMapping) {
            this.reinit(eQTLsToRegressArr);
            this.mapEQTLs();
        }
        System.out.println("===============================================================================\n");
        System.out.println("Done with eQTL mappings.. Now summarizing results.");
        HashMap<Pair<String, String>, Double> fdrSNPsConditional = this.readFDRFile(origOutputDir + "/SNPs-Conditional/" + fdrAllFile);
        HashMap<Pair<String, String>, Double> fdrProbesConditional = this.readFDRFile(origOutputDir + "/Probes-Conditional/" + fdrAllFile);
        HashMap<Pair<String, String>, EQTL> snpConditionaleQTLMap = this.readEQTLFile(origOutputDir + "/SNPs-Conditional/" + fdrAllFile);
        HashMap<Pair<String, String>, EQTL> probeConditionaleQTLMap = this.readEQTLFile(origOutputDir + "/Probes-Conditional/" + fdrAllFile);
        DetermineLD ld = new DetermineLD();
        TextFile outfile = new TextFile(origOutputDir + "/ConditionalAnalysis.txt", true);
        outfile.writeln("Probe\tProbe Chr\tProbe ChrPos\tProbe HUGO\tgSNP\tgSNP Chr\tgSNP ChrPos\tgSNP alleles\tgSNP allele assessed\teSNP\teSNP Chr\teSNP ChrPos\teSNP alleles\teSNP allele assessed\tLD (rsquared, dprime)\teSNP N\tgSNP N\tgSNP-PVal\teSNP-PVal\tgSNP-PVal-Conditional\teSNP-PVal-Conditional\tgSNP-ZMeta\teSNP-ZMeta\tgSNP-ZMeta-Conditional\teSNP-ZMeta-Conditional\tgSNP-BMeta\teSNP-BMeta\tgSNP-BMeta-Conditional\teSNP-BMeta-Conditional\tgSNP-B\teSNP-B\tgSNP-B-Conditional\teSNP-B-Conditional\tgSNP-FDR\teSNP-FDR\tgSNP-FDR-Conditional\teSNP-FDR-Conditional\t");
        SNPLoader[] loaders = new SNPLoader[this.m_gg.length];
        for (int d = 0; d < this.m_gg.length; ++d) {
            loaders[d] = this.m_gg[d].getGenotypeData().createSNPLoader();
        }
        for (EQTL snpUnconditionalEQTL : eQTLsSNPsUnconditional) {
            EQTL probeunconditionaleqtl = (EQTL)probeeQTLMap.get(snpUnconditionalEQTL.getProbe());
            if (probeunconditionaleqtl == null) {
                System.err.println("ERROR: probe " + snpUnconditionalEQTL.getProbe() + " was not tested in probe-unconditional analysis.");
                System.exit(0);
            }
            Pair<String, String> gSNPPair = new Pair<String, String>(snpUnconditionalEQTL.getRsName(), snpUnconditionalEQTL.getProbe());
            Pair<String, String> eSNPPair = new Pair<String, String>(probeunconditionaleqtl.getRsName(), probeunconditionaleqtl.getProbe());
            EQTL snpconditionaleqtl = snpConditionaleQTLMap.get(gSNPPair);
            EQTL probeconditionaleqtl = probeConditionaleQTLMap.get(eSNPPair);
            String gsnp = snpUnconditionalEQTL.getRsName();
            String esnp = probeunconditionaleqtl.getRsName();
            String ldstr = "";
            String genename = snpUnconditionalEQTL.getProbeHUGO();
            if (genename == null) {
                genename = "-";
            }
            String output = snpUnconditionalEQTL.getProbe() + "\t" + ChrAnnotation.parseByte(snpUnconditionalEQTL.getProbeChr()) + "\t" + snpUnconditionalEQTL.getProbeChrPos() + "\t" + genename + "\t" + gsnp + "\t" + ChrAnnotation.parseByte(snpUnconditionalEQTL.getRsChr()) + "\t" + snpUnconditionalEQTL.getRsChrPos() + "\t" + snpUnconditionalEQTL.getAlleles() + "\t" + snpUnconditionalEQTL.getAlleleAssessed() + "\t" + esnp + "\t" + ChrAnnotation.parseByte(probeunconditionaleqtl.getRsChr()) + "\t" + probeunconditionaleqtl.getRsChrPos() + "\t" + probeunconditionaleqtl.getAlleles() + "\t" + probeunconditionaleqtl.getAlleleAssessed() + "\t";
            if (gsnp.equals(esnp)) {
                ldstr = "1";
            } else {
                String[] ldStrArr = new String[this.m_gg.length];
                for (int ds = 0; ds < this.m_gg.length; ++ds) {
                    ldStrArr[ds] = "-";
                    TriTyperGeneticalGenomicsDataset d = this.m_gg[ds];
                    Integer gsnpid = d.getGenotypeData().getSnpToSNPId().get((Object)gsnp);
                    Integer esnpid = d.getGenotypeData().getSnpToSNPId().get((Object)esnp);
                    if (gsnpid == -9 || esnpid == -9) continue;
                    SNP gsnpobj = d.getGenotypeData().getSNPObject(gsnpid);
                    SNP esnpobj = d.getGenotypeData().getSNPObject(esnpid);
                    if (gsnpobj != null && esnpobj != null) {
                        loaders[ds].loadGenotypes(gsnpobj);
                        loaders[ds].loadGenotypes(esnpobj);
                        double r2 = ld.getRSquared(gsnpobj, esnpobj, d.getGenotypeData(), 4, 1, false);
                        double dprime = ld.getRSquared(gsnpobj, esnpobj, d.getGenotypeData(), 5, 1, false);
                        ldStrArr[ds] = "" + r2 + ", " + dprime;
                    }
                    gsnpobj.clearGenotypes();
                    esnpobj.clearGenotypes();
                }
                ldstr = Strings.concat(ldStrArr, Strings.semicolon);
            }
            Integer[] samples = snpUnconditionalEQTL.getDatasetsSamples();
            int sampleSizeSNPUnconditional = 0;
            for (int i = 0; i < samples.length; ++i) {
                if (samples[i] == null) continue;
                sampleSizeSNPUnconditional += samples[i].intValue();
            }
            samples = probeunconditionaleqtl.getDatasetsSamples();
            int sampleSizeProbeUnconditional = 0;
            for (int i = 0; i < samples.length; ++i) {
                if (samples[i] == null) continue;
                sampleSizeProbeUnconditional += samples[i].intValue();
            }
            String eSNPSample = "" + sampleSizeSNPUnconditional;
            String gSNPSample = "" + sampleSizeProbeUnconditional;
            String probeunconditionalpval = "" + probeunconditionaleqtl.getPvalue();
            String snpconditionalpval = "-";
            String snpconditionalz = "-";
            String snpconditionalmetabeta = "-";
            String snpconditionalbeta = "-";
            String snpconditionalfc = "-";
            String snpconditionalfdr = "-";
            String probeconditionalpval = "-";
            String probeconditionalz = "-";
            String probeconditionalmetabeta = "-";
            String probeconditionalbeta = "-";
            String probeconditionalfc = "-";
            String probeconditionalfdr = "-";
            if (snpconditionaleqtl != null) {
                snpconditionalpval = "" + snpconditionaleqtl.getPvalue();
                snpconditionalmetabeta = snpconditionaleqtl.getMetaBeta();
                snpconditionalbeta = snpconditionaleqtl.getBeta();
                snpconditionalfc = snpconditionaleqtl.getFC();
                snpconditionalz = "" + snpconditionaleqtl.getZscore();
                snpconditionalfdr = "" + fdrSNPsConditional.get(gSNPPair);
            }
            if (probeconditionaleqtl != null) {
                probeconditionalpval = "" + probeconditionaleqtl.getPvalue();
                probeconditionalmetabeta = probeconditionaleqtl.getMetaBeta();
                probeconditionalbeta = probeconditionaleqtl.getBeta();
                probeconditionalfc = probeconditionaleqtl.getFC();
                probeconditionalz = "" + probeconditionaleqtl.getZscore();
                probeconditionalfdr = "" + fdrProbesConditional.get(eSNPPair);
            }
            output = output + ldstr + "\t" + eSNPSample + "\t" + gSNPSample + "\t" + snpUnconditionalEQTL.getPvalue() + "\t" + probeunconditionalpval + "\t" + snpconditionalpval + "\t" + probeconditionalpval + "\t" + snpUnconditionalEQTL.getZscore() + "\t" + probeunconditionaleqtl.getZscore() + "\t" + snpconditionalz + "\t" + probeconditionalz + "\t" + snpUnconditionalEQTL.getMetaBeta() + "\t" + probeunconditionaleqtl.getMetaBeta() + "\t" + snpconditionalmetabeta + "\t" + probeconditionalmetabeta + "\t" + snpUnconditionalEQTL.getBeta() + "\t" + probeunconditionaleqtl.getBeta() + "\t" + snpconditionalbeta + "\t" + probeconditionalbeta + "\t" + snpUnconditionalEQTL.getFDR() + "\t" + probeunconditionaleqtl.getFDR() + "\t" + snpconditionalfdr + "\t" + probeconditionalfdr;
            outfile.writeln(output);
            System.out.println(output);
        }
        for (int ds = 0; ds < this.m_gg.length; ++ds) {
            loaders[ds].close();
            loaders[ds].close();
        }
        outfile.close();
    }

    private void reinit(EQTL[] regressthis) throws IOException, Exception {
        int i;
        this.m_gg = null;
        int numDatasets = this.m_settings.datasetSettings.size();
        this.m_gg = new TriTyperGeneticalGenomicsDataset[numDatasets];
        this.numAvailableInds = 0;
        for (i = 0; i < numDatasets; ++i) {
            System.out.println("- Loading dataset: " + this.m_settings.datasetSettings.get((int)i).name + "");
            System.out.println("-------------------------------------------------------------------------------\n");
            this.m_gg[i] = new TriTyperGeneticalGenomicsDataset(this.m_settings.datasetSettings.get(i));
        }
        for (i = 0; i < numDatasets; ++i) {
            if (!this.m_settings.performParametricAnalysis) {
                this.m_gg[i].getExpressionData().rankAllExpressionData(this.m_settings.equalRankForTies);
            }
            this.m_gg[i].getExpressionData().calcAndSubtractMean();
            this.m_gg[i].getExpressionData().calcMeanAndVariance();
            this.numAvailableInds += this.m_gg[i].getExpressionToGenotypeIdArray().length;
        }
        if (regressthis != null && regressthis.length > 0) {
            EQTLRegression eqr = new EQTLRegression();
            eqr.regressOutEQTLEffects(regressthis, this.m_gg);
        }
        System.out.println("-------------------------------------------------------------------------------\n");
        System.out.println("");
        Arrays.sort(this.m_gg, Collections.reverseOrder());
        System.out.println("Accumulating available data...");
        System.out.print("-------------------------------------------------------------------------------\n");
        this.createSNPList();
        this.createProbeList();
        this.determineSNPProbeCombinations();
        if (this.m_workPackages == null || this.m_workPackages.length == 0) {
            System.err.println("Error: No work detected");
            System.exit(0);
        }
        if (this.m_settings.nrThreads == null) {
            this.m_settings.nrThreads = Runtime.getRuntime().availableProcessors();
        } else {
            int numProcs = Runtime.getRuntime().availableProcessors();
            if (this.m_settings.nrThreads > numProcs || this.m_settings.nrThreads < 1) {
                this.m_settings.nrThreads = numProcs;
            }
        }
        if (this.m_workPackages.length < this.m_settings.nrThreads) {
            this.m_settings.nrThreads = this.m_workPackages.length;
        }
        this.printSummary();
    }

    public void runGetResultsForAllSNPs(String xmlSettingsFile, String texttoreplace, String texttoreplacewith, String ingt, String inexp, String inexpplatform, String inexpannot, String gte, String out, boolean cis, boolean trans, int perm, boolean textout, boolean binout, String snpfile, Integer threads) throws IOException, Exception {
    }

    private eQTLObject[] readeQTLs(String eqtlfile) throws IOException {
        ArrayList<eQTLObject> output = new ArrayList<eQTLObject>();
        TextFile tf = new TextFile(eqtlfile, false);
        tf.readLine();
        String[] elems = tf.readLineElems(TextFile.tab);
        while (elems != null) {
            eQTLObject e = new eQTLObject();
            e.p = elems[0];
            e.snp = elems[1];
            e.snpchr = elems[2];
            e.snpchrpos = elems[3];
            e.probe = elems[4];
            e.probechr = elems[5];
            e.probechrpos = elems[6];
            e.alleleAssessed = elems[eQTLTextFile.ASESSEDALLELE];
            e.alleles = elems[eQTLTextFile.ASESSEDALLELE - 1];
            e.samplesize = elems[eQTLTextFile.DATASETSIZE];
            e.metab = elems[eQTLTextFile.METAB];
            e.metaz = elems[eQTLTextFile.METAZ];
            e.b = elems[eQTLTextFile.DATASETB];
            e.hugo = elems[eQTLTextFile.HUGO];
            e.FDR = elems[elems.length - 1];
            output.add(e);
            elems = tf.readLineElems(TextFile.tab);
        }
        tf.close();
        return output.toArray(new eQTLObject[0]);
    }

    private HashMap<Pair<String, String>, Double> readFDRFile(String file) throws IOException {
        HashMap<Pair<String, String>, Double> output = new HashMap<Pair<String, String>, Double>();
        TextFile tfSNPsCond = new TextFile(file, false);
        tfSNPsCond.readLine();
        String[] elems = tfSNPsCond.readLineElems(TextFile.tab);
        while (elems != null) {
            String snp = elems[1];
            String probe = elems[4];
            String fdrStr = elems[elems.length - 1];
            Double fdr = Double.parseDouble(fdrStr);
            output.put(new Pair<String, String>(snp, probe), fdr);
            elems = tfSNPsCond.readLineElems(TextFile.tab);
        }
        tfSNPsCond.close();
        return output;
    }

    private HashMap<Pair<String, String>, EQTL> readEQTLFile(String eqtlfilename) throws IOException {
        HashMap<Pair<String, String>, EQTL> output = new HashMap<Pair<String, String>, EQTL>();
        TextFile efile = new TextFile(eqtlfilename, false);
        efile.readLine();
        String[] elems = efile.readLineElems(TextFile.tab);
        while (elems != null) {
            EQTL e = new EQTL();
            e.setPvalue(Double.parseDouble(elems[0]));
            e.setRsName(elems[1]);
            e.setRsChr(ChrAnnotation.parseChr(elems[2]));
            e.setRsChrPos(Integer.parseInt(elems[3]));
            e.setProbe(elems[4]);
            e.setProbeChr(ChrAnnotation.parseChr(elems[5]));
            e.setProbeChrPos(Integer.parseInt(elems[6]));
            e.setAlleles(elems[8]);
            e.setAlleleAssessed(elems[9]);
            if (elems.length > 20 && !elems[20].equals("" + null)) {
                e.setFC(elems[20]);
            }
            e.setZscore(Double.parseDouble(elems[eQTLTextFile.METAZ]));
            e.setMetaBeta(elems[eQTLTextFile.METAB]);
            e.setBeta(elems[eQTLTextFile.DATASETB]);
            output.put(new Pair<String, String>(elems[1], elems[4]), e);
            elems = efile.readLineElems(TextFile.tab);
        }
        efile.close();
        return output;
    }

    void setSkipAllEQTLMapping() {
        this.skipAlleQTLMapping = true;
    }

    private void determineTopProbeEffect(String outdir) throws IOException {
        TextFile efile = new TextFile(outdir + "/eQTLs.txt", false);
        TextFile efileout = new TextFile(outdir + "/eQTLsTopProbeEffects.txt", true);
        efileout.writeln(efile.readLine());
        String[] elems = efile.readLineElems(TextFile.tab);
        HashSet<String> probesVisited = new HashSet<String>();
        while (elems != null) {
            if (!probesVisited.contains(elems[4])) {
                efileout.writeln(Strings.concat(elems, Strings.tab));
                probesVisited.add(elems[4]);
            }
            elems = efile.readLineElems(TextFile.tab);
        }
        efileout.close();
        efile.close();
    }

    private HashMap<String, HashSet<String>> determineSNPProbeCombos(String filename) throws IOException {
        HashMap<String, HashSet<String>> gsnpProbePairs = new HashMap<String, HashSet<String>>();
        TextFile efile = new TextFile(filename, false);
        efile.readLine();
        String[] elems = efile.readLineElems(TextFile.tab);
        while (elems != null) {
            String snp = elems[1];
            String probe = elems[4];
            HashSet<String> probes = gsnpProbePairs.get(snp);
            if (probes == null) {
                probes = new HashSet();
            }
            probes.add(probe);
            gsnpProbePairs.put(snp, probes);
            elems = efile.readLineElems(TextFile.tab);
        }
        efile.close();
        return gsnpProbePairs;
    }

    private class eQTLObject {
        String p;
        String snp;
        String probe;
        String metaz;
        String metab;
        String z;
        String b;
        String hugo;
        String samplesize;
        String alleleAssessed;
        String alleles;
        String probechr;
        String probechrpos;
        String snpchr;
        String snpchrpos;
        String FDR;

        private eQTLObject() {
        }
    }
}

