/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.chromosomeyexpressionplotter;

import JSci.maths.ArrayMath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import javax.imageio.ImageIO;
import umcg.genetica.io.trityper.TriTyperGeneticalGenomicsDataset;
import umcg.genetica.util.RankDoubleArray;

public class ChromosomeYExpressionPlot {
    public void draw(TriTyperGeneticalGenomicsDataset[] gg, String outputFile) {
        System.setProperty("java.awt.headless", "true");
        System.out.println("Generating chromosome Y expression plot:");
        int numDatasets = gg.length;
        int[] cumSamples = new int[numDatasets];
        int totalNrSamples = 0;
        for (int d = 0; d < numDatasets; ++d) {
            cumSamples[d] = totalNrSamples;
            totalNrSamples += gg[d].getTotalGGSamples();
        }
        int height = 450;
        int margin = 20;
        int width = totalNrSamples * 10 + margin * 2;
        int x0 = margin;
        int x1 = width - margin;
        int innerWidth = x1 - x0;
        int y0 = margin;
        int y1 = height - margin - 100;
        int innerHeight = y1 - y0;
        BufferedImage bi = new BufferedImage(width, height, 1);
        Graphics2D g2d = bi.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(new Color(255, 255, 255));
        g2d.fillRect(0, 0, width, height);
        for (int d = 0; d < gg.length; ++d) {
            int ind;
            int ind2;
            int nrYProbes = 0;
            ArrayList<Double> vecProbeMeans = new ArrayList<Double>();
            int probeCount = gg[d].getExpressionData().getProbes().length;
            for (int probe = 0; probe < probeCount; ++probe) {
                if (gg[d].getExpressionData().getChr()[probe] != 24) continue;
                vecProbeMeans.add(gg[d].getExpressionData().getProbeMean()[probe]);
            }
            Collections.sort(vecProbeMeans);
            double meanChrYProbeExpressionThreshold = 0.0;
            if (vecProbeMeans.size() > 0) {
                meanChrYProbeExpressionThreshold = (Double)vecProbeMeans.get((int)((double)vecProbeMeans.size() * 0.75));
            }
            for (int probe = 0; probe < probeCount; ++probe) {
                if (gg[d].getExpressionData().getChr()[probe] != 24 || !(gg[d].getExpressionData().getProbeMean()[probe] > meanChrYProbeExpressionThreshold)) continue;
                ++nrYProbes;
            }
            double[][] yProbeData = new double[gg[d].getTotalGGSamples()][nrYProbes];
            nrYProbes = 0;
            double[][] rawData = gg[d].getExpressionData().getMatrix();
            for (int probe = 0; probe < probeCount; ++probe) {
                if (gg[d].getExpressionData().getChr()[probe] != 24 || !(gg[d].getExpressionData().getProbeMean()[probe] > meanChrYProbeExpressionThreshold)) continue;
                for (ind2 = 0; ind2 < gg[d].getTotalGGSamples(); ++ind2) {
                    yProbeData[ind2][nrYProbes] = rawData[probe][ind2];
                }
                ++nrYProbes;
            }
            System.out.println(" - Dataset:\t" + gg[d].getSettings().name + "\tNumber of probes mapping to chromosome Y:\t" + nrYProbes);
            if (nrYProbes <= 0) continue;
            double[] meanArray = new double[gg[d].getTotalGGSamples()];
            for (ind2 = 0; ind2 < gg[d].getTotalGGSamples(); ++ind2) {
                meanArray[ind2] = ArrayMath.mean((double[])yProbeData[ind2]);
            }
            double min = ArrayMath.min((double[])meanArray);
            double max = ArrayMath.max((double[])meanArray);
            RankDoubleArray rda = new RankDoubleArray();
            double[] meanArrayRanked = rda.rank(meanArray);
            int[] intIndex = new int[gg[d].getTotalGGSamples()];
            for (ind = 0; ind < gg[d].getTotalGGSamples(); ++ind) {
                intIndex[ind] = (int)meanArrayRanked[ind];
            }
            for (ind = 0; ind < gg[d].getTotalGGSamples(); ++ind) {
                int indIncrement = 0;
                for (int ind22 = ind + 1; ind22 < gg[d].getTotalGGSamples(); ++ind22) {
                    if (intIndex[ind] != intIndex[ind22]) continue;
                    int n = ind22;
                    intIndex[n] = intIndex[n] + ++indIncrement;
                }
            }
            float[] dash = new float[]{3.0f};
            BasicStroke strokeDashed = new BasicStroke(3.0f, 0, 0, 3.0f, dash, 0.0f);
            g2d.setFont(new Font(g2d.getFont().getFontName(), 0, 8));
            int[] ggindWGA = gg[d].getExpressionToGenotypeIdArray();
            for (int ind3 = 0; ind3 < gg[d].getTotalGGSamples(); ++ind3) {
                int indWGA = ggindWGA[ind3];
                g2d.setColor(new Color(0, 0, 255));
                g2d.setStroke(strokeDashed);
                String sex = "Male";
                if (gg[d].getGenotypeData().getIsFemale()[indWGA].booleanValue()) {
                    sex = "Female";
                    g2d.setStroke(new BasicStroke(3.0f));
                    g2d.setColor(new Color(255, 0, 0));
                }
                int plotX = x0 + intIndex[ind3] * 10 + cumSamples[d] * 10;
                int plotY = y1 - (int)((double)innerHeight * (meanArray[ind3] - min) / (max - min));
                g2d.drawLine(plotX, y1 + 1, plotX, plotY);
                g2d.setColor(new Color(90, 90, 90));
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.drawLine(plotX, y1 + 2, plotX, y1 + 5);
                g2d.setColor(new Color(0, 0, 0));
                g2d.setFont(new Font(g2d.getFont().getFontName(), 0, 8));
                String sampleName = gg[d].getGenotypeData().getIndividuals()[indWGA];
                g2d.translate(plotX + 3, height - 5);
                g2d.rotate(-1.5707963267948966);
                int sampleNamePixelWidth = this.getPixelWidthOfString(sampleName, g2d.getFont());
                g2d.drawString(sampleName, 100 - sampleNamePixelWidth, 0);
                g2d.rotate(1.5707963267948966);
                g2d.translate(-(plotX + 3), -(height - 5));
            }
            int plotX = x0 + cumSamples[d] * 10 + 10;
            g2d.setColor(new Color(0, 0, 0));
            g2d.setFont(new Font(g2d.getFont().getFontName(), 1, 12));
            g2d.drawString(gg[d].getSettings().name, plotX, y0 + 4 + 3);
            g2d.setFont(new Font(g2d.getFont().getFontName(), 1, 8));
            g2d.setStroke(new BasicStroke(3.0f));
            g2d.setColor(new Color(255, 0, 0));
            g2d.drawLine(plotX, y0 + 20, plotX + 20, y0 + 20);
            g2d.setColor(new Color(0, 0, 0));
            g2d.drawString("Female average chromosome Y probe expression", plotX + 25, y0 + 20 + 3);
            g2d.setColor(new Color(0, 0, 255));
            g2d.setStroke(strokeDashed);
            g2d.drawLine(plotX, y0 + 35, plotX + 20, y0 + 35);
            g2d.setColor(new Color(0, 0, 0));
            g2d.drawString("Male average chromosome Y probe expression", plotX + 25, y0 + 35 + 3);
            g2d.setColor(new Color(90, 90, 90));
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.drawLine(x0 + cumSamples[d] * 10 - 3, y1 + 2, x0 + (cumSamples[d] + gg[d].getTotalGGSamples()) * 10 - 3, y1 + 2);
            g2d.drawLine(x0 + cumSamples[d] * 10 - 3, y1 + 2, x0 + cumSamples[d] * 10 - 3, y0);
        }
        try {
            ImageIO.write((RenderedImage)bi, "png", new File(outputFile));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println(e.getStackTrace());
        }
        System.out.println("");
    }

    public int getPixelWidthOfString(String text, Font font) {
        Graphics2D g2d = new BufferedImage(1, 1, 2).createGraphics();
        TextLayout tL = new TextLayout(text, font, g2d.getFontRenderContext());
        return (int)tL.getBounds().getWidth();
    }
}

