/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.causalinference;

import JSci.maths.ArrayMath;
import eqtlmappingpipeline.causalinference.IVAnalysis;
import java.io.IOException;
import java.util.Iterator;
import umcg.genetica.console.ProgressBar;
import umcg.genetica.containers.Triple;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.SNP;
import umcg.genetica.io.trityper.SNPLoader;
import umcg.genetica.io.trityper.util.BaseAnnot;
import umcg.genetica.math.stats.Descriptives;
import umcg.genetica.math.stats.Regression;

public class Mediation
extends IVAnalysis {
    public Mediation(String xmlSettingsFile, String ingt, String inexp, String inexpplatform, String inexpannot, String gte, String out, int perm, String snpProbeCombinationList, boolean parametric) throws IOException, Exception {
        super(xmlSettingsFile, ingt, inexp, inexpplatform, inexpannot, gte, out, perm, snpProbeCombinationList, parametric);
    }

    @Override
    public void run() throws IOException {
        for (int d = 0; d < this.m_gg.length; ++d) {
            SNPLoader snpLoader = this.m_gg[d].getGenotypeData().createSNPLoader();
            int[] indWGA = this.m_gg[d].getExpressionToGenotypeIdArray();
            for (int perm = 0; perm < this.m_settings.nrPermutationsFDR + 1; ++perm) {
                String outfile = null;
                if (perm == 0) {
                    outfile = this.outDir + this.m_gg[d].getSettings().name + "_IVAnalysis-RealData.txt";
                } else {
                    outfile = this.outDir + this.m_gg[d].getSettings().name + "_IVAnalysis-PermutationRound-" + perm + ".txt";
                    this.m_gg[d].permuteSampleLables(this.m_settings.randomNumberGenerator);
                }
                TextFile out = new TextFile(outfile, true);
                Iterator it = this.snpProbeCombos.iterator();
                Triple next = (Triple)it.next();
                ProgressBar pb = new ProgressBar(this.snpProbeCombos.size(), "Running Mediation Analysis - Permutation " + perm);
                out.writeln("SNP\tSNP Chr\tSNP ChrPos\tAlleles\tDirectionAllele\tN\tCisArrayAddress\tCisProbe Chr\tCisProbe ChrPos\tCisGeneName\tTransArrayAddress\tTransProbe Chr\tTransProbe ChrPos\tTransGeneName\tCisTrans-Correlation\tCis-eQTL-Beta\tCis-eQTL-SE\tCisTrans-Beta\tCisTrans-SE\tTrans-eQTL-Beta\tTrans-eQTL-SE\tCisTrans-Residual-Correlation\tCisTrans-Residual-Beta\tCisTrans-Residual-SE\tTrans-eQTL-Residual-Beta\tTrans-eQTL-Residual-SE\tBeta-Ratio");
                while (next != null) {
                    String snp = (String)next.getLeft();
                    String cisprobe = (String)next.getMiddle();
                    String transprobe = (String)next.getRight();
                    Integer snpId = this.m_gg[d].getGenotypeData().getSnpToSNPId().get((Object)snp);
                    Integer cisProbeId = (Integer)this.m_gg[d].getExpressionData().getProbeToId().get((Object)cisprobe);
                    Integer transProbeId = (Integer)this.m_gg[d].getExpressionData().getProbeToId().get((Object)transprobe);
                    if (snpId != -9 && cisProbeId != null && transProbeId != null) {
                        SNP snpObj = this.m_gg[d].getGenotypeData().getSNPObject(snpId);
                        snpLoader.loadGenotypes(snpObj);
                        if (snpLoader.hasDosageInformation()) {
                            snpLoader.loadDosage(snpObj);
                        }
                        double[] origCisVals = this.m_gg[d].getExpressionData().getMatrix()[cisProbeId];
                        double[] origTransVals = this.m_gg[d].getExpressionData().getMatrix()[transProbeId];
                        int calledGenotypes = 0;
                        for (int i = 0; i < this.m_gg[d].getExpressionData().getIndividuals().length; ++i) {
                            int genotypeId = indWGA[i];
                            short gt = snpObj.getGenotypes()[genotypeId];
                            if (genotypeId <= -1 || gt <= -1) continue;
                            ++calledGenotypes;
                        }
                        double[] genotypes = new double[calledGenotypes];
                        double[] cisvals = new double[calledGenotypes];
                        double[] transvals = new double[calledGenotypes];
                        calledGenotypes = 0;
                        for (int i = 0; i < this.m_gg[d].getExpressionData().getIndividuals().length; ++i) {
                            int genotypeId = indWGA[i];
                            short gt = snpObj.getGenotypes()[genotypeId];
                            if (genotypeId <= -1 || gt <= -1) continue;
                            genotypes[calledGenotypes] = snpObj.getDosageValues()[genotypeId];
                            cisvals[calledGenotypes] = origCisVals[i];
                            transvals[calledGenotypes] = origTransVals[i];
                            ++calledGenotypes;
                        }
                        genotypes = this.normalize(genotypes);
                        cisvals = this.normalize(cisvals);
                        transvals = this.normalize(transvals);
                        double corrCisTrans = ArrayMath.correlation((double[])cisvals, (double[])transvals);
                        double[] cisTransRCs = Regression.getLinearRegressionCoefficients(cisvals, transvals);
                        double[] snpCisRCs = Regression.getLinearRegressionCoefficients(genotypes, cisvals);
                        double[] snpTransRCs = Regression.getLinearRegressionCoefficients(genotypes, transvals);
                        double[] resTransVals = new double[cisvals.length];
                        for (int i = 0; i < resTransVals.length; ++i) {
                            resTransVals[i] = transvals[i] - cisTransRCs[0] * cisvals[i];
                        }
                        resTransVals = this.normalize(resTransVals);
                        double[] cisResTransRCs = Regression.getLinearRegressionCoefficients(cisvals, resTransVals);
                        double[] snpResTransRCs = Regression.getLinearRegressionCoefficients(genotypes, resTransVals);
                        double rescorr = ArrayMath.correlation((double[])cisvals, (double[])resTransVals);
                        out.writeln(snp + "\t" + snpObj.getChr() + "\t" + snpObj.getChrPos() + "\t" + BaseAnnot.toString(snpObj.getAlleles()[0]) + "/" + BaseAnnot.toString(snpObj.getAlleles()[1]) + "\t" + BaseAnnot.toString(snpObj.getAlleles()[0]) + "\t" + transvals.length + "\t" + cisprobe + "\t" + this.m_gg[d].getExpressionData().getChr()[cisProbeId] + "\t" + this.m_gg[d].getExpressionData().getChrStart()[cisProbeId] + ":" + this.m_gg[d].getExpressionData().getChrStop()[cisProbeId] + "\t" + this.m_gg[d].getExpressionData().getAnnotation()[cisProbeId] + "\t" + transprobe + "\t" + this.m_gg[d].getExpressionData().getChr()[transProbeId] + "\t" + this.m_gg[d].getExpressionData().getChrStart()[transProbeId] + ":" + this.m_gg[d].getExpressionData().getChrStop()[transProbeId] + "\t" + this.m_gg[d].getExpressionData().getAnnotation()[transProbeId] + "\t" + corrCisTrans + "\t" + snpCisRCs[0] + "\t" + snpCisRCs[2] + "\t" + cisTransRCs[0] + "\t" + cisTransRCs[2] + "\t" + snpTransRCs[0] + "\t" + snpTransRCs[2] + "\t" + rescorr + "\t" + cisResTransRCs[0] + "\t" + cisResTransRCs[2] + "\t" + snpResTransRCs[0] + "\t" + snpResTransRCs[2] + "\t" + snpResTransRCs[0] / snpTransRCs[0]);
                        snpObj.clearGenotypes();
                    }
                    next = it.hasNext() ? (Triple)it.next() : null;
                    pb.iterate();
                }
                pb.close();
                out.close();
            }
            snpLoader.close();
        }
    }

    private double[] normalize(double[] x) {
        double mean = Descriptives.mean(x);
        double sd = Math.sqrt(Descriptives.variance(x, mean));
        double[] xcorr = new double[x.length];
        for (int i = 0; i < xcorr.length; ++i) {
            xcorr[i] = (x[i] - mean) / sd;
        }
        return xcorr;
    }
}

