/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.causalinference;

import JSci.maths.ArrayMath;
import eqtlmappingpipeline.metaqtl3.containers.Settings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import umcg.genetica.console.ProgressBar;
import umcg.genetica.containers.Triple;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.SNP;
import umcg.genetica.io.trityper.SNPLoader;
import umcg.genetica.io.trityper.TriTyperGeneticalGenomicsDataset;
import umcg.genetica.io.trityper.TriTyperGeneticalGenomicsDatasetSettings;
import umcg.genetica.math.stats.Correlation;
import umcg.genetica.math.stats.Regression;
import umcg.genetica.math.stats.TwoStepLeastSquares;

public class IVAnalysis {
    protected HashSet<Triple<String, String, String>> snpProbeCombos = new HashSet();
    protected Settings m_settings;
    protected TriTyperGeneticalGenomicsDataset[] m_gg;
    protected final String outDir;

    public IVAnalysis(String xmlSettingsFile, String ingt, String inexp, String inexpplatform, String inexpannot, String gte, String out, int perm, String snpProbeCombinationList, boolean parametric) throws IOException, Exception {
        if (xmlSettingsFile == null && (ingt == null || inexp == null)) {
            throw new IllegalArgumentException("Supply settingsfile for IV Analysis");
        }
        if (snpProbeCombinationList == null) {
            throw new IllegalArgumentException("Supply SNP probe combination file for IV Analysis");
        }
        this.loadSNPProbeCombos(snpProbeCombinationList);
        if (this.snpProbeCombos.isEmpty()) {
            throw new IllegalArgumentException("SNP Probe combination file is empty!");
        }
        this.initializeDatasets(xmlSettingsFile, ingt, inexp, inexpplatform, inexpannot, gte, out, perm, parametric);
        if (!out.endsWith("/")) {
            out = out + "/";
        }
        Gpio.createDir(out);
        this.outDir = out;
    }

    private void loadSNPProbeCombos(String snpProbeCombinationList) throws IOException {
        System.out.println("Loading SNP-Cis-Trans combo's from file: " + snpProbeCombinationList);
        TextFile tf = new TextFile(snpProbeCombinationList, false);
        String[] elems = tf.readLineElems(TextFile.tab);
        while (elems != null) {
            if (elems.length >= 3) {
                Triple<String, String, String> t = new Triple<String, String, String>(elems[0], elems[1], elems[2]);
                this.snpProbeCombos.add(t);
            }
            elems = tf.readLineElems(TextFile.tab);
        }
        tf.close();
        System.out.println("Loaded " + this.snpProbeCombos.size() + " combinations.");
    }

    private void initializeDatasets(String xmlSettingsFile, String ingt, String inexp, String inexpplatform, String inexpannot, String gte, String out, int perm, boolean parametric) throws IOException, Exception {
        if (this.m_settings == null && xmlSettingsFile == null && ingt != null) {
            boolean settingsOk = true;
            if (inexp == null || inexp.trim().length() == 0) {
                System.err.println("ERROR: you did not specify a gene expression file.");
                settingsOk = false;
            }
            if (inexpannot != null && inexpannot.trim().length() != 0 && (inexpplatform == null || inexpplatform.trim().length() == 0)) {
                System.err.println("ERROR: you specified " + inexpannot + " but you did not specify the platform (using --inexpplatform)!");
                settingsOk = false;
            }
            if (out == null || out.trim().length() == 0) {
                System.err.println("ERROR: you did not specify an output directory.");
                settingsOk = false;
            }
            if (!settingsOk) {
                System.out.println();
                System.exit(0);
            }
            this.m_settings = new Settings();
            TriTyperGeneticalGenomicsDatasetSettings s = new TriTyperGeneticalGenomicsDatasetSettings();
            s.name = "Dataset";
            s.expressionLocation = inexp;
            s.expressionplatform = inexpplatform;
            s.probeannotation = inexpannot;
            s.genotypeLocation = ingt;
            s.genotypeToExpressionCoupling = gte;
            s.cisAnalysis = true;
            s.transAnalysis = true;
            if (parametric) {
                System.out.println("Running parametric analysis.");
                this.m_settings.performParametricAnalysis = true;
            }
            this.m_settings.cisAnalysis = true;
            this.m_settings.transAnalysis = true;
            boolean cistrans = false;
            if (this.m_settings.cisAnalysis && this.m_settings.transAnalysis) {
                this.m_settings.confineProbesToProbesMappingToAnyChromosome = true;
            }
            this.m_settings.datasetSettings = new ArrayList();
            this.m_settings.regressOutEQTLEffectFileName = null;
            this.m_settings.datasetSettings.add(s);
            this.m_settings.nrThreads = 1;
            this.m_settings.cisAnalysis = true;
            this.m_settings.transAnalysis = true;
            this.m_settings.nrPermutationsFDR = perm;
            if (!out.endsWith("/")) {
                out = out + "/";
            }
            if (!Gpio.exists(out)) {
                Gpio.createDir(out);
            }
            this.m_settings.outputReportsDir = out;
            this.m_settings.createTEXTOutputFiles = true;
            this.m_settings.createBinaryOutputFiles = false;
        } else if (this.m_settings == null && xmlSettingsFile != null) {
            this.m_settings = new Settings();
            this.m_settings.load(xmlSettingsFile);
        } else if (this.m_settings == null) {
            System.out.println("ERROR: No input specified");
            System.exit(0);
        }
        if (!this.m_settings.cisAnalysis && !this.m_settings.transAnalysis) {
            System.err.println("! WARNING: defaulting to CIS analysis (override with --trans or --trans and --cis))");
            this.m_settings.cisAnalysis = true;
        }
        this.m_settings.writeSettingsToDisk();
        int numDatasets = this.m_settings.datasetSettings.size();
        this.m_gg = new TriTyperGeneticalGenomicsDataset[numDatasets];
        int nrOfDatasetsWithGeneExpressionData = 0;
        for (int i = 0; i < numDatasets; ++i) {
            System.out.println("- Loading dataset: " + this.m_settings.datasetSettings.get((int)i).name + "");
            this.m_settings.datasetSettings.get((int)i).confineProbesToProbesMappingToAnyChromosome = this.m_settings.confineProbesToProbesMappingToAnyChromosome;
            System.out.println("-------------------------------------------------------------------------------\n");
            this.m_gg[i] = new TriTyperGeneticalGenomicsDataset(this.m_settings.datasetSettings.get(i));
            if (!this.m_gg[i].isExpressionDataLoadedCorrectly()) continue;
            ++nrOfDatasetsWithGeneExpressionData;
        }
        if (nrOfDatasetsWithGeneExpressionData == 0) {
            System.out.println("Error: none of your datasets contain any gene expression data for the settings you have specified");
            System.exit(0);
        }
    }

    public void run() throws IOException {
        for (int d = 0; d < this.m_gg.length; ++d) {
            SNPLoader snpLoader = this.m_gg[d].getGenotypeData().createSNPLoader();
            int[] indWGA = this.m_gg[d].getExpressionToGenotypeIdArray();
            for (int perm = 0; perm < this.m_settings.nrPermutationsFDR + 1; ++perm) {
                String outfile = null;
                if (perm == 0) {
                    outfile = this.outDir + this.m_gg[d].getSettings().name + "_IVAnalysis-RealData.txt";
                } else {
                    outfile = this.outDir + this.m_gg[d].getSettings().name + "_IVAnalysis-PermutationRound-" + perm + ".txt";
                    this.m_gg[d].permuteSampleLables(this.m_settings.randomNumberGenerator);
                }
                TextFile out = new TextFile(outfile, true);
                Iterator<Triple<String, String, String>> it = this.snpProbeCombos.iterator();
                Triple<String, String, String> next = it.next();
                ProgressBar pb = new ProgressBar(this.snpProbeCombos.size(), "Running IV Analysis - Permutation " + perm);
                out.writeln("SNP\tCisArrayAddress\tCisGeneNameTransArrayAddress\tTransGeneNamecisEQTL\tr2cisEQTL\ttransEQTL\tr2TransEQTL\tcorCisTrans\tr2CisTrans\tcorResCisResTrans\tr2ResCisResTrans\tIV-Beta\tIV-SE");
                while (next != null) {
                    String snp = next.getLeft();
                    String cisprobe = next.getMiddle();
                    String transprobe = next.getRight();
                    Integer snpId = this.m_gg[d].getGenotypeData().getSnpToSNPId().get((Object)snp);
                    Integer cisProbeId = (Integer)this.m_gg[d].getExpressionData().getProbeToId().get((Object)cisprobe);
                    Integer transProbeId = (Integer)this.m_gg[d].getExpressionData().getProbeToId().get((Object)transprobe);
                    if (snpId != -9 && cisProbeId != null && transProbeId != null) {
                        SNP snpObj = this.m_gg[d].getGenotypeData().getSNPObject(snpId);
                        snpLoader.loadGenotypes(snpObj);
                        snpLoader.loadDosage(snpObj);
                        double[] origCisVals = this.m_gg[d].getExpressionData().getMatrix()[cisProbeId];
                        double[] origTransVals = this.m_gg[d].getExpressionData().getMatrix()[transProbeId];
                        boolean nrequal = false;
                        int calledGenotypes = 0;
                        for (int i = 0; i < this.m_gg[d].getExpressionData().getIndividuals().length; ++i) {
                            int genotypeId = indWGA[i];
                            short gt = snpObj.getGenotypes()[genotypeId];
                            if (genotypeId <= -1 || gt <= -1) continue;
                            ++calledGenotypes;
                        }
                        double[] genotypes = new double[calledGenotypes];
                        double[] cisvals = new double[calledGenotypes];
                        double[] transvals = new double[calledGenotypes];
                        calledGenotypes = 0;
                        for (int i = 0; i < this.m_gg[d].getExpressionData().getIndividuals().length; ++i) {
                            int genotypeId = indWGA[i];
                            short gt = snpObj.getGenotypes()[genotypeId];
                            if (genotypeId <= -1 || gt <= -1) continue;
                            genotypes[calledGenotypes] = snpObj.getDosageValues()[genotypeId];
                            cisvals[calledGenotypes] = origCisVals[i];
                            transvals[calledGenotypes] = origTransVals[i];
                            ++calledGenotypes;
                        }
                        double corrCisTrans = ArrayMath.correlation((double[])cisvals, (double[])transvals);
                        double[] snpCisRCs = Regression.getLinearRegressionCoefficients(genotypes, cisvals);
                        double[] snpTransRCs = Regression.getLinearRegressionCoefficients(genotypes, transvals);
                        double[] resCis = new double[cisvals.length];
                        double[] resTrans = new double[cisvals.length];
                        for (int i = 0; i < resCis.length; ++i) {
                            resCis[i] = cisvals[i] - snpCisRCs[0] * genotypes[i];
                            resTrans[i] = transvals[i] - snpTransRCs[0] * genotypes[i];
                        }
                        double corrResCisResTrans = ArrayMath.correlation((double[])resCis, (double[])resTrans);
                        double[] cisTransRCs = Regression.getLinearRegressionCoefficients(cisvals, transvals);
                        double[] resCisTransRCs = Regression.getLinearRegressionCoefficients(resCis, transvals);
                        double[] resCisTrans = new double[cisvals.length];
                        double[] resResCisTrans = new double[cisvals.length];
                        for (int i = 0; i < resCisTrans.length; ++i) {
                            resCisTrans[i] = transvals[i] - cisTransRCs[0] * cisvals[i];
                            resResCisTrans[i] = transvals[i] - resCisTransRCs[0] * cisvals[i];
                        }
                        double corrCisResTrans = Correlation.correlate(cisvals, resCisTrans);
                        double transEQTL = Correlation.correlate(genotypes, transvals);
                        double corrSNPResTrans = Correlation.correlate(genotypes, resCisTrans);
                        double corrSNPResCisResTrans = Correlation.correlate(genotypes, resResCisTrans);
                        double[] result = TwoStepLeastSquares.tsls(transvals, cisvals, genotypes);
                        double cisEQTL = Correlation.correlate(genotypes, cisvals);
                        out.write(snp + "\t" + cisprobe + "\t" + this.m_gg[d].getExpressionData().getAnnotation()[cisProbeId] + "\t" + transprobe + "\t" + this.m_gg[d].getExpressionData().getAnnotation()[transProbeId] + "\t" + cisEQTL + "\t" + cisEQTL * cisEQTL + "\t" + transEQTL + "\t" + transEQTL * transEQTL + "\t" + corrCisTrans + "\t" + corrCisTrans * corrCisTrans + "\t" + corrResCisResTrans + "\t" + corrResCisResTrans * corrResCisResTrans + "\t" + result[0] + "\t" + result[2]);
                        snpObj.clearGenotypes();
                    }
                    next = it.hasNext() ? it.next() : null;
                    pb.iterate();
                }
                pb.close();
                out.close();
            }
            snpLoader.close();
        }
    }
}

