/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.binarymeta.util;

import eqtlmappingpipeline.binarymeta.meta.MetaAnalyze;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.zip.DataFormatException;
import umcg.genetica.console.ProgressBar;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.trityper.bin.BinaryResultDataset;
import umcg.genetica.io.trityper.bin.BinaryResultSNP;
import umcg.genetica.io.trityper.util.BaseAnnot;
import umcg.genetica.math.stats.Descriptives;

public class SNPAlleleCheck
extends MetaAnalyze {
    @Override
    public void analyze() throws IOException, DataFormatException, Exception {
        System.out.println("");
        System.out.println("Starting analysis!");
        String[] datasets = new String[m_settings.getDatasetnames().size()];
        for (int i = 0; i < m_settings.getDatasetnames().size(); ++i) {
            datasets[i] = m_settings.getDatasetnames().get(i);
        }
        if (!m_settings.getOutput().endsWith("/")) {
            m_settings.setOutput(m_settings.getOutput() + "/MetaAnalysis/");
        }
        if (!Gpio.exists(m_settings.getOutput())) {
            Gpio.createDir(m_settings.getOutput());
        }
        String[] locations = new String[m_settings.getDatasetnames().size()];
        for (int i = 0; i < locations.length; ++i) {
            locations[i] = m_settings.getDatasetlocations().get(i);
        }
        this.ds = new BinaryResultDataset[m_settings.getDatasetlocations().size()];
        this.pvaluedistribution = null;
        this.eQTLBuffer = null;
        this.finalEQTLBuffer = null;
        this.nrInFinalBuffer = 0;
        this.uniqueProbes = new HashSet();
        this.uniqueSNPs = new HashSet();
        int numDatasets = this.ds.length;
        this.probes = new ArrayList();
        this.snps = new ArrayList();
        this.snpChr = new ArrayList();
        this.snpChrPos = new ArrayList();
        this.nrTotalSamples = 0;
        String[] probeName = this.probeTranslation.getProbes();
        this.probes.addAll(Arrays.asList(probeName));
        this.initdatasets(locations, 0, -1);
        Descriptives.lookupSqrt(this.nrTotalSamples);
        ProgressBar pb = new ProgressBar(this.snps.size());
        for (int s = 0; s < this.snps.size(); ++s) {
            int d;
            Double[][] zscorePerDataset = new Double[this.ds.length][this.probes.size()];
            for (d = 0; d < this.ds.length; ++d) {
                BinaryResultSNP firstSNPPassingQC = null;
                Integer snpId = this.snpTranslation[d][s];
                if (snpId == null) continue;
                BinaryResultSNP snpObject = this.ds[d].getSnps()[snpId];
                long pointer = snpObject.getzScoreIndex();
                long nextpointer = -1L;
                if (snpId + 1 < this.ds[d].getSnps().length) {
                    BinaryResultSNP snpObject2 = this.ds[d].getSnps()[snpId + 1];
                    nextpointer = snpObject2.getzScoreIndex();
                }
                Float[] zscores = this.ds[d].getMatrix().read(pointer, nextpointer, this.ds[d].getNumProbes());
                for (int p = 0; p < this.probes.size(); ++p) {
                    Integer probeId = this.probeTranslationLookupTable[d][p];
                    byte probechr = this.probeTranslation.getProbeChr(p);
                    int probechrpos = this.probeTranslation.getProbeChrPos(p);
                    boolean testprobe = false;
                    if (probeId == null || !testprobe) continue;
                    if (!zscores[probeId].isNaN()) {
                        int nrSamples = snpObject.getNumsamples();
                        double weight = Descriptives.getSqrt(nrSamples);
                        double zscore = zscores[probeId].floatValue();
                        if (firstSNPPassingQC == null) {
                            firstSNPPassingQC = snpObject;
                        } else {
                            Boolean flipalleles = this.flipalleles(firstSNPPassingQC, snpObject);
                            if (flipalleles == null) {
                                System.err.println("ERROR! SNP alleles cannot be matched for snp\t" + snpObject.getName() + "\tin dataset\t" + datasets[d]);
                                System.err.println("This SNP will be excluded from further research");
                            } else if (flipalleles.booleanValue()) {
                                zscore = -zscore;
                            }
                        }
                        zscorePerDataset[d][p] = zscore;
                        continue;
                    }
                    System.out.println("SNP\t" + (String)this.snps.get(s) + ", " + this.snpChr.get(s) + ", " + this.snpChrPos.get(s) + "\thas not been tested for probe\t" + (String)this.probes.get(p) + ", " + this.probeTranslation.getProbeChr(p) + ", " + this.probeTranslation.getProbeChrPos(p) + "\tin dataset\t" + datasets[d]);
                }
            }
            for (d = 0; d < this.ds.length; ++d) {
                for (int d2 = 0; d2 < this.ds.length; ++d2) {
                    for (int p = 0; p < this.probes.size(); ++p) {
                        if (d2 == d || zscorePerDataset[d2][p] == null || zscorePerDataset[d][p] == null) continue;
                        double z1 = zscorePerDataset[d][p];
                        Integer snpId = this.snpTranslation[d][s];
                        BinaryResultSNP snpObject1 = this.ds[d].getSnps()[snpId];
                        snpId = this.snpTranslation[d2][s];
                        BinaryResultSNP snpObject2 = this.ds[d2].getSnps()[snpId];
                        double z2 = zscorePerDataset[d2][p];
                        if (!(z2 >= 4.0 && z1 <= -4.0) && (!(z1 >= 4.0) || !(z2 <= -4.0))) continue;
                        System.out.println("Discordant pair: ");
                        System.out.println(snpObject1.getName() + "\t" + BaseAnnot.toString(snpObject1.getAlleles()[0]) + "/" + BaseAnnot.toString(snpObject1.getAlleles()[1]) + "=" + BaseAnnot.toString(snpObject1.getAssessedAllele()) + "\t" + snpObject1.getMinorAllele() + "/" + snpObject1.getMaf());
                        System.out.println(snpObject2.getName() + "\t" + BaseAnnot.toString(snpObject2.getAlleles()[0]) + "/" + BaseAnnot.toString(snpObject2.getAlleles()[1]) + "=" + BaseAnnot.toString(snpObject2.getAssessedAllele()) + "\t" + snpObject1.getMinorAllele() + "/" + snpObject2.getMaf());
                        System.out.println("");
                    }
                }
            }
            pb.set(s);
        }
        pb.close();
    }

    private Boolean flipalleles(BinaryResultSNP firstSNPPassingQC, BinaryResultSNP snpObject) {
        int j;
        byte allele1;
        int i;
        byte[] allelesfirst = firstSNPPassingQC.getAlleles();
        byte allelefirstassessed = firstSNPPassingQC.getAssessedAllele();
        byte[] allelessecond = snpObject.getAlleles();
        byte allelesecondassessed = snpObject.getAssessedAllele();
        int nridenticalalleles = 0;
        for (i = 0; i < allelesfirst.length; ++i) {
            allele1 = allelesfirst[i];
            for (j = 0; j < allelessecond.length; ++j) {
                if (allelessecond[j] != allele1) continue;
                ++nridenticalalleles;
            }
        }
        if (nridenticalalleles == 2) {
            if (allelefirstassessed == allelesecondassessed) {
                return false;
            }
            return true;
        }
        allelessecond = this.convertToComplementaryAlleles(allelessecond);
        allelesecondassessed = BaseAnnot.getComplement(allelesecondassessed);
        nridenticalalleles = 0;
        for (i = 0; i < allelesfirst.length; ++i) {
            allele1 = allelesfirst[i];
            for (j = 0; j < allelessecond.length; ++j) {
                if (allelessecond[j] != allele1) continue;
                ++nridenticalalleles;
            }
        }
        if (nridenticalalleles == 2) {
            if (allelefirstassessed == allelesecondassessed) {
                return false;
            }
            return true;
        }
        return null;
    }

    private byte[] convertToComplementaryAlleles(byte[] allelesToCompare) {
        byte[] allelesComplementary = new byte[2];
        for (int a = 0; a < 2; ++a) {
            allelesComplementary[a] = BaseAnnot.getComplement(allelesToCompare[a]);
        }
        return allelesComplementary;
    }
}

