/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.binarymeta.meta.graphics;

import eqtlmappingpipeline.binarymeta.meta.graphics.PlotPackage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.concurrent.ArrayBlockingQueue;

public class ZScorePlotThread
extends Thread {
    int width = 0;
    int height = 0;
    int spacer = 50;
    BufferedImage bimage;
    Graphics2D g2d;
    int numDatasets = 0;
    private int unitsize = 0;
    private int halfsize;
    private int plotsize;
    ArrayBlockingQueue<PlotPackage> queue;
    private static final Color defaultColor = new Color(0, 0, 0, 128);
    private static final Color absentColor = new Color(255, 0, 0, 225);
    private final int[] individualSize;
    private final int[][] shared;
    private final int[][] identicaldirection;

    public ZScorePlotThread(ArrayBlockingQueue<PlotPackage> wqueue, BufferedImage image, Graphics2D g2dd, int width, int height, int spacer, int numdatasets, int unitsize, int halfsize, int plotsize) {
        this.queue = wqueue;
        this.bimage = image;
        this.g2d = g2dd;
        this.width = width;
        this.height = height;
        this.spacer = spacer;
        this.numDatasets = numdatasets;
        this.unitsize = unitsize;
        this.halfsize = halfsize;
        this.plotsize = plotsize;
        this.g2d.setColor(defaultColor);
        this.individualSize = new int[numdatasets];
        this.shared = new int[numdatasets][numdatasets];
        this.identicaldirection = new int[numdatasets][numdatasets];
    }

    @Override
    public void run() {
        boolean poison = false;
        while (!poison) {
            try {
                PlotPackage pack = this.queue.take();
                if (!pack.poison) {
                    this.plot(pack.zscore1, pack.zscore2, pack.dataset1, pack.dataset2);
                } else {
                    poison = pack.poison;
                }
                pack = null;
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        this.g2d.setColor(defaultColor);
        DecimalFormat df = new DecimalFormat("##");
        DecimalFormat df2 = new DecimalFormat("###,###,###,###,###");
        for (int dataset1 = 0; dataset1 < this.numDatasets; ++dataset1) {
            for (int dataset2 = dataset1 + 1; dataset2 < this.numDatasets; ++dataset2) {
                int leftmargin = (dataset2 + 1) * this.spacer + dataset2 * this.plotsize - (this.plotsize + this.spacer);
                int topmargin = (dataset1 + 1) * this.spacer + dataset1 * this.plotsize;
                int posX = leftmargin;
                int posY = topmargin;
                double perc = (double)this.identicaldirection[dataset1][dataset2] / (double)this.shared[dataset1][dataset2] * 100.0;
                this.g2d.drawString("Shared: " + df2.format(this.shared[dataset1][dataset2]), posX, posY + 10);
                this.g2d.drawString("Identical direction: " + df2.format(this.identicaldirection[dataset1][dataset2]) + " (" + df.format(perc) + "%)", posX, posY + 22);
            }
        }
    }

    private void plot(Double zScore, Double zScore2, int dataset1, int dataset2) {
        boolean absent1 = false;
        boolean absent2 = false;
        if (zScore == null) {
            zScore = 0.0;
            absent1 = true;
        }
        if (zScore2 == null) {
            zScore2 = 0.0;
            absent2 = true;
        }
        zScore = this.maxOut(zScore);
        zScore2 = this.maxOut(zScore2);
        int leftmargin = (dataset2 + 1) * this.spacer + dataset2 * this.plotsize - (this.plotsize + this.spacer);
        int topmargin = (dataset1 + 1) * this.spacer + dataset1 * this.plotsize;
        int posX = leftmargin + this.halfsize + (int)Math.round(zScore * (double)this.unitsize);
        int posY = topmargin + this.halfsize - (int)Math.round(zScore2 * (double)this.unitsize);
        if (!absent1 || !absent2) {
            if (absent1 || absent2) {
                this.g2d.setColor(absentColor);
                this.g2d.fillOval(posX - 3, posY - 3, 6, 6);
                this.g2d.setColor(defaultColor);
            } else {
                int[] nArray = this.shared[dataset1];
                int n = dataset2;
                nArray[n] = nArray[n] + 1;
                if (zScore >= 0.0 && zScore2 >= 0.0 || zScore < 0.0 && zScore2 < 0.0) {
                    int[] nArray2 = this.identicaldirection[dataset1];
                    int n2 = dataset2;
                    nArray2[n2] = nArray2[n2] + 1;
                }
                this.g2d.fillOval(posX - 3, posY - 3, 6, 6);
            }
        }
    }

    private double maxOut(double zScore) {
        if (zScore > 40.0) {
            return 40.0;
        }
        if (zScore < -40.0) {
            return -40.0;
        }
        return zScore;
    }
}

