/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.binarymeta.meta.graphics;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import eqtlmappingpipeline.binarymeta.meta.graphics.PlotPackage;
import eqtlmappingpipeline.binarymeta.meta.graphics.ZScorePlotThread;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.concurrent.ArrayBlockingQueue;
import javax.imageio.ImageIO;

public class ZScorePlot {
    int width = 0;
    int height = 0;
    int spacer = 50;
    BufferedImage bimage;
    Graphics2D g2d;
    int numDatasets = 0;
    private int unitsize = 0;
    private int halfsize;
    private int plotsize;
    private ZScorePlotThread thread;
    private ArrayBlockingQueue<PlotPackage> queue;
    private String[] datasets;
    private boolean pdfOutput = false;
    private String outfilename = "";
    private Document document;
    private PdfContentByte cb;
    private PdfWriter writer;

    public void init(int numdatasets, String[] datasets, boolean pdf, String filename) {
        if (pdf) {
            this.pdfOutput = true;
            this.outfilename = filename + ".pdf";
        }
        this.datasets = datasets;
        this.plotsize = 400;
        this.numDatasets = numdatasets;
        this.halfsize = 200;
        this.unitsize = 5;
        this.spacer = 5 * this.unitsize * 3;
        this.width = this.plotsize * this.numDatasets + (numdatasets + 1) * this.spacer - (this.plotsize + this.spacer);
        this.height = this.plotsize * this.numDatasets + (numdatasets + 1) * this.spacer - (this.plotsize + this.spacer);
        if (this.pdfOutput) {
            Rectangle rectangle = new Rectangle((float)this.width, (float)this.height);
            this.document = new Document(rectangle);
            this.writer = null;
            try {
                this.writer = PdfWriter.getInstance((Document)this.document, (OutputStream)new FileOutputStream(filename));
                this.document.open();
                this.cb = this.writer.getDirectContent();
                this.cb.saveState();
                this.g2d = this.cb.createGraphics((float)this.width, (float)this.height);
            }
            catch (Exception e) {
                System.out.println("Cannot write to PDF file!:\t" + filename);
                System.exit(-1);
            }
        } else {
            this.bimage = new BufferedImage(this.width, this.height, 1);
            this.g2d = this.bimage.createGraphics();
            this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.g2d.setColor(new Color(255, 255, 255));
            this.g2d.fillRect(0, 0, this.width, this.height);
            this.g2d.setColor(new Color(0, 0, 0));
        }
        this.queue = new ArrayBlockingQueue(8);
        this.thread = new ZScorePlotThread(this.queue, this.bimage, this.g2d, this.width, this.height, this.spacer, numdatasets, this.unitsize, this.halfsize, this.plotsize);
        this.thread.setName("Plotter");
        this.thread.start();
    }

    public synchronized void draw(Double zScore, Double zScore2, int dataset1, int dataset2) {
        try {
            PlotPackage p = new PlotPackage();
            p.zscore1 = zScore;
            p.zscore2 = zScore2;
            p.dataset1 = dataset1;
            p.dataset2 = dataset2;
            this.queue.put(p);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public void write(String outputFile) throws Exception {
        int topmargin;
        int leftmargin;
        int dataset2;
        int dataset1;
        try {
            PlotPackage p = new PlotPackage();
            p.poison = true;
            this.queue.put(p);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this.thread.join();
        this.g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        Color black = new Color(0, 0, 0);
        Color grey = new Color(150, 150, 150);
        this.g2d.setColor(grey);
        this.g2d.setStroke(new BasicStroke(2.0f, 2, 1));
        AffineTransform atNormal = new AffineTransform();
        AffineTransform at90deg = new AffineTransform();
        atNormal.setToRotation(0.0);
        at90deg.setToRotation(-1.5707963267948966);
        Font f = new Font("Sans-Serif", 1, 15);
        this.g2d.setFont(f);
        AffineTransform fontAT = new AffineTransform();
        fontAT.rotate(Math.toRadians(-90.0));
        Font font = this.g2d.getFont();
        Font theDerivedFont = font.deriveFont(fontAT);
        this.g2d.setFont(font);
        for (dataset1 = 0; dataset1 < this.numDatasets; ++dataset1) {
            for (dataset2 = dataset1 + 1; dataset2 < this.numDatasets; ++dataset2) {
                this.g2d.setColor(grey);
                leftmargin = (dataset2 + 1) * this.spacer + dataset2 * this.plotsize - (this.plotsize + this.spacer);
                topmargin = (dataset1 + 1) * this.spacer + dataset1 * this.plotsize;
                int startX = leftmargin + 0;
                int stopX = leftmargin + this.plotsize;
                int midX = leftmargin + this.halfsize;
                int startY = topmargin + 0;
                int stopY = topmargin + this.plotsize;
                int midY = topmargin + this.halfsize;
                this.g2d.drawLine(startX, midY, stopX, midY);
                this.g2d.drawLine(midX, startY, midX, stopY);
                for (int z = -40; z <= 40; z += 5) {
                    this.g2d.drawLine(midX + z * this.unitsize, midY, midX + z * this.unitsize, midY + this.unitsize);
                    this.g2d.drawLine(midX, midY - z * this.unitsize, midX + this.unitsize, midY - z * this.unitsize);
                }
                this.g2d.setColor(black);
                this.g2d.setFont(font);
                this.g2d.drawString(this.datasets[dataset1], startX, midY - this.unitsize);
                this.g2d.setFont(theDerivedFont);
                this.g2d.drawString(this.datasets[dataset2], midX - this.unitsize, stopY);
            }
        }
        this.g2d.setFont(font);
        this.g2d.setColor(grey);
        for (dataset1 = 0; dataset1 < this.numDatasets; ++dataset1) {
            for (dataset2 = dataset1 + 1; dataset2 < this.numDatasets; ++dataset2) {
                leftmargin = (dataset2 + 1) * this.spacer + dataset2 * this.plotsize - (this.plotsize + this.spacer);
                topmargin = (dataset1 + 1) * this.spacer + dataset1 * this.plotsize;
                int boxdist = 5 * this.unitsize;
                this.g2d.setStroke(new BasicStroke(1.0f, 2, 1));
                this.g2d.setColor(new Color(0, 0, 0));
                this.g2d.drawRect(leftmargin - boxdist, topmargin - boxdist, this.plotsize + boxdist * 2, this.plotsize + boxdist * 2);
            }
        }
        if (this.pdfOutput) {
            this.g2d.dispose();
            this.cb.restoreState();
            this.document.close();
            this.writer.close();
        } else {
            ImageIO.write((RenderedImage)this.bimage, "png", new File(outputFile + "-ZScoreComparison.png"));
        }
    }
}

