/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.binarymeta.meta.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import umcg.genetica.containers.Pair;

public class MultiVenn {
    int width = 0;
    int height = 0;
    int spacer = 50;
    BufferedImage bimage;
    Graphics2D g2d;
    private int requestedsize;
    private FontMetrics fontmetrics;
    private int margin;
    private int plotwidth;
    private int plotheight;

    public static void main(String[] args) {
        String[] setnames = new String[]{"SetA", "SetB", "SetC"};
        double[] setsizes = new double[]{100.0, 100.0, 25.0};
        double[][] overlaps = new double[3][3];
        overlaps[0][1] = 50.0;
        overlaps[0][2] = 10.0;
        overlaps[1][2] = 10.0;
        MultiVenn m = new MultiVenn();
        m.plot(setnames, setsizes, overlaps);
        System.out.println("drawing");
        m.draw("d:\\work\\multivenn.png");
    }

    public void plot(String[] setnames, double[] setsizes, double[][] overlaps) {
        int columns = setnames.length - 1;
        System.out.println(columns);
        this.requestedsize = 200;
        this.margin = 75;
        this.bimage = new BufferedImage(1, 1, 1);
        this.g2d = this.bimage.createGraphics();
        this.fontmetrics = this.g2d.getFontMetrics();
        this.plotwidth = 200;
        this.plotheight = 200;
        this.height = this.width = columns * this.plotwidth + (columns + 1) * this.margin;
        this.bimage = new BufferedImage(this.width, this.height, 1);
        this.g2d = this.bimage.createGraphics();
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2d.setColor(new Color(255, 255, 255));
        this.g2d.fillRect(0, 0, this.width, this.height);
        this.g2d.setColor(new Color(0, 0, 0));
        for (int i = 0; i < columns; ++i) {
            for (int j = i + 1; j < setnames.length; ++j) {
                int row = i;
                int col = j - 1;
                int offsetY = this.margin + row * this.plotwidth + row * this.margin;
                int offsetX = this.margin + col * this.plotwidth + col * this.margin;
                System.out.println(offsetX + "\t" + offsetY + "\t" + setnames[i] + "\t" + setnames[j]);
                this.plot(setsizes[i], setsizes[j], overlaps[i][j], setnames[i], setnames[j], offsetX, offsetY);
            }
        }
        System.out.println(this.width + "\t" + this.height);
    }

    private void plot(double sizeSetA, double sizeSetB, double overlap, String setAName, String setBName, int offsetX, int offsetY) {
        double distanceradians = this.getDistance(sizeSetA, sizeSetB, overlap);
        this.g2d.setStroke(new BasicStroke(2.0f));
        int widthofstringA = this.fontmetrics.stringWidth(setAName);
        int widthofstringB = this.fontmetrics.stringWidth(setBName);
        int maxCircleSize = this.plotwidth / 2;
        System.out.println("max circle\t" + maxCircleSize);
        double width1radians = this.getR(sizeSetA) * 2.0;
        double width2radians = this.getR(sizeSetB) * 2.0;
        double maxwidthradians = width1radians;
        if (width2radians > width1radians) {
            maxwidthradians = width2radians;
        }
        int circle1sizepixels = (int)Math.ceil((double)maxCircleSize * (width1radians / maxwidthradians));
        int circle2sizepixels = (int)Math.ceil((double)maxCircleSize * (width2radians / maxwidthradians));
        int distancepixels = (int)Math.ceil((double)maxCircleSize * (distanceradians / maxwidthradians));
        System.out.println(circle1sizepixels + "\t" + circle2sizepixels + "\t" + distancepixels);
        double radius1 = (double)circle1sizepixels / 2.0;
        double radius2 = (double)circle2sizepixels / 2.0;
        Color black = new Color(0, 0, 0);
        Color white = new Color(255, 255, 255);
        Color grey = new Color(255, 255, 255, 125);
        int totaldistance = distancepixels + (int)Math.ceil(radius1) + (int)Math.ceil(radius2);
        int remaining = this.plotwidth - totaldistance;
        int marginx = remaining / 2;
        System.out.println(totaldistance + "\t" + remaining + "\t" + marginx);
        this.g2d.setColor(black);
        this.g2d.fillOval(offsetX + marginx, offsetY + this.plotheight / 2 - (int)Math.floor(radius1), circle1sizepixels, circle1sizepixels);
        int circle1origin = offsetX + marginx + (int)Math.ceil(radius1);
        int circle2origin = circle1origin + distancepixels;
        int circle2start = circle2origin - (int)Math.ceil(radius2);
        this.g2d.setColor(grey);
        this.g2d.fillOval(circle2start, offsetY + this.plotheight / 2 - (int)Math.floor(radius2), circle2sizepixels, circle2sizepixels);
        this.g2d.setColor(black);
        this.g2d.drawOval(circle2start, offsetY + this.plotheight / 2 - (int)Math.floor(radius2), circle2sizepixels, circle2sizepixels);
        this.g2d.setColor(black);
        int originX1 = offsetX + (int)Math.ceil((double)marginx + radius1);
        int originY1 = offsetY + (int)Math.ceil(this.plotheight / 2);
        int originX2 = (int)Math.ceil((double)circle2start + radius2);
        int originY2 = offsetY + (int)Math.ceil(this.plotheight / 2);
        int deg = 225;
        Pair<Integer, Integer> xy0 = this.calcPosOnCircle(radius1, 0.0, 0.0, deg);
        Pair<Integer, Integer> xy1 = this.calcPosOnCircle(radius1 + 10.0, 0.0, 0.0, deg);
        this.g2d.drawLine(originX1 + xy0.getLeft(), originY1 + xy0.getRight(), originX1 + xy1.getLeft(), originY1 + xy1.getRight());
        String setADesc = "(" + sizeSetA + ")";
        int setADescWidth = this.fontmetrics.stringWidth(setADesc);
        int descheight = this.fontmetrics.getHeight() * 2;
        this.g2d.drawString(setAName, originX1 + xy1.getLeft() - widthofstringA - 5, originY1 + xy1.getRight() - descheight / 2);
        this.g2d.drawString(setADesc, originX1 + xy1.getLeft() - setADescWidth - 5, originY1 + xy1.getRight() + this.fontmetrics.getHeight() - descheight / 2);
        deg = 315;
        xy0 = this.calcPosOnCircle(radius2, 0.0, 0.0, deg);
        xy1 = this.calcPosOnCircle(radius2 + 10.0, 0.0, 0.0, deg);
        this.g2d.drawLine(originX2 + xy0.getLeft(), originY2 + xy0.getRight(), originX2 + xy1.getLeft(), originY2 + xy1.getRight());
        String setBDesc = "(" + sizeSetB + ")";
        this.g2d.drawString(setBName, originX2 + xy1.getLeft() + 5, originY2 + xy1.getRight() - descheight / 2);
        this.g2d.drawString(setBDesc, originX2 + xy1.getLeft() + 5, originY2 + xy1.getRight() + this.fontmetrics.getHeight() - descheight / 2);
        String overlapstr = "Overlap";
        String overlapdesc = "(" + overlap + ")";
        int overlapstrwidth = this.fontmetrics.stringWidth(overlapstr);
        int overlapstrwidthhalway = overlapstrwidth / 2;
        int overlapdescstrwidth = this.fontmetrics.stringWidth(overlapdesc);
        int overlapdescstrwidthhalway = overlapdescstrwidth / 2;
        int dd2 = distancepixels - (int)Math.floor(radius1);
        int dd1 = distancepixels - (int)Math.floor(radius2);
        int ddx = distancepixels - dd1 - dd2;
        int overlapmid = offsetX + marginx + (int)Math.floor(radius1) + dd1 + (int)Math.floor(ddx / 2);
        System.out.println(overlapmid);
        int halfmaxcircleheight = maxCircleSize / 2;
        this.g2d.drawLine(overlapmid, offsetY + this.plotheight / 2, overlapmid, offsetY + this.plotheight / 2 - halfmaxcircleheight - 10);
        this.g2d.fillOval(overlapmid - 5, offsetY + this.plotheight / 2 - 5, 10, 10);
        this.g2d.drawString(overlapstr, overlapmid - overlapstrwidthhalway, offsetY + this.plotheight / 2 - halfmaxcircleheight - this.fontmetrics.getHeight() * 2);
        this.g2d.drawString(overlapdesc, overlapmid - overlapdescstrwidthhalway, offsetY + this.plotheight / 2 - halfmaxcircleheight - this.fontmetrics.getHeight());
    }

    public void draw(String loc) {
        try {
            ImageIO.write((RenderedImage)this.bimage, "png", new File(loc));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private double calc_overlap(double r1, double r2, double d) {
        double alpha = 2.0 * Math.acos((Math.pow(d, 2.0) + Math.pow(r1, 2.0) - Math.pow(r2, 2.0)) / (2.0 * r1 * d));
        double beta = 2.0 * Math.acos((Math.pow(d, 2.0) + Math.pow(r2, 2.0) - Math.pow(r1, 2.0)) / (2.0 * r2 * d));
        double s = 0.5 * Math.pow(r1, 2.0) * (alpha - Math.sin(alpha)) + 0.5 * Math.pow(r2, 2.0) * (beta - Math.sin(beta));
        return s;
    }

    private Pair<Integer, Integer> calcPosOnCircle(double r, double originX, double originY, double angle) {
        double radians = angle * Math.PI / 180.0;
        Integer x = (int)Math.floor(originX + r * Math.cos(radians));
        Integer y = (int)Math.floor(originY + r * Math.sin(radians));
        return new Pair<Integer, Integer>(x, y);
    }

    private double getR(double r) {
        return Math.sqrt(r / Math.PI);
    }

    private double getDistance(double sizeSetA, double sizeSetB, double overlap) {
        double maxOverlap;
        double r1 = this.getR(sizeSetA);
        double r2 = this.getR(sizeSetB);
        double minOverlap = Math.abs(r1 - r2);
        double upper = maxOverlap = r1 + r2;
        double lower = minOverlap;
        double testpos = 0.0;
        double circleOverlap = 0.0;
        double allowed_difference = overlap / 100.0;
        int i = 0;
        while (lower != upper && !(Math.abs((circleOverlap = this.calc_overlap(r1, r2, testpos = (lower + upper) / 2.0)) - overlap) <= allowed_difference)) {
            if (circleOverlap > overlap) {
                lower = testpos;
            } else {
                upper = testpos;
            }
            if (i == 100) break;
            ++i;
        }
        return testpos;
    }
}

