/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.binarymeta.meta.cis;

import eqtlmappingpipeline.binarymeta.meta.cis.CisAnalysis;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import umcg.genetica.containers.Pair;
import umcg.genetica.io.trityper.bin.BinaryResultDataset;
import umcg.genetica.io.trityper.bin.BinaryResultSNP;

public class ZScoreLoaderTask
implements Callable<Pair<Integer, Float[]>> {
    private final int d;
    private final boolean[] snpsForWhichThereAreEffects;
    private final Integer[][] reverseSNPLookupTable;
    private final BinaryResultDataset[] ds;
    private final ArrayList<String> probes;
    private final Integer[][] probeTranslationLookupTable;
    private final HashMap<Pair<Integer, Integer>, Integer> SNPProbeToEffectMap;
    private final Float[] output;
    private final Inflater inflater = new Inflater();
    private final boolean[] probePresent;

    public ZScoreLoaderTask(BinaryResultDataset[] ds, int d, boolean[] snpsForWhichThereAreEffects, Integer[][] reverseSNPLookupTable, ArrayList<String> probes, Integer[][] probeTranslationLookupTable, HashMap<Pair<Integer, Integer>, Integer> SNPProbeToEffectMap, Float[] output, boolean[] probePresent) {
        this.ds = ds;
        this.d = d;
        this.snpsForWhichThereAreEffects = snpsForWhichThereAreEffects;
        this.reverseSNPLookupTable = reverseSNPLookupTable;
        this.probes = probes;
        this.probeTranslationLookupTable = probeTranslationLookupTable;
        this.SNPProbeToEffectMap = SNPProbeToEffectMap;
        this.output = output;
        this.probePresent = probePresent;
    }

    @Override
    public Pair<Integer, Float[]> call() throws Exception {
        BinaryResultSNP[] binsnps = this.ds[this.d].getSnps();
        for (int snp = 0; snp < binsnps.length; ++snp) {
            if (this.snpsForWhichThereAreEffects[snp]) {
                BinaryResultSNP snpObject = binsnps[snp];
                Integer binSNPId = snpObject.getId();
                Integer metaSNPId = this.reverseSNPLookupTable[this.d][binSNPId];
                long pointer = snpObject.getzScoreIndex();
                long nextpointer = -1L;
                if (binSNPId + 1 < this.ds[this.d].getSnps().length) {
                    BinaryResultSNP snpObject2 = this.ds[this.d].getSnps()[binSNPId + 1];
                    nextpointer = snpObject2.getzScoreIndex();
                }
                Float[] zscores = null;
                try {
                    byte[] data = this.ds[this.d].getMatrix().readDeflated(pointer, nextpointer, this.ds[this.d].getNumProbes());
                    zscores = this.inflate(data, this.ds[this.d].getNumProbes());
                }
                catch (DataFormatException ex) {
                    Logger.getLogger(CisAnalysis.class.getName()).log(Level.SEVERE, null, ex);
                }
                for (int probe = 0; probe < this.probes.size(); ++probe) {
                    Pair<Integer, Integer> snpProbePair;
                    Integer pairId;
                    Integer dsProbeId;
                    if (!this.probePresent[probe] || (dsProbeId = this.probeTranslationLookupTable[this.d][probe]) == null || (pairId = this.SNPProbeToEffectMap.get(snpProbePair = new Pair<Integer, Integer>(metaSNPId, probe))) == null) continue;
                    this.output[pairId.intValue()] = zscores[dsProbeId];
                }
            }
            if (snp <= 0 || snp % 1000 != 0) continue;
            System.out.println("Dataset\t" + this.d + "\t" + snp + "/" + binsnps.length + "\t" + (double)snp / (double)binsnps.length);
        }
        return new Pair<Integer, Float[]>(this.d, this.output);
    }

    private Float[] inflate(byte[] buffer, int numElems) throws DataFormatException {
        this.inflater.setInput(buffer);
        this.inflater.finished();
        byte[] decompressed = new byte[numElems * 4];
        this.inflater.inflate(decompressed);
        long actuallydecompressed = this.inflater.getBytesWritten();
        if (actuallydecompressed != (long)(numElems * 4)) {
            throw new DataFormatException("IO Error: uncompressed data does not correspond to the size requested\t" + actuallydecompressed + "\t" + numElems * 4);
        }
        this.inflater.reset();
        ByteBuffer bytebuffer = ByteBuffer.wrap(decompressed);
        Float[] output = new Float[numElems];
        int ctr = 0;
        for (int i = 0; i < numElems; ++i) {
            Float f = Float.valueOf(bytebuffer.getFloat());
            if (f.isNaN()) {
                f = null;
            } else {
                ++ctr;
            }
            output[i] = f;
        }
        decompressed = null;
        if (ctr == 0) {
            return null;
        }
        return output;
    }
}

