/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.binarymeta.meta.cis;

import eqtlmappingpipeline.binarymeta.meta.MetaSettings;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import umcg.genetica.console.ProgressBar;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.bin.BinaryFile;
import umcg.genetica.io.trityper.bin.BinaryResultDataset;
import umcg.genetica.io.trityper.bin.BinaryResultProbe;
import umcg.genetica.io.trityper.bin.BinaryResultSNP;

public class CisBinaryConverter {
    private final MetaSettings m_settings;
    private Inflater inflater = new Inflater();

    public static void main(String[] args) {
        String settingsfile = "/Volumes/Data2/MetaAnalysisSoftware/settings/2011-12-06-CIS-40PCs-4GWAS-GeneticVectorsNotRemoved.xml";
        CisBinaryConverter c = new CisBinaryConverter(settingsfile);
        try {
            c.run();
        }
        catch (IOException ex) {
            Logger.getLogger(CisBinaryConverter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public CisBinaryConverter(String settings) {
        this.m_settings = new MetaSettings();
        this.m_settings.parse(settings, null, null);
    }

    public void run() throws IOException {
        ArrayList<String> datasetLocations = this.m_settings.getDatasetlocations();
        ArrayList<String> datasetNames = this.m_settings.getDatasetnames();
        ArrayList<String> datasetAnnot = this.m_settings.getDatasetannotations();
        int nrPerm = this.m_settings.getNrPermutations();
        int nrprocs = Runtime.getRuntime().availableProcessors() / 2;
        System.out.println(nrprocs + " procs.");
        Gpio.createDir(this.m_settings.getOutput());
        System.out.println("Found " + datasetLocations.size() + " datasets..");
        for (int d = 0; d < datasetLocations.size(); ++d) {
            System.out.println("Starting for " + datasetNames.get(d));
            for (int perm = 0; perm < nrPerm + 1; ++perm) {
                String datasetName = "Dataset";
                BinaryResultDataset dataset = new BinaryResultDataset(datasetLocations.get(d), datasetName, perm);
                BinaryResultSNP[] snps = dataset.getSnps();
                BinaryResultProbe[] probes = dataset.getProbes();
                int nrProbes = dataset.getNumProbes();
                String outfile = null;
                outfile = perm == 0 ? this.m_settings.getOutput() + datasetNames.get(d) + "-eQTLs.dat" : this.m_settings.getOutput() + datasetNames.get(d) + "-PermutedDataPermutationRound-" + perm + ".dat";
                BinaryFile bf = new BinaryFile(outfile, true);
                System.out.println("Outfile: " + outfile);
                int snp = 0;
                dataset.clearProbeObjects();
                ProgressBar pb = new ProgressBar(snps.length);
                for (snp = 0; snp < snps.length; ++snp) {
                    BinaryResultSNP snpObject = snps[snp];
                    long pointer = snpObject.getzScoreIndex();
                    long nextpointer = -1L;
                    if (snp + 1 < snps.length) {
                        BinaryResultSNP snpObject2 = snps[snp + 1];
                        nextpointer = snpObject2.getzScoreIndex();
                    }
                    byte[] bindata = dataset.getMatrix().readDeflated(pointer, nextpointer, dataset.getNumProbes());
                    try {
                        Float[] data = this.inflate(bindata, dataset.getNumProbes());
                        bindata = null;
                        Integer snpid = snp;
                        for (int dp = 0; dp < data.length; ++dp) {
                            Float datapoint = data[dp];
                            if (datapoint == null) continue;
                            bf.writeInt(snpid);
                            bf.writeInt(dp);
                            bf.writeFloat(datapoint.floatValue());
                            datapoint = null;
                        }
                        data = null;
                    }
                    catch (DataFormatException ex) {
                        Logger.getLogger(CisBinaryConverter.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    pb.iterate();
                }
                pb.close();
                bf.close();
                dataset.close();
                dataset = null;
            }
        }
        System.out.println("Done.");
    }

    protected Float[] inflate(byte[] buffer, int numElems) throws DataFormatException {
        this.inflater.setInput(buffer);
        this.inflater.finished();
        byte[] decompressed = new byte[numElems * 4];
        this.inflater.inflate(decompressed);
        long actuallydecompressed = this.inflater.getBytesWritten();
        if (actuallydecompressed != (long)(numElems * 4)) {
            throw new DataFormatException("IO Error: uncompressed data does not correspond to the size requested\t" + actuallydecompressed + "\t" + numElems * 4);
        }
        this.inflater.reset();
        ByteBuffer bytebuffer = ByteBuffer.wrap(decompressed);
        Float[] output = new Float[numElems];
        int ctr = 0;
        for (int i = 0; i < numElems; ++i) {
            Float f = Float.valueOf(bytebuffer.getFloat());
            if (f.isNaN()) {
                f = null;
            } else {
                ++ctr;
            }
            output[i] = f;
        }
        decompressed = null;
        if (ctr == 0) {
            return null;
        }
        return output;
    }
}

