/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.binarymeta.meta.cis;

import com.lowagie.text.DocumentException;
import eqtlmappingpipeline.binarymeta.meta.MetaAnalyze;
import eqtlmappingpipeline.binarymeta.meta.MetaSettings;
import eqtlmappingpipeline.metaqtl3.FDR;
import eqtlmappingpipeline.metaqtl3.graphics.EQTLDotPlot;
import eqtlmappingpipeline.util.eqtlfilesorter.EQTLFileSorter;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import umcg.genetica.console.ProgressBar;
import umcg.genetica.containers.Pair;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.bin.BinaryFile;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.bin.BinaryResultDataset;
import umcg.genetica.io.trityper.bin.BinaryResultProbe;
import umcg.genetica.io.trityper.bin.BinaryResultSNP;
import umcg.genetica.io.trityper.eQTLTextFile;
import umcg.genetica.io.trityper.probeannotation.ProbeTranslation;
import umcg.genetica.io.trityper.util.BaseAnnot;
import umcg.genetica.math.stats.Descriptives;
import umcg.genetica.text.Strings;

public class CisAnalysis
extends MetaAnalyze {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: meta settings.xml");
        } else {
            String config = args[0];
            try {
                CisAnalysis c = new CisAnalysis(config);
                c.run();
            }
            catch (IOException ex) {
                Logger.getLogger(CisAnalysis.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public CisAnalysis(String args) throws IOException {
        m_settings = new MetaSettings();
        m_settings.parse(args, null, null);
        this.probeTranslation = new ProbeTranslation();
        this.probeTranslation.load(m_settings.getProbetranslationfile());
    }

    public void run() throws IOException {
        System.out.println("");
        System.out.println("Starting analysis!");
        String[] datasets = new String[m_settings.getDatasetnames().size()];
        for (int i = 0; i < m_settings.getDatasetnames().size(); ++i) {
            datasets[i] = m_settings.getDatasetnames().get(i);
        }
        if (!m_settings.getOutput().endsWith("/")) {
            m_settings.setOutput(m_settings.getOutput() + "/MetaAnalysis/");
        }
        if (!Gpio.exists(m_settings.getOutput())) {
            Gpio.createDir(m_settings.getOutput());
        }
        String[] locations = new String[m_settings.getDatasetnames().size()];
        for (int i = 0; i < locations.length; ++i) {
            locations[i] = m_settings.getDatasetlocations().get(i);
        }
        int permstart = 0;
        int permstop = m_settings.getNrPermutations() + 1;
        if (m_settings.getRunonlypermutation() > -1) {
            permstart = m_settings.getRunonlypermutation();
            permstop = m_settings.getRunonlypermutation() + m_settings.getNrPermutations();
        }
        for (int perm = permstart; perm < permstop; ++perm) {
            this.ds = new BinaryResultDataset[m_settings.getDatasetlocations().size()];
            this.runCalculationRound(perm, locations, datasets, -1);
        }
        Gpio.createDir(m_settings.getOutput() + "Sorted/");
        for (int abs = 0; abs < 1; ++abs) {
            for (int perm = 0; perm < m_settings.getNrPermutations() + 1; ++perm) {
                EQTLFileSorter sorter = new EQTLFileSorter();
                String suffix = "eQTLs.txt.gz";
                if (perm > 0) {
                    suffix = "PermutedEQTLsPermutationRound" + perm + ".txt.gz";
                }
                if (abs > 0) {
                    suffix = suffix + "-Absolute.txt.gz";
                }
                sorter.run(m_settings.getOutput() + suffix, null);
                System.out.println("Moving file.");
                System.out.println("SRC: " + m_settings.getOutput() + suffix + "_sorted.txt");
                System.out.println("DST: " + m_settings.getOutput() + "/Sorted/" + suffix);
                Gpio.moveFile(m_settings.getOutput() + suffix + "_sorted.txt", m_settings.getOutput() + "/Sorted/" + suffix);
            }
        }
        if (m_settings.getRunonlypermutation() == -1 && m_settings.getNrPermutations() > 0) {
            TextFile eQTLFile = new TextFile(m_settings.getOutput() + "/Sorted/eQTLs.txt.gz", false);
            int nrEQTLs = eQTLFile.countLines() - 1;
            eQTLFile.close();
            FDR.calculateFDR(m_settings.getOutput() + "/Sorted/", m_settings.getNrPermutations(), nrEQTLs, m_settings.getFdrthreshold(), true, null, null, FDR.FDRMethod.ALL, true);
            EQTLDotPlot edp = new EQTLDotPlot();
            try {
                edp.draw(m_settings.getOutput() + "/eQTLsFDR" + m_settings.getFdrthreshold() + ".txt", m_settings.getOutput() + "/DotPlot-FDR" + m_settings.getFdrthreshold() + ".pdf", EQTLDotPlot.Output.PDF);
            }
            catch (DocumentException ex) {
                Logger.getLogger(CisAnalysis.class.getName()).log(Level.SEVERE, null, ex);
            }
            edp = null;
        }
    }

    @Override
    public void runCalculationRound(int perm, String[] locations, String[] datasets, int dToUse) throws IOException {
        int d;
        this.uniqueProbes = new HashSet();
        this.uniqueSNPs = new HashSet();
        int numDatasets = this.ds.length;
        this.probes = new ArrayList();
        this.snps = new ArrayList();
        this.snpChr = new ArrayList();
        this.snpChrPos = new ArrayList();
        this.nrTotalSamples = 0;
        String[] probeName = this.probeTranslation.getProbes();
        this.probes.addAll(Arrays.asList(probeName));
        super.initdatasets(locations, perm, dToUse);
        Descriptives.lookupSqrt(this.nrTotalSamples);
        System.out.println("Performing the meta-analysis now: ");
        System.out.println(this.nrTotalSamples + "\t total samples");
        int effectcounter = 0;
        HashMap<Pair<Integer, Integer>, Integer> SNPProbeToEffectMap = new HashMap<Pair<Integer, Integer>, Integer>(14000000);
        HashMap<Integer, Pair<Integer, Integer>> EffectToSNPProbeMap = new HashMap<Integer, Pair<Integer, Integer>>(14000000);
        HashSet snpsForWhichThereAreEffects = new HashSet();
        System.out.println();
        boolean[] probespresentarray = new boolean[this.probes.size()];
        for (int p = 0; p < this.probes.size(); ++p) {
            boolean probeIsPresent = false;
            for (int d2 = 0; d2 < this.ds.length; ++d2) {
                if (this.probeTranslationLookupTable[d2][p] == null) continue;
                probeIsPresent = true;
            }
            probespresentarray[p] = probeIsPresent;
        }
        ProgressBar pb = new ProgressBar(this.snps.size(), "Building indexes.. please wait. ");
        HashSet probesWithEffects = new HashSet();
        boolean[] snpsHavingEffects = new boolean[this.snps.size()];
        boolean[] probeActuallyTested = new boolean[this.probes.size()];
        int metaprobenr = this.probes.size();
        int metasnpnr = this.snps.size();
        for (int snp = 0; snp < metasnpnr; ++snp) {
            byte chr = (Byte)this.snpChr.get(snp);
            Integer pos = (Integer)this.snpChrPos.get(snp);
            for (int probe = 0; probe < metaprobenr; ++probe) {
                byte probeChr;
                if (!probespresentarray[probe] || (probeChr = this.probeTranslation.getProbeChr(probe)) != chr) continue;
                Integer probeChrPos = this.probeTranslation.getProbeChrPos(probe);
                if (Math.abs(pos - probeChrPos) > m_settings.getCisdistance()) continue;
                probeActuallyTested[probe] = true;
                snpsHavingEffects[snp] = true;
                Pair<Integer, Integer> snpprobepair = new Pair<Integer, Integer>(snp, probe);
                if (SNPProbeToEffectMap.get(snpprobepair) != null) continue;
                SNPProbeToEffectMap.put(snpprobepair, effectcounter);
                EffectToSNPProbeMap.put(effectcounter, snpprobepair);
                snpsForWhichThereAreEffects.add(this.snps.get(snp));
                probesWithEffects.add(this.probes.get(probe));
                ++effectcounter;
            }
            pb.iterate();
        }
        pb.close();
        TextFile outfx = new TextFile(m_settings.getOutput() + "NumberOfEffects.txt", true);
        System.out.println(effectcounter + " effects detected..");
        outfx.writeln(effectcounter + " effects detected..");
        outfx.writeln(snpsForWhichThereAreEffects.size() + " snps");
        System.out.println(snpsForWhichThereAreEffects.size() + " snps");
        outfx.writeln(probesWithEffects.size() + " probes");
        System.out.println(probesWithEffects.size() + " probes");
        outfx.close();
        snpsForWhichThereAreEffects = null;
        probesWithEffects = null;
        System.out.println("In total, number of effects: " + effectcounter);
        System.out.println("Now building zscore matrix");
        Float[][] allZScores = new Float[this.ds.length][effectcounter];
        System.out.println("Building reverse lookup table");
        Integer[][] reverseSNPLookupTable = new Integer[this.ds.length][];
        for (d = 0; d < this.ds.length; ++d) {
            reverseSNPLookupTable[d] = new Integer[this.ds[d].getSnps().length];
            for (int snp = 0; snp < this.snps.size(); ++snp) {
                BinaryResultSNP snpObj = this.ds[d].getStringToSNP().get(this.snps.get(snp));
                if (snpObj == null) continue;
                Integer id = snpObj.getId();
                reverseSNPLookupTable[d][id.intValue()] = snp;
            }
        }
        System.out.println("Loading zscores.. ");
        for (d = 0; d < this.ds.length; ++d) {
            String filename = m_settings.getOutput() + m_settings.getDatasetnames().get(d) + "-eQTLs.dat";
            if (perm > 0) {
                filename = m_settings.getOutput() + m_settings.getDatasetnames().get(d) + "-PermutedDataPermutationRound-" + perm + ".dat";
            }
            System.out.println("Loading file: " + filename);
            BinaryFile bf = new BinaryFile(filename, false);
            boolean eof = false;
            String datasetannotation = m_settings.getDatasetannotations().get(d);
            int effectctr = 0;
            int lnctr = 0;
            while (!eof) {
                try {
                    Integer snpId = bf.readInt();
                    Integer probeId = bf.readInt();
                    Float zscore = Float.valueOf(bf.readFloat());
                    Integer metaSNPId = reverseSNPLookupTable[d][snpId];
                    BinaryResultProbe probeObj = this.ds[d].getProbes()[probeId];
                    Integer metaProbeId = this.probeTranslation.getProbeId(datasetannotation + probeObj.getName());
                    if (metaSNPId != null && metaProbeId != null) {
                        Integer effect = (Integer)SNPProbeToEffectMap.get(new Pair<Integer, Integer>(metaSNPId, metaProbeId));
                        if (effect != null) {
                            allZScores[d][effect.intValue()] = zscore;
                            ++effectctr;
                        }
                        if (d == 0 && ((String)this.snps.get(metaSNPId)).equals("rs4475691")) {
                            System.out.println(effect + "\t" + zscore + "\t" + (String)this.snps.get(metaSNPId));
                        }
                    }
                }
                catch (EOFException e) {
                    eof = true;
                }
                ++lnctr;
            }
            System.out.println("");
            System.out.println("Done");
            bf.close();
        }
        String outFileName = "eQTLs.txt.gz";
        if (perm > 0) {
            outFileName = "PermutedEQTLsPermutationRound" + perm + ".txt.gz";
        }
        System.out.println("Writing file: " + m_settings.getOutput() + outFileName);
        TextFile eQTLOutput = new TextFile(m_settings.getOutput() + outFileName, true);
        TextFile eQTLOutputAbs = new TextFile(m_settings.getOutput() + outFileName + "-Absolute.txt.gz", true);
        eQTLOutput.writeln(eQTLTextFile.header);
        eQTLOutputAbs.writeln(eQTLTextFile.header);
        pb = new ProgressBar(effectcounter, "Now performing meta-analysis...");
        for (int effect = 0; effect < effectcounter; ++effect) {
            int nrDSHavingZScore = 0;
            int finalNrOfSamples = 0;
            double zsum = 0.0;
            double zsumabs = 0.0;
            Pair snpProbePair = (Pair)EffectToSNPProbeMap.get(effect);
            Integer snpId = (Integer)snpProbePair.getLeft();
            Integer probeId = (Integer)snpProbePair.getRight();
            BinaryResultSNP firstSNPToPassQC = null;
            BinaryResultSNP[] snpsPerDataset = new BinaryResultSNP[this.ds.length];
            for (int d3 = 0; d3 < this.ds.length; ++d3) {
                Float dsZScore = allZScores[d3][effect];
                Integer dsSNPId = this.snpTranslation[d3][snpId];
                if (dsZScore == null || dsSNPId == null) continue;
                BinaryResultSNP dsSNPObj = this.ds[d3].getSnps()[dsSNPId];
                int nrsamples = dsSNPObj.getNumsamples();
                double weight = Descriptives.getSqrt(nrsamples);
                ++nrDSHavingZScore;
                finalNrOfSamples += nrsamples;
                snpsPerDataset[d3] = dsSNPObj;
                if (firstSNPToPassQC == null) {
                    firstSNPToPassQC = dsSNPObj;
                } else {
                    Boolean flipalleles = this.flipalleles(firstSNPToPassQC, dsSNPObj);
                    if (flipalleles == null) {
                        System.err.println("ERROR! SNP alleles cannot be matched for snp\t" + dsSNPObj.getName() + "\tin dataset\t" + d3);
                        System.err.println("This SNP will be excluded from further research");
                    } else if (flipalleles.booleanValue()) {
                        allZScores[d3][effect] = Float.valueOf(-dsZScore.floatValue());
                    }
                }
                Float finalZ = allZScores[d3][effect];
                zsum += (double)finalZ.floatValue() * weight;
                zsumabs += Math.abs((double)finalZ.floatValue() * weight);
            }
            int nrDatasetsThatShouldHaveEffect = m_settings.getSnpDatasetPresenceThreshold();
            if (nrDatasetsThatShouldHaveEffect == 0) {
                nrDatasetsThatShouldHaveEffect = 1;
            }
            if (nrDSHavingZScore >= nrDatasetsThatShouldHaveEffect) {
                double zSumVal = zsum;
                double sqrtSample = Descriptives.getSqrt(finalNrOfSamples);
                double metaZScore = zSumVal / sqrtSample;
                double pValueOverall = Descriptives.convertZscoreToPvalue(metaZScore);
                double zSumValAbsolute = zsumabs;
                double zScoreAbs = zSumValAbsolute / sqrtSample;
                double pValueOverallAbs = Descriptives.convertZscoreToPvalue(zScoreAbs);
                for (int abs = 0; abs < 1; ++abs) {
                    StringBuilder output = new StringBuilder();
                    if (abs == 0) {
                        output.append(pValueOverall).append("\t");
                    } else {
                        output.append(pValueOverallAbs).append("\t");
                    }
                    output.append(firstSNPToPassQC.getName()).append("\t");
                    output.append(this.snpChr.get(snpId)).append("\t");
                    output.append(this.snpChrPos.get(snpId)).append("\t");
                    output.append((String)this.probes.get(probeId)).append("\t");
                    Integer probeTranslationId = probeId;
                    output.append(this.probeTranslation.getProbeChr(probeTranslationId)).append("\t");
                    output.append(this.probeTranslation.getProbeChrPos(probeTranslationId)).append("\t");
                    output.append("cis").append("\t");
                    output.append(BaseAnnot.toString(firstSNPToPassQC.getAlleles()[0])).append("/").append(BaseAnnot.toString(firstSNPToPassQC.getAlleles()[1])).append("\t");
                    output.append(BaseAnnot.toString(firstSNPToPassQC.getAssessedAllele())).append("\t");
                    if (abs == 0) {
                        output.append(metaZScore).append("\t");
                    } else {
                        output.append(zScoreAbs).append("\t");
                    }
                    String[] datasetsPassingQC = new String[this.ds.length];
                    String[] datasetZScores = new String[this.ds.length];
                    String[] numSamplesPerDataset = new String[this.ds.length];
                    String[] emptyvalues = new String[this.ds.length];
                    for (int d4 = 0; d4 < this.ds.length; ++d4) {
                        emptyvalues[d4] = "-";
                        if (allZScores[d4][effect] == null) {
                            datasetZScores[d4] = "-";
                            datasetsPassingQC[d4] = "-";
                            numSamplesPerDataset[d4] = "-";
                            continue;
                        }
                        datasetZScores[d4] = "" + allZScores[d4][effect];
                        datasetsPassingQC[d4] = m_settings.getDatasetnames().get(d4);
                        numSamplesPerDataset[d4] = "" + snpsPerDataset[d4].getNumsamples();
                    }
                    output.append(Strings.concat(datasetsPassingQC, Strings.comma)).append("\t");
                    output.append(Strings.concat(datasetZScores, Strings.comma)).append("\t");
                    output.append(Strings.concat(numSamplesPerDataset, Strings.comma)).append("\t");
                    output.append(Strings.concat(emptyvalues, Strings.comma)).append("\t");
                    output.append(Strings.concat(emptyvalues, Strings.comma)).append("\t");
                    output.append(this.probeTranslation.getProbeSymbol(probeTranslationId)).append("\t");
                    output.append(Strings.concat(emptyvalues, Strings.comma)).append("\t");
                    output.append(Strings.concat(emptyvalues, Strings.comma)).append("\t");
                    output.append(Strings.concat(emptyvalues, Strings.comma)).append("\t");
                    output.append(Strings.concat(emptyvalues, Strings.comma)).append("\t");
                    output.append(firstSNPToPassQC.getAssessedAllele()).append("\t");
                    if (abs == 0) {
                        eQTLOutput.writeln(output.toString());
                        continue;
                    }
                    eQTLOutputAbs.writeln(output.toString());
                }
            }
            pb.set(effect);
        }
        pb.close();
        eQTLOutput.close();
        eQTLOutputAbs.close();
        System.out.println("Done. Have a nice day.");
    }

    public Boolean flipalleles(BinaryResultSNP firstSNPPassingQC, BinaryResultSNP snpObject) {
        int j;
        byte allele1;
        int i;
        byte[] allelesfirst = firstSNPPassingQC.getAlleles();
        byte allelefirstassessed = firstSNPPassingQC.getAssessedAllele();
        byte[] allelessecond = snpObject.getAlleles();
        byte allelesecondassessed = snpObject.getAssessedAllele();
        int nridenticalalleles = 0;
        for (i = 0; i < allelesfirst.length; ++i) {
            allele1 = allelesfirst[i];
            for (j = 0; j < allelessecond.length; ++j) {
                if (allelessecond[j] != allele1) continue;
                ++nridenticalalleles;
            }
        }
        if (nridenticalalleles == 2) {
            if (allelefirstassessed == allelesecondassessed) {
                return false;
            }
            return true;
        }
        allelessecond = this.convertToComplementaryAlleles(allelessecond);
        allelesecondassessed = BaseAnnot.getComplement(allelesecondassessed);
        nridenticalalleles = 0;
        for (i = 0; i < allelesfirst.length; ++i) {
            allele1 = allelesfirst[i];
            for (j = 0; j < allelessecond.length; ++j) {
                if (allelessecond[j] != allele1) continue;
                ++nridenticalalleles;
            }
        }
        if (nridenticalalleles == 2) {
            if (allelefirstassessed == allelesecondassessed) {
                return false;
            }
            return true;
        }
        return null;
    }

    public byte[] convertToComplementaryAlleles(byte[] allelesToCompare) {
        byte[] allelesComplementary = new byte[2];
        for (int a = 0; a < 2; ++a) {
            allelesComplementary[a] = BaseAnnot.getComplement(allelesToCompare[a]);
        }
        return allelesComplementary;
    }
}

