/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.binarymeta.meta.cis;

import eqtlmappingpipeline.binarymeta.meta.cis.BinaryUnzipTask;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import umcg.genetica.containers.Pair;

public class CalcThread
extends Thread {
    private final ArrayBlockingQueue<BinaryUnzipTask> input;
    private final ArrayBlockingQueue<Pair<Integer, HashMap<Integer, Float>>> output;
    private boolean poisoned;

    public CalcThread(ArrayBlockingQueue<BinaryUnzipTask> input, ArrayBlockingQueue<Pair<Integer, HashMap<Integer, Float>>> output) {
        this.input = input;
        this.output = output;
    }

    @Override
    public void run() {
        while (!this.poisoned) {
            try {
                BinaryUnzipTask task = this.input.take();
                if (task.isPoison()) {
                    this.poisoned = true;
                    continue;
                }
                Object result = task.call();
                this.output.offer((Pair<Integer, HashMap<Integer, Float>>)result);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(CalcThread.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (Exception ex) {
                Logger.getLogger(CalcThread.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

