/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.binarymeta.meta.cis;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import umcg.genetica.containers.Pair;
import umcg.genetica.io.trityper.bin.BinaryResultDataset;
import umcg.genetica.io.trityper.bin.BinaryResultSNP;

public class BinaryUnzipTask
implements Callable<Pair<Integer, HashMap<Integer, Float>>> {
    private final int snp;
    private BinaryResultDataset data;
    private final int numprobes;
    private final Inflater inflater = new Inflater();
    private boolean poison;

    public BinaryUnzipTask(int snp, BinaryResultDataset data, int numprobes) {
        this.snp = snp;
        this.data = data;
        this.numprobes = numprobes;
    }

    BinaryUnzipTask(int snp, int nrProbes, BinaryResultDataset dataset, BinaryResultSNP[] snps) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Pair<Integer, HashMap<Integer, Float>> call() throws Exception {
        if (this.snp < 0) {
            return new Pair<Integer, Object>(-1, null);
        }
        BinaryResultSNP[] snps = this.data.getSnps();
        BinaryResultSNP snpObject = snps[this.snp];
        long pointer = snpObject.getzScoreIndex();
        long nextpointer = -1L;
        if (this.snp + 1 < snps.length) {
            BinaryResultSNP snpObject2 = snps[this.snp + 1];
            nextpointer = snpObject2.getzScoreIndex();
        }
        byte[] bindata = this.data.getMatrix().readDeflated(pointer, nextpointer, this.data.getNumProbes());
        HashMap<Integer, Float> dataUnzipped = this.inflate(bindata, this.data.getNumProbes());
        bindata = null;
        return new Pair<Integer, HashMap<Integer, Float>>(this.snp, dataUnzipped);
    }

    private HashMap<Integer, Float> inflate(byte[] buffer, int numElems) throws DataFormatException {
        this.inflater.setInput(buffer);
        this.inflater.finished();
        byte[] decompressed = new byte[numElems * 4];
        this.inflater.inflate(decompressed);
        long actuallydecompressed = this.inflater.getBytesWritten();
        if (actuallydecompressed != (long)(numElems * 4)) {
            throw new DataFormatException("IO Error: uncompressed data does not correspond to the size requested\t" + actuallydecompressed + "\t" + numElems * 4);
        }
        this.inflater.reset();
        ByteBuffer bytebuffer = ByteBuffer.wrap(decompressed);
        Float[] output = new Float[numElems];
        int ctr = 0;
        HashMap<Integer, Float> results = new HashMap<Integer, Float>();
        for (int i = 0; i < numElems; ++i) {
            Float f = Float.valueOf(bytebuffer.getFloat());
            if (f.isNaN()) {
                f = null;
                continue;
            }
            ++ctr;
            results.put(i, f);
        }
        decompressed = null;
        buffer = null;
        if (ctr == 0) {
            return null;
        }
        return results;
    }

    void setIsPoison() {
        this.poison = true;
    }

    boolean isPoison() {
        return this.poison;
    }
}

