/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.binarymeta.meta;

import eqtlmappingpipeline.binarymeta.meta.MetaAnalysisCalculationThread;
import eqtlmappingpipeline.binarymeta.meta.MetaAnalysisLoaderThread;
import eqtlmappingpipeline.binarymeta.meta.MetaAnalysisPlotThread;
import eqtlmappingpipeline.binarymeta.meta.MetaAnalysisWorkPackage;
import eqtlmappingpipeline.binarymeta.meta.MetaAnalyze;
import eqtlmappingpipeline.binarymeta.meta.PValueThreshold;
import eqtlmappingpipeline.binarymeta.meta.graphics.ZScorePlot;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.zip.DataFormatException;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.EQTL;
import umcg.genetica.io.trityper.bin.BinaryResultDataset;
import umcg.genetica.math.stats.Descriptives;

public class ZScoreComparison
extends MetaAnalyze {
    @Override
    public void analyze() throws IOException, DataFormatException, Exception {
        System.out.println("");
        System.out.println("Starting analysis!");
        String[] datasets = new String[m_settings.getDatasetnames().size()];
        for (int i = 0; i < m_settings.getDatasetnames().size(); ++i) {
            datasets[i] = m_settings.getDatasetnames().get(i);
        }
        if (!m_settings.getOutput().endsWith("/")) {
            m_settings.setOutput(m_settings.getOutput() + "/MetaAnalysis/");
        }
        if (!Gpio.exists(m_settings.getOutput())) {
            Gpio.createDir(m_settings.getOutput());
        }
        String[] locations = new String[m_settings.getDatasetnames().size()];
        for (int i = 0; i < locations.length; ++i) {
            locations[i] = m_settings.getDatasetlocations().get(i);
        }
        int permstart = 0;
        int permstop = m_settings.getNrPermutations() + 1;
        if (m_settings.getRunonlypermutation() > -1) {
            permstart = m_settings.getRunonlypermutation();
            permstop = m_settings.getRunonlypermutation() + 1;
        }
        for (int perm = permstart; perm < permstop; ++perm) {
            this.ds = new BinaryResultDataset[m_settings.getDatasetlocations().size()];
            this.plotZScores(perm, locations, datasets);
        }
    }

    private void plotZScores(int perm, String[] locations, String[] datasets) throws IOException, Exception {
        this.pvaluedistribution = null;
        this.eQTLBuffer = null;
        this.finalEQTLBuffer = null;
        this.nrInFinalBuffer = 0;
        this.uniqueProbes = new HashSet();
        this.uniqueSNPs = new HashSet();
        int numDatasets = this.ds.length;
        this.probes = new ArrayList();
        this.snps = new ArrayList();
        this.snpChr = new ArrayList();
        this.snpChrPos = new ArrayList();
        this.nrTotalSamples = 0;
        String[] probeName = this.probeTranslation.getProbes();
        this.probes.addAll(Arrays.asList(probeName));
        this.initdatasets(locations, perm, -1);
        String zsName = null;
        if (m_settings.isMakezscoreplot()) {
            this.zs = new ZScorePlot();
            String[] datasets2 = new String[datasets.length + 1];
            System.arraycopy(datasets, 0, datasets2, 0, datasets.length);
            datasets2[datasets2.length - 1] = "Meta-Analysis";
            zsName = perm > 0 ? m_settings.getOutput() + "ZScoreComparison-PermutationRound" + perm : m_settings.getOutput() + "ZScoreComparison";
            this.zs.init(numDatasets + 1, datasets2, true, zsName);
        }
        Descriptives.lookupSqrt(this.nrTotalSamples);
        this.pvaluedistribution = new int[m_settings.getNrOfBins()];
        this.eQTLBuffer = new EQTL[1];
        this.finalEQTLBuffer = new EQTL[0];
        this.pvaluethreshold = Double.MAX_VALUE;
        this.zsumPerSNP = new double[this.snps.size()];
        this.zsumSNPsNumberOfProbes = new int[this.snps.size()];
        this.zsumPerProbe = new double[this.probes.size()];
        this.zsumProbesNumberOfSNPs = new int[this.probes.size()];
        System.out.println("Performing the meta-analysis now: ");
        System.out.println(this.nrTotalSamples + "\t total samples");
        this.zscoretable = perm == 0 ? new TextFile(m_settings.getOutput() + "metazscoretable.txt.gz", true, 0xA00000) : new TextFile(m_settings.getOutput() + "metazscoretable-Permutation" + perm + ".txt.gz", true, 0xA00000);
        StringBuilder zscoreout = new StringBuilder();
        zscoreout.append("SNP\tAlleleCoding\tAssessedAllele");
        for (int i = 0; i < this.probes.size(); ++i) {
            zscoreout.append("\t").append((String)this.probes.get(i));
        }
        this.zscoretable.writeln(zscoreout.toString());
        int nrProcs = Runtime.getRuntime().availableProcessors();
        if (m_settings.getNrThresds() > 0 && m_settings.getNrThresds() < nrProcs) {
            m_settings.setNrThresds(m_settings.getNrThresds());
        }
        MetaAnalysisCalculationThread[] calcPool = new MetaAnalysisCalculationThread[nrProcs];
        LinkedBlockingQueue<MetaAnalysisWorkPackage> loaderQueue = new LinkedBlockingQueue<MetaAnalysisWorkPackage>(nrProcs);
        MetaAnalysisLoaderThread loaderThread = new MetaAnalysisLoaderThread(loaderQueue, this.snpTranslation, this.snps, this.ds);
        loaderThread.setName("Loader");
        loaderThread.start();
        PValueThreshold p = new PValueThreshold();
        for (int i = 0; i < nrProcs; ++i) {
            calcPool[i] = new MetaAnalysisPlotThread(loaderQueue, null, this.snps, this.probes, this.snpChr, this.snpChrPos, this.ds, this.snpTranslation, this.probeTranslationLookupTable, this.probeTranslation, m_settings, this.zs, p);
            calcPool[i].setName("MetaCalc-" + i);
            calcPool[i].start();
        }
        try {
            int threadNum;
            loaderThread.join();
            MetaAnalysisWorkPackage poison = new MetaAnalysisWorkPackage(0, 0);
            poison.poisonTheWell();
            for (threadNum = 0; threadNum < calcPool.length; ++threadNum) {
                try {
                    loaderQueue.put(poison);
                    continue;
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            for (threadNum = 0; threadNum < calcPool.length; ++threadNum) {
                calcPool[threadNum].join();
            }
        }
        catch (InterruptedException e) {
            System.err.println("Exception: Thread main interrupted.");
        }
        if (m_settings.isMakezscoretable()) {
            this.zscoretable.close();
        }
        if (this.zs != null) {
            this.zs.write(zsName);
        }
    }
}

