/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.binarymeta.meta;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;

public class MetaSettings {
    private int nrPermutations = 10;
    private boolean useAbsoluteZscore = false;
    private int finalEQTLBufferMaxLength = 1000000;
    private int nrOfBins = 100;
    private double fdrthreshold = 0.05;
    private boolean includeSNPsWithoutProperMapping = true;
    private boolean includeProbesWithoutProperMapping = true;
    private boolean cis = true;
    private boolean trans = true;
    private int cisdistance = 250000;
    private int transdistance = 5000000;
    private boolean makezscoreplot = true;
    private String probetranslationfile;
    private ArrayList<String> datasetnames;
    private ArrayList<String> datasetPrefix;
    private ArrayList<String> datasetlocations;
    private ArrayList<String> datasetannotations;
    private ArrayList<Integer> selectedProbes;
    private String output;
    private boolean makezscoretable = false;
    private int probeDatasetPresenceThreshold = 0;
    private int snpDatasetPresenceThreshold = 0;
    private int probeAndSNPPresenceFilterSampleThreshold = 0;
    private int runonlypermutation;
    private int nrThresds;
    private String probeselection;
    private String snpselection;
    private XMLConfiguration config;
    private String snpprobeselection;

    public void parse(String settings, String texttoreplace, String replacetextwith) {
        try {
            this.config = new XMLConfiguration(settings);
            this.nrPermutations = this.config.getInt("defaults.permutations", 0);
            this.useAbsoluteZscore = this.config.getBoolean("defaults.absolutezscore", false);
            this.finalEQTLBufferMaxLength = this.config.getInt("defaults.finalnreqtls", 100000);
            this.fdrthreshold = this.config.getDouble("defaults.fdrthreshold", 0.05);
            this.cisdistance = this.config.getInt("defaults.cisprobedistance", 250000);
            this.transdistance = this.config.getInt("defaults.transprobedistance", 5000000);
            this.includeProbesWithoutProperMapping = this.config.getBoolean("defaults.includeprobeswithoutmapping", true);
            this.includeSNPsWithoutProperMapping = this.config.getBoolean("defaults.includesnpswithoutmapping", true);
            this.makezscoreplot = this.config.getBoolean("defaults.makezscoreplot", true);
            this.makezscoretable = this.config.getBoolean("defaults.makezscoretable", false);
            this.probetranslationfile = this.config.getString("defaults.probetranslationfile");
            this.output = this.config.getString("defaults.output");
            this.probeDatasetPresenceThreshold = this.config.getInt("defaults.minimalnumberofdatasetsthatcontainprobe", 0);
            this.snpDatasetPresenceThreshold = this.config.getInt("defaults.minimalnumberofdatasetsthatcontainsnp", 0);
            this.probeAndSNPPresenceFilterSampleThreshold = this.config.getInt("defaults.snpprobeselectsamplesizethreshold", -1);
            this.runonlypermutation = this.config.getInt("defaults.runonlypermutation", -1);
            this.nrThresds = this.config.getInt("defaults.threads", 0);
            this.cis = this.config.getBoolean("defaults.cis", false);
            this.trans = this.config.getBoolean("defaults.trans", false);
            this.probeselection = this.config.getString("defaults.probeselection");
            if (this.probeselection != null && this.probeselection.trim().length() == 0) {
                this.probeselection = null;
            }
            this.snpselection = this.config.getString("defaults.snpselection");
            if (this.snpselection != null && this.snpselection.trim().length() == 0) {
                this.snpselection = null;
            }
            this.snpprobeselection = this.config.getString("defaults.snpprobeselection");
            if (this.snpprobeselection != null && this.snpprobeselection.trim().length() == 0) {
                this.snpprobeselection = null;
            } else {
                System.out.println("SNP PROBE SELECTION: " + this.snpprobeselection);
            }
            int i = 0;
            String dataset = "";
            this.datasetnames = new ArrayList();
            this.datasetlocations = new ArrayList();
            this.datasetannotations = new ArrayList();
            this.datasetPrefix = new ArrayList();
            while (dataset != null) {
                dataset = this.config.getString("datasets.dataset(" + i + ").name");
                if (dataset != null) {
                    this.datasetnames.add(dataset);
                    String prefix = this.config.getString("datasets.dataset(" + i + ").prefix");
                    if (prefix == null) {
                        prefix = "Dataset";
                    }
                    this.datasetPrefix.add(prefix);
                    String datasetlocation = this.config.getString("datasets.dataset(" + i + ").location");
                    if (texttoreplace != null && replacetextwith != null && datasetlocation.contains(texttoreplace)) {
                        datasetlocation = datasetlocation.replace(texttoreplace, replacetextwith);
                    }
                    String datasetannotation = this.config.getString("datasets.dataset(" + i + ").expressionplatform");
                    this.datasetlocations.add(datasetlocation);
                    this.datasetannotations.add(datasetannotation);
                }
                ++i;
            }
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }

    public int getNrPermutations() {
        return this.nrPermutations;
    }

    public void setNrPermutations(int nrPermutations) {
        this.nrPermutations = nrPermutations;
    }

    public boolean isUseAbsoluteZscore() {
        return this.useAbsoluteZscore;
    }

    public void setUseAbsoluteZscore(boolean useAbsoluteZscore) {
        this.useAbsoluteZscore = useAbsoluteZscore;
    }

    public int getFinalEQTLBufferMaxLength() {
        return this.finalEQTLBufferMaxLength;
    }

    public void setFinalEQTLBufferMaxLength(int finalEQTLBufferMaxLength) {
        this.finalEQTLBufferMaxLength = finalEQTLBufferMaxLength;
    }

    public int getNrOfBins() {
        return this.nrOfBins;
    }

    public void setNrOfBins(int nrOfBins) {
        this.nrOfBins = nrOfBins;
    }

    public double getFdrthreshold() {
        return this.fdrthreshold;
    }

    public void setFdrthreshold(double fdrthreshold) {
        this.fdrthreshold = fdrthreshold;
    }

    public boolean isIncludeSNPsWithoutProperMapping() {
        return this.includeSNPsWithoutProperMapping;
    }

    public void setIncludeSNPsWithoutProperMapping(boolean includeSNPsWithoutProperMapping) {
        this.includeSNPsWithoutProperMapping = includeSNPsWithoutProperMapping;
    }

    public boolean isIncludeProbesWithoutProperMapping() {
        return this.includeProbesWithoutProperMapping;
    }

    public void setIncludeProbesWithoutProperMapping(boolean includeProbesWithoutProperMapping) {
        this.includeProbesWithoutProperMapping = includeProbesWithoutProperMapping;
    }

    public boolean isCis() {
        return this.cis;
    }

    public void setCis(boolean cis) {
        this.cis = cis;
    }

    public boolean isTrans() {
        return this.trans;
    }

    public void setTrans(boolean trans) {
        this.trans = trans;
    }

    public int getCisdistance() {
        return this.cisdistance;
    }

    public void setCisdistance(int cisdistance) {
        this.cisdistance = cisdistance;
    }

    public int getTransdistance() {
        return this.transdistance;
    }

    public void setTransdistance(int transdistance) {
        this.transdistance = transdistance;
    }

    public boolean isMakezscoreplot() {
        return this.makezscoreplot;
    }

    public void setMakezscoreplot(boolean makezscoreplot) {
        this.makezscoreplot = makezscoreplot;
    }

    public String getProbetranslationfile() {
        return this.probetranslationfile;
    }

    public void setProbetranslationfile(String probetranslationfile) {
        this.probetranslationfile = probetranslationfile;
    }

    public ArrayList<String> getDatasetnames() {
        return this.datasetnames;
    }

    public void setDatasetnames(ArrayList<String> datasetnames) {
        this.datasetnames = datasetnames;
    }

    public ArrayList<String> getDatasetlocations() {
        return this.datasetlocations;
    }

    public void setDatasetlocations(ArrayList<String> datasetlocations) {
        this.datasetlocations = datasetlocations;
    }

    public ArrayList<String> getDatasetannotations() {
        return this.datasetannotations;
    }

    public void setDatasetannotations(ArrayList<String> datasetannotations) {
        this.datasetannotations = datasetannotations;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public boolean isMakezscoretable() {
        return this.makezscoretable;
    }

    public void setMakezscoretable(boolean makezscoretable) {
        this.makezscoretable = makezscoretable;
    }

    public int getProbeDatasetPresenceThreshold() {
        return this.probeDatasetPresenceThreshold;
    }

    public void setProbeDatasetPresenceThreshold(int probeDatasetPresenceThreshold) {
        this.probeDatasetPresenceThreshold = probeDatasetPresenceThreshold;
    }

    public int getSnpDatasetPresenceThreshold() {
        return this.snpDatasetPresenceThreshold;
    }

    public void setSnpDatasetPresenceThreshold(int snpDatasetPresenceThreshold) {
        this.snpDatasetPresenceThreshold = snpDatasetPresenceThreshold;
    }

    public int getProbeAndSNPPresenceFilterSampleThreshold() {
        return this.probeAndSNPPresenceFilterSampleThreshold;
    }

    public void setProbeAndSNPPresenceFilterSampleThreshold(int probeAndSNPPresenceFilterSampleThreshold) {
        this.probeAndSNPPresenceFilterSampleThreshold = probeAndSNPPresenceFilterSampleThreshold;
    }

    public int getRunonlypermutation() {
        return this.runonlypermutation;
    }

    public void setRunonlypermutation(int runonlypermutation) {
        this.runonlypermutation = runonlypermutation;
    }

    public int getNrThresds() {
        return this.nrThresds;
    }

    public void setNrThresds(int nrThresds) {
        this.nrThresds = nrThresds;
    }

    ArrayList<String> getDatasetPrefix() {
        return this.datasetPrefix;
    }

    public String getProbeselection() {
        return this.probeselection;
    }

    public void setProbeselection(String probeselection) {
        this.probeselection = probeselection;
    }

    public String getSNPSelection() {
        return this.snpselection;
    }

    public String getSNPProbeSelection() {
        return this.snpprobeselection;
    }

    void save() {
        try {
            this.config.save(this.output + "metasettings.xml");
        }
        catch (ConfigurationException ex) {
            Logger.getLogger(MetaSettings.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

