/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.binarymeta.meta;

import eqtlmappingpipeline.binarymeta.meta.MetaAnalysisCalculationThread;
import eqtlmappingpipeline.binarymeta.meta.MetaAnalysisLoaderThread;
import eqtlmappingpipeline.binarymeta.meta.MetaAnalysisResultThread;
import eqtlmappingpipeline.binarymeta.meta.MetaAnalysisWorkPackage;
import eqtlmappingpipeline.binarymeta.meta.MetaSettings;
import eqtlmappingpipeline.binarymeta.meta.PValueThreshold;
import eqtlmappingpipeline.binarymeta.meta.graphics.ZScorePlot;
import eqtlmappingpipeline.metaqtl3.FDR;
import eqtlmappingpipeline.metaqtl3.graphics.EQTLDotPlot;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.zip.DataFormatException;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.EQTL;
import umcg.genetica.io.trityper.bin.BinaryResultDataset;
import umcg.genetica.io.trityper.bin.BinaryResultProbe;
import umcg.genetica.io.trityper.bin.BinaryResultSNP;
import umcg.genetica.io.trityper.probeannotation.ProbeTranslation;
import umcg.genetica.math.stats.Descriptives;

public class MetaAnalyze {
    protected static MetaSettings m_settings;
    protected BinaryResultDataset[] ds;
    protected ArrayList<String> probes;
    protected ArrayList<String> snps;
    protected Integer[][] snpTranslation;
    protected int[] pvaluedistribution;
    protected EQTL[] eQTLBuffer;
    protected EQTL[] finalEQTLBuffer;
    protected int nrInFinalBuffer = 0;
    protected double pvaluethreshold;
    protected ArrayList<Byte> snpChr;
    protected ArrayList<Integer> snpChrPos;
    protected ProbeTranslation probeTranslation;
    protected Integer[][] probeTranslationLookupTable;
    public static String header;
    protected double[] zsumPerSNP;
    protected int[] zsumSNPsNumberOfProbes;
    protected double[] zsumPerProbe;
    protected int[] zsumProbesNumberOfSNPs;
    protected ZScorePlot zs;
    protected TextFile zscoretable;
    protected HashSet<String> uniqueProbes;
    protected HashSet<String> uniqueSNPs;
    protected int nrTotalSamples;
    protected int numSNPs;
    protected int numProbes;
    private HashSet<String> probeListToAnalyze;

    public void init(String settingsFile, String texttoreplace, String replacetextwith) throws IOException {
        m_settings = new MetaSettings();
        m_settings.parse(settingsFile, texttoreplace, replacetextwith);
        this.probeTranslation = new ProbeTranslation();
        this.probeTranslation.load(m_settings.getProbetranslationfile());
    }

    public void analyze() throws IOException, DataFormatException, Exception {
        System.out.println("");
        System.out.println("Starting analysis!");
        String[] datasets = new String[m_settings.getDatasetnames().size()];
        for (int i = 0; i < m_settings.getDatasetnames().size(); ++i) {
            datasets[i] = m_settings.getDatasetnames().get(i);
        }
        if (!m_settings.getOutput().endsWith("/")) {
            m_settings.setOutput(m_settings.getOutput() + "/MetaAnalysis/");
        }
        if (!Gpio.exists(m_settings.getOutput())) {
            Gpio.createDir(m_settings.getOutput());
        }
        m_settings.save();
        String[] locations = new String[m_settings.getDatasetnames().size()];
        for (int i = 0; i < locations.length; ++i) {
            locations[i] = m_settings.getDatasetlocations().get(i);
        }
        int permstart = 0;
        int permstop = m_settings.getNrPermutations() + 1;
        if (m_settings.getRunonlypermutation() > -1) {
            permstart = m_settings.getRunonlypermutation();
            permstop = m_settings.getRunonlypermutation() + m_settings.getNrPermutations();
        }
        for (int perm = permstart; perm < permstop; ++perm) {
            this.ds = new BinaryResultDataset[m_settings.getDatasetlocations().size()];
            this.runCalculationRound(perm, locations, datasets, -1);
        }
        if (m_settings.getRunonlypermutation() == -1 && m_settings.getNrPermutations() > 0) {
            FDR.calculateFDR(m_settings.getOutput(), m_settings.getNrPermutations(), m_settings.getFinalEQTLBufferMaxLength(), m_settings.getFdrthreshold(), true, null, null, FDR.FDRMethod.ALL, true);
            EQTLDotPlot edp = new EQTLDotPlot();
            edp.draw(m_settings.getOutput() + "/eQTLsFDR" + m_settings.getFdrthreshold() + ".txt", m_settings.getOutput() + "/DotPlot-FDR" + m_settings.getFdrthreshold() + ".pdf", EQTLDotPlot.Output.PDF);
            edp = null;
        }
    }

    protected void initdatasets(String[] locations, int perm, int dToUse) throws IOException {
        Integer[] presentNrs;
        int numProbes = this.probeTranslation.getNumProbes();
        System.out.println(numProbes + " probes found in translation table. Now matching probes across datasets..");
        this.probeTranslationLookupTable = new Integer[this.ds.length][numProbes];
        HashSet<Integer> probesPresentInDatasets = new HashSet<Integer>();
        HashSet<String> selectedSNPs = null;
        HashMap<String, HashSet<String>> selectedSNPProbePairs = null;
        if (m_settings.getSNPProbeSelection() != null) {
            System.out.println("Selecting SNP-probe pairs from: " + m_settings.getSNPProbeSelection());
            selectedSNPProbePairs = new HashMap<String, HashSet<String>>();
            selectedSNPs = new HashSet<String>();
            TextFile stf = new TextFile(m_settings.getSNPProbeSelection(), false);
            int ctr = 0;
            String[] felems = stf.readLineElems(TextFile.tab);
            while (felems != null) {
                String snp = felems[0];
                String probe = felems[1];
                HashSet<String> probesForSNP = (HashSet<String>)selectedSNPProbePairs.get(snp);
                if (probesForSNP == null) {
                    probesForSNP = new HashSet<String>();
                }
                probesForSNP.add(probe);
                selectedSNPs.add(snp);
                selectedSNPProbePairs.put(snp, probesForSNP);
                ++ctr;
                felems = stf.readLineElems(TextFile.tab);
            }
            stf.close();
            System.out.println("Selected " + ctr + " unique SNPs from file.");
        }
        HashSet<String> probesToInclude = null;
        if (m_settings.getProbeselection() != null) {
            TextFile tf = new TextFile(m_settings.getProbeselection(), false);
            ArrayList<String> probesSelected = tf.readAsArrayList();
            probesToInclude = new HashSet<String>();
            probesToInclude.addAll(probesSelected);
            System.out.println(probesSelected.size() + " probes selected from file: " + m_settings.getProbeselection());
            tf.close();
        }
        for (int d = 0; d < this.ds.length; ++d) {
            int probeAnnotationToUse = d;
            if (dToUse != -1) {
                probeAnnotationToUse = dToUse;
            }
            this.ds[d] = new BinaryResultDataset(locations[d], m_settings.getDatasetPrefix().get(probeAnnotationToUse), perm);
            BinaryResultProbe[] dsProbes = this.ds[d].getProbes();
            BinaryResultSNP[] dsSNPs = this.ds[d].getSnps();
            this.nrTotalSamples += this.ds[d].getMaxNrSamples();
            for (BinaryResultProbe p : dsProbes) {
                Integer newProbeId = this.probeTranslation.getProbeId(m_settings.getDatasetannotations().get(probeAnnotationToUse) + p.getName());
                if (newProbeId == null) {
                    System.out.println(m_settings.getDatasetannotations().get(probeAnnotationToUse) + "\t" + p.getName() + " probe not present in annotationfile...?");
                    System.exit(0);
                }
                if (probesToInclude == null || probesToInclude.contains("" + newProbeId)) {
                    probesPresentInDatasets.add(newProbeId);
                    this.probeTranslationLookupTable[d][newProbeId.intValue()] = p.getId();
                    continue;
                }
                this.probeTranslationLookupTable[d][newProbeId.intValue()] = null;
            }
            for (BinaryResultSNP s : dsSNPs) {
                if (this.uniqueSNPs.contains(s.getName()) || selectedSNPs != null && !selectedSNPs.contains(s.getName())) continue;
                this.snps.add(s.getName());
                this.snpChr.add(s.getChr());
                this.snpChrPos.add(s.getChrpos());
                this.uniqueSNPs.add(s.getName());
            }
        }
        TextFile probesPresentFile = new TextFile(m_settings.getOutput() + "ProbesPresentInAtLeastOneDataset.txt", true);
        System.out.println(probesPresentInDatasets.size() + "\tunique probes present in all datasets.");
        for (Integer i : presentNrs = probesPresentInDatasets.toArray(new Integer[0])) {
            probesPresentFile.writeln("" + i);
        }
        probesPresentFile.close();
        int selectedprobes = 0;
        for (int q = 0; q < this.probeTranslationLookupTable[0].length; ++q) {
            int d;
            int probePresenceCounter = 0;
            if (this.probeListToAnalyze != null && !this.probeListToAnalyze.contains("" + q)) {
                for (d = 0; d < this.ds.length; ++d) {
                    this.probeTranslationLookupTable[d][q] = null;
                }
            }
            for (int i = 0; i < this.ds.length; ++i) {
                if (this.probeTranslationLookupTable[i][q] == null || this.ds[i].getMaxNrSamples() <= m_settings.getProbeAndSNPPresenceFilterSampleThreshold()) continue;
                ++probePresenceCounter;
            }
            if (m_settings.getProbeDatasetPresenceThreshold() > 0 && probePresenceCounter < m_settings.getProbeDatasetPresenceThreshold()) {
                for (d = 0; d < this.ds.length; ++d) {
                    this.probeTranslationLookupTable[d][q] = null;
                }
                continue;
            }
            if (probePresenceCounter <= 0) continue;
            ++selectedprobes;
        }
        System.out.println("Selected " + selectedprobes + " probes from at least " + m_settings.getProbeDatasetPresenceThreshold() + " datasets of at least " + m_settings.getProbeAndSNPPresenceFilterSampleThreshold() + " samples.");
        this.numSNPs = this.uniqueSNPs.size();
        this.initSNPTranslation();
    }

    protected void initSNPTranslation() throws IOException {
        this.snpTranslation = new Integer[this.ds.length][this.numSNPs];
        for (int d = 0; d < this.ds.length; ++d) {
            BinaryResultProbe[] dsProbes = this.ds[d].getProbes();
            BinaryResultSNP[] dsSNPs = this.ds[d].getSnps();
            for (int i = 0; i < this.snps.size(); ++i) {
                BinaryResultSNP s = this.ds[d].getStringToSNP().get(this.snps.get(i));
                this.snpTranslation[d][i] = s != null ? s.getId() : null;
            }
        }
        int selectedsnps = 0;
        HashSet<String> selectedSNPs = null;
        if (m_settings.getSNPSelection() != null) {
            System.out.println("Selecting SNPs from: " + m_settings.getSNPSelection());
            selectedSNPs = new HashSet<String>();
            TextFile stf = new TextFile(m_settings.getSNPSelection(), false);
            selectedSNPs.addAll(stf.readAsArrayList());
            stf.close();
            System.out.println("Selected " + selectedSNPs.size() + " unique SNPs from file.");
        }
        TextFile selectedSNPFile = new TextFile(m_settings.getOutput() + "/SelectedSNPs.txt", true);
        for (int s = 0; s < this.numSNPs; ++s) {
            int d;
            String snpName = this.snps.get(s);
            int snppresencecounter = 0;
            for (d = 0; d < this.ds.length; ++d) {
                if (this.snpTranslation[d][s] == null || this.ds[d].getMaxNrSamples() < m_settings.getProbeAndSNPPresenceFilterSampleThreshold()) continue;
                ++snppresencecounter;
            }
            if (m_settings.getSnpDatasetPresenceThreshold() > 0 && snppresencecounter < m_settings.getSnpDatasetPresenceThreshold() || selectedSNPs != null && !selectedSNPs.contains(snpName)) {
                for (d = 0; d < this.ds.length; ++d) {
                    this.snpTranslation[d][s] = null;
                }
                continue;
            }
            if (snppresencecounter <= 0) continue;
            selectedSNPFile.writeln(this.snps.get(s));
            ++selectedsnps;
        }
        selectedSNPFile.close();
        System.out.println("Selected " + selectedsnps + " snps from at least " + m_settings.getSnpDatasetPresenceThreshold() + " datasets of at least " + m_settings.getProbeAndSNPPresenceFilterSampleThreshold() + " samples.");
    }

    protected void runCalculationRound(int perm, String[] locations, String[] datasets, int dToUse) throws IOException, Exception {
        this.pvaluedistribution = null;
        this.eQTLBuffer = null;
        this.finalEQTLBuffer = null;
        this.nrInFinalBuffer = 0;
        this.uniqueProbes = new HashSet();
        this.uniqueSNPs = new HashSet();
        int numDatasets = this.ds.length;
        this.probes = new ArrayList();
        this.snps = new ArrayList();
        this.snpChr = new ArrayList();
        this.snpChrPos = new ArrayList();
        this.nrTotalSamples = 0;
        String[] probeName = this.probeTranslation.getProbes();
        this.probes.addAll(Arrays.asList(probeName));
        this.initdatasets(locations, perm, dToUse);
        String zsName = null;
        if (m_settings.isMakezscoreplot()) {
            this.zs = new ZScorePlot();
            String[] datasets2 = new String[datasets.length + 1];
            System.arraycopy(datasets, 0, datasets2, 0, datasets.length);
            datasets2[datasets2.length - 1] = "Meta-Analysis";
            zsName = perm > 0 ? m_settings.getOutput() + "ZScoreComparison-PermutationRound" + perm : m_settings.getOutput() + "ZScoreComparison";
            this.zs.init(numDatasets + 1, datasets2, true, zsName);
        }
        Descriptives.lookupSqrt(this.nrTotalSamples);
        this.pvaluedistribution = new int[m_settings.getNrOfBins()];
        this.eQTLBuffer = new EQTL[10000];
        this.finalEQTLBuffer = new EQTL[0];
        this.pvaluethreshold = Double.MAX_VALUE;
        this.zsumPerSNP = new double[this.snps.size()];
        this.zsumSNPsNumberOfProbes = new int[this.snps.size()];
        this.zsumPerProbe = new double[this.probes.size()];
        this.zsumProbesNumberOfSNPs = new int[this.probes.size()];
        System.out.println("Performing the meta-analysis now: ");
        System.out.println(this.nrTotalSamples + "\t total samples");
        if (m_settings.isMakezscoretable()) {
            this.zscoretable = perm == 0 ? new TextFile(m_settings.getOutput() + "metazscoretable.txt.gz", true, 0xA00000) : new TextFile(m_settings.getOutput() + "metazscoretable-Permutation" + perm + ".txt.gz", true, 0xA00000);
            StringBuilder zscoreout = new StringBuilder();
            zscoreout.append("SNP\tAlleleCoding\tAssessedAllele");
            for (int i = 0; i < this.probes.size(); ++i) {
                zscoreout.append("\t").append(this.probes.get(i));
            }
            this.zscoretable.writeln(zscoreout.toString());
        }
        HashMap<String, HashSet<String>> selectedSNPProbePairs = null;
        if (m_settings.getSNPProbeSelection() != null) {
            System.out.println("Selecting SNP-probe pairs from: " + m_settings.getSNPProbeSelection());
            selectedSNPProbePairs = new HashMap<String, HashSet<String>>();
            TextFile stf = new TextFile(m_settings.getSNPProbeSelection(), false);
            int ctr = 0;
            String[] felems = stf.readLineElems(TextFile.tab);
            while (felems != null) {
                String snp = felems[0];
                String probe = felems[1];
                HashSet<String> probesForSNP = (HashSet<String>)selectedSNPProbePairs.get(snp);
                if (probesForSNP == null) {
                    probesForSNP = new HashSet<String>();
                }
                probesForSNP.add(probe);
                selectedSNPProbePairs.put(snp, probesForSNP);
                ++ctr;
                felems = stf.readLineElems(TextFile.tab);
            }
            stf.close();
            System.out.println("Selected " + ctr + " unique SNPs from file.");
        }
        int nrProcs = Runtime.getRuntime().availableProcessors();
        if (m_settings.getNrThresds() > 0) {
            if (m_settings.getNrThresds() > nrProcs) {
                m_settings.setNrThresds(nrProcs);
            }
            nrProcs = m_settings.getNrThresds();
        }
        System.out.println("Using " + nrProcs + " threads :)");
        MetaAnalysisCalculationThread[] calcPool = new MetaAnalysisCalculationThread[nrProcs];
        LinkedBlockingQueue<MetaAnalysisWorkPackage> loaderQueue = new LinkedBlockingQueue<MetaAnalysisWorkPackage>(nrProcs);
        MetaAnalysisLoaderThread loaderThread = new MetaAnalysisLoaderThread(loaderQueue, this.snpTranslation, this.snps, this.ds);
        loaderThread.setName("Loader");
        loaderThread.start();
        PValueThreshold p = new PValueThreshold();
        LinkedBlockingQueue<MetaAnalysisWorkPackage> resultQueue = new LinkedBlockingQueue<MetaAnalysisWorkPackage>(nrProcs);
        MetaAnalysisResultThread resultThread = new MetaAnalysisResultThread(resultQueue, m_settings, datasets, perm, this.zscoretable, p, this.snps, selectedSNPProbePairs, this.probes);
        resultThread.setName("Result");
        resultThread.start();
        for (int i = 0; i < nrProcs; ++i) {
            calcPool[i] = new MetaAnalysisCalculationThread(loaderQueue, resultQueue, this.snps, this.probes, this.snpChr, this.snpChrPos, this.ds, this.snpTranslation, this.probeTranslationLookupTable, this.probeTranslation, m_settings, this.zs, p);
            calcPool[i].setName("MetaCalc-" + i);
            calcPool[i].start();
        }
        try {
            int threadNum;
            loaderThread.join();
            MetaAnalysisWorkPackage poison = new MetaAnalysisWorkPackage(0, 0);
            poison.poisonTheWell();
            for (threadNum = 0; threadNum < calcPool.length; ++threadNum) {
                try {
                    loaderQueue.put(poison);
                    continue;
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            for (threadNum = 0; threadNum < calcPool.length; ++threadNum) {
                calcPool[threadNum].join();
            }
            resultQueue.put(poison);
            resultThread.join();
        }
        catch (InterruptedException e) {
            System.err.println("Exception: Thread main interrupted.");
        }
        if (m_settings.isMakezscoretable()) {
            this.zscoretable.close();
        }
        if (this.zs != null) {
            this.zs.write(zsName);
        }
    }

    static {
        header = "PValue\tSNPName\tSNPChr\tSNPChrPos\tProbeName\tProbeChr\tProbeCenterChrPos\tCisTrans\tSNPType\tAlleleAssessed\tOverallZScore\tDatasetsWhereSNPProbePairIsAvailableAndPassesQC\tDatasetsZScores\tDatasetsNrSamples\tIncludedDatasetsMeanProbeExpression\tIncludedDatasetsProbeExpressionVariance\tHGNCName\tIncludedDatasetsCorrelationCoefficient";
    }
}

