/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.binarymeta.meta;

import java.util.HashSet;
import umcg.genetica.io.trityper.EQTL;
import umcg.genetica.io.trityper.bin.BinaryResultSNP;

public class MetaAnalysisWorkPackage
implements Comparable<MetaAnalysisWorkPackage> {
    private boolean poison = false;
    private EQTL[] result;
    private byte[][] datasetdata;
    private int sortForDataset = 0;
    private Integer[] snpids;
    private BinaryResultSNP[] snpObjects;
    private int snpNumber;
    private String zscoretabeline;
    private int numberOfTestedProbes;
    private Integer[] testedProbesList;
    private boolean passedQC;

    public MetaAnalysisWorkPackage(int snpnumber, int numDatasets) {
        this.snpNumber = snpnumber;
        this.snpids = new Integer[numDatasets];
        this.snpObjects = new BinaryResultSNP[numDatasets];
        this.datasetdata = new byte[numDatasets][0];
    }

    boolean getPoison() {
        return this.poison;
    }

    public void setSNPObject(int d, BinaryResultSNP snpObj) {
        this.snpObjects[d] = snpObj;
    }

    public BinaryResultSNP getSNPObject(int d) {
        return this.snpObjects[d];
    }

    public void setResult(EQTL[] result) {
        this.result = result;
    }

    public void poisonTheWell() {
        this.poison = true;
    }

    public EQTL[] getResult() {
        return this.result;
    }

    public Integer getSNPId(int d) {
        return this.snpids[d];
    }

    @Override
    public int compareTo(MetaAnalysisWorkPackage o) {
        Integer otherSNPId = o.getSNPId(this.sortForDataset);
        Integer currentSNPId = this.snpids[this.sortForDataset];
        if (currentSNPId != null && otherSNPId != null) {
            return currentSNPId - otherSNPId;
        }
        if (currentSNPId == null) {
            return Integer.MAX_VALUE;
        }
        return Integer.MIN_VALUE;
    }

    public boolean equals(MetaAnalysisWorkPackage o) {
        Integer otherSNPId = o.getSNPId(this.sortForDataset);
        Integer currentSNPId = this.snpids[this.sortForDataset];
        if (currentSNPId != null && otherSNPId != null) {
            return currentSNPId.equals(otherSNPId);
        }
        return false;
    }

    public void setSNPId(int d, Integer snpid) {
        this.snpids[d] = snpid;
    }

    public void setSortByDataset(int d) {
        this.sortForDataset = d;
    }

    public byte[] getData(int d) {
        return this.datasetdata[d];
    }

    public void setData(int d, byte[] datasetdata) {
        this.datasetdata[d] = datasetdata;
    }

    public int getSNPNum() {
        return this.snpNumber;
    }

    public void setZScoreOut(String toString) {
        this.zscoretabeline = toString;
    }

    public String getZScoreOut() {
        return this.zscoretabeline;
    }

    public void clearData() {
        int i;
        for (i = 0; i < this.result.length; ++i) {
            this.result[i] = null;
        }
        this.result = null;
        for (i = 0; i < this.snpObjects.length; ++i) {
            this.snpids[i] = null;
            this.snpObjects[i] = null;
        }
        this.snpids = null;
    }

    public void clearByteData() {
        for (int i = 0; i < this.snpObjects.length; ++i) {
            this.datasetdata[i] = null;
        }
        this.datasetdata = null;
    }

    void setNumOfTestedProbes(int probesTested) {
        this.numberOfTestedProbes = probesTested;
    }

    public int getNumberOfTestedProbes() {
        return this.numberOfTestedProbes;
    }

    public void setProbesTestedHash(HashSet<Integer> probesTestedHash) {
        this.testedProbesList = probesTestedHash.toArray(new Integer[0]);
    }

    public Integer[] getListOfTestedProbes() {
        return this.testedProbesList;
    }

    public boolean getPassedQC() {
        return this.passedQC;
    }

    public void setPassedQC(boolean b) {
        this.passedQC = b;
    }
}

