/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.binarymeta.meta;

import eqtlmappingpipeline.binarymeta.meta.MetaAnalysisWorkPackage;
import eqtlmappingpipeline.binarymeta.meta.MetaSettings;
import eqtlmappingpipeline.binarymeta.meta.PValueThreshold;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.LinkedBlockingQueue;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.EQTL;

public class MetaAnalysisResultThread
extends Thread {
    private final LinkedBlockingQueue<MetaAnalysisWorkPackage> m_queue_input;
    private static String header = "PValue\tSNPName\tSNPChr\tSNPChrPos\tProbeName\tProbeChr\tProbeCenterChrPos\tCisTrans\tSNPType\tAlleleAssessed\tOverallZScore\tDatasetsWhereSNPProbePairIsAvailableAndPassesQC\tDatasetsZScores\tDatasetsNrSamples\tIncludedDatasetsMeanProbeExpression\tIncludedDatasetsProbeExpressionVariance\tHGNCName\tIncludedDatasetsCorrelationCoefficient";
    private int ctr = 0;
    private EQTL[] eQTLBuffer = new EQTL[100000];
    private EQTL[] finalEQTLBuffer = new EQTL[0];
    private int nrInFinalBuffer = 0;
    private static MetaSettings m_settings;
    private int perm;
    private String[] datasets;
    private final TextFile zscoretable;
    private final PValueThreshold pvaluethreshold;
    private final ArrayList<String> snps;
    private final HashMap<String, HashSet<String>> snpProbeSelection;
    private final ArrayList<String> probes;
    TextFile snpout = null;
    private HashSet<String> uniqueSNPs = new HashSet();
    private HashSet<String> uniqueSNPsNotPassingQC = new HashSet();
    private HashSet<Integer> uniqueProbes = new HashSet();
    private int totalNumberOfEQTLs = 0;

    public MetaAnalysisResultThread(LinkedBlockingQueue<MetaAnalysisWorkPackage> input, MetaSettings m_settings, String[] datasets, int perm, TextFile zscoretable, PValueThreshold p, ArrayList<String> snps, HashMap<String, HashSet<String>> snpProbeSelection, ArrayList<String> probes) {
        MetaAnalysisResultThread.m_settings = m_settings;
        this.datasets = datasets;
        this.perm = perm;
        this.zscoretable = zscoretable;
        this.pvaluethreshold = p;
        this.m_queue_input = input;
        this.snps = snps;
        this.snpProbeSelection = snpProbeSelection;
        this.probes = probes;
    }

    @Override
    public void run() {
        boolean poison = false;
        try {
            this.snpout = new TextFile(m_settings.getOutput() + "snpsandnreqtls.txt", true);
            while (!poison) {
                try {
                    MetaAnalysisWorkPackage pack = this.m_queue_input.take();
                    if (!pack.getPoison()) {
                        Integer snpnum = pack.getSNPNum();
                        String snp = this.snps.get(snpnum);
                        if (this.snpProbeSelection != null && !this.snpProbeSelection.containsKey(snp)) continue;
                        this.analyze(pack);
                        continue;
                    }
                    poison = pack.getPoison();
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            if (this.ctr > 0) {
                this.mergebuffers(this.ctr);
            }
            this.snpout.close();
            this.writeresults();
            TextFile out = new TextFile(m_settings.getOutput() + "/NumberOfEQTLSTotal.txt", true);
            out.writeln("Number of eQTLs in total: " + this.totalNumberOfEQTLs);
            System.out.println("Number of eQTLs in total: " + this.totalNumberOfEQTLs);
            out.writeln("Number of snps in total: " + this.uniqueSNPs.size());
            out.writeln("Number of snps in total not passing QC: " + this.uniqueSNPsNotPassingQC.size());
            System.out.println("Number of snps in total: " + this.uniqueSNPs.size());
            TextFile out2 = new TextFile(m_settings.getOutput() + "/TestedSNPs.txt", true);
            ArrayList<String> list = new ArrayList<String>(this.uniqueSNPs);
            out2.writeList(list);
            out2.close();
            out2 = new TextFile(m_settings.getOutput() + "/TestedSNPsNPQC.txt", true);
            list = new ArrayList<String>(this.uniqueSNPsNotPassingQC);
            out2.writeList(list);
            out.writeln("Number of probes in total: " + this.uniqueProbes.size());
            System.out.println("Number of probes in total: " + this.uniqueProbes.size());
            out2 = new TextFile(m_settings.getOutput() + "/TestedProbes.txt", true);
            ArrayList<Integer> list2 = new ArrayList<Integer>(this.uniqueProbes);
            ArrayList<String> list2str = new ArrayList<String>();
            for (Integer i : list2) {
                list2str.add("" + i);
            }
            out2.writeList(list2str);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void analyze(MetaAnalysisWorkPackage pack) {
        Integer snpnum = pack.getSNPNum();
        String snp = this.snps.get(snpnum);
        HashSet<String> allowedProbes = null;
        if (this.snpProbeSelection != null) {
            allowedProbes = this.snpProbeSelection.get(snp);
        }
        Integer[] probeList = pack.getListOfTestedProbes();
        for (int i = 0; i < probeList.length; ++i) {
            String probe = this.probes.get(probeList[i]);
            if (allowedProbes != null && !allowedProbes.contains(probe)) continue;
            ++this.totalNumberOfEQTLs;
            this.uniqueProbes.add(probeList[i]);
        }
        if (pack.getPassedQC()) {
            this.uniqueSNPs.add(this.snps.get(snpnum));
        } else {
            this.uniqueSNPsNotPassingQC.add(this.snps.get(snpnum));
        }
        if (m_settings.isMakezscoretable() && this.zscoretable != null) {
            try {
                String zscoreout = pack.getZScoreOut();
                if (zscoreout != null) {
                    this.zscoretable.writeln(zscoreout);
                    pack.setZScoreOut(null);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        EQTL[] finalEQTLs = pack.getResult();
        int nreQTLsForSNP = 0;
        for (int p = 0; p < finalEQTLs.length; ++p) {
            if (finalEQTLs[p] != null && finalEQTLs[p].getPvalue() <= this.pvaluethreshold.getPvalue() && (allowedProbes == null || allowedProbes.contains(finalEQTLs[p].getProbe()))) {
                ++nreQTLsForSNP;
                this.eQTLBuffer[this.ctr] = finalEQTLs[p];
                ++this.ctr;
                if (this.ctr != this.eQTLBuffer.length) continue;
                this.mergebuffers(this.ctr);
                this.ctr = 0;
                continue;
            }
            if (finalEQTLs[p] == null) continue;
            finalEQTLs[p].clearData();
            finalEQTLs[p] = null;
        }
        finalEQTLs = null;
        try {
            this.snpout.writeln(this.snps.get(pack.getSNPNum()) + "\t" + nreQTLsForSNP);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pack.clearData();
        pack = null;
    }

    protected void mergebuffers(int ctr) {
        EQTL[] toMerge = null;
        if (ctr < this.eQTLBuffer.length) {
            toMerge = new EQTL[ctr];
            System.arraycopy(this.eQTLBuffer, 0, toMerge, 0, ctr);
        } else {
            toMerge = this.eQTLBuffer;
        }
        Object[] tmp = new EQTL[this.finalEQTLBuffer.length + toMerge.length];
        System.arraycopy(toMerge, 0, tmp, 0, toMerge.length);
        System.arraycopy(this.finalEQTLBuffer, 0, tmp, toMerge.length, this.finalEQTLBuffer.length);
        Arrays.sort(tmp);
        this.nrInFinalBuffer += toMerge.length;
        if (this.nrInFinalBuffer < m_settings.getFinalEQTLBufferMaxLength()) {
            this.finalEQTLBuffer = tmp;
        } else {
            this.finalEQTLBuffer = new EQTL[m_settings.getFinalEQTLBufferMaxLength()];
            System.arraycopy(tmp, 0, this.finalEQTLBuffer, 0, m_settings.getFinalEQTLBufferMaxLength());
            this.nrInFinalBuffer = m_settings.getFinalEQTLBufferMaxLength();
            this.pvaluethreshold.setPvalue(this.finalEQTLBuffer[this.nrInFinalBuffer - 1].getPvalue());
        }
    }

    private void writeresults() throws IOException {
        TextFile out = null;
        out = this.perm > 0 ? new TextFile(m_settings.getOutput() + "PermutedEQTLsPermutationRound" + this.perm + ".txt.gz", true) : new TextFile(m_settings.getOutput() + "eQTLs.txt", true);
        out.write(header + "\n");
        for (int i = 0; i < this.finalEQTLBuffer.length; ++i) {
            this.finalEQTLBuffer[i].setDatasets(this.datasets);
            out.writeln(this.finalEQTLBuffer[i].toString());
        }
        out.close();
        TextFile oppositeEffects = null;
        oppositeEffects = this.perm > 0 ? new TextFile(m_settings.getOutput() + "OppositeEffects-PermutedEQTLsPermutationRound" + this.perm + ".txt.gz", true) : new TextFile(m_settings.getOutput() + "OppositeEffects-eQTLs.txt", true);
        for (int i = 0; i < this.finalEQTLBuffer.length; ++i) {
            String oppositeEffectIndicator = "";
            double pValueOverall = this.finalEQTLBuffer[i].getPvalue();
            double pValueAbs = this.finalEQTLBuffer[i].getPvalueAbs();
            if (!(pValueAbs < pValueOverall)) continue;
            oppositeEffectIndicator = "OppositeEffect";
            if (pValueAbs <= pValueOverall / 100000.0) {
                oppositeEffectIndicator = "StrongOppositeEffect";
            }
            oppositeEffects.writeln(oppositeEffectIndicator + "\t" + pValueAbs + "\t" + this.finalEQTLBuffer[i].getZscoreAbs() + "\t" + this.finalEQTLBuffer[i].toString());
        }
        oppositeEffects.close();
    }
}

