/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.binarymeta.meta;

import eqtlmappingpipeline.binarymeta.meta.MetaAnalysisCalculationThread;
import eqtlmappingpipeline.binarymeta.meta.MetaAnalysisWorkPackage;
import eqtlmappingpipeline.binarymeta.meta.MetaSettings;
import eqtlmappingpipeline.binarymeta.meta.PValueThreshold;
import eqtlmappingpipeline.binarymeta.meta.graphics.ZScorePlot;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import umcg.genetica.io.trityper.EQTL;
import umcg.genetica.io.trityper.bin.BinaryResultDataset;
import umcg.genetica.io.trityper.bin.BinaryResultSNP;
import umcg.genetica.io.trityper.probeannotation.ProbeTranslation;
import umcg.genetica.math.stats.Descriptives;

public class MetaAnalysisPlotThread
extends MetaAnalysisCalculationThread {
    public MetaAnalysisPlotThread(LinkedBlockingQueue<MetaAnalysisWorkPackage> input, LinkedBlockingQueue<MetaAnalysisWorkPackage> output, ArrayList<String> snps, ArrayList<String> probes, ArrayList<Byte> snpChr, ArrayList<Integer> snpChrPos, BinaryResultDataset[] ds, Integer[][] snpTranslation, Integer[][] probeTranslationLookupTable, ProbeTranslation probeTranslation, MetaSettings m_settings, ZScorePlot zs, PValueThreshold p) {
        super(input, output, snps, probes, snpChr, snpChrPos, ds, snpTranslation, probeTranslationLookupTable, probeTranslation, m_settings, zs, p);
    }

    @Override
    protected void analyze(MetaAnalysisWorkPackage pack) {
        int s = pack.getSNPNum();
        int[] totalNrSamples = new int[this.probes.size()];
        double[] zSum = new double[this.probes.size()];
        double[] zSumAbsolute = new double[this.probes.size()];
        int[] dsPassQC = new int[this.probes.size()];
        boolean[] zscoreflipped = new boolean[this.ds.length];
        EQTL[] result = new EQTL[this.probes.size()];
        BinaryResultSNP firstSNPPassingQC = null;
        Byte snpchr = (Byte)this.snpChr.get(s);
        Integer snpchrpos = (Integer)this.snpChrPos.get(s);
        boolean snphaspropermapping = true;
        if (snpchr == null || snpchrpos == null || snpchr == -1) {
            snpchr = -1;
            snpchrpos = -1;
            snphaspropermapping = false;
        }
        int numDSPassingQC = 0;
        boolean[] testprobes = new boolean[this.probes.size()];
        for (int p = 0; p < this.probes.size(); ++p) {
            byte probechr = this.probeTranslation.getProbeChr(p);
            int probechrpos = this.probeTranslation.getProbeChrPos(p);
            boolean testprobe = false;
            if (this.m_settings.isCis() && this.m_settings.isTrans()) {
                testprobe = true;
            } else if (this.m_settings.isCis() && !this.m_settings.isTrans()) {
                testprobe = snpchr < 1 || probechr < 1 ? false : (probechr == snpchr ? Math.abs(snpchrpos - probechrpos) < this.m_settings.getCisdistance() : false);
            } else if (!this.m_settings.isCis() && this.m_settings.isTrans()) {
                testprobe = snpchr < 1 || probechr < 1 ? false : (probechr == snpchr ? Math.abs(snpchrpos - probechrpos) > this.m_settings.getTransdistance() : true);
            }
            testprobes[p] = testprobe;
        }
        boolean[] dsPassQCForProbe = new boolean[this.ds.length];
        double[][] zScoreForProbe = new double[this.ds.length][this.probes.size()];
        for (int d = 0; d < this.ds.length; ++d) {
            Integer snpId = this.snpTranslation[d][s];
            if (snpId == null) continue;
            BinaryResultSNP snpObject = pack.getSNPObject(d);
            byte[] data = pack.getData(d);
            Float[] zscores = null;
            if (data == null) continue;
            try {
                zscores = this.inflate(data, this.ds[d].getNumProbes());
                pack.setData(d, null);
            }
            catch (DataFormatException ex) {
                Logger.getLogger(MetaAnalysisCalculationThread.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (zscores == null) continue;
            ++numDSPassingQC;
            dsPassQCForProbe[d] = true;
            int nrSamples = snpObject.getNumsamples();
            double weight = Descriptives.getSqrt(nrSamples);
            for (int p = 0; p < this.probes.size(); ++p) {
                boolean testprobe = testprobes[p];
                if (!testprobe) continue;
                Integer probeId = this.probeTranslationLookupTable[d][p];
                if (!testprobe && probeId != null) {
                    zscores[probeId.intValue()] = null;
                    continue;
                }
                if (probeId == null || !testprobe || zscores[probeId] == null) continue;
                int n = p;
                totalNrSamples[n] = totalNrSamples[n] + nrSamples;
                double zscore = zscores[probeId].floatValue();
                int n2 = p;
                dsPassQC[n2] = dsPassQC[n2] + 1;
                if (firstSNPPassingQC == null) {
                    firstSNPPassingQC = snpObject;
                } else {
                    Boolean flipalleles = this.flipalleles(firstSNPPassingQC, snpObject);
                    if (flipalleles == null) {
                        System.err.println("ERROR! SNP alleles cannot be matched for snp\t" + snpObject.getName() + "\tin dataset\t" + d);
                        System.err.println("This SNP will be excluded from further research");
                    } else if (flipalleles.booleanValue()) {
                        zscore = -zscore;
                        zscoreflipped[d] = true;
                    }
                }
                zScoreForProbe[d][p] = zscore;
                int n3 = p;
                zSumAbsolute[n3] = zSumAbsolute[n3] + Math.abs(zscore * weight);
                int n4 = p;
                zSum[n4] = zSum[n4] + zscore * weight;
            }
            for (int i = 0; i < zscores.length; ++i) {
                zscores[i] = null;
            }
        }
        pack.clearByteData();
        if (numDSPassingQC > 0) {
            Double[] metaZPerProbe = null;
            if (this.m_settings.isMakezscoretable()) {
                metaZPerProbe = new Double[this.probes.size()];
            }
            for (int p = 0; p < this.probes.size(); ++p) {
                if (dsPassQC[p] <= 0 || totalNrSamples[p] <= 0) continue;
                double zSumVal = zSum[p];
                double sqrtSample = Descriptives.getSqrt(totalNrSamples[p]);
                double zScore = zSumVal / sqrtSample;
                double pValueOverall = Descriptives.convertZscoreToPvalue(zScore);
                double zSumValAbsolute = zSumAbsolute[p];
                double zScoreAbs = zSumValAbsolute / sqrtSample;
                double pValueOverallAbs = Descriptives.convertZscoreToPvalue(zScoreAbs);
                result[p] = new EQTL();
                if (!(pValueOverallAbs < 1.0)) continue;
                for (int d1 = 0; d1 < this.ds.length; ++d1) {
                    boolean ds1PassesQC = dsPassQCForProbe[d1];
                    if (!ds1PassesQC) continue;
                    double zscore = zScoreForProbe[p][d1];
                    for (int d2 = d1 + 1; d2 < this.ds.length; ++d2) {
                        if (!dsPassQCForProbe[d2]) continue;
                        double zscore2 = zScoreForProbe[p][d2];
                        if (this.zs == null || !(pValueOverall < 1.0E-20)) continue;
                        this.zs.draw(zscore, zscore2, d1, d2);
                    }
                    if (this.zs == null || !(pValueOverall < 1.0E-20)) continue;
                    this.zs.draw(zscore, zScore, d1, this.ds.length);
                }
            }
        }
    }
}

