/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.binarymeta.meta;

import eqtlmappingpipeline.binarymeta.meta.MetaAnalysisWorkPackage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.LinkedBlockingQueue;
import umcg.genetica.console.ProgressBar;
import umcg.genetica.io.trityper.bin.BinaryResultDataset;
import umcg.genetica.io.trityper.bin.BinaryResultSNP;

public class MetaAnalysisLoaderThread
extends Thread {
    private final LinkedBlockingQueue<MetaAnalysisWorkPackage> m_queue_output;
    private ArrayList<String> snps;
    protected Integer[][] snpTranslation;
    protected BinaryResultDataset[] ds;

    public MetaAnalysisLoaderThread(LinkedBlockingQueue<MetaAnalysisWorkPackage> output, Integer[][] snpTranslation, ArrayList<String> snps, BinaryResultDataset[] ds) {
        this.snps = snps;
        this.ds = ds;
        this.snpTranslation = snpTranslation;
        this.m_queue_output = output;
    }

    @Override
    public void run() {
        int buffersize = 8;
        ProgressBar pb = new ProgressBar(this.snps.size());
        for (int snpsprocessed = 0; snpsprocessed < this.snps.size(); snpsprocessed += buffersize) {
            if (snpsprocessed + buffersize > this.snps.size()) {
                buffersize = this.snps.size() - snpsprocessed;
            }
            Object[] buffer = new MetaAnalysisWorkPackage[buffersize];
            int bufferpos = 0;
            for (int s = snpsprocessed; s < snpsprocessed + buffersize; ++s) {
                buffer[bufferpos] = new MetaAnalysisWorkPackage(s, this.ds.length);
                for (int d = 0; d < this.ds.length; ++d) {
                    Integer snpid = this.snpTranslation[d][s];
                    ((MetaAnalysisWorkPackage)buffer[bufferpos]).setSNPId(d, snpid);
                }
                ++bufferpos;
            }
            bufferpos = 0;
            for (int d = 0; d < this.ds.length; ++d) {
                int b;
                for (b = 0; b < buffersize; ++b) {
                    ((MetaAnalysisWorkPackage)buffer[b]).setSortByDataset(d);
                }
                Arrays.sort(buffer);
                for (b = 0; b < buffersize; ++b) {
                    Integer snpidtoload = ((MetaAnalysisWorkPackage)buffer[b]).getSNPId(d);
                    if (snpidtoload == null) continue;
                    BinaryResultSNP snpObject = this.ds[d].getSnps()[snpidtoload];
                    ((MetaAnalysisWorkPackage)buffer[b]).setSNPObject(d, snpObject);
                    long pointer = snpObject.getzScoreIndex();
                    long nextpointer = -1L;
                    if (snpidtoload + 1 < this.ds[d].getSnps().length) {
                        BinaryResultSNP snpObject2 = this.ds[d].getSnps()[snpidtoload + 1];
                        nextpointer = snpObject2.getzScoreIndex();
                    }
                    try {
                        byte[] datasetdata = this.ds[d].getMatrix().readDeflated(pointer, nextpointer, this.ds[d].getNumProbes());
                        ((MetaAnalysisWorkPackage)buffer[b]).setData(d, datasetdata);
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            for (int b = 0; b < buffersize; ++b) {
                try {
                    this.m_queue_output.put((MetaAnalysisWorkPackage)buffer[b]);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                pb.set(snpsprocessed + b);
            }
        }
        pb.close();
        System.out.println("done loading... ");
    }
}

