/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.binarymeta.meta;

import eqtlmappingpipeline.binarymeta.meta.MetaAnalysisWorkPackage;
import eqtlmappingpipeline.binarymeta.meta.MetaSettings;
import eqtlmappingpipeline.binarymeta.meta.PValueThreshold;
import eqtlmappingpipeline.binarymeta.meta.Result;
import eqtlmappingpipeline.binarymeta.meta.graphics.ZScorePlot;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import umcg.genetica.io.trityper.EQTL;
import umcg.genetica.io.trityper.bin.BinaryResultDataset;
import umcg.genetica.io.trityper.bin.BinaryResultSNP;
import umcg.genetica.io.trityper.probeannotation.ProbeTranslation;
import umcg.genetica.io.trityper.util.BaseAnnot;
import umcg.genetica.math.stats.Descriptives;

public class MetaAnalysisCalculationThread
extends Thread {
    protected LinkedBlockingQueue<MetaAnalysisWorkPackage> m_queue_input;
    protected LinkedBlockingQueue<MetaAnalysisWorkPackage> m_queue_output;
    protected ArrayList<String> probes;
    protected ArrayList<String> snps;
    protected ArrayList<Byte> snpChr;
    protected ArrayList<Integer> snpChrPos;
    protected BinaryResultDataset[] ds;
    protected Integer[][] snpTranslation;
    protected Integer[][] probeTranslationLookupTable;
    protected ProbeTranslation probeTranslation;
    protected MetaSettings m_settings;
    protected ZScorePlot zs;
    protected Inflater inflater = new Inflater();
    protected PValueThreshold pvaluethreshold;
    private int numEffects = 0;
    private int numSNPs = 0;

    public MetaAnalysisCalculationThread(LinkedBlockingQueue<MetaAnalysisWorkPackage> input, LinkedBlockingQueue<MetaAnalysisWorkPackage> output, ArrayList<String> snps, ArrayList<String> probes, ArrayList<Byte> snpChr, ArrayList<Integer> snpChrPos, BinaryResultDataset[] ds, Integer[][] snpTranslation, Integer[][] probeTranslationLookupTable, ProbeTranslation probeTranslation, MetaSettings m_settings, ZScorePlot zs, PValueThreshold p) {
        this.probes = probes;
        this.snps = snps;
        this.snpChr = snpChr;
        this.snpChrPos = snpChrPos;
        this.snpTranslation = snpTranslation;
        this.ds = ds;
        this.probeTranslation = probeTranslation;
        this.probeTranslationLookupTable = probeTranslationLookupTable;
        this.m_settings = m_settings;
        this.zs = zs;
        this.pvaluethreshold = p;
        this.m_queue_input = input;
        this.m_queue_output = output;
    }

    @Override
    public void run() {
        boolean poison = false;
        while (!poison) {
            try {
                MetaAnalysisWorkPackage pack = this.m_queue_input.take();
                poison = pack.getPoison();
                if (poison) continue;
                this.analyze(pack);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        System.out.println(this.getName() + " - Poisoned - Num tests passed QC: " + this.numEffects + "\t" + this.numSNPs);
    }

    protected void analyze(MetaAnalysisWorkPackage pack) {
        int s = pack.getSNPNum();
        int[] totalNrSamples = new int[this.probes.size()];
        double[] zSum = new double[this.probes.size()];
        double[] zSumAbsolute = new double[this.probes.size()];
        int[] dsPassQC = new int[this.probes.size()];
        Result r = new Result();
        r.finalzscores = new Double[this.probes.size()];
        r.finalpvalues = new Double[this.probes.size()];
        r.numSamples = new Integer[this.probes.size()][this.ds.length];
        r.datasetZScores = new Double[this.probes.size()][this.ds.length];
        r.dspassingqc = new boolean[this.probes.size()][this.ds.length];
        r.snp = s;
        r.passesQC = true;
        r.datasets = new String[this.ds.length];
        boolean[] zscoreflipped = new boolean[this.ds.length];
        EQTL[] result = new EQTL[this.probes.size()];
        BinaryResultSNP firstSNPPassingQC = null;
        Byte snpchr = this.snpChr.get(s);
        Integer snpchrpos = this.snpChrPos.get(s);
        boolean snphaspropermapping = true;
        if (snpchr == null || snpchrpos == null || snpchr == -1) {
            snpchr = -1;
            snpchrpos = -1;
            snphaspropermapping = false;
        }
        StringBuilder zscoretableout = new StringBuilder();
        int numDSPassingQC = 0;
        HashSet<Integer> probesTestedHash = new HashSet<Integer>();
        boolean[] testprobes = new boolean[this.probes.size()];
        for (int p = 0; p < this.probes.size(); ++p) {
            byte probechr = this.probeTranslation.getProbeChr(p);
            int probechrpos = this.probeTranslation.getProbeChrPos(p);
            boolean testprobe = false;
            if (this.m_settings.isCis() && this.m_settings.isTrans()) {
                testprobe = true;
            } else if (this.m_settings.isCis() && !this.m_settings.isTrans()) {
                testprobe = snpchr < 1 || probechr < 1 ? false : (probechr == snpchr ? Math.abs(snpchrpos - probechrpos) < this.m_settings.getCisdistance() : false);
            } else if (!this.m_settings.isCis() && this.m_settings.isTrans()) {
                testprobe = snpchr < 1 || probechr < 1 ? false : (probechr == snpchr ? Math.abs(snpchrpos - probechrpos) > this.m_settings.getTransdistance() : true);
            }
            testprobes[p] = testprobe;
            if (!testprobe) continue;
            probesTestedHash.add(p);
        }
        for (int d = 0; d < this.ds.length; ++d) {
            Integer snpId = this.snpTranslation[d][s];
            if (snpId == null) continue;
            BinaryResultSNP snpObject = pack.getSNPObject(d);
            byte[] data = pack.getData(d);
            Float[] zscores = null;
            if (data == null) continue;
            try {
                zscores = this.inflate(data, this.ds[d].getNumProbes());
                pack.setData(d, null);
            }
            catch (DataFormatException ex) {
                Logger.getLogger(MetaAnalysisCalculationThread.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (zscores == null) continue;
            ++numDSPassingQC;
            int nrSamples = snpObject.getNumsamples();
            double weight = Descriptives.getSqrt(nrSamples);
            for (int p = 0; p < this.probes.size(); ++p) {
                boolean testprobe = testprobes[p];
                if (!testprobe) continue;
                Integer probeId = this.probeTranslationLookupTable[d][p];
                if (!testprobe && probeId != null) {
                    zscores[probeId.intValue()] = null;
                    continue;
                }
                if (probeId == null || !testprobe || zscores[probeId] == null) continue;
                int n = p;
                totalNrSamples[n] = totalNrSamples[n] + nrSamples;
                r.dspassingqc[p][d] = true;
                r.numSamples[p][d] = nrSamples;
                double zscore = zscores[probeId].floatValue();
                r.datasets[d] = this.ds[d].getM_name();
                int n2 = p;
                dsPassQC[n2] = dsPassQC[n2] + 1;
                if (firstSNPPassingQC == null) {
                    firstSNPPassingQC = snpObject;
                } else {
                    Boolean flipalleles = this.flipalleles(firstSNPPassingQC, snpObject);
                    if (flipalleles == null) {
                        System.err.println("ERROR! SNP alleles cannot be matched for snp\t" + snpObject.getName() + "\tin dataset\t" + d);
                        System.err.println("This SNP will be excluded from further research");
                        r.passesQC = false;
                    } else if (flipalleles.booleanValue()) {
                        zscore = -zscore;
                        zscoreflipped[d] = true;
                    }
                }
                r.datasetZScores[p][d] = new Double(zscore);
                int n3 = p;
                zSumAbsolute[n3] = zSumAbsolute[n3] + Math.abs(zscore * weight);
                int n4 = p;
                zSum[n4] = zSum[n4] + zscore * weight;
            }
            for (int i = 0; i < zscores.length; ++i) {
                zscores[i] = null;
            }
        }
        pack.clearByteData();
        int numDSThatMinimallyShouldHaveEffect = this.m_settings.getSnpDatasetPresenceThreshold();
        if (numDSThatMinimallyShouldHaveEffect == 0) {
            numDSThatMinimallyShouldHaveEffect = 1;
        }
        if (numDSPassingQC >= numDSThatMinimallyShouldHaveEffect) {
            pack.setPassedQC(true);
            Double[] metaZPerProbe = null;
            if (this.m_settings.isMakezscoretable()) {
                metaZPerProbe = new Double[this.probes.size()];
            }
            int probesTested = 0;
            ++this.numSNPs;
            for (int p = 0; p < this.probes.size(); ++p) {
                if (dsPassQC[p] >= numDSThatMinimallyShouldHaveEffect && totalNrSamples[p] > 0) {
                    ++this.numEffects;
                    probesTestedHash.add(p);
                    ++probesTested;
                    double zSumVal = zSum[p];
                    double sqrtSample = Descriptives.getSqrt(totalNrSamples[p]);
                    double metaZScore = zSumVal / sqrtSample;
                    double pValueOverall = Descriptives.convertZscoreToPvalue(metaZScore);
                    double zSumValAbsolute = zSumAbsolute[p];
                    double zScoreAbs = zSumValAbsolute / sqrtSample;
                    double pValueOverallAbs = Descriptives.convertZscoreToPvalue(zScoreAbs);
                    boolean outputeqtl = false;
                    if (this.m_settings.isMakezscoretable()) {
                        outputeqtl = true;
                    } else if (pValueOverall <= this.pvaluethreshold.getPvalue()) {
                        outputeqtl = true;
                    }
                    if (outputeqtl) {
                        result[p] = new EQTL();
                        EQTL e = result[p];
                        e.setRsChr(this.snpChr.get(s));
                        e.setRsChrPos(this.snpChrPos.get(s));
                        e.setProbeChr(this.probeTranslation.getProbeChr(p));
                        e.setProbeChrPos(this.probeTranslation.getProbeChrPos(p));
                        e.setDatasets(r.datasets);
                        e.setAlleleAssessed(BaseAnnot.toString(firstSNPPassingQC.getAssessedAllele()));
                        byte[] alleles = firstSNPPassingQC.getAlleles();
                        String alleleStr = BaseAnnot.toString(alleles[0]) + "/" + BaseAnnot.toString(alleles[1]);
                        e.setAlleles(alleleStr);
                        e.setDatasetZScores(r.datasetZScores[p]);
                        e.setZscore(metaZScore);
                        e.setPvalue(pValueOverall);
                        e.setZscoreAbs(zScoreAbs);
                        e.setPvalueAbs(pValueOverallAbs);
                        if (this.m_settings.isUseAbsoluteZscore()) {
                            e.setUseAbsoluteZScore();
                        }
                        if (pValueOverallAbs < 1.0) {
                            for (int d1 = 0; d1 < this.ds.length; ++d1) {
                                boolean ds1PassesQC = r.dspassingqc[p][d1];
                                if (!ds1PassesQC) continue;
                                double datasetZScore = r.datasetZScores[p][d1];
                                if (zscoreflipped[d1]) {
                                    datasetZScore = -datasetZScore;
                                }
                                for (int d2 = d1 + 1; d2 < this.ds.length; ++d2) {
                                    if (!r.dspassingqc[p][d2]) continue;
                                    double zscore2 = r.datasetZScores[p][d2];
                                    if (zscoreflipped[d2]) {
                                        zscore2 = -zscore2;
                                    }
                                    if (this.zs == null || !(pValueOverall < 1.0E-15)) continue;
                                    this.zs.draw(new Double(datasetZScore), new Double(zscore2), d1, d2);
                                }
                                if (this.zs == null || !(pValueOverall < 1.0E-15)) continue;
                                this.zs.draw(new Double(datasetZScore), new Double(metaZScore), d1, this.ds.length);
                            }
                        }
                        e.setDatasetsSamples(r.numSamples[p]);
                        e.setProbe(this.probes.get(p));
                        e.setRsName(firstSNPPassingQC.getName());
                        e.setProbeHUGO(this.probeTranslation.getProbeSymbol(p));
                    }
                    if (!this.m_settings.isMakezscoretable()) continue;
                    metaZPerProbe[p] = metaZScore;
                    continue;
                }
                r.finalzscores[p] = null;
            }
            if (this.m_settings.isMakezscoretable() && firstSNPPassingQC != null) {
                zscoretableout.append(this.snps.get(s));
                zscoretableout.append("\t").append(BaseAnnot.toString(firstSNPPassingQC.getAlleles()[0])).append("/").append(BaseAnnot.toString(firstSNPPassingQC.getAlleles()[1])).append("\t").append(BaseAnnot.toString(firstSNPPassingQC.getAssessedAllele()));
                for (int i = 0; i < metaZPerProbe.length; ++i) {
                    zscoretableout.append("\t").append(metaZPerProbe[i]);
                    metaZPerProbe[i] = null;
                }
                metaZPerProbe = null;
                pack.setZScoreOut(zscoretableout.toString());
            }
            r.clearData();
            if (numDSPassingQC > 0) {
                pack.setProbesTestedHash(probesTestedHash);
            } else {
                pack.setProbesTestedHash(new HashSet<Integer>());
            }
            pack.setNumOfTestedProbes(probesTested);
            pack.setResult(result);
            try {
                this.m_queue_output.put(pack);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    public Boolean flipalleles(BinaryResultSNP firstSNPPassingQC, BinaryResultSNP snpObject) {
        int j;
        byte allele1;
        int i;
        byte[] allelesfirst = firstSNPPassingQC.getAlleles();
        byte allelefirstassessed = firstSNPPassingQC.getAssessedAllele();
        byte[] allelessecond = snpObject.getAlleles();
        byte allelesecondassessed = snpObject.getAssessedAllele();
        int nridenticalalleles = 0;
        for (i = 0; i < allelesfirst.length; ++i) {
            allele1 = allelesfirst[i];
            for (j = 0; j < allelessecond.length; ++j) {
                if (allelessecond[j] != allele1) continue;
                ++nridenticalalleles;
            }
        }
        if (nridenticalalleles == 2) {
            if (allelefirstassessed == allelesecondassessed) {
                return false;
            }
            return true;
        }
        allelessecond = this.convertToComplementaryAlleles(allelessecond);
        allelesecondassessed = BaseAnnot.getComplement(allelesecondassessed);
        nridenticalalleles = 0;
        for (i = 0; i < allelesfirst.length; ++i) {
            allele1 = allelesfirst[i];
            for (j = 0; j < allelessecond.length; ++j) {
                if (allelessecond[j] != allele1) continue;
                ++nridenticalalleles;
            }
        }
        if (nridenticalalleles == 2) {
            if (allelefirstassessed == allelesecondassessed) {
                return false;
            }
            return true;
        }
        return null;
    }

    public byte[] convertToComplementaryAlleles(byte[] allelesToCompare) {
        byte[] allelesComplementary = new byte[2];
        for (int a = 0; a < 2; ++a) {
            allelesComplementary[a] = BaseAnnot.getComplement(allelesToCompare[a]);
        }
        return allelesComplementary;
    }

    protected Float[] inflate(byte[] buffer, int numElems) throws DataFormatException {
        this.inflater.setInput(buffer);
        this.inflater.finished();
        byte[] decompressed = new byte[numElems * 4];
        this.inflater.inflate(decompressed);
        long actuallydecompressed = this.inflater.getBytesWritten();
        if (actuallydecompressed != (long)(numElems * 4)) {
            throw new DataFormatException("IO Error: uncompressed data does not correspond to the size requested\t" + actuallydecompressed + "\t" + numElems * 4);
        }
        this.inflater.reset();
        ByteBuffer bytebuffer = ByteBuffer.wrap(decompressed);
        Float[] output = new Float[numElems];
        int ctr = 0;
        for (int i = 0; i < numElems; ++i) {
            Float f = Float.valueOf(bytebuffer.getFloat());
            if (f.isNaN()) {
                f = null;
            } else {
                ++ctr;
            }
            output[i] = f;
        }
        decompressed = null;
        if (ctr == 0) {
            return null;
        }
        return output;
    }
}

