/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.binarymeta.meta;

import eqtlmappingpipeline.binarymeta.meta.MetaAnalyze;
import eqtlmappingpipeline.binarymeta.meta.MetaSettings;
import eqtlmappingpipeline.binarymeta.meta.graphics.MultiVenn;
import java.io.IOException;
import java.util.HashSet;
import java.util.zip.DataFormatException;
import umcg.genetica.io.trityper.EQTL;
import umcg.genetica.io.trityper.eQTLTextFile;
import umcg.genetica.io.trityper.probeannotation.ProbeTranslation;

public class IndividualAnalysis
extends MetaAnalyze {
    @Override
    public void init(String args, String texttoreplace, String replacetextwith) throws IOException {
        m_settings = new MetaSettings();
        m_settings.parse(args, texttoreplace, replacetextwith);
        this.probeTranslation = new ProbeTranslation();
        this.probeTranslation.load(m_settings.getProbetranslationfile());
    }

    @Override
    public void analyze() throws IOException, DataFormatException, Exception {
        System.out.println("");
        System.out.println("Starting analysis!");
        if (!m_settings.getOutput().endsWith("/")) {
            m_settings.setOutput(m_settings.getOutput() + "/");
        }
        String origOuputDir = m_settings.getOutput();
        System.out.println(m_settings.getDatasetnames().size() + " datasets to analyze");
        int numTotalDatasets = m_settings.getDatasetnames().size();
        String[] setnames = new String[m_settings.getDatasetnames().size() + 1];
        for (int i = 0; i < setnames.length - 1; ++i) {
            setnames[i] = m_settings.getDatasetnames().get(i);
        }
        setnames[setnames.length - 1] = "Meta-Analysis";
        EQTL[][] eqtls = new EQTL[setnames.length][0];
        double[] setsizes = new double[setnames.length];
        for (int i = 0; i < setnames.length - 1; ++i) {
            eQTLTextFile etf = new eQTLTextFile(origOuputDir + "/" + setnames[i] + "/eQTLsFDR" + m_settings.getFdrthreshold() + ".txt", false);
            eqtls[i] = etf.read();
            HashSet<String> uniqueprobes = new HashSet<String>();
            for (EQTL u : eqtls[i]) {
                uniqueprobes.add(u.getProbe());
            }
            setsizes[i] = uniqueprobes.size();
            etf.close();
        }
        eQTLTextFile etf = new eQTLTextFile(origOuputDir + "/eQTLsFDR" + m_settings.getFdrthreshold() + ".txt", false);
        eqtls[setnames.length - 1] = etf.read();
        HashSet<String> uniqueprobes = new HashSet<String>();
        for (EQTL u : eqtls[setnames.length - 1]) {
            uniqueprobes.add(u.getProbe());
        }
        setsizes[setnames.length - 1] = uniqueprobes.size();
        etf.close();
        double[][] overlaps = new double[setnames.length][setnames.length];
        for (int i = 0; i < setnames.length - 1; ++i) {
            EQTL[] a = eqtls[i];
            HashSet<String> uniqueProbesA = new HashSet<String>();
            for (EQTL e : a) {
                uniqueProbesA.add(e.getProbe());
            }
            String[] probeList = uniqueProbesA.toArray(new String[0]);
            for (int j = i + 1; j < setnames.length; ++j) {
                EQTL[] b = eqtls[j];
                HashSet<String> uniqueProbesB = new HashSet<String>();
                for (EQTL e : b) {
                    uniqueProbesB.add(e.getProbe());
                }
                int overlap = 0;
                for (String s : probeList) {
                    if (!uniqueProbesB.contains(s)) continue;
                    ++overlap;
                }
                overlaps[i][j] = overlap;
            }
        }
        System.out.println("");
        System.out.println("");
        System.out.println("");
        System.out.println("");
        MultiVenn m = new MultiVenn();
        m.plot(setnames, setsizes, overlaps);
        System.out.println("drawing");
        m.draw(origOuputDir + "/multivenn.png");
    }
}

