/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.binarymeta;

import eqtlmappingpipeline.binarymeta.LDCalc;
import eqtlmappingpipeline.binarymeta.meta.IndividualAnalysis;
import eqtlmappingpipeline.binarymeta.meta.MetaAnalyze;
import eqtlmappingpipeline.binarymeta.meta.cis.CisAnalysis;
import eqtlmappingpipeline.binarymeta.util.Filter;
import eqtlmappingpipeline.binarymeta.util.SNPAlleleCheck;
import eqtlmappingpipeline.metaqtl3.FDR;
import eqtlmappingpipeline.pcaoptimum.PCAOptimum;
import eqtlmappingpipeline.util.NoLdSnpProbeListCreator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Main {
    public static void main(String[] args) {
        String texttoreplace = null;
        String replacetextwith = null;
        boolean individualAnalysis = false;
        String mode = null;
        String settings = null;
        String gwascatalog = null;
        String cormat = null;
        String transfile = null;
        String cisfile = null;
        String probetranslation = null;
        String zscore = null;
        String out = null;
        String eqtlfile = null;
        String probeannot = null;
        String annot = null;
        String in = null;
        String inexp = null;
        String gte = null;
        Integer nrPerm = 0;
        Integer nrEQTLs = null;
        Double cutoff = null;
        String query = null;
        String ldfile = null;
        String dbsnp = null;
        String pw = null;
        String snpselectionlist = null;
        String snpprobeselectionlist = null;
        boolean createQQPlot = true;
        Integer stepSize = 5;
        Integer max = 5;
        for (int i = 0; i < args.length; ++i) {
            String val = null;
            if (i + 1 < args.length) {
                val = args[i + 1];
            }
            if (args[i].equals("--metamode")) {
                mode = val;
                continue;
            }
            if (args[i].equals("--settings")) {
                settings = val;
                continue;
            }
            if (args[i].equals("--settings")) continue;
            if (args[i].equals("--gwascatalog")) {
                gwascatalog = val;
                continue;
            }
            if (args[i].equals("--trans")) {
                transfile = val;
                continue;
            }
            if (args[i].equals("--cis")) {
                cisfile = val;
                continue;
            }
            if (args[i].equals("--cormat")) {
                cormat = val;
                continue;
            }
            if (args[i].equals("--probetranslation")) {
                probetranslation = val;
                continue;
            }
            if (args[i].equals("--zscore")) {
                zscore = val;
                continue;
            }
            if (args[i].equals("--out")) {
                out = val;
                continue;
            }
            if (args[i].equals("--probeannot")) {
                probeannot = val;
                continue;
            }
            if (args[i].equals("--eqtlfile")) {
                eqtlfile = val;
                continue;
            }
            if (args[i].equals("--in")) {
                in = val;
                continue;
            }
            if (args[i].equals("--inexp")) {
                inexp = val;
                continue;
            }
            if (args[i].equals("--gte")) {
                gte = val;
                continue;
            }
            if (args[i].equals("--annot")) {
                annot = val;
                continue;
            }
            if (args[i].equals("--nrperm")) {
                nrPerm = Integer.parseInt(val);
                continue;
            }
            if (args[i].equals("--cutoff")) {
                cutoff = Double.parseDouble(val);
                continue;
            }
            if (args[i].equals("--nreqtls")) {
                nrEQTLs = Integer.parseInt(val);
                continue;
            }
            if (args[i].equals("--query")) {
                query = val;
                continue;
            }
            if (args[i].equals("--ldfile")) {
                ldfile = val;
                continue;
            }
            if (args[i].equals("--dbsnp")) {
                dbsnp = val;
                continue;
            }
            if (args[i].equals("--pw")) {
                pw = val;
                continue;
            }
            if (args[i].equals("--individual")) {
                individualAnalysis = true;
                continue;
            }
            if (args[i].equals("--texttoreplace")) {
                texttoreplace = val;
                continue;
            }
            if (args[i].equals("--replacetextwith")) {
                replacetextwith = val;
                continue;
            }
            if (args[i].equals("--skipqqplot")) {
                createQQPlot = false;
                continue;
            }
            if (args[i].equals("--snpselectionlist")) {
                snpselectionlist = val;
                continue;
            }
            if (args[i].equals("--snpprobeselectionlist")) {
                snpprobeselectionlist = val;
                continue;
            }
            if (args[i].equals("--stepsizepcaremoval")) {
                stepSize = Integer.parseInt(val);
                continue;
            }
            if (!args[i].equals("--maxnrpcaremoved")) continue;
            max = Integer.parseInt(val);
        }
        if (mode == null) {
            System.out.println("Specify metamode (meta, cismeta, summary, splitzscoretable, allelecheck, filter or fdr, crosshybparser, determineSnpProbList)");
        } else if (mode.equals("meta")) {
            if (settings == null) {
                System.out.println("Specify settings");
            } else {
                try {
                    MetaAnalyze m2 = new MetaAnalyze();
                    m2.init(settings, texttoreplace, replacetextwith);
                    m2.analyze();
                    if (individualAnalysis) {
                        IndividualAnalysis m = new IndividualAnalysis();
                        m.init(settings, texttoreplace, replacetextwith);
                        m.analyze();
                        m = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (mode.equals("cismeta")) {
            if (settings == null) {
                System.out.println("Specify settings");
            } else {
                try {
                    CisAnalysis c = new CisAnalysis(settings);
                    c.analyze();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (mode.equals("individual")) {
            try {
                IndividualAnalysis m = new IndividualAnalysis();
                m.init(settings, texttoreplace, replacetextwith);
                m.analyze();
                m = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (mode.equals("allelecheck")) {
            if (settings == null) {
                System.out.println("Specify mode (meta or summary or splitzscoretable, or reannotate)");
            } else {
                try {
                    SNPAlleleCheck m2 = new SNPAlleleCheck();
                    m2.init(settings, texttoreplace, replacetextwith);
                    m2.analyze();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (mode.equals("filter")) {
            if (in == null || probetranslation == null || annot == null) {
                System.out.println("Please specify --in --probetranslation and --annot");
            } else {
                try {
                    Filter f = new Filter();
                    f.run(in, probetranslation, annot);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (mode.equals("fdr")) {
            if (in == null || nrEQTLs == null || cutoff == null) {
                System.out.println("Please specify --in --nrperm and --cutoff and --nreqtls [--skipqqplot]");
            } else if (snpselectionlist != null) {
                try {
                    FDR.calculateFDR2(in, nrPerm, nrEQTLs, cutoff, createQQPlot, null, null, FDR.FDRMethod.ALL, true, snpselectionlist, snpprobeselectionlist);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    FDR.calculateFDR(in, nrPerm, nrEQTLs, cutoff, createQQPlot, null, null, FDR.FDRMethod.ALL, true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (mode.equals("ld")) {
            if (in == null || eqtlfile == null || out == null) {
                System.out.println("Please specify --in and --eqtlfile and --outdir");
            } else {
                try {
                    LDCalc ld = new LDCalc();
                    ld.LDCalc(eqtlfile, in, out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (mode.equals("nongeneticPcaCorrection")) {
            if (in == null || out == null || inexp == null || gte == null) {
                System.out.println("Please specify --in, --out, --stepsizepcaremoval, --maxnrpcaremoved, --gte and --nreqtls");
            } else {
                try {
                    PCAOptimum p = new PCAOptimum();
                    p.alternativeInitialize(in, inexp, null, annot, gte, out, true, true, 10, snpselectionlist, 1);
                    File file = new File(inexp);
                    p.performeQTLMappingOverEigenvectorMatrixAndReNormalize(inexp, out, file.getAbsoluteFile().getParent(), stepSize, max, nrEQTLs);
                }
                catch (IOException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (Exception ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        } else if (mode.equals("determineSnpProbList")) {
            try {
                NoLdSnpProbeListCreator.main(Arrays.copyOfRange(args, 2, args.length));
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (Exception ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            System.out.print("Invalid option, valid options are:");
            System.out.println("fdr, ld, filter, allelecheck, individual, cismeta, meta, determineSnpProbList");
        }
        System.exit(0);
    }
}

