/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.ase;

import eqtlmappingpipeline.ase.AseConfiguration;
import eqtlmappingpipeline.ase.AseResults;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.RandomAccessGenotypeData;
import org.molgenis.genotype.multipart.IncompatibleMultiPartGenotypeDataException;
import org.molgenis.genotype.multipart.MultiPartGenotypeData;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variant.GeneticVariantMeta;
import org.molgenis.genotype.variant.GenotypeRecord;
import org.molgenis.genotype.variant.id.GeneticVariantId;
import org.molgenis.genotype.vcf.VcfGenotypeData;

public class ReadCountsLoader
implements Runnable {
    private final Iterator<File> inputFileIterator;
    private final AseResults aseResults;
    private final Set<String> detectedSampleSet;
    private final AtomicInteger fileCounter;
    private final AseConfiguration configuration;
    private final RandomAccessGenotypeData genotypeReference;
    Map<String, String> refToStudySampleId;
    private final String chr;
    private final int start;
    private final int stop;
    private static final Logger LOGGER = Logger.getLogger(ReadCountsLoader.class);

    public ReadCountsLoader(Iterator<File> inputFileIterator, AseResults aseResults, Set<String> detectedSampleSet, AtomicInteger fileCounter, AseConfiguration configuration) {
        this(inputFileIterator, aseResults, detectedSampleSet, fileCounter, configuration, null);
    }

    public ReadCountsLoader(Iterator<File> inputFileIterator, AseResults aseResults, Set<String> detectedSampleSet, AtomicInteger fileCounter, AseConfiguration configuration, RandomAccessGenotypeData genotypeReference) {
        this(inputFileIterator, aseResults, detectedSampleSet, fileCounter, configuration, genotypeReference, null, null, 0, Integer.MAX_VALUE);
    }

    public ReadCountsLoader(Iterator<File> inputFileIterator, AseResults aseResults, Set<String> detectedSampleSet, AtomicInteger fileCounter, AseConfiguration configuration, RandomAccessGenotypeData genotypeReference, Map<String, String> refToStudySampleId, String chr, int start, int stop) {
        this.inputFileIterator = inputFileIterator;
        this.aseResults = aseResults;
        this.detectedSampleSet = detectedSampleSet;
        this.fileCounter = fileCounter;
        this.configuration = configuration;
        this.genotypeReference = genotypeReference;
        this.refToStudySampleId = refToStudySampleId == null ? Collections.EMPTY_MAP : refToStudySampleId;
        this.chr = chr;
        this.start = start;
        this.stop = stop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String inputFilePath;
        TObjectIntHashMap referenceSamples = null;
        try {
            if (this.genotypeReference != null) {
                String[] referenceSampleNames = this.genotypeReference.getSampleNames();
                referenceSamples = new TObjectIntHashMap(referenceSampleNames.length, 0.2f, -1);
                int i = 0;
                for (String sample : referenceSampleNames) {
                    String translatedSampleId = this.refToStudySampleId.get(sample);
                    if (translatedSampleId != null) {
                        referenceSamples.put((Object)translatedSampleId, i);
                    } else {
                        referenceSamples.put((Object)sample, i);
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            System.err.println("Error reading samples from reference data: " + ex.getMessage());
            LOGGER.fatal((Object)"Error reading samples from reference data.", (Throwable)ex);
            System.exit(1);
        }
        File inputFile = null;
        try {
            while (this.inputFileIterator.hasNext()) {
                MultiPartGenotypeData genotypeData;
                Iterator<File> i = this.inputFileIterator;
                synchronized (i) {
                    if (!this.inputFileIterator.hasNext()) {
                        break;
                    }
                    inputFile = this.inputFileIterator.next();
                }
                if (inputFile.isDirectory()) {
                    try {
                        genotypeData = MultiPartGenotypeData.createFromVcfFolder((File)inputFile, (int)100, (double)0.8);
                    }
                    catch (IncompatibleMultiPartGenotypeDataException ex) {
                        System.err.println("Error reading folder with VCF files: " + ex.getMessage());
                        LOGGER.fatal((Object)"Error reading folder with VCF files: ", (Throwable)ex);
                        System.exit(1);
                        return;
                    }
                } else {
                    genotypeData = new VcfGenotypeData(inputFile, 100, 0.8);
                }
                List samples = genotypeData.getSamples();
                ArrayList<String> sampleIds = new ArrayList<String>(samples.size());
                for (String sample : samples) {
                    sampleIds.add(sample.getId().intern());
                }
                MultiPartGenotypeData variants = this.chr == null ? genotypeData : genotypeData.getVariantsByRange(this.chr, this.start, this.stop);
                block18: for (GeneticVariant variant : variants) {
                    if (variant.getVariantMeta().getRecordType("AD") != GeneticVariantMeta.Type.INTEGER_LIST) continue;
                    GeneticVariantId variantId = variant.getVariantId();
                    Iterator sampleIdIterator = sampleIds.iterator();
                    List referenceVariantAlleles = null;
                    for (GenotypeRecord record : variant.getSampleGenotypeRecords()) {
                        String sampleId = (String)sampleIdIterator.next();
                        try {
                            Alleles alleles;
                            if (this.genotypeReference == null) {
                                alleles = record.getSampleAlleles();
                            } else {
                                int sampleIndexRef;
                                if (referenceVariantAlleles == null) {
                                    RandomAccessGenotypeData randomAccessGenotypeData = this.genotypeReference;
                                    synchronized (randomAccessGenotypeData) {
                                        GeneticVariant referenceVariant = this.genotypeReference.getSnpVariantByPos(variant.getSequenceName(), variant.getStartPos());
                                        if (referenceVariant == null) {
                                            continue block18;
                                        }
                                        if (!referenceVariant.getVariantAlleles().sameAlleles(variant.getVariantAlleles())) {
                                            continue block18;
                                        }
                                        if (variantId == null || variantId == GeneticVariantId.BLANK_GENETIC_VARIANT_ID) {
                                            variantId = referenceVariant.getVariantId();
                                        }
                                        referenceVariantAlleles = referenceVariant.getSampleVariants();
                                    }
                                }
                                if ((sampleIndexRef = referenceSamples.get((Object)sampleId)) == -1) {
                                    throw new GenotypeDataException("Sample " + sampleId + " not found in data with reference genotypes");
                                }
                                alleles = (Alleles)referenceVariantAlleles.get(sampleIndexRef);
                            }
                            if (alleles != null && (alleles.getAlleleCount() != 2 || alleles.get(0) == alleles.get(1) || alleles.contains(Allele.ZERO))) continue;
                            List counts = (List)record.getGenotypeRecordData("AD");
                            int a1Count = (Integer)counts.get(0);
                            int a2Count = (Integer)counts.get(1);
                            int totalReads = a1Count + a2Count;
                            double minReads = Math.min(a1Count, a2Count);
                            if (totalReads < this.configuration.getMinTotalReads() || !(minReads >= (double)this.configuration.getMinAlleleReads()) || totalReads > this.configuration.getMaxTotalReads() || !(minReads / (double)totalReads >= this.configuration.getMinAlleleReadFraction())) continue;
                            if (variant.getVariantMeta().getRecordType("RQ") == GeneticVariantMeta.Type.FLOAT_LIST) {
                                List meanAlleleBaseQualties = (List)record.getGenotypeRecordData("RQ");
                                this.aseResults.addResult(variant.getSequenceName(), variant.getStartPos(), variantId, variant.getVariantAlleles().get(0), variant.getVariantAlleles().get(1), a1Count, a2Count, sampleId, (Double)meanAlleleBaseQualties.get(0), (Double)meanAlleleBaseQualties.get(1));
                                continue;
                            }
                            this.aseResults.addResult(variant.getSequenceName(), variant.getStartPos(), variantId, variant.getVariantAlleles().get(0), variant.getVariantAlleles().get(1), a1Count, a2Count, sampleId);
                        }
                        catch (GenotypeDataException ex) {
                            System.err.println("Error parsing " + variant.getSequenceName() + ":" + variant.getStartPos() + " for sample " + sampleId + " " + ex.getMessage());
                            LOGGER.fatal((Object)("Error parsing " + variant.getSequenceName() + ":" + variant.getStartPos() + " for sample " + sampleId), (Throwable)ex);
                            System.exit(1);
                            return;
                        }
                    }
                }
                this.fileCounter.incrementAndGet();
                genotypeData.close();
                for (String sample : genotypeData.getSampleNames()) {
                    this.detectedSampleSet.add(sample);
                }
            }
        }
        catch (IOException ex) {
            inputFilePath = inputFile != null ? inputFile.getAbsolutePath() : "?";
            System.err.println("Error reading input data at " + inputFilePath + " error: " + ex.getMessage());
            LOGGER.fatal((Object)("Error reading input data at " + inputFilePath), (Throwable)ex);
            System.exit(1);
        }
        catch (GenotypeDataException ex) {
            inputFilePath = inputFile != null ? inputFile.getAbsolutePath() : "?";
            System.err.println("Error reading input data at " + inputFilePath + " error: " + ex.getMessage());
            LOGGER.fatal((Object)("Error reading input data at " + inputFilePath), (Throwable)ex);
            System.exit(1);
        }
    }
}

