/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.ase;

import java.io.BufferedReader;
import java.io.FileReader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.molgenis.genotype.plink.BedBimFamGenotypeData;
import org.molgenis.genotype.util.Ld;
import org.molgenis.genotype.variant.GeneticVariant;
import umcg.genetica.io.trityper.EQTL;
import umcg.genetica.io.trityper.eQTLTextFile;

public class NewMain {
    private static final Pattern TAB_PATTERN = Pattern.compile("\\t");
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");

    public static void main(String[] args) throws Exception {
        String line;
        eQTLTextFile eQTLsTextFile = new eQTLTextFile("D:\\UMCG\\Genetica\\Projects\\RnaSeqEqtl\\batch9_eQTLmapping\\result_non-geuvadis_maf0.05_call0.5_pcs100_normalizedPCA_meta\\notInGeuvadis.txt", false);
        BufferedReader aseReader = new BufferedReader(new FileReader("D:\\UMCG\\Genetica\\Projects\\RnaSeqEqtl\\Ase\\all_maskAll_r20_a10_p0_s5_rq0_gatkGeno\\ase_bh.txt"));
        BedBimFamGenotypeData genotypes = new BedBimFamGenotypeData("D:\\UMCG\\Genetica\\Projects\\RnaSeqEqtl\\batch9_genotypes\\plink\\batch9", 10000);
        HashMap<String, ArrayList<EQTL>> eQtls = new HashMap<String, ArrayList<EQTL>>();
        Iterator<EQTL> eQtlIt = eQTLsTextFile.getEQtlIterator();
        while (eQtlIt.hasNext()) {
            EQTL eQtl = eQtlIt.next();
            String eQtlKey = eQtl.getProbe();
            ArrayList<EQTL> posEqtls = (ArrayList<EQTL>)eQtls.get(eQtlKey);
            if (posEqtls == null) {
                posEqtls = new ArrayList<EQTL>(1);
                eQtls.put(eQtlKey, posEqtls);
            }
            posEqtls.add(eQtl);
        }
        int aseTotal = 0;
        int aseWithEQtl = 0;
        int sameDirection = 0;
        int oppositeDirection = 0;
        aseReader.readLine();
        while ((line = aseReader.readLine()) != null) {
            String[] elements = TAB_PATTERN.split(line);
            HashSet<String> aseGenes = new HashSet<String>();
            for (String gene : COMMA_PATTERN.split(elements[9])) {
                aseGenes.add(gene);
            }
            ++aseTotal;
            ArrayList posEqtls = (ArrayList)eQtls.get(elements[9]);
            if (posEqtls == null) continue;
            for (EQTL eQtl : posEqtls) {
                Ld ld;
                if (eQtl == null || !aseGenes.contains(eQtl.getProbe())) continue;
                String chr = eQtl.getRsChr() + "";
                GeneticVariant eQtlVar = genotypes.getSnpVariantByPos(String.valueOf(chr), eQtl.getRsChrPos().intValue());
                if (eQtlVar == null) {
                    System.out.println("eQtl not found: " + eQtl.getRsChr() + ":" + eQtl.getRsChrPos());
                    continue;
                }
                GeneticVariant aseVar = genotypes.getSnpVariantByPos(elements[2], Integer.valueOf(elements[3]).intValue());
                if (aseVar == null || !((ld = eQtlVar.calculateLd(aseVar)).getR2() >= 0.8)) continue;
                eQtls.remove(elements[9]);
                ++aseWithEQtl;
                double aseZ = Double.parseDouble(elements[1]);
                if (elements[7].equals(eQtl.getAlleleAssessed())) {
                    if (aseZ * eQtl.getZscore() > 0.0) {
                        ++sameDirection;
                        continue;
                    }
                    ++oppositeDirection;
                    continue;
                }
                if (aseZ * eQtl.getZscore() > 0.0) {
                    ++oppositeDirection;
                    continue;
                }
                ++sameDirection;
            }
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
        System.out.println("Ase total: " + aseTotal);
        System.out.println("Ase SNP with eQTL effect: " + aseWithEQtl + " (" + numberFormat.format((double)aseWithEQtl / (double)aseTotal) + ")");
        System.out.println(" - Same direction: " + sameDirection + " (" + numberFormat.format((double)sameDirection / (double)aseWithEQtl) + ")");
        System.out.println(" - Opposite direction: " + oppositeDirection + " (" + numberFormat.format((double)oppositeDirection / (double)aseWithEQtl) + ")");
    }
}

