/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.ase;

import java.io.BufferedReader;
import java.io.FileReader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Pattern;
import umcg.genetica.io.trityper.EQTL;
import umcg.genetica.io.trityper.eQTLTextFile;

public class CompareAseToEqtl {
    private static final Pattern TAB_PATTERN = Pattern.compile("\\t");
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private static final int ASE_ESTIMATE_COLUMN = 2;
    private static final int ASE_CHR_COLUMN = 5;
    private static final int ASE_POS_COLUMN = 6;
    private static final int ASE_GENES_COLUMN = 12;
    private static final int ASE_A1_COLUMN = 9;

    public static void main(String[] args) throws Exception {
        String line;
        eQTLTextFile eQTLsTextFile = new eQTLTextFile("D:\\UMCG\\Genetica\\Projects\\RnaSeqEqtl\\batch9_eQTLmapping\\result_geuvadis_maf0.05_call0.5_pcs100_normalizedPCA_meta_fix\\eQTLsFDR0.05-ProbeLevel.txt", false);
        BufferedReader aseReader = new BufferedReader(new FileReader("D:\\UMCG\\Genetica\\Projects\\RnaSeqEqtl\\Ase\\geuvadis_maskAll4_r20_a10_p2_s5_rq17_m1_gatkGenoGq30\\ase_bh.txt"));
        HashMap<String, ArrayList<EQTL>> eQtls = new HashMap<String, ArrayList<EQTL>>();
        Iterator<EQTL> eQtlIt = eQTLsTextFile.getEQtlIterator();
        while (eQtlIt.hasNext()) {
            EQTL eQtl = eQtlIt.next();
            String eQtlKey = eQtl.getRsChr() + ":" + eQtl.getRsChrPos();
            ArrayList<EQTL> posEqtls = (ArrayList<EQTL>)eQtls.get(eQtlKey);
            if (posEqtls == null) {
                posEqtls = new ArrayList<EQTL>(1);
                eQtls.put(eQtlKey, posEqtls);
            }
            posEqtls.add(eQtl);
        }
        int aseTotal = 0;
        int aseWithEQtl = 0;
        int sameDirection = 0;
        int oppositeDirection = 0;
        HashSet<String> countedGenes = new HashSet<String>();
        aseReader.readLine();
        while ((line = aseReader.readLine()) != null) {
            String[] elements = TAB_PATTERN.split(line);
            HashSet<String> aseGenes = new HashSet<String>();
            for (String gene : COMMA_PATTERN.split(elements[12])) {
                aseGenes.add(gene);
            }
            ++aseTotal;
            ArrayList posEqtls = (ArrayList)eQtls.get(elements[5] + ":" + elements[6]);
            if (posEqtls == null) continue;
            for (EQTL eQtl : posEqtls) {
                double eQtlZ;
                if (eQtl == null || !aseGenes.contains(eQtl.getProbe()) || countedGenes.contains(eQtl.getProbe())) continue;
                countedGenes.add(eQtl.getProbe());
                ++aseWithEQtl;
                double aseEstimate = Double.parseDouble(elements[2]);
                double d = eQtlZ = elements[9].equals(eQtl.getAlleleAssessed()) ? eQtl.getZscore() : eQtl.getZscore() * -1.0;
                if (aseEstimate > 0.5 && eQtlZ > 0.0 || aseEstimate < 0.5 && eQtlZ < 0.0) {
                    ++sameDirection;
                    continue;
                }
                ++oppositeDirection;
            }
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
        System.out.println("Ase total: " + aseTotal);
        System.out.println("Ase SNP with eQTL effect: " + aseWithEQtl + " (" + numberFormat.format((double)aseWithEQtl / (double)aseTotal) + ")");
        System.out.println(" - Same direction: " + sameDirection + " (" + numberFormat.format((double)sameDirection / (double)aseWithEQtl) + ")");
        System.out.println(" - Opposite direction: " + oppositeDirection + " (" + numberFormat.format((double)oppositeDirection / (double)aseWithEQtl) + ")");
    }
}

